/*
Copyright (C) 1997 $B9b66(B $B?-(B (TAKAHASHI Shin)
*/

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/Xt/SoXtRenderArea.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoMaterial.h>
#include <Inventor/nodes/SoPointLight.h>
#include <Inventor/nodes/SoSpotLight.h>
#include <Inventor/nodes/SoDirectionalLight.h>
#include <Inventor/nodes/SoPerspectiveCamera.h>
#include <Inventor/nodes/SoEventCallback.h>
#include <Inventor/nodes/SoFont.h>
#include <Inventor/nodes/SoCoordinate3.h>
#include <Inventor/events/SoMouseButtonEvent.h>
#include <Inventor/engines/SoElapsedTime.h>
#include <Inventor/sensors/SoFieldSensor.h>
#include <Inventor/actions/SoWriteAction.h>
#include <Inventor/SoDB.h>

#include <Xm/DialogS.h>
#include <Xm/Label.h>
#include <Xm/ScrollBar.h>
#include <Xm/Form.h>
#include <Xm/PanedW.h>

#include "Box.h"
#include "Cylinder.h"
#include "Sphere.h"
#include "Word.h"
#include "Cone.h"
#include "VsrObjects.h"
#include "ShapeTable.h"

SoElapsedTime	*globalCounter;
int	DEBUG;
static int stopFlag;
static float speedValue;

extern int First;
extern ShapeObject	object_table[TABLESIZE];

Shape *graphical_object(int Obj, int name)
{
   Transition type;

   switch(Obj){
      case SPHERE:{
		   Sphere *obj = new Sphere;
		   obj->setName(name);
		   return obj;
		}
      case LINE:
      case CYLINDER:{
		   Cylinder *obj = new Cylinder;
		   obj->setName(name);
		   return obj;
		}	  
      case BOX:{
		   Box *obj = new Box;
		   obj->setName(name);
		   return obj;
		}
      case WORD:{
		   Word *obj = new Word;
		   obj->setName(name);
		   //obj->setPathType(type);
		   return obj;
		}
      case CONE:{
		   Cone *obj = new Cone;
		   obj->setName(name);
		   //obj->setPathType(type);
		   return obj;
		}	  
      default:
	fprintf(stderr,"unknown object type!\n");
	exit(1);
	return (Shape *)0;
   }
}

/// Initializing 

SoSFTime *global_time;
SoCoordinate3 *global_time_proxy;
SoFieldSensor *timer_sensor;

static Widget		myWindow;
SoXtExaminerViewer 	*myViewer;

void initializeWindow(void)
{
   // Set up window
   myWindow = SoXt::init("tree");
   if (myWindow == NULL) exit(1);
}

void setupGlobalCounter(void)
{
	extern void timer_handler(void *object, SoSensor *sensor);

	globalCounter = new SoElapsedTime;
	globalCounter->ref();
	globalCounter->speed.setValue(0.1);
	//globalCounter->speed.setValue(1);
	globalCounter->reset.touch();
	globalCounter->on.setValue(FALSE);

	// Attach a sensor to 'global_time'
	timer_sensor = new SoFieldSensor(timer_handler, NULL);

	/*
	global_time = new SoSFTime;
	global_time->connectFrom(&(globalCounter->timeOut));
	timer_sensor->attach(global_time);
	*/
	global_time_proxy = new SoCoordinate3;
	SoComposeVec3f *gtp = new SoComposeVec3f;
	gtp->x.connectFrom(&globalCounter->timeOut);
	global_time_proxy->point.connectFrom(&gtp->vector);
	timer_sensor->attach(&gtp->x);
}

/// the Root Node of all Inventor objects displayed
SoSeparator* root;

void setupRootNode(void)
{
   void sendSignal(void *, SoEventCallback *);

   // Create a root node
    root = new SoSeparator;
    root->ref();
    //root->addChild(new SoPerspectiveCamera);
    root->addChild(new SoPointLight);
    SoSpotLight *mylight = new SoSpotLight;
    mylight->location.setValue(10.0, -10.0, 10.0);
    mylight->direction.setValue(-1.0, 1.0, -1.0);
    root->addChild(mylight);
    root->setName("Root");

   /* Create a Font node */
   SoFont *myFont = new SoFont;
   myFont->name.setValue("Times-Roman");
   myFont->size.setValue(18.0);
   root->addChild(myFont);


   // setup event callback  ---->> temporary 
   //     Add an event callback to catch mouse button presses.
   //     Each button press will start the animation
   //
   SoEventCallback *myEventCB = new SoEventCallback;
   myEventCB->addEventCallback(
            SoMouseButtonEvent::getClassTypeId(),
            sendSignal, NULL);
   root->addChild(myEventCB);
   //
}

static void barCallback(Widget w, XtPointer client_data, XtPointer call_data)
{
   Arg al[10];
   int pos = ((XmScrollBarCallbackStruct *)call_data)->value;
   int ac, max, min;

   ac = 0;
   XtSetArg(al[ac], XmNmaximum, &max); ac++;
   XtSetArg(al[ac], XmNminimum, &min); ac++;
   XtGetValues(w, al, ac);
   printf("---> %d, %d, %d\n",pos, max, min);
   globalCounter->speed.setValue((float)pos/20.0);
}

void displayViewer(void)
{
    Arg al[5];

    // Widget formWidget = XmCreateForm(myWindow, "form", NULL, 0);
    Widget formWidget = XmCreatePanedWindow(myWindow, "form", NULL, 0);

    //Set up viewer
    myViewer = new SoXtExaminerViewer(formWidget);
    myViewer->setSceneGraph(root);
    myViewer->setTitle("Indy-Trip");
    myViewer->setStereoViewing(TRUE);
    //fprintf(stderr,"%f\n",myViewer->getStereoOffset());
    myViewer->setStereoOffset(5.0);
    //myViewer->setBackgroundColor(SbColor(0.1,0.1,0.1));

    Widget bar = XmCreateScrollBar(formWidget,
				"speedoScrollbar", al, 0);
    XtManageChild(formWidget);
    XtManageChild(bar);
    
    myViewer->show();

    XtAddCallback(bar, XmNvalueChangedCallback, barCallback, NULL);

    SoXt::show(myWindow);
}

/// CALLBACK Function at the end of Transition

void
endOfTransition(void *object, SoSensor *sensor)
{
  //float gt = global_time->getValue().getValue();
  float gt = global_time_proxy->point[0][0];
  //printf("endOfTransition: %f\n",gt);

  if(gt >= ((Shape *)object)->path->H[0][1]){
    if(((Shape *)object)->deleteFlag)
      object_table[((Shape *)object)->loc].empty = TRUE;
    ((Shape *)object)->endTransition();
  }else
    ((Shape *)object)->setNextPath(gt);
}


// Callback Function for Start Animation
void
sendSignal(void *, SoEventCallback *eventCB)
{
   const SoEvent *event = eventCB->getEvent();

   // Check for mouse button being pressed
   if (SO_MOUSE_PRESS_EVENT(event, ANY)) {
	// send signal
	// kill(getpid(), 25);
   // debug
    if(DEBUG){
            SoWriteAction *foo = new SoWriteAction;
            foo->apply(root);
    }


	if(stopFlag){
	  puts("GO");
	  globalCounter->speed.setValue(speedValue);
	  stopFlag = 0;
	}else{
	  puts("STOP");
	  speedValue = globalCounter->speed.getValue();
	  globalCounter->speed.setValue((float)0.0);
	  stopFlag = 1;
	}

	 eventCB->setHandled();
   }
}

/// Set Transition Type

void setTransitionType(Shape *obj, int number)
{
   Transition	type;

   switch(number){
      case 1:
	   type.path = circuitous;
	   //type.v1 = SbVec3f(0.0, -100.0, 0.0);
	   //type.v2 = SbVec3f(0.0, 100.0, 0.0);
	   type.v1 = SbVec3f(0.0, 0.0, 500.0);
	   type.v2 = SbVec3f(0.0, 0.0, -500.0);
	   break;
      case 2:
	   type.path = lazy;
	   break;
      case 3:
	   type.path = immediate;
	   break;
      case 4:
	   type.path = creation;
	   break;
      case 5:
	   type.path = deletion;
	   break;
      case 6:
	   type.path = multipath;
	   break;
      case 0:
      default:
	   type.path = straight;
	   break;
   }
   obj->setPathType(type);
}
