/*
Copyright (C) 1997 $B9b66(B $B?-(B (TAKAHASHI Shin)
*/

/* Word class */

#include "Word.h"
#include "ShapeTable.h"

#include <Inventor/engines/SoCalculator.h>
#include <Inventor/engines/SoElapsedTime.h>

extern SoElapsedTime	*globalCounter;

Word::Word(void)
{
	moji = new SoText2;
	moji->justification = SoText2::CENTER;
	node->addChild(moji);
}

void Word::setString(char *t, char *mode)
{
	if(deleteFlag) return;

	strncpy(mytext, t, 63);

	moji->string = mytext;
	switch(*mode){
	  case 'r' :
		moji->justification = SoText2::RIGHT;
		break;
	  case 'l' :
		moji->justification = SoText2::LEFT;
		break;
	  case 'c' :
		moji->justification = SoText2::CENTER;
		break;
	  default :
		fprintf(stderr,"unknown type justification!\n");
		break;
	}

}

void Word::setVariable(int type, int val)
{
      if(deleteFlag){  
	this->setTransition(type, val, val);
	return;
      }

      SbVec3f tmp = location->translation.getValue();

	switch(type){
	   case 4:
	      location->translation.setValue((float)val, tmp[1], tmp[2]);
	      break;
	   case 5:
	      location->translation.setValue(tmp[0], (float)val, tmp[2]);
	      break;
	   case 6:
	      location->translation.setValue(tmp[0], tmp[1], (float)val);
	      break;
	  default:
	      break;
	}
}

void Word::setTransition(int type, int val1, int val2)
{
        if((val1 == val2)&&(!deleteFlag)) {
                switch(type){
                   case 4:
                      path->B.setValue(val1, path->B[0][1], path->B[0][2]);
                      path->C.setValue(val1, path->C[0][1], path->C[0][2]);
                      return;
                   case 5:
                      path->B.setValue(path->B[0][0], val1, path->B[0][2]);
                      path->C.setValue(path->C[0][0], val1, path->C[0][2]);
                      return;
                   case 6:
                      path->B.setValue(path->B[0][0], path->B[0][1], val1);
                      path->C.setValue(path->C[0][0], path->C[0][1], val1);
                      return;
                  default:
                      return;
                }
        }else{
                if(!(path->a.isConnected())){
                        // Connect 'globalCounter' to 'path'
                        path->a.connectFrom(&globalCounter->timeOut);
                }

                switch(type){
                   case 4:
                      path->B.setValue(val1, path->B[0][1], path->B[0][2]);
                      path->C.setValue(val2, path->C[0][1], path->C[0][2]);
                      if(!(location->translation.isConnected()))
                        location->translation.connectFrom(&path->oA);
                      break;
                   case 5:
                      path->B.setValue(path->B[0][0], val1, path->B[0][2]);
                      path->C.setValue(path->C[0][0], val2, path->C[0][2]);
                      if(!(location->translation.isConnected()))
                        location->translation.connectFrom(&path->oA);
                      break;
                   case 6:
                      path->B.setValue(path->B[0][0], path->B[0][1], val1);
                      path->C.setValue(path->C[0][0], path->C[0][1], val2);
                      if(!(location->translation.isConnected()))
                        location->translation.connectFrom(&path->oA);
                      break;
                  default:
                      break;
                }
        }
}

void Word::endTransition(void)
{
        // detaching the sensor
         endDetect->detach();

        // Disconnecting various engines
         location->translation.disconnect();
         path->a.disconnect();

        // Delete this if deleteFlag is true
         if(deleteFlag){ 
		delete this;
	 }

         return;
}

void Word::deleteAfterTransition(void)
{
	extern ShapeObject object_table[TABLESIZE];


	deleteFlag = TRUE;

	node->removeChild(moji);

}
