/*
Copyright (C) 1997 $B9b66(B $B?-(B (TAKAHASHI Shin)
*/

/* Sphere class */

#include "Sphere.h"
#include <Inventor/engines/SoElapsedTime.h>
#include <Inventor/engines/SoCalculator.h>
#include <Inventor/sensors/SoFieldSensor.h>
#include <Inventor/fields/SoSFTrigger.h>
#include <Inventor/fields/SoSFBool.h>
#include <Inventor/fields/SoSFTime.h>

extern	SoElapsedTime		*globalCounter;

Sphere::Sphere(void)
{
	maru = new SoSphere;
	node->addChild(maru);
}

Sphere::Sphere(SoSphere *obj)
{
	maru = obj;
	node->addChild(obj);
}

void Sphere::setRadius(float radius)
{
	maru->radius.setValue(radius);
}

void Sphere::setVariable(int type, int val)
{
      SbVec3f tmp = location->translation.getValue();

	switch(type){
	   case 2:
	      this->setRadius((float)val);
	      break;
	   case 4:
	      location->translation.setValue((float)val, tmp[1], tmp[2]);
	      break;
	   case 5:
	      location->translation.setValue(tmp[0], (float)val, tmp[2]);
	      break;
	   case 6:
	      location->translation.setValue(tmp[0], tmp[1], (float)val);
	      break;
	  default:
	      break;
	}
	
	// Debug
	//printf("%s  ",name);
}

void Sphere::setTransition(int type, int val1, int val2)
{
	if((val1 == val2)&&(transType.path == straight)) {
		switch(type){
		   case 2:
		      return;
		   case 4:
		      path->B.setValue(val1, path->B[0][1], path->B[0][2]);
		      path->C.setValue(val1, path->C[0][1], path->C[0][2]);
		      return;
		   case 5:
		      path->B.setValue(path->B[0][0], val1, path->B[0][2]);
		      path->C.setValue(path->C[0][0], val1, path->C[0][2]);
		      return;
		   case 6:
		      path->B.setValue(path->B[0][0], path->B[0][1], val1);
		      path->C.setValue(path->C[0][0], path->C[0][1], val1);
		      return;
		  default:
		      return;
		}
	}else{
		if(!(path->a.isConnected())){
			// Connect 'globalCounter' to 'path'
			path->a.connectFrom(&globalCounter->timeOut);
		}
		path->H.setValue(path->a[0], path->a[0] + 1.0, 0);
		switch(type){
		   case 2:
		      path->b = val1;
		      path->c = val2;
		      maru->radius.connectFrom(&path->oa);
		      break;
		   case 4:
		      path->B.setValue(val1, path->B[0][1], path->B[0][2]);
		      path->C.setValue(val2, path->C[0][1], path->C[0][2]);
		      if(!(location->translation.isConnected()))
			location->translation.connectFrom(&path->oA);
		      break;
		   case 5:
		      path->B.setValue(path->B[0][0], val1, path->B[0][2]);
		      path->C.setValue(path->C[0][0], val2, path->C[0][2]);
		      if(!(location->translation.isConnected()))
			location->translation.connectFrom(&path->oA);
		      break;
		   case 6:
		      path->B.setValue(path->B[0][0], path->B[0][1], val1);
		      path->C.setValue(path->C[0][0], path->C[0][1], val2);
		      if(!(location->translation.isConnected()))
			location->translation.connectFrom(&path->oA);
		      break;
		  default:
		      break;
		}
	}
}

void Sphere::endTransition(void)
{
	// detaching the sensor
	 endDetect->detach();

	// Disconnecting various engines
	 maru->radius.disconnect();
	 location->translation.disconnect();
	 path->a.disconnect();

	// Delete this if deleteFlag is true
	 if(deleteFlag){ 
		delete this;
	 }else{
	  // setting default path 
	   if(transType.path == creation){
		   transType.path = straight;
		   this->setPathType(transType);
	   }
	 }
	 return;
}
