/*
Copyright (C) 1997 $B9b66(B $B?-(B (TAKAHASHI Shin)
*/

/* Shape class */

#ifndef _myShape_h_
#define _myShape_h_

#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoTransformSeparator.h>
#include <Inventor/nodes/SoTranslation.h>
#include <Inventor/nodes/SoRotation.h>
#include <Inventor/nodes/SoMaterial.h>
#include <Inventor/engines/SoCalculator.h>
#include <Inventor/engines/SoOneShot.h>
#include <Inventor/sensors/SoFieldSensor.h>

#include "TransitionType.h"
#include "MaterialType.h"

class Shape {
protected:
	SoRotation		*direction;
	SoMaterial		*zaisitu;
	SoFieldSensor		*endDetect;
	int			name;
	Transition		transType;

public:
	SoCalculator		*path;
	SoTranslation		*location;
	SoSeparator		*node;
	//SoTransformSeparator		*node;

	SbBool			deleteFlag;
	int			loc;
	int			numberOfPath;
	int			nanbanme;

	SoMFVec3f		*viaList;

	Shape(void);
	~Shape(void);
	void setName(int name);
	void setMaterial(MaterialType type, float v1, float v2, float v3);
	int getName(void);
	virtual void deleteAfterTransition(void);
	virtual void moveto(float x, float y, float z);
	virtual void setVariable(int type, int val);
	virtual void rotate(float x, float y, float z, float theta);
	virtual void setTransition(int var, int val1, int val2);
	void setLongTransition(int var, float t1, int val1, 
			       float t2, int val2);
	virtual void endTransition(void);
	void setPathType(Transition type);

	void setNumberOfPaths(int num);
	void setNextPath(float time);
};

#endif 
