/*
Copyright (C) 1997 $B9b66(B $B?-(B (TAKAHASHI Shin)
*/

/* Shape class */

#include "Shape.h"

Shape::Shape(void)
{
	void endOfTransition(void *, SoSensor *);

	//node = new SoTransformSeparator;
	node = new SoSeparator;
	node->ref();

	location = new SoTranslation;
	node->addChild(location);
	direction = new SoRotation;
	node->addChild(direction);
	zaisitu = NULL;

	path = new SoCalculator;
	path->ref();

	// Attach a sensor to 'path->a'
	endDetect = new SoFieldSensor(endOfTransition, this);
	endDetect->attach(&(path->a));

	// clear deleteFlag;
	deleteFlag = FALSE;

	viaList = new SoMFVec3f;
}

Shape::~Shape(void)
{

	((SoGroup *)(SoNode::getByName("Root")))->removeChild(node);
	node->unref();
	path->unref();

	delete endDetect;

	delete viaList;
}

void Shape::setName(int id)
{
	name = id;

	return;
}

void Shape::setMaterial(MaterialType type, float v1, float v2, float v3)
{
   if(zaisitu == NULL){
	zaisitu = new SoMaterial;
	node->insertChild(zaisitu, 0);
   }
   switch(type){
     default: break;
     case AMBIENT:
	zaisitu->ambientColor.setValue(v1, v2, v3);
	break;
     case DIFFUSE:
	zaisitu->diffuseColor.setValue(v1, v2, v3);
	break;
     case SPECULAR:
	zaisitu->specularColor.setValue(v1, v2, v3);
	break;
     case EMISSIVE:
	zaisitu->emissiveColor.setValue(v1, v2, v3);
	break;
     case SHININESS:
	zaisitu->shininess.setValue(v1);
	break;
     case TRANSPARENCY:
	zaisitu->transparency.setValue(v1);
	break;
   }

   return;
}


int Shape::getName(void)
{
	return name;
}

void Shape::moveto(float x, float y, float z)
{
	location->translation.setValue(x, y, z);

	return;
}

void Shape::setVariable(int , int )
{
	return;
}

void Shape::rotate(float x, float y, float z, float theta)
{
	direction->rotation.setValue(SbVec3f(x, y, z), theta);
}

void Shape::setTransition(int , int , int )
{
	puts("masaka!!!");
	return;
}

void Shape::setLongTransition(int var, float t1, int val1, float t2, int val2)
{
  this->setTransition(var, val1, val2);
  path->H.setValue(t1+1.0, t2, 0);
  fprintf(stdout,"%d:%f -> %d:%f, %f->%f, %f\n", val1, t1+1.0, val2, t2,
	path->H[0][0], path->H[0][1], path->a[0]);

  return;
}

void Shape::endTransition(void)
{
	return;
}

void Shape::deleteAfterTransition(void)
{
	deleteFlag = TRUE;

	return;
}

void Shape::setPathType(Transition type)
{
   transType = type;

   switch(type.path){
	case circuitous:{
		// Using Hermite Curve
		//   input
		//	a : time
		//	B : p1 (start point)
		//	C : p4 (end point)
		//	D : r1 (start tangent vector)
		//	E : r4 (end tangent vector)
		//	H[0] : start time
		//	H[1] : end time
		//	b,c : width change
		//	d,e : depth change
		//	f,g : height change
		//   output
		//	oA : position
		//	oa : width
		//	ob : depth
		//	oc : height
		const char *expr[10] = {
				//"te=0.5-sin(M_PI*cos(M_PI*a)/2.0)/2.0",
//"te=-cos(M_PI*a)/4.0-sin(M_PI*sin(M_PI*cos(M_PI*a)/2.0)/2.0)/4.0+0.25",
				//"ta=(te>1.0)?1.0:((te<0.0)?0.0:te)",
  "te=(a>H[1])?1.0:((a<H[0])?0.0:((a-H[0])/(H[1]-H[0])))",
  "ta=-sin(M_PI*sin(M_PI*cos(M_PI*te)/2.0)/2.0)/2.0+0.5",
				"tb=ta*ta",
				"tc=tb*ta",
				"tA=2.0*B-2.0*C+D+E",
				"tB=-3.0*B+3.0*C-2.0*D-E",
				"oA=tA*tc+tB*tb+D*ta+B",
				"oa=(c-b)*ta+b",
				"ob=(e-d)*ta+d",
				"oc=(g-f)*ta+f"};

		path->expression.setValues(0, 10, expr);
		path->D = type.v1;
		path->E = type.v2;
	   }
	   break;
	case lazy:{
		// lazy
		//   input
		//	a : time
		//	B : p1 (start point)
		//	C : p4 (end point)
		//	b,c : width change
		//	d,e : depth change
		//	f,g : height change
		//	H[0] : start time
		//	H[1] : end time
		//   output
		//	oA : position
		//	oa : width
		//	ob : depth
		//	oc : height
		const char *expr[4] ={"oA=(a>H[1])?C:B",
				"oa=(a>H[1])?c:b",
				"ob=(a>H[1])?e:d",
				"oc=(a>H[1])?g:f"};
		path->expression.setValues(0, 4, expr);
	   }
	   break;
	case deletion:{
		// deletion
		//   input
		//	a : time
		//	B : p1 (start point)
		//	C : p4 (end point)
		//	b,c : width change
		//	d,e : depth change
		//	f,g : height change
		//	H[0] : start time
		//	H[1] : end time
		//   output
		//	oA : position
		//	oa : width
		//	ob : depth
		//	oc : height
		const char *expr[5] ={
			"ta=(a>H[1])?1.0:((a<H[0])?0.0:(a-H[0])/(H[1]-H[0]))",
				"oA=(ta==1.0)?C:B",
				"oa=(c-b)*ta+b",
				"ob=(e-d)*ta+d",
				"oc=(g-f)*ta+f"};
		path->expression.setValues(0, 5, expr);
	   }
	   break;
	   /*
	case creation:{
		// creation
		//   input
		//	a : time
		//	B : p1 (start point)
		//	C : p4 (end point)
		//	b,c : width change
		//	d,e : depth change
		//	f,g : height change
		//	H[0] : start time
		//	H[1] : end time
		//   output
		//	oA : position
		//	oa : width
		//	ob : depth
		//	oc : height
		const char *expr[5] ={
			"ta=(a>H[1])?1.0:((a<H[0])?0.0:(a-H[0])/(H[1]-H[0]))",
				"oA=(a==H[0])?B:C",
				"oa=(c-b)*ta+b",
				"ob=(e-d)*ta+d",
				"oc=(g-f)*ta+f"};
		path->expression.setValues(0, 5, expr);
	   }
	   break;*/
	case immediate:{
		// immediate
		//   input
		//	a : time
		//	B : p1 (start point)
		//	C : p4 (end point)
		//	H[0] : start time
		//	H[1] : end time
		//	b,c : width change
		//	d,e : depth change
		//	f,g : height change
		//   output
		//	oA : position
		//	oa : width
		//	ob : depth
		//	oc : height
		const char *expr[4] ={"oA=(a==H[0])?B:C",
				"oa=(a==H[0])?b:c",
				"ob=(a==H[0])?d:e",
				"oc=(a==H[0])?f:g"};
		path->expression.setValues(0, 4, expr);
	   }
	   break;
	case multipath: {
		// Mutlipath (straight)
		//   input
		//	a : time
		//	B : p1 (start point)
		//	E : p4 (end point)
		//	H[0] : start time
		//	H[1] : end time
		//	b,c : width change
		//	d,e : depth change
		//	f,g : height change
		//   output
		//	oA : position
		//	oa : width
		//	ob : depth
		//	oc : height
		const char *expr[5] ={
			"ta=(a>H[1])?1.0:((a<H[0])?0.0:(a-H[0])/(H[1]-H[0]))",
				"oA=(E-B)*(D[0]*ta-D[1])+B",
				"oa=(c-b)*ta+b",
				"ob=(e-d)*ta+d",
				"oc=(g-f)*ta+f"};

		path->expression.setValues(0, 5, expr);
		path->D.setValue(1.0, 0.0, 0.0);
	   }
	   break;
	case straight:
	default:{
		// Straight
		//   input
		//	a : time
		//	B : p1 (start point)
		//	C : p4 (end point)
		//	H[0] : start time
		//	H[1] : end time
		//	b,c : width change
		//	d,e : depth change
		//	f,g : height change
		//   output
		//	oA : position
		//	oa : width
		//	ob : depth
		//	oc : height
		const char *expr[6] ={
   "te=(a>H[1])?1.0:((a<H[0])?0.0:((a-H[0])/(H[1]-H[0])))",
   "ta=-sin(M_PI*sin(M_PI*cos(M_PI*te)/2.0)/2.0)/2.0+0.5",
				"oA=(C-B)*ta+B",
				"oa=(c-b)*ta+b",
				"ob=(e-d)*ta+d",
				"oc=(g-f)*ta+f"};

		path->expression.setValues(0, 6, expr);
		path->D.setValue(1.0, 0.0, 0.0);
	   }
	   break;
   }
}

void Shape::setNumberOfPaths(int num)
{
   path->D.setValue((float)num, 0.0, 0.0);
   numberOfPath = num;
   nanbanme = 1;
}

void Shape::setNextPath(float time)
{
   // store of points on a path 
   //   0 : B (start point)
   //   1 : viaList[0]
   //   2 : viaList[1]
   //   3 : viaList[2]
   //   4 : C (end point)
   //
   if(transType.path != multipath) return;

   if(time > ((float)nanbanme/(float)numberOfPath)){
        //fprintf(stderr,"%f %d %d\n", time, nanbanme, numberOfPath);
	path->D.setValue((float)numberOfPath, (float)nanbanme, 0.0);
	path->B = path->E;
	if(nanbanme == (numberOfPath - 1)){
		path->E = path->C;
	}else{
		path->E = (*viaList)[nanbanme];
	}
	nanbanme ++;
        /*fprintf(stderr,"%3.1f %3.1f %3.1f ---> %3.1f %3.1f %3.1f\n%3.1f %3.1f %3.1f\n",
		path->B[0][0], path->B[0][1], path->B[0][2],
		path->E[0][0], path->E[0][1], path->E[0][2],
		path->D[0][0], path->D[0][1], path->D[0][2]);*/
   }
}
