/*
Copyright (C) 1997 $B9b66(B $B?-(B (TAKAHASHI Shin)
*/

/* Cylinder class */

#include "Cylinder.h"
#include <Inventor/engines/SoElapsedTime.h>
#include <Inventor/engines/SoCalculator.h>
#include <Inventor/sensors/SoFieldSensor.h>
#include <Inventor/fields/SoSFBool.h>

extern SoElapsedTime	*globalCounter;

Cylinder::Cylinder(void)
{

	const char *expr[6] ={"tA=B-A",
		"ta=length(tA)", 
		"oA=vec3f(tA[2],0.0,-tA[0])",
		"oa=(ta!=0)?acos(tA[1]/ta):0",
		"ob=ta",
		"oB=(A+B)/2.0"};

	enchu = new SoCylinder;
	node->addChild(enchu);

	connection = new SoCalculator;
	connection->expression.setValues(0, 6, expr);
	connection->ref();
	kaiten = new SoComposeRotation;
	kaiten->axis.connectFrom(&connection->oA);
	kaiten->angle.connectFrom(&connection->oa);
}

Cylinder::~Cylinder(void)
{
	connection->unref();
	//'kaiten' should be deleted automatically
}

void Cylinder::setRadius(float radius)
{
	enchu->radius.setValue(radius);
}

void Cylinder::setHeight(float height)
{
	enchu->height.setValue(height);
}

void Cylinder::setVariable(int type, int val)
{
      SbVec3f tmp = location->translation.getValue();

	switch(type){
	   case 2:
	      this->setRadius((float)val);
	      break;
	   case 1:
	      this->setHeight((float)val);
	      break;
	   case 4:
	      location->translation.setValue((float)val, tmp[1], tmp[2]);
	      break;
	   case 5:
	      location->translation.setValue(tmp[0], (float)val, tmp[2]);
	      break;
	   case 6:
	      location->translation.setValue(tmp[0], tmp[1], (float)val);
	      break;
	  default:
	      break;
	}
      // Debug
      //printf("%s  ", name);
}

void Cylinder::setTransition(int type, int val1, int val2)
{
	//debug
	//printf("<%s> %c %d %d\n", name, *type, val1, val2);
	if(val1 == val2) {
		switch(type){
		   case 1:
		   case 2:
		      return;
		   case 4:
		      path->B.setValue(val1, path->B[0][1], path->B[0][2]);
		      path->C.setValue(val1, path->C[0][1], path->C[0][2]);
		      return;
		   case 5:
		      path->B.setValue(path->B[0][0], val1, path->B[0][2]);
		      path->C.setValue(path->C[0][0], val1, path->C[0][2]);
		      return;
		   case 6:
		      path->B.setValue(path->B[0][0], path->B[0][1], val1);
		      path->C.setValue(path->C[0][0], path->C[0][1], val1);
		      return;
		  default:
		      return;
		}
	}else{
	        if(!(path->a.isConnected())){
			// Connect 'globalCounter' to 'path'
			path->a.connectFrom(&globalCounter->timeOut);
		}
		path->H.setValue(path->a[0], path->a[0] + 1.0, 0);

		switch(type){
		   case 1:
		      path->d = val1;
		      path->e = val2;
		      enchu->height.connectFrom(&path->ob);
		      break;
		   case 2:
		      path->b = val1;
		      path->c = val2;
		      enchu->radius.connectFrom(&path->oa);
		      break;
		   case 4:
		      path->B.setValue(val1, path->B[0][1], path->B[0][2]);
		      path->C.setValue(val2, path->C[0][1], path->C[0][2]);
		      if(!(location->translation.isConnected()))
			location->translation.connectFrom(&path->oA);
		      break;
		   case 5:
		      path->B.setValue(path->B[0][0], val1, path->B[0][2]);
		      path->C.setValue(path->C[0][0], val2, path->C[0][2]);
		      if(!(location->translation.isConnected()))
			location->translation.connectFrom(&path->oA);
		      break;
		   case 6:
		      path->B.setValue(path->B[0][0], path->B[0][1], val1);
		      path->C.setValue(path->C[0][0], path->C[0][1], val2);
		      if(!(location->translation.isConnected()))
			location->translation.connectFrom(&path->oA);
		      break;
		  default:
		      break;
		}
	}
}

void Cylinder::endTransition(void)
{
	// Detouching the sensor
	 endDetect->detach();

        // Disconnecting various engines
         enchu->radius.disconnect();
         //enchu->height.disconnect();
         //location->translation.disconnect();
         path->a.disconnect();

	// delete this
	 if(deleteFlag){
		delete this;
	 }else{
	   if(transType.path == creation){
		 transType.path = straight;
		 this->setPathType(transType);
	   }
	 }
	 return;
}

void Cylinder::setupConnection(Shape *end1, Shape *end2)
{

	connection->A.connectFrom(&(end1->location->translation));
	connection->B.connectFrom(&(end2->location->translation));

	direction->rotation.connectFrom(&kaiten->rotation);

	enchu->height.connectFrom(&connection->ob);
	location->translation.connectFrom(&connection->oB);

	return;
}
