/*
Copyright (C) 1997 $B9b66(B $B?-(B (TAKAHASHI Shin)
*/

/* Cone class */

#include "Cone.h"
#include <Inventor/engines/SoElapsedTime.h>
#include <Inventor/engines/SoCalculator.h>
#include <Inventor/sensors/SoFieldSensor.h>
#include <Inventor/fields/SoSFBool.h>

extern SoElapsedTime	*globalCounter;

Cone::Cone(void)
{
	ensui = new SoCone;
	node->addChild(ensui);
}

void Cone::setRadius(float radius)
{
	ensui->bottomRadius.setValue(radius);
}

void Cone::setHeight(float height)
{
	ensui->height.setValue(height);
}

void Cone::setVariable(int type, int val)
{
      SbVec3f tmp = location->translation.getValue();

	switch(type){
	   case 2:
	      this->setRadius((float)val);
	      break;
	   case 1:
	      this->setHeight((float)val);
	      break;
	   case 4:
	      location->translation.setValue((float)val, tmp[1], tmp[2]);
	      break;
	   case 5:
	      location->translation.setValue(tmp[0], (float)val, tmp[2]);
	      break;
	   case 6:
	      location->translation.setValue(tmp[0], tmp[1], (float)val);
	      break;
	  default:
	      break;
	}
      // Debug
      //printf("%s  ", name);
}

void Cone::setTransition(int type, int val1, int val2)
{
	//debug
	//printf("<%s> %c %d %d\n", name, *type, val1, val2);
	if(val1 == val2) {
		switch(type){
		   case 1:
		   case 2:
		      return;
		   case 4:
		      path->B.setValue(val1, path->B[0][1], path->B[0][2]);
		      path->C.setValue(val1, path->C[0][1], path->C[0][2]);
		      return;
		   case 5:
		      path->B.setValue(path->B[0][0], val1, path->B[0][2]);
		      path->C.setValue(path->C[0][0], val1, path->C[0][2]);
		      return;
		   case 6:
		      path->B.setValue(path->B[0][0], path->B[0][1], val1);
		      path->C.setValue(path->C[0][0], path->C[0][1], val1);
		      return;
		  default:
		      return;
		}
	}else{
	        if(!(path->a.isConnected())){
			// Connect 'globalCounter' to 'path'
			path->a.connectFrom(&globalCounter->timeOut);
		}

		switch(type){
		   case 1:
		      path->d = val1;
		      path->e = val2;
		      ensui->height.connectFrom(&path->ob);
		      break;
		   case 2:
		      path->b = val1;
		      path->c = val2;
		      ensui->bottomRadius.connectFrom(&path->oa);
		      break;
		   case 4:
		      path->B.setValue(val1, path->B[0][1], path->B[0][2]);
		      path->C.setValue(val2, path->C[0][1], path->C[0][2]);
		      if(!(location->translation.isConnected()))
			location->translation.connectFrom(&path->oA);
		      break;
		   case 5:
		      path->B.setValue(path->B[0][0], val1, path->B[0][2]);
		      path->C.setValue(path->C[0][0], val2, path->C[0][2]);
		      if(!(location->translation.isConnected()))
			location->translation.connectFrom(&path->oA);
		      break;
		   case 6:
		      path->B.setValue(path->B[0][0], path->B[0][1], val1);
		      path->C.setValue(path->C[0][0], path->C[0][1], val2);
		      if(!(location->translation.isConnected()))
			location->translation.connectFrom(&path->oA);
		      break;
		  default:
		      break;
		}
	}
}

void Cone::endTransition(void)
{
	// Detouching the sensor
	 endDetect->detach();

        // Disconnecting various engines
         ensui->bottomRadius.disconnect();
         //ensui->height.disconnect();
         //location->translation.disconnect();
         path->a.disconnect();

	// delete this
	 if(deleteFlag){
		delete this;
	 }else{
	   if(transType.path == creation){
		 transType.path = straight;
		 this->setPathType(transType);
	   }
	 }
	 return;
}
