/*
Copyright (C) 1997 $B9b66(B $B?-(B (TAKAHASHI Shin)
*/

/* Box class */

#include "Box.h"

#include <Inventor/engines/SoCalculator.h>
#include <Inventor/engines/SoElapsedTime.h>

extern SoElapsedTime	*globalCounter;

Box::Box(void)
{
	hako = new SoCube;
	node->addChild(hako);
}

void Box::setWidth(float width)
{
	hako->width.setValue(width);
}

void Box::setHeight(float height)
{
	hako->height.setValue(height);
}

void Box::setDepth(float depth)
{
	hako->depth.setValue(depth);
}

void Box::setSize(float width, float height, float depth)
{
	hako->width.setValue(width);
	hako->height.setValue(height);
	hako->depth.setValue(depth);
}

void Box::setVariable(int type, int val)
{
      SbVec3f tmp = location->translation.getValue();

	switch(type){
	   case 3:
	      this->setWidth((float)val);
	      break;
	   case 0:
	      this->setDepth((float)val);
	      break;
	   case 1:
	      this->setHeight((float)val);
	      break;
	   case 4:
	      location->translation.setValue((float)val, tmp[1], tmp[2]);
	      break;
	   case 5:
	      location->translation.setValue(tmp[0], (float)val, tmp[2]);
	      break;
	   case 6:
	      location->translation.setValue(tmp[0], tmp[1], (float)val);
	      break;
	  default:
	      break;
	}
}

void Box::setTransition(int type, int val1, int val2)
{
        if(val1 == val2) {
                switch(type){
                   case 3:
                   case 0:
                   case 1:
                      return;
                   case 4:
                      path->B.setValue(val1, path->B[0][1], path->B[0][2]);
                      path->C.setValue(val1, path->C[0][1], path->C[0][2]);
                      return;
                   case 5:
                      path->B.setValue(path->B[0][0], val1, path->B[0][2]);
                      path->C.setValue(path->C[0][0], val1, path->C[0][2]);
                      return;
                   case 6:
                      path->B.setValue(path->B[0][0], path->B[0][1], val1);
                      path->C.setValue(path->C[0][0], path->C[0][1], val1);
                      return;
                  default:
                      return;
                }
        }else{
                if(!(path->a.isConnected())){
                        // Connect 'globalCounter' to 'path'
                        path->a.connectFrom(&globalCounter->timeOut);
                }
		path->H.setValue(path->a[0], path->a[0] + 1.0, 0);
                switch(type){
                   case 3:
                      path->b = val1;
                      path->c = val2;
                      hako->width.connectFrom(&path->oa);
                      break;
                   case 0:
                      path->d = val1;
                      path->e = val2;
                      hako->depth.connectFrom(&path->ob);
                      break;
                   case 1:
                      path->f = val1;
                      path->g = val2;
                      hako->height.connectFrom(&path->oc);
                      break;
                   case 4:
                      path->B.setValue(val1, path->B[0][1], path->B[0][2]);
                      path->C.setValue(val2, path->C[0][1], path->C[0][2]);
                      if(!(location->translation.isConnected()))
                        location->translation.connectFrom(&path->oA);
                      break;
                   case 5:
                      path->B.setValue(path->B[0][0], val1, path->B[0][2]);
                      path->C.setValue(path->C[0][0], val2, path->C[0][2]);
                      if(!(location->translation.isConnected()))
                        location->translation.connectFrom(&path->oA);
                      break;
                   case 6:
                      path->B.setValue(path->B[0][0], path->B[0][1], val1);
                      path->C.setValue(path->C[0][0], path->C[0][1], val2);
                      if(!(location->translation.isConnected()))
                        location->translation.connectFrom(&path->oA);
                      break;
                  default:
                      break;
                }
        }
}

void Box::endTransition(void)
{
        // detaching the sensor
         //endDetect->detach();

        // Disconnecting various engines
         hako->width.disconnect();
         hako->height.disconnect();
         hako->depth.disconnect();
         location->translation.disconnect();
         path->a.disconnect();

        // Delete this if deleteFlag is true
         if(deleteFlag){ 
		delete this;
	 }else{
	   if(transType.path == creation){
		transType.path = straight;
		this->setPathType(transType);
	   }
	 }

         return;
}
