/*
Copyright (C) 1997 $B9b66(B $B?-(B (TAKAHASHI Shin)
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <unistd.h>
#include <signal.h>
#include <sys/time.h>

#include "Shape.h"


#define	BUFSIZE 1023
#define TRUE  1
#define FALSE 0

static char	buf[BUFSIZE+1];	/* line buffer */
static char	command[128];
static char	mode[256];
static FILE 	*fp;

float	global_time;

static float	next_event_time;
int		animating;
Am_Object	my_win;
Am_Object	tokei;
Am_Slot_Key	jikoku;
Am_Slot_Key	start_time;
Am_Slot_Key	end_time;
Am_Slot_Key	start_width;
Am_Slot_Key	end_width;
Am_Slot_Key	start_height;
Am_Slot_Key	end_height;
Am_Slot_Key	start_top;
Am_Slot_Key	end_top;
Am_Slot_Key	start_left;
Am_Slot_Key	end_left;

Am_Slot_Key	PathListW;
Am_Slot_Key	PathListH;
Am_Slot_Key	PathListT;
Am_Slot_Key	PathListL;

Am_Slot_Key	End1;
Am_Slot_Key	End2;

#include "ShapeTable.h"
#include "VsrObjects.h"
#include "TransitionType.h"


ShapeObject	object_table[TABLESIZE];


int	step;
int	DEBUG_FLAG;

/* maybe OK */
static void analyze_mode(int loc, char *mode)
{
   char 	*ptr;
   float	v1, v2, v3;
   int		i;

   /* In Amulet, only RGB values are effective.
     But it's very troublesome to change the following codes... */

   ptr = mode;
   while(TRUE){
      switch(*ptr){
	 case 'a' : // ambient
		ptr = strchr(ptr, ' '); ptr++;
		sscanf(ptr, "%f %f %f", &v1, &v2, &v3);
		(object_table[loc].object)->setMaterial(AMBIENT, v1, v2, v3);
		for(i=0;i<3;i++){ 
			ptr = strchr(ptr, ' ');
			ptr++;
		}
		break;
	 case 'd' : // diffuse
		ptr = strchr(ptr, ' '); ptr++;
		sscanf(ptr, "%f %f %f", &v1, &v2, &v3);
		(object_table[loc].object)->setMaterial(DIFFUSE, v1, v2, v3);
		for(i=0;i<3;i++){ 
			ptr = strchr(ptr, ' ');
			ptr++;
		}
		break;
	 case 's' : 
		switch(*(ptr+1)){
		   case 'p' : // specular
			ptr = strchr(ptr, ' '); ptr++;
			sscanf(ptr, "%f %f %f", &v1, &v2, &v3);
			(object_table[loc].object)->
				setMaterial(SPECULAR, v1, v2, v3);
			for(i=0;i<3;i++){ 
				ptr = strchr(ptr, ' ');
				ptr++;
			}
			break;
		   case 'h' : // shininess
			ptr = strchr(ptr, ' '); ptr++;
			sscanf(ptr, "%f", &v1);
			(object_table[loc].object)-> 
				setMaterial(SHININESS, v1, 0.0, 0.0);
			ptr = strchr(ptr, ' '); ptr++;
			break;
		    default : return;
		} 
		break;
	 case 'e' : // emissive
		ptr = strchr(ptr, ' '); ptr++;
		sscanf(ptr, "%f %f %f", &v1, &v2, &v3);
		(object_table[loc].object)->setMaterial(EMISSIVE, v1, v2, v3);
		for(i=0;i<3;i++){ 
			ptr = strchr(ptr, ' ');
			ptr++;
		}
		break;
	 case 't' : // transparency
		ptr = strchr(ptr, ' '); ptr++;
		sscanf(ptr, "%f", &v1);
		(object_table[loc].object)->
			setMaterial(TRANSPARENCY, v1, 0.0, 0.0);
		ptr = strchr(ptr, ' '); ptr++;
		break;
	 case 'E' : // End
	 default  : 
		return;
      }
   }
}

/* OK */
int search_object(int name)
{
   int hash_value, loc;

   hash_value = name & TABLEMASK;

   loc = hash_value;
   while((object_table[loc].empty)||(object_table[loc].name!=name)){
	if(object_table[loc].name==name) break;
	loc = (loc + 1)&TABLEMASK;
	if(loc == hash_value){
		fprintf(stderr,"cannot find %s!\n", name);
		exit(1);
	}
   }
   return loc;
}

/*
static Shape *graphical_object(int Obj, int name)
{
   switch(Obj){
      case SPHERE:{
		   Sphere *obj = new Sphere;
		   obj->setName(name);
		   return obj;
		}
      case LINE:{
		   Line *obj = new Line;
		   obj->setName(name);
		   return obj;
		}	  
      case BOX:{
		   Box *obj = new Box;
		   obj->setName(name);
		   return obj;
		}
      case CYLINDER:{
		   Cylinder *obj = new Cylinder;
		   obj->setName(name);
		   return obj;
		}
      default:
	fprintf(stderr,"unknown object type!\n");
	exit(1);
   }
}*/

/* OK */
static void create_object(void)
{
   int type, hash_value, loc, name;
   char *ptr;
   Transition	tp;

   sscanf(buf, "%s %d %d", command, &type, &name);

   hash_value = name & TABLEMASK;
   loc = hash_value;
   while(!(object_table[loc].empty)){
	loc = (loc + 1)&TABLEMASK;
	if(loc == hash_value){
		fprintf(stderr,"cannot find space!\n");
		exit(1);
	}
   }
   //object_table[loc].object = graphical_object(type, name);
   object_table[loc].object = new Shape;
   (object_table[loc].object)->setShape(type, name);
   object_table[loc].name   = name;
   object_table[loc].type   = type;
   object_table[loc].empty  = FALSE; /* not empty */
 
   tp.path = CREATION;
   (object_table[loc].object)->setPathType(tp);

   ptr = &(buf[9]);
   ptr = strchr(ptr, ' '); ptr++;

   analyze_mode(loc, ptr);

   object_table[loc].object->loc = loc;

}


/* OK */
static void set_line(void)
{
   int	lobj, end1, end2;
   int  name1, name2, name3;

   sscanf(buf, "%s %d %d %d", command, &name1, &name2, &name3);

   lobj = search_object(name1);
   end1 = search_object(name2);
   end2 = search_object(name3);

   (object_table[lobj].object)->
   	setupConnection(object_table[end1].object, object_table[end2].object);
}

/* OK */
static void set_transition(void)
{
   int val1, val2;
   int loc;
   int name, var_name;

   sscanf(buf, "%s %d %d %d %d", command, &name, &var_name, &val1, &val2);

   loc = search_object(name);

   (object_table[loc].object)->setTransition(var_name, val1, val2);
}

/* OK */
static void delete_object(void)
{
   int type, loc, name;
   Transition	tp;

   sscanf(buf, "%s %d %d %s", command, &type, &name, mode);

   loc = search_object(name);

   tp.path = DELETION;
   (object_table[loc].object)->setPathType(tp);

   object_table[loc].deleted = TRUE;
}

/* OK */
static void set_variable(void)
{
   int type, val, loc, name, var_name;

   sscanf(buf, "%s %d %d %d %d", command, &type, &name, &var_name, &val);

   loc = search_object(name);

   (object_table[loc].object)->setVariable(var_name, val);
}

/* maybe OK */
static void set_mode(void)
{
   int loc, name;
   char *ptr;

   sscanf(buf, "%s %d", command, &name);

   loc = search_object(name);

   ptr = &(buf[6]);
   ptr = strchr(ptr, ' '); ptr++;

   analyze_mode(loc, ptr); /* modes "?????" HERE STARTS MODES */
}

/* mada
static void set_text(void)
{
   int loc, name;
   char aString[128];

   sscanf(buf, "%s %d %s %s", command, &name, aString, mode);

   loc = search_object(name);

   aString[strlen(aString)-1] = (char)NULL;

   ((Word *)object_table[loc].object)->setString(&(aString[1]), mode);
}
*/

/* mada 
static void set_path(void)
{
   int 		type, name, j;
   char 	*ptr;
   Shape	*shp; 
   Transition	tp;

   sscanf(buf, "%s %d %d", command, &name, &type);

   ptr = buf;
   for(j=0;j<3;j++){ 
	ptr = strchr(ptr, ' ');
	ptr++;
   }

   shp = object_table[search_object(name)].object;

   tp.path = type;

   if(type == CIRCUITOUS){
	int v1x, v1y, v1z, v2x, v2y, v2z;

        sscanf(ptr, "%d %d %d %d %d %d", &v1x, &v1y, &v1z, &v2x, &v2y, &v2z);
	tp.v1[0] = (GLfloat)v1x;
	tp.v1[1] = (GLfloat)v1y;
	tp.v1[2] = (GLfloat)v1z;
	tp.v2[0] = (GLfloat)v2x;
	tp.v2[1] = (GLfloat)v2y;
	tp.v2[2] = (GLfloat)v2z;
	shp->setPathType(tp);
   }else if(type == MULTIPATH){
	int num, x, y, z, i;

	shp->setPathType(tp);

	sscanf(ptr, "%d", &num); 
	shp->setNumberOfPaths(num);
	ptr = strchr(ptr, ' '); ptr++;

	//printf("# of path = %d\n", num);

	for(i = 0; i < (num-1); i++){
		//puts(ptr);
		sscanf(ptr, "%d %d %d", &x, &y, &z);
		shp->viaList[i][0] = (GLfloat)x;
		shp->viaList[i][1] = (GLfloat)x;
		shp->viaList[i][2] = (GLfloat)x;
		//printf("%d %d %d\n",x,y,z);
		for(j=0;j<3;j++){ 
			ptr = strchr(ptr, ' ');
			ptr++;
		}
	}
   }else{
	   shp->setPathType(tp);
   }
}*/


static void end_of_state(void)
{
   Am_Do_Events(FALSE);
}


static void clear_objects(void)
{
   int i;

   for(i = 0; i < TABLESIZE; i++)
      if(!(object_table[i].empty)){
         delete object_table[i].object;
	 object_table[i].empty = TRUE;
	 object_table[i].deleted = FALSE;
      }
}

static void removeDeletedObjects(void)
{
   int i;
   Transition	tp;

   tp.path = STRAIGHT;

   for(i = 0; i < TABLESIZE; i++){
      if(object_table[i].empty) continue;
      if(object_table[i].deleted){
         delete object_table[i].object;
	 object_table[i].empty = TRUE;
	 object_table[i].deleted = FALSE;
      }

      // Set to Default Path Type
      (object_table[i].object)->setPathType(tp);
   }
}

void proceed_until_time(void)
{
   struct itimerval	mytimer;
   double interval;


   sscanf(buf, "%s %f", command, &next_event_time);

   mytimer.it_interval.tv_sec = 0;
   mytimer.it_interval.tv_usec = 5000;
   mytimer.it_value.tv_sec = 0;
   mytimer.it_value.tv_usec = 5000;
   setitimer(ITIMER_REAL, &mytimer, NULL);

   animating = TRUE;

   //printf("proceed_until_time next_event_time = %f\n", next_event_time);

   return;
}

void set_long_action(void)
{
   int val1, val2;
   int loc;
   int name1, name2, var_name1, var_name2;
   int id_num1, id_num2;
   float time2;
   long pos;

   sscanf(buf, "%s %d %d %d %d", command, &id_num1, &name1, &var_name1, &val1);
   puts(buf);

   pos = ftell(fp); // to memorize current file pointer
   while(!feof(fp)){
	fgets(buf, BUFSIZE, fp);
	if((buf[0] == 0)||(buf[0] == '\n')) continue;
	if(!strncmp(buf, "time", 4)){
	   sscanf(buf, "%s %f", command, &time2);
	}else if(!strncmp(buf, "stop", 4)){
	   sscanf(buf, "%s %d %d %d %d", command, &id_num2, &name2, 
					&var_name2, &val2);
	   puts(buf);
	   if((id_num1 == id_num2)&&(var_name1 == var_name2)){ // found stop event!
		loc = search_object(name1);
		(object_table[loc].object)->
		   setLongTransition(var_name1, global_time, val1, time2, val2);
		fseek(fp, pos, SEEK_SET); //set pos as before
		return;
	   }
	}
   }
   /* Oh, cannot find stop event */
   fprintf(stderr,"cannot find a stop event! %s\n", name1);
   exit(1);
}

extern int numberOfTransitions;

void readAnimData(void)
{
   //puts("Into readAnimData");
   while(TRUE){
     while(!feof(fp)){
	/* read from file */
	fgets(buf, BUFSIZE, fp);
	//puts(buf);
	if((buf[0] == 0)||(buf[0] == '\n')) continue;

	/* select command */
	switch(buf[0]){
	  case 'c' :
		switch(buf[1]){
		  case 'r' :			/* create */
			create_object(); 
			break;
		  case 'o' :			/* connect */
			set_line(); 
			break;
		  case 'h' :			/* change */
			set_transition(); 
			break;
		  default :
			fprintf(stderr,"ERROR!!!<<%s>>\n",buf);
			break;
		}
		break;
	  case 'd' :				/* delete */
		delete_object();
		break;
	  case 's' :				/* set */
		switch(buf[1]){
		  case 'e' :
			set_variable();
			break;
		  case 't' : /* start and stop */
			if(!strncmp(buf,"start",5)) set_long_action();
			break;
		  default :
			fprintf(stderr,"ERROR!!!<<%s>>\n",buf);
			break;
		}
		break;
	  case 'm' :				/* modes */
		set_mode();
		break;
	  case 'e' :				/* end_of_state */
		end_of_state();
		//puts("end_of_state!");
		break;
	  case 't' :
		switch(buf[1]){
		  case 'e' :
		     //set_text();
		     break;
		  case 'i' :	/* time */
		     fprintf(stderr,"#ofTransitiions=%d\n",numberOfTransitions);
		     numberOfTransitions = 0;
		     proceed_until_time();
		     return;
		}
		return;
	  case 'p' :				/* path */
		//set_path();
		break;
	  default:
		fprintf(stderr,"ERROR!!!<<%s>>\n",buf);
		break;
	}
     }
     if (step == 3) break;
     clear_objects();
     rewind(fp);
     global_time = 0.0;
     tokei.Set(jikoku, 0.0);
     fprintf(stderr,"da capo!\n");
   }
   return;
}

void timer_handler(int sig)
{
   struct itimerval	mytimer;

   //puts("timer handler");

   if(!animating){
	//puts("not animating");
	readAnimData();
   }else{
	global_time += 0.05;
	tokei.Set(jikoku, global_time);
	//printf("animating: ct = %f nt = %f\n", global_time, next_event_time);
	Am_Do_Events(FALSE);
	if(global_time >= next_event_time){
	   //puts("end_of_transition");
	   animating = FALSE;
	   mytimer.it_value.tv_sec = 0;
	   mytimer.it_value.tv_usec = 1;
	   mytimer.it_interval.tv_sec = 0;
	   mytimer.it_interval.tv_usec = 0;
	   setitimer(ITIMER_REAL, &mytimer, NULL);
	}
   }
   return;
}

void main(int argc, char *argv[])
{
   int	i, distance;

   struct itimerval	mytimer;

   /* Initialize object_table */
   for(i = 0; i < TABLESIZE; i++){
	object_table[i].empty = TRUE;
	object_table[i].deleted = FALSE;
   }

   /* open a file */
   if(argc > 1){
      if((fp = fopen(argv[1], "r"))==NULL){
	perror("cannot open!");
	exit(1);
      }
   }else{
      fp = stdin;
   }

   /* see the setup flag */
   if(argc > 2)
     if(strcmp("-step", argv[2]) == 0) step = 1;
   if(argc > 2)
     if(strcmp("-debug", argv[2]) == 0){ step = 2; DEBUG_FLAG = 1; }
   if(argc > 2)
     if(strcmp("-once", argv[2]) == 0){ step = 3; }


  Am_Initialize ();

  my_win = Am_Window.Create ("my_win")
    .Set (Am_LEFT, 20)
    .Set (Am_TOP, 50)
    .Set (Am_WIDTH, 200)
    .Set (Am_HEIGHT, 200);

  Am_Screen.Add_Part (my_win);

  jikoku = Am_Register_Slot_Name("jikoku");
  start_time = Am_Register_Slot_Name("start_time");
  end_time = Am_Register_Slot_Name("end_time");
  start_width = Am_Register_Slot_Name("start_width");
  end_width = Am_Register_Slot_Name("end_width");
  start_height = Am_Register_Slot_Name("start_height");
  end_height = Am_Register_Slot_Name("end_height");
  start_top = Am_Register_Slot_Name("start_top");
  end_top = Am_Register_Slot_Name("end_top");
  start_left = Am_Register_Slot_Name("start_left");
  end_left = Am_Register_Slot_Name("end_left");

  PathListW = Am_Register_Slot_Name("PathListW");
  PathListH = Am_Register_Slot_Name("PathListH");
  PathListT = Am_Register_Slot_Name("PathListT");
  PathListL = Am_Register_Slot_Name("PathListL");

  End1 = Am_Register_Slot_Name("End1");
  End2 = Am_Register_Slot_Name("End2");

  global_time = 0.0;
  tokei = Am_Root_Object.Create("tokei")
		.Set(jikoku, 0.0);

  animating = FALSE;

  signal(SIGALRM, &timer_handler);
  mytimer.it_interval.tv_sec = 1;
  mytimer.it_interval.tv_usec = 0;
  mytimer.it_value.tv_sec = 2;
  mytimer.it_value.tv_usec = 0;
  setitimer(ITIMER_REAL, &mytimer, NULL);

  //my_win.Add_Part(Am_Line.Create().Set(Am_X2, 100).Set(Am_Y2, 100));


  Am_Main_Event_Loop ();
  Am_Cleanup ();

}
