/*
Copyright (C) 1997 $B9b66(B $B?-(B (TAKAHASHI Shin)
*/

/* TransitionType.h */

#ifndef __TransitionType_H__
#define __TransitionType_H__


#define	UNDEFINED	-1
#define	STRAIGHT	0
#define	CIRCUITOUS	1
#define	LAZY		2
#define	IMMEDIATE	3
#define	CREATION	4
#define	DELETION	5
#define	MULTIPATH	6

typedef int TransType;

typedef struct _Transition {
	TransType	path;
	float		v1[3];
	float		v2[3];
	union _attr {
		struct _box {
			TransType width;
			TransType depth;
			TransType height;
		}box;
		struct _sphere {
			TransType radius;
		}sphere;
		struct _cylinder {
			TransType radius;
			TransType height;
		}cylinder;
		struct _line {
			TransType radius;
		}line;
	} attr;
} Transition;

#endif
