/*
Copyright (C) 1997 $B9b66(B $B?-(B (TAKAHASHI Shin)
*/

/* Shape class */

#ifndef _myShape_h_
#define _myShape_h_

#include <amulet.h>
#include <amulet/object.h>

#include "TransitionType.h"
#include "VarType.h"
#include "MaterialType.h"

class Shape {
protected:
	int			name;
	int			numberOfPaths;
	int			nanbanme;
	Transition		transType;

	float	vars[7];
	float	ends[7][2];

public:
	int	loc;

	float	cx;
	float	cy;
	float	cz;

	float viaList[16][3];

	float	color[4];

	Am_Object	gobj;

	Shape(void);
	~Shape(void);

	virtual void draw(float time);

	void setVariable(int type, int val);
	void setTransition(int var, int val1, int val2);
	void setLongTransition(int var, float t1, int val1, float t2, int val2);
	void setShape(int type, int name);
	void setPathType(Transition type);
	void setNumberOfPaths(int num);
	void setMaterial(MaterialType type, float v1, float v2, float v3);
	void setupConnection(Shape *e1, Shape *e2);
};

#endif 
