/*
Copyright (C) 1997 $B9b66(B $B?-(B (TAKAHASHI Shin)
*/

/* Shape class */

#include "Shape.h"

#include "VsrObjects.h"

#include <stdio.h>
#include <stdlib.h>

extern Am_Object	my_win;
extern Am_Object	tokei;
extern Am_Slot_Key	jikoku;
extern Am_Slot_Key	start_time;
extern Am_Slot_Key	end_time;
extern Am_Slot_Key	start_width;
extern Am_Slot_Key	end_width;
extern Am_Slot_Key	start_height;
extern Am_Slot_Key	end_height;
extern Am_Slot_Key	start_top;
extern Am_Slot_Key	end_top;
extern Am_Slot_Key	start_left;
extern Am_Slot_Key	end_left;

extern Am_Slot_Key	PathListW;
extern Am_Slot_Key	PathListH;
extern Am_Slot_Key	PathListT;
extern Am_Slot_Key	PathListL;

extern Am_Slot_Key	End1;
extern Am_Slot_Key	End2;

extern float global_time;

Shape::Shape(void)
{
	numberOfPaths = 1;

	transType.path = UNDEFINED;
}

Shape::~Shape(void)
{
	gobj.Destroy();
}

void Shape::setShape(int type, int id)
{
	name = id;
	switch(type){
	  default:
	  case BOX:
		gobj = Am_Rectangle.Create()
				   .Set(PathListW, Am_Value_List())
				   .Set(PathListH, Am_Value_List())
				   .Set(PathListT, Am_Value_List())
				   .Set(PathListL, Am_Value_List());
		break;
	  case SPHERE:
		gobj = Am_Arc.Create()
			     .Set(PathListW, Am_Value_List())
			     .Set(PathListH, Am_Value_List())
			     .Set(PathListT, Am_Value_List())
			     .Set(PathListL, Am_Value_List());
		break;
	  case LINE:
		gobj = Am_Line.Create()
				.Set(Am_X1, 0)
				.Set(Am_Y1, 0)
				.Set(Am_X2, 100)
				.Set(Am_Y2, 50);
		break;
	}
	my_win.Add_Part (gobj);
	//puts("setShape");

	return;
}

void Shape::setVariable(int type, int val)
{
	//printf("%d = %d\n", type, val);
	vars[type] = (float)val;

	
	if(transType.path == UNDEFINED){
	  puts("Internal Error: 'setVariable' is called before 'setPathType'");
	  exit(1);
	}

	if(transType.path == CREATION){
	   ends[type][0] = 0.0;
	   ends[type][1] = (float)val;
	}else if(transType.path == DELETION){
	   ends[type][0] = (float)val;
	   ends[type][1] = 0.0;
	}

	  switch(type){
	     case VAR_W:
	       gobj.Set (Am_WIDTH, val);
	       break;
	     case VAR_H:
	       gobj.Set (Am_HEIGHT, val);
	       break;
	     case VAR_X:
	       gobj.Set (Am_LEFT, val);
	       break;
	     case VAR_Y:
	       gobj.Set (Am_TOP, val);
	       break;
	     case VAR_R:
	       gobj.Set (Am_HEIGHT, val * 2);
	       gobj.Set (Am_WIDTH,  val * 2);
	       break;
	     default:
	       break;
	  }
	//puts("setVar!");

	return;
}

//
// Defining Formulae 
//

Am_Define_Formula (int, trans_width)
{
  float t;
  Am_Value_List pl;
  Am_Value tmp;
  Am_Object obj;

  pl = self.Get(PathListW);
  //printf("width %d\n",pl.Length());
  pl.Start();
  //pl.Get(tmp); 
  obj = pl.Get();

  t = tokei.GV(jikoku);
  if(t < (float)obj.Get(start_time))
        return obj.Get(start_width);
  else if(t > (float)obj.Get(end_time)){
	pl.Delete();
	if(pl.Length() == 0){
	   self.Set(Am_WIDTH, (int)obj.Get(end_width));
	}else{
	   self.Set(PathListW, pl);
	}
        return obj.Get(end_width);
  }else
        return (int)(((int)obj.Get(end_width) - (int)obj.Get(start_width))
                *(t - (float)obj.Get(start_time))
                /((float)obj.Get(end_time)-(float)obj.Get(start_time))
                + (int)obj.Get(start_width));
}

Am_Define_Formula (int, trans_height)
{
  float t;
  Am_Value_List pl;
  Am_Value  tmp;
  Am_Object obj;

  pl = self.Get(PathListH);
  //printf("height %d\n",pl.Length());
  pl.Start();
  obj = pl.Get(); 

  t = tokei.GV(jikoku);
  if(t < (float)obj.Get(start_time))
        return obj.Get(start_height);
  else if(t > (float)obj.Get(end_time)){
	pl.Delete();
	if(pl.Length() == 0){
	   self.Set(Am_HEIGHT,(int)obj.Get(end_height));
	}else{
	   self.Set(PathListH, pl);
	}
        return obj.Get(end_height);
  }else
        return (int)(((int)obj.Get(end_height) - (int)obj.Get(start_height))
                *(t - (float)obj.Get(start_time))
                /((float)obj.Get(end_time)-(float)obj.Get(start_time))
                + (int)obj.Get(start_height));
}

Am_Define_Formula (int, trans_top)
{
  float t;
  Am_Value_List pl;
  Am_Value  tmp;
  Am_Object obj;

  pl = self.Get(PathListT);
  //printf("top %d\n",pl.Length());
  pl.Start();
  obj = pl.Get(); 

  t = tokei.GV(jikoku);
  //printf("time = %2.3f\n", t);
  if(t < (float)obj.Get(start_time))
        return obj.Get(start_top);
  else if(t > (float)obj.Get(end_time)){
	pl.Delete();
	if(pl.Length() == 0){
	   self.Set(Am_TOP,(int)obj.Get(end_top));
	}else{
	   self.Set(PathListT, pl);
	}
        return obj.Get(end_top);
  }else
        return (int)(((int)obj.Get(end_top) - (int)obj.Get(start_top))
                *(t - (float)obj.Get(start_time))
                /((float)obj.Get(end_time)-(float)obj.Get(start_time))
                + (int)obj.Get(start_top));
}

Am_Define_Formula (int, trans_left)
{
  float t;
  Am_Value_List pl;
  Am_Value  tmp;
  Am_Object obj;

  pl = self.Get(PathListL);
  //printf("left %d\n",pl.Length());
  pl.Start();
  obj = pl.Get(); 

  t = tokei.GV(jikoku);
  //printf("time = %2.3f\n", t);
  if(t < (float)obj.Get(start_time))
        return obj.Get(start_left);
  else if(t > (float)obj.Get(end_time)){
	pl.Delete();
	//printf("deleted!! %d", pl.Length());
	if(pl.Length() == 0){
	   //puts("here");
	   self.Set(Am_LEFT,(int)obj.Get(end_left));
	}else{
	   self.Set(PathListL, pl);
	}
        return obj.Get(end_left);
  }else
        return (int)(((int)obj.Get(end_left) - (int)obj.Get(start_left))
                *(t - (float)obj.Get(start_time))
                /((float)obj.Get(end_time)-(float)obj.Get(start_time))
                + (int)obj.Get(start_left));
}


//for debug
int numberOfTransitions;


void Shape::setTransition(int type, int val1, int val2)
{
	//printf("S:type = %d\n t1 = %2.3f : %d\n t2 = %2.3f : %d \n", 
	//	type, global_time, val1, global_time+1.0, val2);
	ends[type][0] = val1;
	ends[type][1] = val2;

	if(val1 != val2){
	  Am_Value_List	pl, tmp;
          Am_Object np = Am_Root_Object.Create();
	  switch(type){
	     case VAR_W:
	       np.Set (start_time, global_time)
		 .Set (end_time, global_time+1.0)
		 .Set (start_width, val1)
		 .Set (end_width, val2);
	       pl = gobj.Get (PathListW);
	       pl.Add(np);
	       gobj.Set (PathListW, pl);
	       //printf("length = %d\n", pl.Length());
	       gobj.Set (Am_WIDTH, trans_width);
	       break;
	     case VAR_H:
	       np.Set (start_time, global_time)
		 .Set (end_time, global_time+1.0)
		 .Set (start_height, val1)
		 .Set (end_height, val2);
	       pl = gobj.Get (PathListH);
	       pl.Add(np);
	       gobj.Set (PathListH, pl);
	       //printf("length = %d\n", pl.Length());
	       gobj.Set (Am_HEIGHT, trans_height);
	       break;
	     case VAR_R:
	       if(!gobj.Is_Instance_Of(Am_Line)){
		       np.Set (start_time, global_time)
			 .Set (end_time, global_time+1.0)
			 .Set (start_height, val1*2)
			 .Set (end_height, val2*2);
		       pl = gobj.Get (PathListH);
		       pl.Add(np);
		       gobj.Set (PathListH, pl);
		       //printf("length = %d\n", pl.Length());
		       gobj.Set (Am_HEIGHT, trans_height);
		       gobj.Set (Am_WIDTH, trans_height);
	       }
	       break;
	     case VAR_X:
	       np.Set (start_time, global_time)
		 .Set (end_time, global_time+1.0)
		 .Set (start_left, val1)
		 .Set (end_left, val2);
	       pl = gobj.Get (PathListL);
	       pl.Add(np);
	       gobj.Set (PathListL, pl);
	       gobj.Set (Am_LEFT, trans_left);
	       break;
	     case VAR_Y:
	       np.Set (start_time, global_time)
		 .Set (end_time, global_time+1.0)
		 .Set (start_top, val1)
		 .Set (end_top, val2);
	       pl = gobj.Get (PathListT);
	       pl.Add(np);
	       gobj.Set (PathListT, pl);
	       gobj.Set (Am_TOP, trans_top);
	       break;
	     default:
	       break;
	  }

	  numberOfTransitions ++;
	}

	return;
}

void Shape::setLongTransition(int type, float t1, int val1, float t2, int val2)
{
	ends[type][0] = val1;
	ends[type][1] = val2;

	//printf("L:type = %d\n t1 = %2.3f : %d\n t2 = %2.3f : %d \n", 
	//	type, t1, val1, t2, val2);
	if(val1 != val2){
	  Am_Value_List	pl;
          Am_Object np = Am_Root_Object.Create();
	  switch(type){
	     case VAR_W:
	       np.Set (start_time, t1+1.0)
		 .Set (end_time, t2)
		 .Set (start_width, val1)
		 .Set (end_width, val2);
	       pl = gobj.Get (PathListW);
	       pl.Add(np);
	       gobj.Set (PathListW, pl);
	       gobj.Set (Am_WIDTH, trans_width);
	       break;
	     case VAR_H:
	       np.Set (start_time, t1+1.0)
		 .Set (end_time, t2)
		 .Set (start_height, val1)
		 .Set (end_height, val2);
	       pl = gobj.Get (PathListH);
	       pl.Add(np);
	       gobj.Set (PathListH, pl);
	       gobj.Set (Am_HEIGHT, trans_height);
	       break;
	     case VAR_X:
	       np.Set (start_time, t1+1.0)
		 .Set (end_time, t2)
		 .Set (start_left, val1)
		 .Set (end_left, val2);
	       pl = gobj.Get (PathListL);
	       pl.Add(np);
	       gobj.Set (PathListL, pl);
	       gobj.Set (Am_LEFT, trans_left);
	       break;
	     case VAR_Y:
	       np.Set (start_time, t1+1.0)
		 .Set (end_time, t2)
		 .Set (start_top, val1)
		 .Set (end_top, val2);
	       pl = gobj.Get (PathListT);
	       pl.Add(np);
	       gobj.Set (PathListT, pl);
	       gobj.Set (Am_TOP, trans_top);
	       break;
	     default:
	       break;
	  }

	}

	return;
}

void Shape::draw(float)
{
	return;
}

void Shape::setPathType(Transition type)
{
   transType = type;
}

/*
void Shape::setNumberOfPaths(int num)
{
   numberOfPaths = num;
   nanbanme = 1;
}
*/


void Shape::setMaterial(MaterialType type, float v1, float v2, float v3)
{
   /*switch(type){
     default: break;
     case AMBIENT:
	ambient[0] = v1;
	ambient[1] = v2;
	ambient[2] = v3;
        break;
     case DIFFUSE:
	diffuse[0] = v1;
	diffuse[1] = v2;
	diffuse[2] = v3;
        break;
     case SPECULAR:
	specular[0] = v1;
	specular[1] = v2;
	specular[2] = v3;
        break;
     case EMISSIVE:
	emission[0] = v1;
	emission[1] = v2;
	emission[2] = v3;
        break;
     case SHININESS:
	shininess = v1;
        break;
     case TRANSPARENCY:
	transparency = 1.0 - v1;
	ambient[3] = transparency;
	diffuse[3] = transparency;
	specular[3] = transparency;
	emission[3] = transparency;
        break;
   }*/
   /* In Amulet, we can specify only RGB values */
   color[0] = v1;
   color[1] = v2;
   color[2] = v3;
   gobj.Set (Am_FILL_STYLE, Am_Style(v1, v2, v3));

   return;
}


Am_Define_Formula (int, line_end_x1)
{
    Am_Object end;

    end = self.Get (End1);
    return (int)end.GV(Am_LEFT) + (int)(end.GV(Am_WIDTH))/2;
}

Am_Define_Formula (int, line_end_y1)
{
    Am_Object end;

    end = self.Get (End1);
    return (int)end.GV(Am_TOP) + (int)(end.GV(Am_HEIGHT))/2;
}

Am_Define_Formula (int, line_end_x2)
{
    Am_Object end;

    end = self.Get (End2);
    return (int)end.GV(Am_LEFT) + (int)(end.GV(Am_WIDTH))/2;
}

Am_Define_Formula (int, line_end_y2)
{
    Am_Object end;

    end = self.Get (End2);
    return (int)end.GV(Am_TOP) + (int)(end.GV(Am_HEIGHT))/2;
}


void Shape::setupConnection(Shape *end1, Shape *end2)
{
    //puts("Here");
    gobj.Set (End1, end1->gobj);
    gobj.Set (End2, end2->gobj);
    gobj.Set (Am_X1, line_end_x1);
    gobj.Set (Am_Y1, line_end_y1);
    gobj.Set (Am_X2, line_end_x2);
    gobj.Set (Am_Y2, line_end_y2);
}
