/*
Copyright (C) 1997 $B9b66(B $B?-(B (TAKAHASHI Shin)
*/

#include <stdio.h>
#include <math.h>
#include "eq_solver.h"

/*------------------------------------------------------*/
/*	Spontaneous linear equations [a]*[x] = [b]	*/
/*	rigid constraints & pliable constraints		*/
/*	solve by the Least Square Method		*/
/*------------------------------------------------------*/

double	matrix[MAX_N][MAX_N+1];
double	transm[MAX_N][MAX_N+1];
double	ans[MAX_N];
int	size;		/* the number of variables */

extern	int	errflag;

void transposed()
{
	int	i,j,k;
	double	d;

	for (i=0; i<size; i++) 
		for (j=0; j<=size; j++) {
			d = 0;
			for (k=0; k<p_idx; k++)
				d += matrix[k][i] * matrix[k][j];
			transm[i][j] = d;
		}
}

int solve()
{
	int	i,j,k,pivot;
	int	sel_pivot();
	void	chg_lin();
	double	akk,adj;
	double	d;

	transposed();
/*
	print_data();		
*/
	for (k=0; k<size-1; k++) {
		pivot = sel_pivot(k,size,transm);	/* calculating pivot */
		if(errflag) return -1;
		chg_lin(k,pivot,size,transm);
		akk = transm[k][k];
		for (i=k+1; i<size; i++) {
			adj = transm[i][k]/akk;
			for (j=k+1; j<=size; j++)
				transm[i][j] -= adj*transm[k][j];
		}
	}
	for (k=size-1; k>=0; k--) {
		d = transm[k][size];
		for (i=size-1; i>k; i--)
			d -= ans[i]*transm[k][i];
		ans[k] = d/transm[k][k];
	}	
	return 0;
}
	
int	sel_pivot(k,lines,m)
int	k,lines;
double	m[MAX_N][MAX_N+1];
{
	double	d,maxval;
	int	i,lin;

	maxval = fabs(m[k][k]);	
	lin = k;
	for (i=k+1; i<lines; i++)
		if (maxval < (d=fabs(m[i][k])))	{
			lin = i;
			maxval = d;
	}
	if (maxval < EPS) {
		fprintf(stderr,"pivot is too small!!!\n");
		fflush(stderr);
		errflag = 1;
		return -1;
	}
	return(lin);
}

void chg_lin(i,j,cols,m)	/* exchage 'i' line and 'j' line */
int	i,j,cols;
double	m[MAX_N][MAX_N+1];
{
	int	n;
	double	d;

	for (n=i; n<=cols; n++) {
		d = m[i][n];
		m[i][n] = m[j][n];
		m[j][n] = d;
	}
}	
	
void print_data()
{
	int	i,j;

	for (j=0; j<size; j++) {
		for (i=0; i<=size; i++) 
			printf("%f ", transm[j][i]);
		printf("\n");
	}
}

void put_answer()
{
	int	i,j;
	double	d;

	printf("---- least square solution ----\n");
	for (i=0; i<size; i++)
		printf("(%c) %f\n",'a'+i,(float)ans[i]);
	printf("---- satisfied constraints ----\n");
	for (i=0; i<size; i++) {
		d = matrix[i][size];
		for (j=0; j<size; j++)
			d -= matrix[i][j]*ans[j];
		if (fabs(d) < EPS)
			printf("%d\n",i);
	}
}

