/*
Copyright (C) 1997 $B9b66(B $B?-(B (TAKAHASHI Shin)
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "eq_solver.h"

struct var_entry	var_tab[MAXVARS];
int	var_count=0;	/* total number of variables */

extern	int	errflag;

Node	*mknode(op, lp, rp)
int	op;
Node	*lp, *rp;
{
	Node	*np;
	void	error(int);

	if ((np=(Node*)malloc(sizeof(Node))) == NULL){
		error(1);
		fprintf(stderr,"mkpict\n");
		fflush(stderr);
		return NULL;
	}
	np->type = NODE;
	np->u.n.op = op;
	np->u.n.left = lp;
	np->u.n.right = rp;
	return(np);
}

Node	*mkleaf(f, var_number, var_type)
int	f, var_number, var_type;
{
	char	name[16];
	Node	*np;
	int	i;
	void	error(int);
	int	searchvar(char *);

	if ((np=(Node*)malloc(sizeof(Node))) == NULL){
		error(1);
		fprintf(stderr,"mkpict\n");
		fflush(stderr);
		return NULL;
	}
	np->type = LEAF;
	np->u.l.kind = f;
	if (f == VAR) {
		sprintf(name, "v%d_%d", var_number, var_type);
		if (var_tab[i=searchvar(name)].busy == DEAD) {
			np->u.l.kind = CONST;
			np->u.l.val = (int)(var_tab[i].value + 0.5);
		}
		else
			np->u.l.val = i;
	}
	else
		np->u.l.val = var_number;
	return(np);
}

Node	*cpnode(p)
Node	*p;
{
	Node	*np;
	void	error(int);

	if (p == (Node*)NULL)
		return(p);
	if (p->type == LEAF) {
		if ((np=(Node*)malloc(sizeof(Node))) == NULL){
			error(1);
			fprintf(stderr,"mkpict\n");
			fflush(stderr);
			return NULL;
		}
		*np = *p;
		return(np);
	}
	else 
		return(mknode(p->u.n.op,
			cpnode(p->u.n.left),cpnode(p->u.n.right))); 		
}

int	hash(s)
char	*s;
{
	int	n=0;

	while (*s)
		n += *s++;
	return(n % MAXVARS);
}

int	findvar(name)
char	*name;
{
	int	i;
	/*int	count=0;*/
	void	error(int);

	i = hash(name);
	while (1) {
		if (var_tab[i].busy == EMPTY){
			error(11);
			/*debug*/
			fprintf(stderr,"<<<%s>>>\n",name);
			return -1;
		}
		else if (strcmp(var_tab[i].name,name) == 0)
				return(i);
		i = (i+1) % MAXVARS;
	}
}

int	searchvar(name)
char	*name;
{
	int	i;
	int	count=0;
	char	*s;
	extern	struct pict_entry	*curpict;
	void	error(int);

	i = hash(name);
	while (1) {
		if (var_tab[i].busy == EMPTY) 
			break;
		else if (strcmp(var_tab[i].name,name) == 0)
				return(i);
		i = (i+1) % MAXVARS;
		if (++count >= MAXVARS){
			error(2);
			return -1;
		}
	}
	var_tab[i].busy = 1;
	strcpy(var_tab[i].name, name);
	var_tab[i].pict = curpict;
	for (s=name; *s; s++)
		if (*s == '.')
			break;
	if (strcmp(s,".cx") == 0)
		var_tab[i].type = CX;
	else if (strcmp(s,".cy") == 0)
		var_tab[i].type = CY;
	else if (strcmp(s,".lx") == 0)
		var_tab[i].type = LX;
	else if (strcmp(s,".rx") == 0)
		var_tab[i].type = RX;
	else if (strcmp(s,".by") == 0)
		var_tab[i].type = BY;
	else if (strcmp(s,".ty") == 0)
		var_tab[i].type = TY;
	else
		var_tab[i].type = GV;
	var_count++;
	return(i);
}

Term	*mkterm(var, cof, next)
int	var;
double	cof;
Term	*next;
{
	Term	*np;
	void	error(int);

	if ((np=(Term*)malloc(sizeof(Term))) == NULL){
		error(1);
		fprintf(stderr,"mkpict\n");
		fflush(stderr);
		return NULL;
	}
	np->var = var;
	np->cof = cof;
	np->next = next;
	return(np);
}

Pict	*mkpict(name,f)
char	*name;
Pict	*f;
{
	Pict	*np;
	void	error(int);

	if ((np=(Pict*)malloc(sizeof(Pict))) == NULL){
		error(1);
		fprintf(stderr,"mkpict\n");
		fflush(stderr);
		return NULL;
	}
	strcpy(np->name, name);
	np->count = 0;
	np->father = f;
	return(np);
}	

void error(n)
int	n;
{
	switch (n) {
		case 1:fprintf(stderr,"memory alloc error!\n"); break;
		case 2:fprintf(stderr,"variable table overflow!\n"); break;
		case 3:fprintf(stderr,"equation table overflow!\n"); break;
		case 4:fprintf(stderr,"rigid cons. table overflow!\n"); break;
		case 5:fprintf(stderr,"pliable cons. table overflow!\n"); break;
		case 6:fprintf(stderr,"constraint not linear!\n"); break;
		case 7:fprintf(stderr,"more constraints required!\n"); break;
		case 8:fprintf(stderr,"inconsistent constraints!\n"); break;
		case 9:fprintf(stderr,"too many variables for LSM!\n"); break;
		case 10:fprintf(stderr,"too many sons for pstart!\n"); break;
		case 11:fprintf(stderr,"unknown variable!\n"); break;
	}
	fflush(stderr);
	errflag = 1;
}
