/*
Copyright (C) 1997 $B9b66(B $B?-(B (TAKAHASHI Shin)
*/


/*	node types 	*/
#define	NODE	0
#define	LEAF	1

/*	leaf kinds	*/
#define VAR	0
#define CONST	1

/*	operators	*/
#define RIGID	0
#define PLIABLE	1
#define ADD	2
#define SUB	3
#define	MUL	4
#define DIV	5
#define SIN	10
#define COS	11
#define TAN	12

struct node {
	int	type;		/* NODE or LEAF */
	union {	
		struct { 
			int	op;		
			struct node	*left;
			struct node	*right;
		} n;
		struct {
			int	kind;
			int	val;
		} l;
	} u;
};
typedef	struct node	Node;

/*	variable table	*/
#define MAXNAME	20
#define MAXVARS	4096

/*	variable level	*/
#define EMPTY 	0
#define ACTIVE	1
#define DEAD	2

/*	variable state	*/
#define FREE	0
#define DEPEND	1
#define FIXED	2

/*	variable type	*/
#define GV	0	/*     */
#define CX	1	/* .cx */
#define CY	2	/* .cx */
#define LX	3	/* .lx */
#define RX	4	/* .rx */
#define BY	5	/* .by */
#define TY	6	/* .ty */

struct	var_entry {
	int	busy;		/* occupied or not 		*/
	char	name[MAXNAME];	/* variable name		*/
	int	state;		/* already computed or not	*/
	int	element;	/* number of LSM matrix		*/
	int	type;		/* variable type		*/
	double	value;		/* computed value		*/
	struct 	pict_entry	
		*pict;		/* picture structure		*/
};
extern	struct var_entry 	var_tab[MAXVARS];
extern	int	var_count;

/*	equation(constraint table)	*/
struct eq_entry {
	int	var;
	double	cof;
	struct eq_entry	*next;
};
typedef	struct eq_entry 	Term;

#define MAXEQ	4096
extern	Node	*eq_tab[MAXEQ];
extern	int	eq_idx;

#define MAXRC	4096
#define MAXPC	256
extern	Term	*r_tab[MAXRC];
extern	Term	*p_tab[MAXPC];
extern	int	r_idx;
extern	int	p_idx;
Term	*mkterm();

#define EPS	1e-5

/*	least square method		*/
#define	MAX_N	50
extern	int	size;
extern	double	matrix[MAX_N][MAX_N+1];
extern	double	transm[MAX_N][MAX_N+1];
extern	double	ans[MAX_N];

/*	picture hierarchy		*/
#define	MAXSONS	10
struct pict_entry {
	char	name[MAXNAME];			/* block name 		*/
	int	count;				/* number of sons	*/
	struct pict_entry	*father;	/* pointer to father	*/
	struct pict_entry	*sons[MAXSONS];	/* arrany of sons	*/
	int	xsiz, ysiz;			/* sizes of box		*/
	int	xoff, yoff;			/* position adjustment	*/ 
};
typedef	struct pict_entry 	Pict;
Pict	*mkpict();
extern void	push(Node *p);
