/* 
 *     PRISM: C-routine for pseudo random number generator
 *
 *                    Copyright (C) 1997
 *  SATO Taisuke and KAMEYA Yoshitaka, Dept. of Computer Science,
 *              Tokyo Institute of Technology
 */ 

#include <stdio.h>
#include <math.h>

#define M 2147483647
#define A 39894229
#define C 5

static long seed;

void      set_seed(long);
double    random_float(double);
int       random_int(int);
long      random_generator(long *);

/*
 *  Using mixed congruential method 
 *  X(n+1) = (a*X(n)+c) mod m
 */

void set_seed(long s)
{
    seed = (long) s;
}

long random_generator(long *s)
{
    *s = ((*s)*A+C) % M;
    return (*s -= (*s < 0 ? M:0));
}

/* generate double number in [0,f] */
double random_float(double f)
{
  return (double) (f * ((double)random_generator(&seed)/(double)M));
}

int random_int(int i)
{
  return (int)(i * random_float(1.0));
}
