output_java(N,L,T,C,Vector):-
	tell('route.sc'),
	writeln(['frame 600 400']),
        name(L,Lstr), append(Lstr,"HV_",S0),
        name(T,Tstr),append(Tstr,"Tracks",S1),
        append(S0,S1,S),
        name(Title,S),
        writeln([channel,L,T,C,Title]),
	output_segments(N,L,T,Vector),
	told,
	system('jview Guide route.sc').
	
output_segments(N,L,T,Vector):-
    functor(Vector1,nets,N),
    decode_layer_track(N,Vector,Vector1,L,T),
    output_segments1(T,1,N,Vector1).

output_segments1(MaxT,N0,N,Vector):-
    N0>N,!.
output_segments1(MaxT,N0,N,Vector):-
    arg(N0,Vector,Net),
    Net=net(N0,Head,Tail,Terms,Layer,Track),
    arg(1,Head,From),
    arg(1,Tail,To),
    writeln([hsegment,Layer,Track,From,To]),
    output_vsegments(MaxT,Terms,Layer,Track),
    N1 is N0+1,
    output_segments1(MaxT,N1,N,Vector).

output_vsegments(MaxT,[],Layer,Track).
output_vsegments(MaxT,[t(X)|Terms],Layer,Track):-
	Track2 is MaxT+1,
        writeln([vsegment,Layer,Track2,Track,X]),
	output_vsegments(MaxT,Terms,Layer,Track).
output_vsegments(MaxT,[b(X)|Terms],Layer,Track):-
    writeln([vsegment,Layer,Track,0,X]),
    output_vsegments(MaxT,Terms,Layer,Track).

writeln([]):-nl.
writeln([X|Xs]):-write(X),write(' '),writeln(Xs).

