import java.awt.*;
import java.io.*;
import java.util.StringTokenizer;

class Guide extends Frame {
	public final static int partBoard = 0;
	public final static int partLabel = 1;
	public final static int partLine = 2;
	public final static int partCircle = 3;
	public final static int partRect = 4;
	public final static int partChannel = 5;
	public final static int partVSegment = 6;
	public final static int partHSegment = 7;
	public final static int partFrame = 8;

	DataInputStream dis;
	String strLine;
	StringTokenizer st;
	String title;
	Board bd;
	LabelInBoard lab = new LabelInBoard();
	Channel chan;
	Segment seg = new Segment();
	public	int frameWidth, frameHeight;

	public static void main(String[] args){
		if (args.length != 1){
			System.out.println("Usage jview Guide scriptfile");
			System.exit(0);
		}
		Guide frame = new Guide(args[0]);
		frame.title = args[0];
		frame.show();
	}

	public Guide(String title){
		super(title);
	}

	public void	openFile(String file)
	{
		try {
			dis = new DataInputStream(new FileInputStream(file));
		}
		catch (FileNotFoundException e){
			System.out.println("Script file "+file+" not found");
			System.exit(0);
		}
		catch (IOException e){
			System.out.println(e);
		}
	}

	public void myReadLine()
	{
		try {
			strLine = dis.readLine();
			if (strLine != null) {
				st = new StringTokenizer(strLine);
				if (!st.hasMoreTokens()) myReadLine();
			} else {
				st = null;
				dis.close();
			}
		}
		catch (IOException e){
			System.out.println(e);
		}
	}

	public String myNextToken(){
		if (st.hasMoreTokens()){
			return st.nextToken();
		} else {
			System.out.println("Token expected");
			System.exit(0);
			return null;
		}
	}

	public int nextPart(){
		String token;
		
		token = myNextToken();
		if (token.equalsIgnoreCase("HSegment"))
			return partHSegment;
		else if (token.equalsIgnoreCase("VSegment"))
			return partVSegment;
		else if (token.equalsIgnoreCase("Board"))
			return partBoard;
		else if (token.equalsIgnoreCase("Label"))
			return partLabel;
		else if (token.equalsIgnoreCase("Channel"))
			return partChannel;
		else if (token.equalsIgnoreCase("Frame"))
			return partFrame;
		else return -1;
	}
	
	public boolean handleEvent(Event e){
		if (e.id == Event.WINDOW_DESTROY)
			System.exit(0);
		return false;
	}

	public void paint(Graphics g){
		int part;
		
		openFile(title);
		for (;;){
			myReadLine();
			if (strLine == null) break;
			part = nextPart();
			switch (part) {
			case partFrame:
					frameWidth = Integer.valueOf(myNextToken()).intValue();
					frameHeight = Integer.valueOf(myNextToken()).intValue();
					this.resize(frameWidth,frameHeight);
					break;
			case partBoard:
					bd = createBoard();
					bd.drawBoard(g);
					break;
			case partLabel:
					FontMetrics fm = g.getFontMetrics();
					Font ft0 = fm.getFont();
					int labFontSize = bd.cellWidth/4;
					Font ft = new Font("Helvetica",Font.BOLD,labFontSize);
					g.setFont(ft);
				    createLabel(fm);
					lab.drawLabel(g);
					g.setFont(ft0);
					break;
			case partChannel:
					chan = createChannel();
					chan.drawChannel(g);
				break;
			case partVSegment:
				int layer = Integer.valueOf(myNextToken()).intValue();
				int track1 = Integer.valueOf(myNextToken()).intValue();
				int track2 = Integer.valueOf(myNextToken()).intValue();
				int terminal = Integer.valueOf(myNextToken()).intValue();
				chan.drawVSegment(g,layer,track1,track2,terminal);
				break;
			case partHSegment:
				layer = Integer.valueOf(myNextToken()).intValue();
				int track = Integer.valueOf(myNextToken()).intValue();
				int terminal1 = Integer.valueOf(myNextToken()).intValue();
				int terminal2 = Integer.valueOf(myNextToken()).intValue();
				chan.drawHSegment(g,layer,track,terminal1,terminal2);
				break;
			default:
				break;
			}
		}
	}

	private Board createBoard(){
		int rows = Integer.valueOf(myNextToken()).intValue();
		int cols = Integer.valueOf(myNextToken()).intValue();
		return new Board(rows,cols,frameWidth/(cols+4),frameHeight/(rows+4));
	}
	
	public void createLabel(FontMetrics fm){
		lab.row = Integer.valueOf(myNextToken()).intValue();
		lab.col = Integer.valueOf(myNextToken()).intValue();
		lab.text = myNextToken();
		lab.bd = bd;
	}	
	
	public Channel createChannel(){
		int layers = Integer.valueOf(myNextToken()).intValue();
		int tracks = Integer.valueOf(myNextToken()).intValue();
		int terminals = Integer.valueOf(myNextToken()).intValue();
		String title = st.hasMoreTokens() ? myNextToken() : "No Title";
		return new Channel(title,layers,tracks,terminals,this);
	}
	
		
}
		
