import java.awt.*;

class Channel{
	public int x_left,x_right; // x axiles of starting and ending point
    public Layer[] layers;
	public int noTerminals;
	public int layerHeight,layerWidth;
	public int gridWidth,gridHeight;
	public static final	int layerSep = 15;
	public static final	int margin = 30;
	public String title;
	public Guide frame;

	public Channel(String title, int noLayers, int noTracks, int noTerminals, Guide frame){
		this.title = title;
		this.layers = new Layer[noLayers];
		this.noTerminals = noTerminals;
		this.frame = frame;
		gridWidth = (frame.frameWidth-margin*2)/noTerminals;
		layerWidth = gridWidth*noTerminals;

	    layerHeight = (frame.frameHeight-margin*2)/noLayers-layerSep;
		gridHeight = layerHeight/(noTracks+1);
		layerHeight = gridHeight*(noTracks+1);
		
		x_left = margin;
		x_right = x_left + layerWidth;

		for (int i=0; i<noLayers; i++){
			int y_top = margin + i*(layerHeight+layerSep);
			int y_bottom = margin + (i+1)*(layerHeight+layerSep)-layerSep;
			layers[i] = new Layer(y_top,y_bottom,noTracks,this);
		}
	}
		
	public void drawChannel(Graphics g){
		FontMetrics fm = g.getFontMetrics();
		Font origFont = g.getFont();
		Font newFont = new Font("Times Roman",Font.BOLD,18);
		g.setFont(newFont);
		g.drawString(title,(frame.frameWidth-fm.stringWidth(title))/2,20);
		g.setFont(origFont);

		for (int i = 0; i<layers.length; i++){
			layers[i].drawLayer(g);
		}
	}

	public void drawHSegment(Graphics g, int layer, int track, int terminal1, int terminal2){
		int seg_x_left,seg_x_right,seg_y;

		seg_x_left = x_left+terminal1*gridWidth;
		seg_x_right = x_left+terminal2*gridWidth;
		seg_y = layers[layer-1].y_bottom-track*gridHeight;
		g.drawLine(seg_x_left,seg_y,seg_x_right,seg_y);
	}

	public void drawVSegment(Graphics g, int layer, int track1, int track2, int terminal){
		int seg_x, seg_y_top, seg_y_bottom;

		seg_x = x_left + terminal*gridWidth;
		seg_y_top = layers[layer-1].y_bottom-track1*gridHeight;
		seg_y_bottom = layers[layer-1].y_bottom-track2*gridHeight;
		g.drawLine(seg_x,seg_y_top,seg_x,seg_y_bottom);
	}
}

class Layer {
	public int y_top,y_bottom; // y coordinates of the top and bottom lines
	public int noTracks;
	Channel chan;

	public Layer(int y_top, int y_bottom, int noTracks, Channel chan){
		this.y_top = y_top;
		this.y_bottom = y_bottom;
		this.noTracks = noTracks;
		this.chan = chan;
	}

	public void drawLayer(Graphics g){
		int x,y;
		int x_left,x_right;
		int radius = 1;
		
		x_left = chan.x_left;
		x_right = chan.x_right;
		g.drawLine(x_left,y_top,x_right,y_top);
		y = y_top-radius;
		for (int j = 1; j<=chan.noTerminals; j++){
			x = x_left+j*chan.gridWidth-radius;
			g.fillOval(x,y,radius*2,radius*2);
		}

		g.drawLine(x_left,y_bottom,x_right,y_bottom);
		y  = y_bottom-radius;
		for (int j = 1; j<=chan.noTerminals; j++){
			x = x_left+j*chan.gridWidth-radius;
			g.fillOval(x,y,2*radius,2*radius);
		}
	}
}

