import java.awt.*;

public class Board {
	public int x,y;   // left-top corner coordinates
	public int rows,cols; // number of rows and columns in the board
	public int cellWidth,cellHeight; 

	public Board(int rows,int cols){
		this(rows,cols,10,10,10,10);
	}

	public Board(int rows,int cols, int w, int h){
		this(rows,cols,w,h,10,10);
	}

	public Board(int rows,int cols, int w, int h, int x, int y){
		this.rows = rows;
		this.cols = cols;
		this.cellWidth = w;
		this.cellHeight = h;
		this.x = x;
		this.y = y;
	}

	public void drawBoard(Graphics g){
		int x1,y1;

		for (int i = 0; i< rows; i++)
			for (int j = 0; j<cols; j++){
				x1 = x+i*cellWidth;
				y1 = y+j*cellHeight;
			    g.drawRect(x1,y1,cellWidth,cellHeight);
			}
	}
}

class LabelInBoard {
	int x,y;
	public int col,row;
	public String text;
	public Board bd;

	public LabelInBoard(){};

	public void drawLabel(Graphics g){
		x = bd.x+(col-1)*bd.cellWidth+bd.cellWidth/2; //-fm.stringWidth(lab))/2;
		y = bd.y+(row-1)*bd.cellHeight+bd.cellHeight/2; //+fm.getAscent()/2;
		g.drawString(text,x,y);
	}
}