// Copyright (C) 1996,1997 Buntarou Shizuki(shizuki@is.titech.ac.jp)

#include "tracer-types.h"

int
unify_term(rterm *t1, rterm *t2)
{
  t1 = deref(t1);
  t2 = deref(t2);

  if (t1 == NULL || t2 == NULL)
    return 1;			// unification failed
  
  if (t1->Type() != tt_variable && t2->Type() == tt_variable) {
    //
    // t1 <---> t2
    //
    rterm *t;
    t = t1; t1 = t2; t2 = t;
  }
  
  switch (t1->Type()) {
    ;				// for indentation
  case tt_variable: {
    term_variable *vp = (term_variable *) t1;
    if (t2->Type() == tt_variable) {
      term_variable *v2 = (term_variable *) t2;
      if (strcmp(vp->GetName(), v2->GetName()) == 0)
	;
      else
	vp->SetContent(t2);
    } else
      vp->SetContent(t2);
    //
    // some processes my be activated
    // some processes are terminated
    //
    return 0;
    break;
  }
  case tt_functor: {
    term_functor *f1, *f2;
    
    if (t2->Type() != tt_functor)
      return 1;			// unification failed
    
    f1 = (term_functor *) t1;
    f2 = (term_functor *) t2;
    
    //if (strcmp(f1->GetName(), f2->GetName()) != 0)
    if (f1->GetName() != f2->GetName())
      return 1;
    if (f1->GetModule() != f2->GetModule())
      return 1;
    if (f1->GetArity() != f2->GetArity())
      return 1;
    
    int arity;
    Pix arg1, arg2;
    SLList<rterm *> args1, args2;
    
    arity = f1->GetArity();
    args1 = f1->GetArgs();
    args2 = f2->GetArgs();
    
    for (arg1 = args1.first(), arg2 = args2.first();
	 arg1 != 0 && arg2 != 0;
	 args1.next(arg1), args2.next(arg2)) {
      int ret;
      
      ret = unify_term(args1(arg1), args2(arg2));
      if (ret)
	return ret;
    }
    return 0;
    break;
  }
  case tt_cons: {
    int ret;
    term_cons *c1, *c2;

    if (t2->Type() != tt_cons)
      return 1;

    c1 = (term_cons *) t1;
    c2 = (term_cons *) t2;

    ret = unify_term(c1->Car(), c2->Car());
    if (ret)
      return ret;
    ret = unify_term(c1->Cdr(), c2->Cdr());
    if (ret)
      return ret;

    return 0;
    break;
  }
  case tt_nil: {
    if (t2->Type() != tt_nil)
      return 1;
    else
      return 0;
    break;
  }
  case tt_vector:
    break;
  case tt_string:
    break;
  case tt_integer: {
/*
    term_integer *i1, *i2;

    if (t2->Type() != tt_integer)
      return 1;

    i1 = (term_integer *) t1;
    i2 = (term_integer *) t2;

    if (i1->GetValue() != i2->GetValue())
      return 1;
    
    return 0;
*/
    // assume that two term_integers with same value
    // are allocated at same address
    return (t1 != t2);
    break;
  }
  case tt_real:
    break;
  case tt_unknown:
  default:
    return 1;			// unification failed
    break;
  }
  
  return 1;
}

//
// unify term
//
/*
   t1 : unbound
   t2 : unbound
   ---> t2 = t1

   t1 : unbound
   t2 : bound
   ---> t1 = t2

 */

/* eof */
