// Copyright (C) 1996,1997 Buntarou Shizuki(shizuki@is.titech.ac.jp)

#include "parse.h"

// tranced KL1 object UNIX pid
#if defined(HAVE_PTY)
static pid_t object_aout;
#endif

// for communicating with traced KL1 object
static FILE *from_mon;
static FILE *to_mon;

static char *klieg_work_dir;
static char klieg_source[PATH_MAX];

static char klieg_traced[PATH_MAX];

int
subprocess_init()
{
  return 0;
}

//
// must construct signal handlers
//
int
subprocess_compile(char *path)
{
  // setting klieg_work_dir, klieg_source and klieg_traced variable
 stage_env:
  {
    klieg_work_dir = getenv(KLIEG_WORK_ENV);
    if (klieg_work_dir == NULL)
      klieg_work_dir = KLIEG_WORK_DEFAULT;

    sprintf(klieg_source, "%s/%s", klieg_work_dir, KLIEG_WORK_FILE);
    sprintf(klieg_traced, "%s/%s", klieg_work_dir, KLIEG_TRACED);
  }

  // mkdir a working directory
 stage_mkdir:
  {
    struct stat s;
    int mkdir_ret, stat_ret;
    int mkdir_errno, stat_errno;
    char *work_dir;

    mkdir_ret = mkdir(klieg_work_dir, KLIEG_WORK_MODE);
    mkdir_errno = errno;
    stat_ret = stat(klieg_work_dir, &s);
    stat_errno = errno;

    if (mkdir_ret && !(mkdir_errno == EEXIST && (s.st_mode & S_IFDIR))) {
      if (stat_ret) {
	errno = stat_errno;
	perror("getting working directory information");
      }
      errno = mkdir_errno;
      perror("creating working directory");
      return 1;
    }
  }

  // copy the KL1 file to the working directory
#define TRACER_COPY_BUF_SIZE	1024

 stage_copy:
  {
    FILE *in_fp, *to_fp;
    char *ret_fgets;
    int ret_fputs;
    char buf[TRACER_COPY_BUF_SIZE];

    in_fp = fopen(path, "r");
    if (in_fp == NULL) {
      perror("copying KL1 source");
      fclose(in_fp);
      return 2;
    }

    to_fp = fopen(klieg_source, "w");
    if (to_fp == NULL) {
      perror("copying KL1 source");
      fclose(in_fp);
      fclose(to_fp);
      return 2;
    }

    while (!ferror(in_fp) && !feof(in_fp)) {
      ret_fgets = fgets(buf, sizeof(buf), in_fp);
      if (ret_fgets == NULL) {
	if (ferror(in_fp))
	  perror("reading KL1 source");
	break;
      }
      ret_fputs = fputs(buf, to_fp);
      if (ret_fputs == EOF) {
	perror("writing KL1 source");
	break;
      }
    }

    fclose(to_fp);
    fclose(in_fp);
  }

#if defined(HAVE_PTY)
  // compile it
 stage_compile:
  {
    pid_t child_pid;

    child_pid = fork();
    if (child_pid < 0) {
      perror("compiling KL1 source");
      return 3;
    }
    if (child_pid == 0) {
      //
      // child process
      //
      int ret_chdir, ret_execle;

      ret_chdir = chdir(klieg_work_dir);
      if (ret_chdir) {
	perror("changing to working directory");
	exit(1);
      }

      char *klic_envp[] = KLIEG_ENVIRONMENT;
      ret_execle = execle(KLIC_PROGRAM,
			  "klic", "-o", KLIEG_TRACED, KLIEG_WORK_FILE, NULL,
			  klic_envp);
      perror("spawning klic program");
      exit(1);

      // not reached

    } else {
      //
      // parent process
      //
      int child_stat;
      int ret_wait;

      ret_wait = wait(&child_stat);
//       if (ret_wait < 0) {
// 	perror("compiling KL1 source has some problem");
// 	return 3;
//       }
//       if (ret_wait != child_pid) {
// 	perror("compiling KL1 source???");
// 	return 3;
//       }
    }
  }
#endif // defined(HAVE_PTY)
  return 0;
}

int
subprocess_start()
{
#if defined(HAVE_PTY)

  if (tracing_mode == TRACE_LOGFILE)
    return 0;

  pid_t child_pid;

  //
  // whether the KL1 object file to be traced exists or not
  //
 stage_check:
  {
    struct stat s;
    int stat_ret;
    
    stat_ret = stat(klieg_traced, &s);
    if (stat_ret) {
      perror("checking KL1 object");
      return 1;
    }
  }
  
 stage_tty:
  int fdm, fds;
  char *slavename;

  fdm = open("/dev/ptmx", O_RDWR); // open master
  
 stage_start:
  {
    int ret_pipe;

    child_pid = fork();
    if (child_pid < 0) {
      perror("spawning KL1 object");
      return 2;
    }
    if (child_pid == 0) {
      setpgrp();
      grantpt(fdm);		      // change permission ofslave
      unlockpt(fdm);		      // unlock slave
      slavename = ptsname(fdm);	      // get name of slave
      //printf("subprocess_start: slavename=%s\n", slavename);
      fds = open(slavename, O_RDWR);  // open slave
      if (fds < 0) {
	perror("opening slave");
	exit(1);
      }
      ioctl(fds, I_PUSH, "ptem");     // push ptem
      ioctl(fds, I_PUSH, "ldterm");   // push ldterm
      ioctl(fds, I_PUSH, "ttcompat"); // XXX
      close(fdm);

      //
      // child process
      //
      int oldtty = open("/dev/tty", O_RDWR);
      if (oldtty >= 0) {
	ioctl(oldtty, TIOCNOTTY, 0);
	close(oldtty);
      }
      int newtty = open(slavename, O_RDWR);
      if (newtty < 0) {
	perror("slave terminal can't be opend");
	exit(1);
      }
      dup2(newtty, 0);
      dup2(newtty, 1);
      dup2(newtty, 2);

      int ret_chdir, ret_execle;
      
      ret_chdir = chdir(klieg_work_dir);
      if (ret_chdir) {
	perror("changing to working directory to spawn KL1 object");
	exit(1);
      }

      char *klic_envp[] = KLIEG_ENVIRONMENT;
      ret_execle = execle(KLIEG_TRACED,
			  KLIEG_TRACED, "-t", NULL,
			  klic_envp);
      perror("spawning KL1 object");
      exit(1);
      // not reached
      
    } else {
      //
      // parent process
      //
      int ret_tracing;
      
      to_mon = fdopen(fdm, "w");
      if (to_mon == NULL) {
	fprintf(stderr,
		"can't create stream connection for KL1 object's input\n");
	return 2;
      }
      setbuf(to_mon, NULL);

      from_mon = fdopen(fdm, "r");
      if (from_mon == NULL) {
	fprintf(stderr, "can't create stream connection with KL1 object\n");
	return 2;
      }
      setbuf(from_mon, NULL);	// the stream becomes unbuffered
    }
  }
#endif // defined(HAVE_PTY)
  return 0;
}

int
subprocess_send(char *str)
{
  if (tracing_mode == TRACE_OBJECT) {
    fprintf(to_mon, str);
    fflush(to_mon);
  }
  return 0;
}

int
subprocess_send_init()
{
#if defined(HAVE_PTY)
  if (tracing_mode == TRACE_LOGFILE)
    return 0;

  // initialize traced process by sending some commands

  // remove limits of printing length and depth of terms
  static char buf[1024]; // XXX

  subprocess_send("pl 100000\n");
  sleep(1);
  fgets(buf, 1024, from_mon);	// printf(buf);
  subprocess_send("pd 100\n");
  sleep(1);
  fgets(buf, 1024, from_mon);	// printf(buf);
#endif // defined(HAVE_PTY)
}

int
subprocess_openlog(char *logfile)
{
  to_mon = stdout;
  from_mon = fopen(logfile, "r");
  if (from_mon == NULL) {
    fprintf(stderr, "can't open log file\n");
    return 1;
  }
  return 0;
}

int
subprocess_tracing()
{
  int ret;

  ret =  tracer_parse(from_mon);
  if (ret) {
    // something is wrong
    return ret;
  }  
  return window_tracing();
}

int
subprocess_clean()
{
  // remove the working directory
}

// eof
