// Copyright (C) 1996,1997  Toyoda Masashi (toyoda@is.titech.ac.jp)
// Copyright (C) 1997  Buntarou Shizuki(shizuki@is.titech.ac.jp)

#include <amulet.h>
#include <amulet/object_advanced.h>
#include <amulet/formula_advanced.h>
#include <amulet/inter_advanced.h>
#include <amulet/widgets_advanced.h>
#include <amulet/debugger.h>
#include <strstream.h>
#include <strings.h>
#include <stdlib.h>
#include "my_amulet.h"
#include "kl_widgets.h"

// packing_layout
static int intcompare(int *i, int *j)
{
  if (*i > *j)
    return (1);
  if (*i < *j)
    return (-1);
  return (0);
}

static int uniq(int *v, int nel)
{
  if (nel < 0) {
    fprintf(stderr, "internal error calling uniq: negative length.\n");
    return -1;
  }
  if (nel < 2)
    return nel;

  int i = 0;
  int j = 0;
  int tmp[nel];

  tmp[0] = v[0];
  for (i = 1; i < nel; i++) {
    if (tmp[j] != v[i])
      tmp[++j] = v[i];
  }

  bcopy((void*) tmp, (void*) v, (j+1)*sizeof(int));
  return j+1;
}

void get_max_rank_and_size (Am_Object self, Am_Constraint_Context& cc,
			    int& max_rank, int& max_size);

static int grid_move(Am_Value_List objs,
		     int *x_list, int x_len, int *y_list, int y_len, int rank)
{
  int i = 0;
  int j = 0;
  
//    printf("\tpacking_layout_grid_move: x_len = %d, y_len = %d\n", x_len, y_len);
//    printf("\t");
//    for (i = 0; i < x_len; i++)
//      printf(" %d", x_list[i]);
//    printf("\n");
//    printf("\t");
//    for (i = 0; i < y_len; i++)
//      printf(" %d", y_list[i]);
//    printf("\n");

  int grid[x_len-1][y_len-1];
  bzero((void*) grid, sizeof(int)*x_len*y_len);

  int xi = 0;
  int yi = 0;

  int occupied = 0;

  Am_Object item;
  for (objs.Start(); !occupied && !objs.Last(); objs.Next()) {
    item = (Am_Object)objs.Get ();
    int left   = (int)item.Get(Am_LEFT);
    int right  = (int)item.Get(Am_WIDTH) + left;
    int top    = (int)item.Get(Am_TOP);
    int bottom = (int)item.Get(Am_HEIGHT) + top;

    for (xi = 0; !occupied && xi < x_len-1; xi++) {
      if (left <= x_list[xi] && x_list[xi+1] <= right) {
	for (yi = 0; !occupied && yi < y_len-1; yi++) {
	  if (top <= y_list[yi] && y_list[yi+1] <= bottom) {
	    if (grid[xi][yi] == 0) {
// 	      printf("\tgrid(%d,%d) is checked\n", xi, yi);
	      grid[xi][yi] = i;
	    } else {
// 	      printf("\tgrid(%d,%d) is occupied!\n", xi, yi);
	      occupied = 1;
	    }
	  }
	}
      }
    }
  }

  int grid_left   = x_list[xi-1];
  int grid_width  = x_list[xi] - x_list[xi-1];
  int grid_right  = x_list[xi];
  int grid_top    = y_list[yi-1];
  int grid_height = y_list[yi] - y_list[yi-1];
  int grid_bottom = y_list[yi];
  
  if (occupied) {
    
    if (grid_width < grid_height) {
      Am_Object mostleft = item;
      for (objs.Start(); !objs.Last(); objs.Next()) {
	Am_Object item = (Am_Object)objs.Get ();
	int left   = (int)item.Get(Am_LEFT);
	int right  = (int)item.Get(Am_WIDTH) + left;
	int top    = (int)item.Get(Am_TOP);
	int bottom = (int)item.Get(Am_HEIGHT) + top;
	
	if (left <= grid_left && grid_right <= right
	    && top <= grid_top && grid_bottom <= bottom
	    && left < (int)mostleft.Get(Am_LEFT))
	  mostleft = item;
      }
      for (objs.Start(); !objs.Last(); objs.Next()) {
	Am_Object item = (Am_Object)objs.Get ();
	int left   = (int)item.Get(Am_LEFT);
	if (grid_left <= left && mostleft != item)
	  item.Set(Am_LEFT, left + grid_width);
      }
    } else {
      Am_Object mosttop = item;
      for (objs.Start(); !objs.Last(); objs.Next()) {
	Am_Object item = (Am_Object)objs.Get ();
	int left   = (int)item.Get(Am_LEFT);
	int right  = (int)item.Get(Am_WIDTH) + left;
	int top    = (int)item.Get(Am_TOP);
	int bottom = (int)item.Get(Am_HEIGHT) + top;
	
	if (left <= grid_left && grid_right <= right
	    && top <= grid_top && grid_bottom <= bottom
	    && top < (int)mosttop.Get(Am_TOP))
	  mosttop = item;
      }
      for (objs.Start(); !objs.Last(); objs.Next()) {
	Am_Object item = (Am_Object)objs.Get ();
	int top = (int)item.Get(Am_TOP);
	if (grid_top <= top && mosttop != item)
	  item.Set(Am_TOP, top + grid_height);
      }
    }
    return 1;			// need re-gridding
  } else {
    return 0;
  }
}

Am_Define_Formula (void*, packing_layout)
{
//   printf("packing_layout:\n");
   
  int i = 0;
  int rank = 0;
  Am_Value_List components = (Am_Value_List)self.GV(Am_GRAPHICAL_PARTS);
  int max_rank, max_size;
  get_max_rank_and_size(self, cc, max_rank, max_size);

  for (components.Start(); !components.Last(); components.Next()) {
    Am_Object item = (Am_Object)components.Get ();
    if ((bool)item.GV(Am_VISIBLE)) {
      item.GV(Am_LEFT);
      item.GV(Am_TOP);
      item.GV(Am_WIDTH);
      item.GV(Am_HEIGHT);
      rank++;
    }
  }

  if (max_rank != 0 && rank > max_rank)
    rank = max_rank;

  Am_Value_List objs;
  
  for (i = 0, components.Start(); i < rank; components.Next()) {
    Am_Object item = (Am_Object)components.Get ();
    if ((bool)item.GV(Am_VISIBLE)) {
      objs.Add(item);
      i++;
    }
  }
  int more = 0;

  int x_list[rank*2+1], y_list[rank*2+1];

  do {
    i = 0;
    for (objs.Start(); !objs.Last(); objs.Next()) {
      Am_Object item = (Am_Object)objs.Get ();
      x_list[i*2  ] = (int)item.GV(Am_LEFT);
      x_list[i*2+1] = (int)item.GV(Am_LEFT) + (int)item.GV(Am_WIDTH);
      y_list[i*2  ] = (int)item.GV(Am_TOP);
      y_list[i*2+1] = (int)item.GV(Am_TOP) + (int)item.GV(Am_HEIGHT);
      i++;
    }
    x_list[rank*2] = 0;
    y_list[rank*2] = 0;

    qsort((void*) x_list, rank*2+1, sizeof(int), intcompare);
    qsort((void*) y_list, rank*2+1, sizeof(int), intcompare);
    int x_len = uniq(x_list, rank*2+1);
    int y_len = uniq(y_list, rank*2+1);

    more = grid_move(objs, x_list, x_len, y_list, y_len, rank);
  } while (more);

  //
  // now extra space is shrinked...
  //
  i = 0;
  for (objs.Start(); !objs.Last(); objs.Next()) {
    Am_Object item = (Am_Object)objs.Get ();
    x_list[i*2  ] = (int)item.GV(Am_LEFT);
    x_list[i*2+1] = (int)item.GV(Am_LEFT) + (int)item.GV(Am_WIDTH);
    y_list[i*2  ] = (int)item.GV(Am_TOP);
    y_list[i*2+1] = (int)item.GV(Am_TOP) + (int)item.GV(Am_HEIGHT);
    i++;
  }
  x_list[rank*2] = 0;
  y_list[rank*2] = 0;
  
  qsort((void*) x_list, rank*2+1, sizeof(int), intcompare);
  qsort((void*) y_list, rank*2+1, sizeof(int), intcompare);
  int x_len = uniq(x_list, rank*2+1);
  int y_len = uniq(y_list, rank*2+1);

  int xi;
  int yi;
  int x_grid[x_len - 1];
  int y_grid[y_len - 1];
  bzero((void*) x_grid, sizeof(int)*(x_len-1));
  bzero((void*) y_grid, sizeof(int)*(y_len-1));

  for (objs.Start(); !objs.Last(); objs.Next()) {
    Am_Object item = (Am_Object)objs.Get ();
    int left   = (int)item.GV(Am_LEFT);
    int right  = (int)item.GV(Am_WIDTH) + left;
    int top    = (int)item.GV(Am_TOP);
    int bottom = (int)item.GV(Am_HEIGHT) + top;

    for (xi = 0; xi < x_len-1; xi++) {
      if (left <= x_list[xi] && x_list[xi+1] <= right)
	x_grid[xi]++;
    }
    for (yi = 0; yi < y_len-1; yi++) {
      if (top <= y_list[yi] && y_list[yi+1] <= bottom)
	y_grid[yi]++;
    }
  }

  int j = 0;
  for (xi = x_len-1; xi >= 0; xi--) {
    if (x_grid[xi] == 0) {
      int grid_width = x_list[xi+1] - x_list[xi];
      for (objs.Start(); !objs.Last(); objs.Next()) {
	Am_Object item = (Am_Object)objs.Get ();
	int item_left = item.GV(Am_LEFT);
// 	  printf("x_list[%d] = %d and item_left = %d\n",
// 		 xi, x_list[xi], item_left);
	if (x_list[xi] <= item_left)
	  item.Set(Am_LEFT, item_left - grid_width);
      }
    }
  }
  for (yi = y_len-1; yi >= 0; yi--) {
    if (y_grid[yi] == 0) {
      int grid_height = y_list[yi+1] - y_list[yi];
      for (objs.Start(); !objs.Last(); objs.Next()) {
	Am_Object item = (Am_Object)objs.Get ();
	int item_top = item.GV(Am_TOP);
// 	  printf("y_list[%d] = %d and item_top = %d\n",
// 		 yi, y_list[yi], item_top);
	if (y_list[yi] <= item_top)
	  item.Set(Am_TOP, item_top - grid_height);
      }
    }
  }

  return NULL;
}

/* ---------------- Margins ----------------- */ 

int proc_margin = 8;
int slot_width_margin = 8;
int slot_height_margin = 4;
int atom_width_margin = 8;
int atom_height_margin = 2;
int structure_width_margin = 8;
int structure_height_margin = 4;
int guard_width_margin = 8;
int guard_height_margin = 6;
int bind_margin = 2;

/* ---------------- Name List ---------------- */

// ---- slot keys ----
Am_Slot_Key NAME_LIST  	    = Am_Register_Slot_Name("NAME_LIST");

// ---- operations ----

void Add_Name(Am_Object proc, char* name)
{
  proc.Make_Unique(NAME_LIST);
  Am_Value_List name_list = (Am_Value_List)proc.Get(NAME_LIST);
  if (name_list.Empty()) {
    proc.Set(NAME_LIST, name_list.Add(name));
  } else {
    name_list.Add(name, Am_TAIL, false);
    proc.Note_Changed(NAME_LIST);
  }
}

void Remove_Name(Am_Object proc, char* name)
{
  proc.Make_Unique(NAME_LIST);
  Am_Value_List name_list = (Am_Value_List)proc.Get(NAME_LIST);
  name_list.Start();
  if (name_list.Member(name)) {
    name_list.Delete(false);
    proc.Note_Changed(NAME_LIST);
  } else {
    cerr << "No " << name << "in " << proc << endl;
  }
  name_list.Start();
}
  
bool Member_Name(Am_Object proc, char* name)
{
  Am_Value_List name_list = (Am_Value_List)proc.Get(NAME_LIST);
  name_list.Start();
  bool result = name_list.Member(name);
  name_list.Start();
  return result;
}

Am_String Next_Name(Am_Object proc, char* base)
// base $B$r(Bprefix$B$H$7$?%W%m%;%9Cf$G%f%K!<%/$JL>A0$rJV$9!%(B
{
  char name[1000];
  ostrstream oname(name, 1000);
  Am_Value_List name_list = (Am_Value_List)proc.Get(NAME_LIST);
  name_list.Start();
  if (!name_list.Member(base)) {
    oname << base << '\0';
  } else {
    int i = 0; do {
      i = i + 1;
      oname.seekp(0, ios::beg);
      oname << base << i << '\0';
    } while (name_list.Start(), name_list.Member(name));
  }
  name_list.Start();
  return (Am_String)name;
}

/* ---------------- Module ---------------- */

// ---- global objects ----
Am_Object Module_Win;
Am_Object Process_Agg;

// ---- slot keys ----
Am_Slot_Key MODULE_WINS     = Am_Register_Slot_Name("MODULE_WINS");
Am_Slot_Key MODULE_NUM      = Am_Register_Slot_Name("MODULE_NUM");
Am_Slot_Key MODULE_NAME     = Am_Register_Slot_Name("MODULE_NAME");

// ---- operations ----
void Module_Rename(Am_Object win, char* name)
{
  win.Set(MODULE_NAME, name);
}

void Modules_Add(Am_Object modules, Am_Object win, char* name)
{
  Am_String new_name = Next_Name(modules, name);
  Module_Rename(win, new_name);
  modules
    .Set(MODULE_NUM, (int)Am_Screen.Get(MODULE_NUM) + 1)
    .Add_Part(win);
}

// ---- formulas ----
Am_Define_Value_List_Formula(module_wins_form) {
  self.GV(MODULE_NUM);
  Am_Value_List wins = Am_Value_List();
  Am_Part_Iterator gparts = self;
  for (gparts.Start(); !gparts.Last(); gparts.Next()) {
    Am_Object obj = gparts.Get();
    if (obj.Is_Instance_Of(Module_Win))
      wins.Add(obj);
  }
  return wins;
}

Am_Define_Value_List_Formula(module_name_list_form) {
  Am_Value_List names = Am_Value_List();
  Am_Value_List wins = (Am_Value_List)self.GV(MODULE_WINS);
  for (wins.Start(); !wins.Last(); wins.Next()) {
    Am_Object win = (Am_Object)wins.Get();
    names.Add((char*)(Am_String)win.GV(MODULE_NAME));
  }
  return names;
}

void Initialize_Module(void)
{
  Am_Screen
    .Set(MODULE_NUM, 0)
    .Set(MODULE_WINS, module_wins_form)
    .Set(NAME_LIST, module_name_list_form);

  Module_Win = Am_Window.Create("Module_Win")
    .Set(MODULE_NAME, "")
    ;

  Am_Object_Advanced obj_adv = (Am_Object_Advanced&)Module_Win;
  obj_adv.Get_Slot(MODULE_NAME).Set_Single_Constraint_Mode(false);

  Process_Agg = Am_Group.Create("Process_Agg")
    .Set(MODULE_NAME, "")
    .Set(NAME_LIST, Am_Value_List())
    ;
}

/* ---------------- Process, Port, Atoms and Structures ---------------- */

// ---- common slot keys ----
Am_Slot_Key FRAME_PART    = Am_Register_Slot_Name("FRAME_PART");
Am_Slot_Key CONTENTS_PART = Am_Register_Slot_Name("CONTENTS_PART");
Am_Slot_Key NAME_PART     = Am_Register_Slot_Name("NAME_PART");

// ---- common formulas ----

// Frame width
Am_Define_Formula(int, frame_width_proc)
{
  return (int)self.GV_Sibling(CONTENTS_PART).GV(Am_WIDTH) +(int)cc.Get_Data();
}
Am_Constraint* KL_Frame_Width(int margin)
{
  Am_Formula_Advanced* formula = (Am_Formula_Advanced*)(Am_Constraint*)
    Am_Formula(frame_width_proc_proc); // XXX
  formula->Set_Data((void*)margin, NULL);
  return formula;
}

// Frame height
Am_Define_Formula(int, frame_height_proc)
{
  return (int)self.GV_Sibling(CONTENTS_PART).GV(Am_HEIGHT)+ (int)cc.Get_Data();
}
Am_Constraint* KL_Frame_Height(int margin)
{
  Am_Formula_Advanced* formula = (Am_Formula_Advanced*)(Am_Constraint*)
    Am_Formula(frame_height_proc_proc);	// XXX
  formula->Set_Data((void*)margin, NULL);
  return formula;
}

// Frame width + margin
Am_Define_Formula(int, frame_width_plus_proc)
{
  return (int)self.GV_Part(FRAME_PART).GV(Am_WIDTH)+ (int)cc.Get_Data();
}
Am_Constraint* KL_Frame_Width_Plus(int margin)
{
  Am_Formula_Advanced* formula = (Am_Formula_Advanced*)(Am_Constraint*)
    Am_Formula(frame_width_plus_proc_proc); // XXX
  formula->Set_Data((void*)margin, NULL);
  return formula;
}

// Frame height + margin
Am_Define_Formula(int, frame_height_plus_proc)
{
  return (int)self.GV_Part(FRAME_PART).GV(Am_HEIGHT)+ (int)cc.Get_Data();
}
Am_Constraint* KL_Frame_Height_Plus(int margin)
{
  Am_Formula_Advanced* formula = (Am_Formula_Advanced*)(Am_Constraint*)
    Am_Formula(frame_height_plus_proc_proc); // XXX
  formula->Set_Data((void*)margin, NULL);
  return formula;
}

/* ---------------- Process, Rule, Goal ---------------- */

// ---- global objects ----
Am_Object Process_Proto;
Am_Object Creator_Proto;
Am_Object Append_Proto;
Am_Object Merge_Proto;
Am_Object Rule_Proto;
Am_Object Vanishing_Rule_Proto;
Am_Object Continuous_Rule_Proto;

// ---- slot keys ----

// Process
Am_Slot_Key PROC_NAME       = Am_Register_Slot_Name("PROC_NAME");
Am_Slot_Key PROC_MODULE     = Am_Register_Slot_Name("PROC_MODULE");
Am_Slot_Key PROC_TYPE       = Am_Register_Slot_Name("PROC_TYPE");
#define KL_Creator_Proc 0
#define KL_Normal_Proc  1
Am_Slot_Key PROC_RULES      = Am_Register_Slot_Name("PROC_RULES");


// Rule
Am_Slot_Key RULE_TYPE       = Am_Register_Slot_Name("RULE_TYPE");
#define KL_Transition_Rule 0
#define KL_Network_Rule    1
Am_Slot_Key PARENT_PROC     = Am_Register_Slot_Name("PARENT_PROC");
//Am_Slot_Key PORT_ID_LIST  = Am_Register_Slot_Name("PORT_ID_LIST");
//Am_Slot_Key RULE_NUMBER = Am_Register_Slot_Name("RULE_NUMBER");

// Icon
Am_Slot_Key IS_ICON	    = Am_Register_Slot_Name("IS_ICON");
Am_Slot_Key ICON_TOP        = Am_Register_Slot_Name("ICON_TOP");
Am_Slot_Key ICON_LEFT       = Am_Register_Slot_Name("ICON_LEFT");
Am_Slot_Key ORIG_TOP        = Am_Register_Slot_Name("ORIG_TOP");
Am_Slot_Key ORIG_LEFT       = Am_Register_Slot_Name("ORIG_LEFT");

// Graphical parts
Am_Slot_Key PORTS_PART      = Am_Register_Slot_Name("PORTS_PART");
Am_Slot_Key GOALS_PART      = Am_Register_Slot_Name("GOALS_PART");
Am_Slot_Key GUARD_PART      = Am_Register_Slot_Name("GUARD_PART");
Am_Slot_Key BINDER_PART     = Am_Register_Slot_Name("BINDER_PART");
Am_Slot_Key PARTS_MOVER     = Am_Register_Slot_Name("PARTS_MOVER");
Am_Slot_Key TEXT_INTER_PART = Am_Register_Slot_Name("TEXT_INTER_PART");
Am_Slot_Key SUB_FRAME_PART  = Am_Register_Slot_Name("SUB_FRAME_PART");

// ---- operations ----

////// Process operations //////

bool is_before_port(Am_Object port1, Am_Object port2)
{
  int mode1 = port1.Get(PORT_MODE);
  int mode2 = port2.Get(PORT_MODE);
  if (mode1 == KL_Input && mode2 == KL_Output) return true;
  if (mode1 == KL_Output && mode2 == KL_Input) return false;

  int type1 = port1.Get(PORT_TYPE);
  int type2 = port2.Get(PORT_TYPE);  
  if (type1 == KL_Stream && type2 == KL_Single) return true;
  if (type1 == KL_Single && type2 == KL_Stream) return false;

  Am_String name1 = (Am_String)port1.Get(PORT_NAME);
  Am_String name2 = (Am_String)port2.Get(PORT_NAME);
  if (strcmp(name1, name2) < 0) return true;
  else return false;
}

Am_Value_List sort_ports(Am_Value_List ports)
{
  Am_Value_List new_ports;
  for (ports.Start(); !ports.Last(); ports.Next()) {
    Am_Object port = (Am_Object)ports.Get();
    for (new_ports.Start(); ; new_ports.Next()) {
      if (new_ports.Last()) {
	new_ports.Add(port);
	break;
      }
      if (is_before_port(port, new_ports.Get())) {
	new_ports.Insert(port, Am_BEFORE, false);
	break;
      }
    }
  }
  return new_ports;
}

void Add_Process(Am_Object proc_agg, Am_Object proc)
{
  Am_String proc_name = (Am_String)proc.Get(PROC_NAME);
  if (Member_Name(proc_agg, proc_name)) {
    proc_name = Next_Name(proc_agg, proc_name);
    Proc_Rename(proc, (char *)proc_name);
  }
  proc_agg.Add_Part(proc);
  Add_Name(proc_agg, proc_name);
}

bool Proc_Rename(Am_Object proc, char* name)
{
  Am_Object proc_agg = proc.Get_Owner();
  if (proc_agg.Valid()) {
    if (Member_Name(proc_agg, name)) return false;
    Remove_Name(proc_agg, (Am_String)proc.Get(PROC_NAME));
    Add_Name(proc_agg, name);
  }
  proc.Get_Part(CONTENTS_PART)
    .Get_Part(NAME_PART)
    .Set(Am_TEXT, name);
  return true;
}

void Rule_Add_Old_Port(Am_Object rule, Am_Object port);

void Goal_Add_Port(Am_Object proc, Am_Object port)
{
  Am_Object port_agg = proc.Get_Part(CONTENTS_PART).Get_Part(PORTS_PART);
  Add_Name(proc, (Am_String)port.Get(PORT_NAME));
  port_agg.Add_Part(port).Remove_Part(port); // $B:G8e$N0l8DLdBj$N$$$$2C8:$JBP1~!%(B
  port_agg.Add_Part(port);
}

void Proc_Add_Port(Am_Object proc, Am_Object port, int x, int y, Am_Object ref_obj)
{
  Am_Object port_agg = proc.Get_Part(CONTENTS_PART).Get_Part(PORTS_PART);

  Am_Translate_Coordinates(ref_obj, x, y, port_agg, x, y); // $B:BI8$NJQ49!%(B
  x = imax(0, x);
  y = imax(0, y);
  port.Set(Am_LEFT, x).Set(Am_TOP, y);

  Am_String port_name = (Am_String)port.Get(PORT_NAME); // $BL>A0$N%A%'%C%/$*$h$SEPO?!%(B
  if (Member_Name(proc, port_name)) {
    port_name = Next_Name(proc, port_name);
    Port_Rename(port, port_name);
  }
  Add_Name(proc, port_name);

  port_agg.Add_Part(port).Remove_Part(port); // $B:G8e$N0l8DLdBj$N$$$$2C8:$JBP1~!%(B
  port_agg.Add_Part(port);

  Am_Value_List rules = (Am_Value_List)proc.Get(PROC_RULES);
  for (rules.Start(); !rules.Last(); rules.Next()) {
    Am_Object rule = (Am_Object)rules.Get();
    Rule_Add_Old_Port(rule, port.Create());
  }
  Am_Instance_Iterator goals = proc;
  for (goals.Start(); !goals.Last(); goals.Next()) {
    Am_Object goal = goals.Get();
    Goal_Add_Port(goal, port.Create());
  }
}

Am_Object Proc_Ports_Part(Am_Object process)
{
  return process.Get_Part(CONTENTS_PART).Get_Part(PORTS_PART);
}

Am_Value_List Proc_Ports(Am_Object process)
{
  Am_Object contents, ports;
  Am_Value_List graphical;

  contents = process.Get_Part(CONTENTS_PART);
  ports = contents.Get_Part(PORTS_PART);
  graphical = ports.Get(Am_GRAPHICAL_PARTS);
  return graphical;
}

Am_Object Proc_Get_Port(Am_Object process, char* name)
{
  Am_Value_List ports = Proc_Ports(process);
  for (ports.Start(); !ports.Last(); ports.Next()) {
    Am_Object pt = (Am_Object)ports.Get();
    Am_String port_name = (Am_String)pt.Get(PORT_NAME);
    if (port_name == name) {
      return pt;
    }
  }
  return 0;
}

// formulas for Iconify

Am_Object parent_rule(Am_Object obj)
{
  Am_Object parent = obj;
  while((parent = parent.Get_Owner()).Valid()) {
    if (parent.Is_Instance_Of(Rule_Proto))
      return parent;
  }
  return 0;
}

Am_Define_Formula(bool, icon_visible_form)
{
  Am_Object rule = 0;
  Am_Object parent = self;
  while((parent = parent.GV_Owner()).Valid()) {
    if (parent.Is_Instance_Of(Rule_Proto)) {
      rule = parent;
      break;
    }
  }
  if (!rule.Valid()) return true;
// $BFbMF$,%"%$%3%s;~$K8+$($J$$!%(B
  if (rule.GV(IS_ICON)) return false;
  else return true;
}

void Rule_Add_Old_Port(Am_Object rule, Am_Object port)
{
  Am_Object dist_agg = Proc_Ports_Part(rule);
  Am_Object p = port.Create().Set(PORT_AGE, KL_Old_Port);
//  if (s.Get(PORT_TYPE) == KL_Stream)
//    Am_To_Bottom(s.Get_Part(CONTENTS_PART).Get_Part(VALUE_PART)); // marker$B$r0\F0(B
  int top  = p.Get(Am_TOP);
  int left = p.Get(Am_LEFT);
  dist_agg.Add_Part(p.Set(PORT_OPEN, KL_Close)
//		     .Set(PORT_ID,   Am_Formula::Create(old_port_id_form))
		     .Set(Am_TOP,   top).Set(Am_LEFT,   left)
		     .Set(ORIG_TOP, top).Set(ORIG_LEFT, left)
		     .Set(ICON_TOP, top).Set(ICON_LEFT, left))
    .Remove_Part(p);
  dist_agg.Add_Part(p);
  if ((int)rule.Get(RULE_TYPE) == KL_Transition_Rule)
    p.Set(PORT_OPEN, KL_Open);
  // $B=PNO%]!<%H$O%"%$%3%s;~$K$O8+$($J$$!%(B
  if ((int)p.Get(PORT_MODE) == KL_Output) {
    p.Set(Am_VISIBLE, icon_visible_form);
  }      
}

Am_Object Rule_Create(Am_Object process, Am_Object rule_proto) {
  Am_Object rule;
  // $B%W%m%H%?%$%W7hDj!%(B
  if ((int)rule_proto.Get(RULE_TYPE) == KL_Transition_Rule)
    rule = Continuous_Rule_Proto.Create();
  else
    rule =  Vanishing_Rule_Proto.Create();
  // $B?F%W%m%;%9;XDj!%(B
  rule.Set(PARENT_PROC, process);
  // $B%]!<%HDI2C!%(B
  Am_Object dist_agg = Rule_Ports_Part(rule);
  Am_Value_List ports = Proc_Ports(process);
  Am_Object pt;
  for (ports.Start(); !ports.Last(); ports.Next()) {
    pt = ports.Get();
    int left = pt.Get(Am_LEFT);
    int top = pt.Get(Am_TOP);
    Rule_Add_Old_Port(rule, pt);
    if (rule.Is_Instance_Of(Continuous_Rule_Proto) &&
	(int)pt.Get(PORT_TYPE) == KL_Single && (int)pt.Get(PORT_MODE) == KL_Input) {
      dist_agg.Add_Part(pt.Create()
			.Set(PORT_AGE, KL_New_Port)
			.Set(Am_VISIBLE, Am_Formula(icon_visible_form))
			.Set(ORIG_TOP, top).Set(ORIG_LEFT, left)
			.Set(ICON_TOP, top).Set(ICON_LEFT, left));
    }
  }
  ports.Start();
  return rule;
}

void Rule_Toggle_Icon(Am_Object rule)
{
//  cout << "start Rule_Toggle_Icon on " << rule << endl;
  bool is_icon = (bool)rule.Get(IS_ICON);
  Am_Value_List ports = Proc_Ports(rule);
  for (ports.Start(); !ports.Last(); ports.Next()) {
    Am_Object pt = (Am_Object)ports.Get();
    int left = pt.Get(Am_LEFT);
    int top = pt.Get(Am_TOP);
    if (is_icon) {
      pt.Set(ICON_LEFT, left)
	.Set(ICON_TOP,  top)
	.Set(Am_LEFT, (int)pt.Get(ORIG_LEFT))
	.Set(Am_TOP,  (int)pt.Get(ORIG_TOP));
//      cout << "icon -> rule" << endl;
    } else {
      pt.Set(ORIG_LEFT, left)
	.Set(ORIG_TOP,  top)
	.Set(Am_LEFT, (int)pt.Get(ICON_LEFT))
	.Set(Am_TOP,  (int)pt.Get(ICON_TOP));
//      cout << "rule -> icon" << endl;
    }
  }
  Am_Object guard_part = Rule_Guard_Part(rule);
  Am_Value_List guards = (Am_Value_List)guard_part.Get(Am_GRAPHICAL_PARTS);
  for (guards.Start(); !guards.Last(); guards.Next()) {
    Am_Object gd = (Am_Object)guards.Get();
    int left = gd.Get(Am_LEFT);
    int top = gd.Get(Am_TOP);
    if (is_icon) {
      gd.Set(ICON_LEFT, left)
	.Set(ICON_TOP,  top)
	.Set(Am_LEFT, (int)gd.Get(ORIG_LEFT))
	.Set(Am_TOP,  (int)gd.Get(ORIG_TOP));
//      cout << "icon -> rule" << endl;
    } else {
      gd.Set(ORIG_LEFT, left)
	.Set(ORIG_TOP,  top)
	.Set(Am_LEFT, (int)gd.Get(ICON_LEFT))
	.Set(Am_TOP,  (int)gd.Get(ICON_TOP));
//      cout << "rule -> icon" << endl;
    }
  }
  rule.Set(IS_ICON, !is_icon); 
}

void Add_Rule(Am_Object rules_agg, Am_Object rule)
{
  Am_Object process = (Am_Object)rule.Get(PARENT_PROC);
  process.Make_Unique(PROC_RULES);
  Am_Value_List rule_list = (Am_Value_List)process.Get(PROC_RULES);
  if (rule_list.Empty()) {
    process.Set(PROC_RULES, rule_list.Add(rule, Am_TAIL, false));
  } else {
    rule_list.Add(rule, Am_TAIL, false);
    process.Note_Changed(PROC_RULES);
  }
  rules_agg.Add_Part(rule);
}
  
void Remove_Rule(Am_Object rules_agg, Am_Object rule)
{
  rules_agg.Remove_Part(rule);
  Am_Object proc = (Am_Object)rule.Get(PARENT_PROC);
  proc.Make_Unique(PROC_RULES);
  Am_Value_List rule_list = (Am_Value_List)proc.Get(PROC_RULES);
  rule_list.Start();
  rule_list.Member(rule);
  rule_list.Delete(false);
  proc.Note_Changed(PROC_RULES);
  rule_list.Start();
}

void Rule_Add_Guard(Am_Object rule, Am_Object guard, int x, int y, Am_Object ref_obj)
{
  Am_Object guard_agg = Rule_Guard_Part(rule);
  Am_Translate_Coordinates(ref_obj, x, y, guard_agg, x, y);
  x = imax(0, x); y = imax(0, y);
  guard_agg.Add_Part(guard.Set(Am_LEFT, x)  .Set(Am_TOP, y)
                          .Set(ORIG_LEFT, x).Set(ORIG_TOP, y)
                          .Set(ICON_LEFT, x).Set(ICON_TOP, y));
  guard_agg.Remove_Part(guard);
  guard_agg.Add_Part(guard);
}

void Rule_Add_Goal(Am_Object rule, Am_Object goal, int x, int y, Am_Object ref_obj)
{
  Am_Object goals_agg = Rule_Goals_Part(rule);
  Am_Translate_Coordinates(ref_obj, x, y, goals_agg, x, y);
  x = imax(0, x); y = imax(0, y);
  goals_agg.Add_Part(goal.Set(Am_LEFT, x).Set(Am_TOP, y));
  goals_agg.Remove_Part(goal);  // $B:G8e$N%4!<%k$r>C$7$F$+$i2C$($k$HI=<($5$l$J$$LdBj$N(B
  goals_agg.Add_Part(goal);     // $BD6%"%I%[%C%/$J2r7h!%(B
}

void Rule_Add_Inner_Port(Am_Object rule, Am_Object port)
{
  Am_String port_name = (Am_String)port.Get(PORT_NAME);
  if (Member_Name(rule, port_name)) {
    port_name = Next_Name(rule, port_name);
    Port_Rename(port, port_name);
  }
  Add_Name(rule, port_name);
  if ((int)port.Get(PORT_MODE) == KL_Input) {
    port // .Set(PORT_ID, Am_Formula::Create(in_port_id_form))
        .Get_Part(CONTENTS_PART)
	  .Get_Part(VALUE_PART)
            .Set(Am_VISIBLE, icon_visible_form);
                             // $BF~NO%]!<%H$NFbMF$O%"%$%3%s;~$K$O8+$($J$$!%(B
  } else {
//    port.Set(PORT_ID, Am_Formula::Create(out_port_id_form));
  }
}

void Rule_Remove_Inner_Port(Am_Object rule, Am_Object port)
{
//  port.Set(PORT_ID, 0);
  Remove_Name(rule, (Am_String)port.Get(PORT_NAME));
}

Am_Object Rule_Ports_Part(Am_Object rule)
{
  return rule.Get_Part(CONTENTS_PART).Get_Part(PORTS_PART);
}

Am_Value_List Rule_Ports(Am_Object rule)
{
  return (Am_Value_List)rule.Get_Part(CONTENTS_PART).Get_Part(PORTS_PART).Get(Am_GRAPHICAL_PARTS);
}

Am_Object Rule_Binder_Part(Am_Object rule)
{
  return rule.Get_Part(CONTENTS_PART).Get_Part(BINDER_PART);
}

Am_Value_List Rule_Binder(Am_Object rule)
{
  return (Am_Value_List)rule.Get_Part(CONTENTS_PART).Get_Part(BINDER_PART).Get(Am_GRAPHICAL_PARTS);
}

Am_Object Rule_Guard_Part(Am_Object rule)
{
  return rule.Get_Part(CONTENTS_PART).Get_Part(GUARD_PART);
}

Am_Value_List Rule_Guard(Am_Object rule)
{
  return (Am_Value_List)rule.Get_Part(CONTENTS_PART).Get_Part(GUARD_PART).Get(Am_GRAPHICAL_PARTS);
}

Am_Object Rule_Goals_Part(Am_Object rule)
{
  return rule.Get_Part(CONTENTS_PART).Get_Part(GOALS_PART);
}

Am_Value_List Rule_Goals(Am_Object rule)
{
  return (Am_Value_List)rule.Get_Part(CONTENTS_PART).Get_Part(GOALS_PART).Get(Am_GRAPHICAL_PARTS);
}

// Goal operations

Am_Define_String_Formula(goal_name_form) {
  char name[1000];
  ostrstream oname(name, 1000);
  // $B?F%W%m%;%9$NL>A0(B
  Am_Object parent = (Am_Object)self.GV_Owner().GV_Owner().GV(PARENT_PROC);
  if (!parent.Valid()) return (Am_String)"";
  Am_String parent_name = (Am_String)parent.GV(PROC_NAME);
  oname << parent_name << '\0';
  return (Am_String) name;
}

Am_Object Goal_Create(Am_Object process) {
  Am_Object goal = process.Create();
  int left = goal.Get(Am_LEFT);
  int top = goal.Get(Am_TOP);
  goal
    .Set(PARENT_PROC, process)
    .Set(PROC_MODULE, "")
    .Set(IS_ICON, false)
    .Set(ORIG_TOP, top).Set(ORIG_LEFT, left)
    .Set(ICON_TOP, top).Set(ICON_LEFT, left)
    .Get_Part(CONTENTS_PART)
      .Get_Part(NAME_PART)
        .Set(Am_TEXT, goal_name_form)
      .Get_Owner()
      .Get_Part(PORTS_PART)
      //.Set(Am_VISIBLE, goal_contents_visible_form)
      .Get_Owner();
  return goal;
}

void Goal_Toggle_Icon(Am_Object goal)
{
  goal.Set(IS_ICON, !(bool)goal.Get(IS_ICON));
}

// ---- formulas ----
Am_Define_Formula(int, under_process_name)
{
  Am_Object name = self.GV_Sibling(NAME_PART);
  if (name.Valid())
    return (int)name.GV(Am_HEIGHT) + 1;
  else
    return 0;
}

Am_Define_String_Formula (process_name_formula)
{
  Am_Object name = self.GV_Part(CONTENTS_PART).GV_Part(NAME_PART);
  if (name.Valid())
    return (Am_String)name.GV(Am_TEXT);
  else
    return (Am_String)"";
}

Am_Define_String_Formula (process_module_formula)
{
  Am_Object proc_agg = self.GV_Owner();
  if (proc_agg.Valid() && proc_agg.Is_Instance_Of(Process_Agg))
    return (Am_String)proc_agg.GV(MODULE_NAME);
  else
    return (Am_String)"";
}

Am_Define_String_Formula (rule_name_for_text)
{
  Am_Object rule = self.GV_Owner().GV_Owner();
  if (rule.Valid()) 
    return (Am_String)rule.GV(PROC_NAME);
  else
    return (Am_String)"";
}

Am_Define_String_Formula (rule_name_formula)
{
  Am_Object parent = (Am_Object)self.GV(PARENT_PROC);
  if (parent.Valid()) 
    return (Am_String)parent.GV(PROC_NAME);
  else
    return (Am_String)"";
}

Am_Define_Formula (int, rule_type_formula)
{
  Am_Object parent = (Am_Object)self.GV(PARENT_PROC);
  if (parent.Valid()) 
    return parent.GV(PROC_TYPE);
  else
    return KL_Normal_Proc;
}

Am_Define_Formula(bool, creator_visible)
{
  if ((int)self.GV_Owner().GV(PROC_TYPE) == KL_Creator_Proc)
    return true;
  else
    return false;
}

Am_Define_Formula(bool, normal_proc_visible)
{
  if ((int)self.GV_Owner().GV(PROC_TYPE) == KL_Creator_Proc)
    return false;
  else
    return true;
}

Am_Define_Formula(int, creator_frame_radius_form)
{
  Am_Object parent = (Am_Object)self.GV_Owner().GV(PARENT_PROC);
  if (parent.Valid())
    return (int)parent.GV_Part(SUB_FRAME_PART).GV(Am_RADIUS);
  else
    return 0;
}

#define PROCESS_TITLE_HEIGHT 18
Am_Slot_Key FRAME_BODY    = Am_Register_Slot_Name("FRAME_BODY");

Am_Define_Formula(int, frame_body_top)
{
  return PROCESS_TITLE_HEIGHT;
}

Am_Define_Formula(int, frame_body_height)
{
  Am_Object parent = self.GV_Owner();
  if (parent.Valid())
    return (int)parent.GV(Am_HEIGHT) - PROCESS_TITLE_HEIGHT;
  else
    return 0;
}

void Initialize_Process(void)
{
  // Process
  //  Am_Object process_frame_body = Am_Border_Rectangle.Create("frame_body")
  Am_Object process_frame_body = Am_Border_Roundtangle.Create("frame_body")
    //    .Set(Am_VISIBLE,    Am_From_Owner(Am_VISIBLE))
    .Set(Am_LEFT,       0)
    .Set(Am_TOP,        frame_body_top)
    .Set(Am_WIDTH,      Am_From_Owner(Am_WIDTH))
    .Set(Am_HEIGHT,     frame_body_height)
    .Set(Am_RADIUS,	3)
    .Set(Am_FILL_STYLE, Am_From_Owner(Am_FILL_STYLE))
    ;
  Am_Object process_frame = Am_Group.Create("process_frame")
    //Am_Object process_frame = Am_Rectangle.Create("process_frame")
    .Set(Am_VISIBLE,    normal_proc_visible)
    .Set(Am_WIDTH,      KL_Frame_Width(proc_margin))
    .Set(Am_HEIGHT,     KL_Frame_Height(proc_margin))
    .Add_Part(FRAME_BODY, process_frame_body)
    ;
//   Am_Object process_frame = Am_Border_Rectangle.Create("process_frame")
//     //Am_Object process_frame = Am_Rectangle.Create("process_frame")
//     .Set(Am_VISIBLE,    normal_proc_visible)
//     .Set(Am_WIDTH,      KL_Frame_Width(proc_margin))
//     .Set(Am_HEIGHT,     KL_Frame_Height(proc_margin))
//     .Set(Am_FILL_STYLE, Am_Motif_Light_Gray)
//     ;
  Am_Object creator_frame_body = Am_Rectangle.Create("frame_body")
    //    .Set(Am_VISIBLE,    Am_From_Owner(Am_VISIBLE))
    .Set(Am_LEFT,       0)
    .Set(Am_TOP,        frame_body_top)
    .Set(Am_WIDTH,      Am_From_Owner(Am_WIDTH))
    .Set(Am_HEIGHT,     frame_body_height)
    .Set(Am_FILL_STYLE, Am_No_Style)
    .Set(Am_LINE_STYLE, Am_Line_2)
    ;
  Am_Object creator_frame = Am_Group.Create("creator_frame")
    .Set(Am_VISIBLE,	creator_visible)
    .Set(Am_WIDTH,      KL_Frame_Width(proc_margin))
    .Set(Am_HEIGHT,     KL_Frame_Height(proc_margin))
    .Add_Part(FRAME_BODY, creator_frame_body)
    ;
//   Am_Object creator_frame = Am_Roundtangle.Create("creator_frame")
//     .Set(Am_VISIBLE,    creator_visible)
//     .Set(Am_WIDTH,      KL_Frame_Width(proc_margin))
//     .Set(Am_HEIGHT,     KL_Frame_Height(proc_margin))
//     .Set(Am_RADIUS,	0)
//     .Set(Am_FILL_STYLE, Am_No_Style)
//     .Set(Am_LINE_STYLE, Am_Line_2)
//     ;
  Am_Object process_name = Am_Text.Create("process_name")
    .Set(Am_LEFT, Am_Center_X_Is_Center_Of_Owner)
    .Set(Am_TEXT, "process")
    .Set(Am_FONT, Am_Font("-*-helvetica-*-r-*--12-*"))
    ;
  Am_Object parts_group = Am_Group.Create("parts_group")
    .Set(Am_TOP,    under_process_name)
    .Set(Am_WIDTH,  Am_Width_Of_Parts)
    .Set(Am_HEIGHT, Am_Height_Of_Parts)
//    .Set(Am_LAYOUT, packing_layout)
//     .Add_Part(PARTS_MOVER, parts_mover)
    ;
  Am_Object process_contents = Am_Group.Create("process_contents")
    .Set(Am_LEFT,   proc_margin /2)
    .Set(Am_TOP,    proc_margin /2)
    .Set(Am_WIDTH,  Am_Width_Of_Parts)
    .Set(Am_HEIGHT, Am_Height_Of_Parts)
    .Add_Part(PORTS_PART, parts_group.Create("ports_part"))
    .Add_Part(NAME_PART,  process_name)
    ;

  Process_Proto = Am_Group.Create("Process_Proto")
    .Set(PROC_NAME,   process_name_formula)
    .Set(PROC_MODULE, process_module_formula)
    .Set(PROC_TYPE,   KL_Normal_Proc)
    .Set(PROC_RULES,  Am_Value_List())
    .Set(NAME_LIST,   Am_Value_List())
    .Set(Am_WIDTH,    Am_From_Part(FRAME_PART, Am_WIDTH))
    .Set(Am_HEIGHT,   Am_From_Part(FRAME_PART, Am_HEIGHT))
    .Add_Part(FRAME_PART,     process_frame)
    .Add_Part(SUB_FRAME_PART, creator_frame)
    .Add_Part(CONTENTS_PART,  process_contents)
    ;

  Creator_Proto = Process_Proto.Create("Creator_Proto")
    .Set(PROC_TYPE, KL_Creator_Proc)
    ;
  Proc_Rename(Creator_Proto, "creator");

  Am_Object rule_name = Am_Text.Create("rule_name")
    .Set(Am_TEXT, rule_name_for_text)
    .Set(Am_FONT, Am_Font("-*-helvetica-*-r-*--12-*"))
    ;
  Am_Object rule_contents = Am_Group.Create("rule_contents")
    .Set(Am_LEFT,   proc_margin / 2)
    .Set(Am_TOP,    proc_margin / 2)
    .Set(Am_WIDTH,  Am_Width_Of_Parts)
    .Set(Am_HEIGHT, Am_Height_Of_Parts)
    .Add_Part(GOALS_PART,  parts_group.Create("goals_part")
	      .Set(Am_VISIBLE, icon_visible_form))
    .Add_Part(PORTS_PART,  parts_group.Create("ports_part"))
    .Add_Part(GUARD_PART,  parts_group.Create("guard_part"))
    .Add_Part(BINDER_PART, parts_group.Create("binder_part")
	      .Set(Am_VISIBLE, icon_visible_form))
    .Add_Part(NAME_PART,   rule_name)
    ;
  rule_contents.Get_Part(PORTS_PART).Remove_Part(PARTS_MOVER);
  rule_contents.Get_Part(BINDER_PART).Remove_Part(PARTS_MOVER);

  Rule_Proto = Am_Group.Create("Rule_Proto")
    .Set(RULE_TYPE,    KL_Transition_Rule)
    .Set(IS_ICON, false)
    .Set(NAME_LIST,    Am_Value_List())
    .Set(PARENT_PROC,  Process_Proto)
    .Set(PROC_NAME,    rule_name_formula)
    .Set(PROC_TYPE,    rule_type_formula)
    ;
}

/* ---------------- Port ---------------- */

// ---- global objects ----
Am_Object Port_Proto;
Am_Object In_Single_Proto;
Am_Object Out_Single_Proto;
Am_Object In_Stream_Proto;
Am_Object Out_Stream_Proto;

// ---- Port's slot keys ----
Am_Slot_Key VALUE_PART = Am_Register_Slot_Name("VALUE_PART");
Am_Slot_Key MARKER_PART = Am_Register_Slot_Name("MARKER_PART");

Am_Slot_Key PORT_NAME = Am_Register_Slot_Name("PORT_NAME");
Am_Slot_Key PORT_AGE = Am_Register_Slot_Name("PORT_AGE");
#define KL_New_Port	0
#define KL_Old_Port	1
Am_Slot_Key PORT_TYPE = Am_Register_Slot_Name("PORT_TYPE");
#define KL_Single	0
#define KL_Stream	1
Am_Slot_Key PORT_MODE = Am_Register_Slot_Name("PORT_MODE");
#define KL_Output	0
#define KL_Input	1
Am_Slot_Key PORT_OPEN = Am_Register_Slot_Name("PORT_OPEN");
#define KL_Open		0
#define KL_Close	1
Am_Slot_Key PORT_DIR = Am_Register_Slot_Name("PORT_DIR");
Am_Slot_Key PORT_DIR_DAEMON = Am_Register_Slot_Name("PORT_DIR_DAEMON");
// Am_Slot_Key PORT_DIR_TOGGLER = Am_Register_Slot_Name("PORT_DIR_TOGGLER");
#define KL_Left		0
#define KL_Right	1
// Am_Slot_Key PORT_ID = Am_Register_Slot_Name("PORT_ID");
Am_Slot_Key PORT_BINDERS = Am_Register_Slot_Name("PORT_BINDERS");

// ---- operations ----

bool Port_Rename(Am_Object port, char* name)
{
  port.Get_Part(CONTENTS_PART)
    .Get_Part(NAME_PART)
    .Set(Am_TEXT, name);
  return true;
}

void Port_Add(Am_Object port, Am_Object data)
{
  if (data.Is_Instance_Of(Port_Proto)) {
    if ((int)data.Get(PORT_TYPE) == KL_Stream &&
	(int)data.Get(PORT_MODE) == KL_Input)
      data.Set(PORT_OPEN, KL_Close);
  }
  Am_Object values_agg = port.Get_Part(CONTENTS_PART).Get_Part(VALUE_PART);
  values_agg.Add_Part(data).Remove_Part(data);
  values_agg.Add_Part(data);
}

void Port_Remove(Am_Object port, Am_Object data)
{
  Am_Object values_agg = port.Get_Part(CONTENTS_PART).Get_Part(VALUE_PART);
  values_agg.Remove_Part(data);
}

void Port_Remove_Value(Am_Object value)
{
  value.Remove_From_Owner();
}

Am_Object Port_Parent(Am_Object port)
{
  Am_Object parent = port.Get_Owner().Get_Owner().Get_Owner();
  if (parent.Valid()) return parent;
  else return 0;
}

Am_Object Port_Top_Parent(Am_Object port)
{
  Am_Object parent = port;
  Am_Object tmp;
  while((tmp = Port_Parent(parent)).Valid()) {
    if (!tmp.Is_Instance_Of(Port_Proto) && !tmp.Is_Instance_Of(Structure_Proto))
      return parent;
    parent = tmp;
  }
  return 0;
}

Am_Object Port_Parent_Proc(Am_Object port) // $B0lHV6a$$?F%W%m%;%9(B,$B%4!<%k(B,$B%k!<%k$rJV$9!%(B
{
  Am_Object parent = port;
  while((parent = Port_Parent(parent)).Valid()) {
    if (!parent.Is_Instance_Of(Port_Proto) && !parent.Is_Instance_Of(Structure_Proto))
      return parent;
  }
  return 0;
}

Am_Object Port_Parent_Rule(Am_Object port) // $B?F%k!<%k$rJV$9!%(B
{
  Am_Object parent = port;
  while((parent = Port_Parent(parent)).Valid()) {
    if (parent.Is_Instance_Of(Rule_Proto))
      return parent;
  }
  return 0;
}

// ---- formulas ----
Am_Define_Formula(int, port_type_to_radius) {
  if ((int)self.GV_Owner().GV(PORT_TYPE) == KL_Single) 
    return 7;
  else
    return 0;
}

Am_Define_Formula(int, head_dir_daemon) {
  Am_Object slot = self.GV_Owner();
  if (!slot.Valid()) return 0;
  int head_dir = slot.GV(PORT_DIR);
  if (head_dir == KL_Left) {
    self.Set(Am_LAYOUT, Am_Horizontal_Layout);
    self.Get_Part(VALUE_PART).Set(Am_LAYOUT, Am_Horizontal_Layout);
  } else {
    self.Set(Am_LAYOUT, Am_Horizontal_Rev_Layout);
    self.Get_Part(VALUE_PART).Set(Am_LAYOUT, Am_Horizontal_Rev_Layout);
  }
  return 0;
}

Am_Define_String_Formula (port_name_form) {
//  cout << self << self.GV_Owner() << self.GV_Owner().GV_Owner() << endl;
  Am_Object port_name = self.GV_Part(CONTENTS_PART).GV_Part(NAME_PART);
  if (port_name.Valid()) 
    return (Am_String)port_name.GV(Am_TEXT);
  else
    return (Am_String)"";
}

Am_Define_Style_Formula(port_fill_style) {
  int age = self.GV_Owner().GV(PORT_AGE);
  if (age == KL_New_Port)
    return Am_Motif_Light_Gray;
  else
    return Am_Motif_Green;
}

Am_Define_Style_Formula(slot_name_color) {
  Am_Object slot = self.GV_Owner().GV_Owner();
  if (slot.Valid()) {
    int age = slot.GV(PORT_AGE);
    if (age == KL_New_Port)
      return Am_Black;
    else
      return Am_White;
  }
  return Am_Black;
}

// marker's formula
Am_Define_Formula(int, marker_height_form)// $BL>A0$HF1$89b$5!%(B
{
  Am_Object owner = self.GV_Owner();
  if (!owner.Valid()) return 0;
  Am_Object name_part = owner.GV_Part(NAME_PART);
  if (name_part.Valid())
    return (int)name_part.GV(Am_HEIGHT);
  else
    return 0;
}

Am_Define_Formula(int, marker_width_form) // Open$B;~$OL>A0$N9b$5$N(B2/3, Close$B;~$OF1$8!%(B
{
  Am_Object port = self.GV_Owner().GV_Owner();
  if (port.Valid()) {
    if ((int)port.GV(PORT_OPEN) == KL_Open)
      return (int)self.GV(Am_HEIGHT) / 2;
    else
      return (int)self.GV(Am_HEIGHT);
  }
}

Am_Define_Point_List_Formula(marker_arrow_point_list_form)
{
//   static int hoge_list[8] = { 0, 0, 4, 0, 4, 4, 0, 4};
//   static Am_Point_List hoge_points(hoge_list, 8);

  Am_Point_List tri;
  Am_Object mark = self.GV_Owner();
  Am_Object port = mark.GV_Owner().GV_Owner();

//   cout << "---point_list: " << port << "\n";
//   cout.flush();
  
  if (!port.Valid()) {
    //cout << "---           port invalid...\n";
    return tri;
  }
  
  int left   = (int)self.GV(Am_LEFT);
  int width  = (int)self.GV(Am_WIDTH);
  //int height = (int)self.GV(Am_HEIGHT);
  int height = (int)mark.GV(Am_HEIGHT);
  int dir    = (int)port.GV(PORT_DIR);
  
  if (dir == KL_Right) {
    tri.Add(0,		2);
    tri.Add(0,		height-2);
    tri.Add(width-2,	height/2);
    tri.Add(0,		2);
  } else {
    tri.Add(width-2,	2);
    tri.Add(width-2,	height-2);
    tri.Add(0,		height/2);
    tri.Add(width-2,	2);
  }
//   cout << "---           " << left << "," << width << "," << height << "\n";
//   cout << "---           " << tri << "\n";
//   cout.flush();
  return tri;
}

Am_Define_Formula(int, marker_arrow_width_form) {
  return (int)self.GV(Am_HEIGHT) / 2;
}

Am_Define_Formula(int, marker_arrow_left_form) {
  Am_Object mark = self.GV_Owner();
  Am_Object port = mark.GV_Owner().GV_Owner();
  if (port.Valid()) {
    int dir  = (int)port.GV(PORT_DIR);
    int mode = (int)port.GV(PORT_MODE);
    int open = (int)port.GV(PORT_OPEN);
    if (dir == KL_Right)
      return 0;
    else
      return (int)mark.GV(Am_WIDTH) - (int)self.GV(Am_WIDTH) - 1;
  }
  return 0;
}

Am_Define_Style_Formula(marker_arrow_style_form) {
  Am_Object mark = self.GV_Owner();
  Am_Object port = mark.GV_Owner().GV_Owner();
  if (port.Valid()) {
    int open = port.GV(PORT_OPEN);
    int age = port.GV(PORT_AGE);
    if (open == KL_Close || age == KL_Old_Port)
      return Am_White;
    else
      return Am_Black;
  }
  return Am_Black;
}

Am_Define_Formula(int, close_rect_visible_form) {
  Am_Object mark = self.GV_Owner();
  Am_Object port = mark.GV_Owner().GV_Owner();
  if (port.Valid()) {
    return port.GV(PORT_OPEN);
  }
  return 0;
}

void Initialize_Port(void)
{
  Am_Object port_frame = Am_Border_Roundtangle.Create("port_frame")
    //Am_Object port_frame = Am_Roundtangle.Create("port_frame")
    .Set(Am_WIDTH,      KL_Frame_Width(slot_width_margin))
    .Set(Am_HEIGHT,     KL_Frame_Height(slot_height_margin))
    .Set(Am_FILL_STYLE, port_fill_style)
    .Set(Am_RADIUS,     port_type_to_radius)
    .Set(Am_SELECTED,   Am_From_Owner(PORT_MODE))
    ;

  Am_Object port_contents = Am_Group.Create("port_contents")
    .Set(Am_LEFT,      slot_width_margin / 2)
    .Set(Am_TOP,       slot_height_margin / 2)
    .Set(Am_WIDTH,     Am_Width_Of_Parts)
    .Set(Am_HEIGHT,    Am_Height_Of_Parts)
    .Set(Am_LAYOUT,    Am_Horizontal_Layout)
    .Set(Am_H_SPACING, 2)
    ;

  Am_Object port_name = Am_Text.Create("port_name")
    .Set(Am_FONT,       Am_Font("-*-helvetica-*-r-*--10-*"))
    .Set(Am_LINE_STYLE, slot_name_color)
    ;

  Am_Object port_values = Am_Group.Create("port_values")
    .Set(Am_WIDTH,     Am_Width_Of_Parts)
    .Set(Am_HEIGHT,    Am_Height_Of_Parts)
    .Set(Am_LAYOUT,    Am_Horizontal_Layout)
    .Set(Am_H_SPACING, 1)
    ;

//   Am_Object port_marker_in = Am_Group.Create("port_marker_in")
//     .Set(Am_WIDTH,  marker_width_form)
//     .Set(Am_HEIGHT, marker_height_form)
//     .Add_Part(FRAME_PART, Am_Rectangle.Create("port_marker_frame")
//  	      .Set(Am_WIDTH,      Am_From_Owner(Am_WIDTH))
//  	      .Set(Am_HEIGHT,     Am_From_Owner(Am_HEIGHT))
// 	      .Set(Am_VISIBLE,    close_rect_visible_form)
//  	      .Set(Am_LINE_STYLE, Am_White)
//  	      .Set(Am_FILL_STYLE, Am_Black)
// 	      )
//     .Add_Part(CONTENTS_PART, Am_Polygon.Create("port_marker_contents")
//   	      .Set(Am_LEFT,       marker_arrow_left_form)
//   	      .Set(Am_HEIGHT,     Am_From_Owner(Am_HEIGHT))
//   	      .Set(Am_WIDTH,      marker_arrow_width_form)
// 	      //.Set(Am_POINT_LIST, hoge_points)
// 	      .Set(Am_POINT_LIST, marker_arrow_point_list_form)
//   	      .Set(Am_LINE_STYLE, marker_arrow_style_form)
//   	      .Set(Am_FILL_STYLE, marker_arrow_style_form)
// 	      )
//     ;
//   Am_Object port_marker_out = Am_Group.Create("port_marker_out")
//     .Set(Am_WIDTH,  marker_width_form)
//     .Set(Am_HEIGHT, marker_height_form)
//     .Add_Part(FRAME_PART, Am_Rectangle.Create("port_marker_frame")
//  	      .Set(Am_WIDTH,      Am_From_Owner(Am_WIDTH))
//  	      .Set(Am_HEIGHT,     Am_From_Owner(Am_HEIGHT))
// 	      .Set(Am_VISIBLE,    close_rect_visible_form)
//  	      .Set(Am_LINE_STYLE, Am_White)
//  	      .Set(Am_FILL_STYLE, Am_Black)
// 	      )
//     .Add_Part(CONTENTS_PART, Am_Polygon.Create("port_marker_contents")
//   	      .Set(Am_LEFT,       marker_arrow_left_form)
//   	      .Set(Am_HEIGHT,     Am_From_Owner(Am_HEIGHT))
//   	      .Set(Am_WIDTH,      marker_arrow_width_form)
// 	      //.Set(Am_POINT_LIST, hoge_points)
// 	      .Set(Am_POINT_LIST, marker_arrow_point_list_form)
//   	      .Set(Am_LINE_STYLE, marker_arrow_style_form)
//   	      .Set(Am_FILL_STYLE, marker_arrow_style_form)
// 	      )
//     ;

  Port_Proto = Am_Group.Create("Port_Proto")
    .Set(PORT_TYPE,    KL_Single)
    .Set(PORT_AGE,     KL_New_Port)
    .Set(PORT_MODE,    KL_Input)
    .Set(PORT_OPEN,    KL_Open)
    .Set(PORT_DIR,     KL_Right)
    .Set(PORT_BINDERS, Am_Value_List())
    .Set(Am_WIDTH,     KL_Frame_Width_Plus(0))
    .Set(Am_HEIGHT,    KL_Frame_Height_Plus(0))
    .Add_Part(FRAME_PART,    port_frame)
    .Add_Part(CONTENTS_PART, port_contents)
    ;

  In_Single_Proto = Port_Proto.Create("In_Single_Proto")
    .Set(PORT_NAME, port_name_form)
    .Set(PORT_TYPE, KL_Single)
    .Set(PORT_MODE, KL_Input)
    .Get_Part(CONTENTS_PART)
      .Add_Part(NAME_PART,  port_name.Create().Set(Am_TEXT, "In"))
      .Add_Part(VALUE_PART, port_values.Create())
    .Get_Owner()
    ;
  Out_Single_Proto = Port_Proto.Create("Out_Single_Proto")
    .Set(PORT_NAME, port_name_form)
    .Set(PORT_TYPE, KL_Single)
    .Set(PORT_MODE, KL_Output)
    .Get_Part(CONTENTS_PART)
      .Add_Part(NAME_PART,  port_name.Create().Set(Am_TEXT, "Out"))
      .Add_Part(VALUE_PART, port_values.Create())
    .Get_Owner()
    ;

  In_Stream_Proto = Port_Proto.Create("In_Stream_Proto")
    .Set(PORT_NAME, port_name_form)
    .Set(PORT_TYPE, KL_Stream)
    .Set(PORT_MODE, KL_Input)
    .Get_Part(CONTENTS_PART)
      .Add_Part(NAME_PART,   port_name.Create().Set(Am_TEXT, "In Stream"))
      .Add_Part(VALUE_PART,  port_values.Create())
      .Add_Part(MARKER_PART, Am_Group.Create("port_marker_in")
		.Set(Am_LEFT, 0)
		.Set(Am_TOP, 0)
		.Set(Am_WIDTH,  marker_width_form)
		.Set(Am_HEIGHT, marker_height_form)
// 		.Add_Part(FRAME_PART, Am_Rectangle.Create("port_marker_frame")
// 			  .Set(Am_WIDTH,      Am_From_Owner(Am_WIDTH))
// 			  .Set(Am_HEIGHT,     Am_From_Owner(Am_HEIGHT))
// 			  .Set(Am_VISIBLE,    close_rect_visible_form)
// 			  .Set(Am_LINE_STYLE, Am_White)
// 			  .Set(Am_FILL_STYLE, Am_Black)
// 			  )
		.Add_Part(CONTENTS_PART, Am_Polygon.Create("port_marker_contents")
			  .Set(Am_LEFT,       marker_arrow_left_form)
			  .Set(Am_HEIGHT,     Am_From_Owner(Am_HEIGHT))
			  .Set(Am_WIDTH,      marker_arrow_width_form)
			  .Set(Am_POINT_LIST, marker_arrow_point_list_form)
			  .Set(Am_LINE_STYLE, marker_arrow_style_form)
			  .Set(Am_FILL_STYLE, marker_arrow_style_form)
			  )
		)
    .Get_Owner()
    ;

  Out_Stream_Proto = Port_Proto.Create("Out_Stream_Proto")
    .Set(PORT_NAME, port_name_form)
    .Set(PORT_TYPE, KL_Stream)
    .Set(PORT_MODE, KL_Output)
    .Get_Part(CONTENTS_PART)
      .Add_Part(VALUE_PART,  port_values.Create())
      .Add_Part(NAME_PART,   port_name.Create().Set(Am_TEXT, "Out Stream"))
      .Add_Part(MARKER_PART, Am_Group.Create("port_marker_out")
		.Set(Am_LEFT, 0)
		.Set(Am_TOP, 0)
		.Set(Am_WIDTH,  marker_width_form)
		.Set(Am_HEIGHT, marker_height_form)
// 		.Add_Part(FRAME_PART, Am_Rectangle.Create("port_marker_frame")
// 			  .Set(Am_WIDTH,      Am_From_Owner(Am_WIDTH))
// 			  .Set(Am_HEIGHT,     Am_From_Owner(Am_HEIGHT))
// 			  .Set(Am_VISIBLE,    close_rect_visible_form)
// 			  .Set(Am_LINE_STYLE, Am_White)
// 			  .Set(Am_FILL_STYLE, Am_Black)
// 			  )
		.Add_Part(CONTENTS_PART, Am_Polygon.Create("port_marker_contents")
			  .Set(Am_LEFT,       marker_arrow_left_form)
			  //.Set(Am_LEFT,       0)
			  .Set(Am_HEIGHT,     Am_From_Owner(Am_HEIGHT))
			  .Set(Am_WIDTH,      marker_arrow_width_form)
			  .Set(Am_POINT_LIST, marker_arrow_point_list_form)
			  .Set(Am_LINE_STYLE, marker_arrow_style_form)
			  .Set(Am_FILL_STYLE, marker_arrow_style_form)
			  )
		)
    .Get_Owner()
    ;
}

/* ---------------- Atom data ---------------- */

// ---- global objects ----
Am_Object Atom_Proto;

void Initialize_Atom(void)
{
  Am_Object atom_frame = Am_Roundtangle.Create("atom_frame")
    .Set(Am_WIDTH, KL_Frame_Width(atom_width_margin))
    .Set(Am_HEIGHT, KL_Frame_Height(atom_height_margin))
    .Set(Am_FILL_STYLE, Am_White)
    .Set(Am_RADIUS, 8)
    ;
  Am_Object atom_content = Am_Text.Create("atom_content")
    .Set(Am_TOP, atom_height_margin /2)
    .Set(Am_LEFT, atom_width_margin / 2)
    .Set(Am_TEXT, "0")
    .Add_Part(TEXT_INTER_PART, Am_Text_Edit_Interactor.Create()
	      .Set(Am_PRIORITY, 5)
	      .Set(Am_START_WHEN, "DOUBLE_LEFT_DOWN")
      )
    ;

  Atom_Proto = Am_Group.Create("Atom_Proto")
    .Set(PORT_MODE, KL_Input)
    .Set(PORT_TYPE, KL_Single)
    .Set(PORT_AGE, KL_New_Port)
    .Set(Am_LEFT, 0)
    .Set(Am_TOP, 0)
    .Set(Am_WIDTH, KL_Frame_Width_Plus(1))
    .Set(Am_HEIGHT, KL_Frame_Height_Plus(1))
    .Add_Part(FRAME_PART, atom_frame)
    .Add_Part(CONTENTS_PART, atom_content)
    ;
  ((Am_Object_Advanced&)Atom_Proto).Set_Default_Inherit_Rule(Am_COPY);
}

/* ---------------- Structure ---------------- */

// ---- global objects ----
Am_Object Structure_Proto;

void Initialize_Structure(void)
{
  Am_Object structure_frame = Am_Roundtangle.Create("structure_frame")
    .Set(Am_WIDTH, KL_Frame_Width(structure_width_margin))
    .Set(Am_HEIGHT, KL_Frame_Height(structure_height_margin))
    .Set(Am_FILL_STYLE, Am_Motif_Light_Gray)
    .Set(Am_RADIUS, 8)
    ;
  Am_Object structure_contents = Am_Group.Create("structure_contents")
    .Set(Am_LEFT, structure_width_margin / 2)
    .Set(Am_TOP, structure_height_margin / 2)
    .Set(Am_WIDTH, Am_Width_Of_Parts)
    .Set(Am_HEIGHT, Am_Height_Of_Parts)
    .Set(Am_LAYOUT, Am_Horizontal_Layout)
    .Set(Am_H_SPACING, 2)
    ;

  Am_Object structure_slots = Am_Group.Create("structure_slots")
    .Set(Am_WIDTH, Am_Width_Of_Parts)
    .Set(Am_HEIGHT, Am_Height_Of_Parts)
    .Set(Am_LAYOUT, Am_Horizontal_Layout)
    .Set(Am_H_SPACING, 2)
    ;

  Structure_Proto = Am_Group.Create("Structure_Proto")
    .Set(PORT_TYPE,    KL_Stream)  // $B$4$^$+$7!"%9%H%j!<%`$@$H;W$C$F$7$^$&!%(B
    .Set(PORT_MODE,    KL_Output)  // output $B$G$J$$$HF0$+$;$J$$!%(B
    .Set(PORT_AGE,     KL_Old_Port)
    .Set(PORT_BINDERS, Am_Value_List())
    .Set(PORT_NAME,    port_name_form)
    .Set(Am_WIDTH,     KL_Frame_Width_Plus(1))
    .Set(Am_HEIGHT,    KL_Frame_Height_Plus(1))
    .Add_Part(FRAME_PART, structure_frame)
    .Add_Part(CONTENTS_PART, structure_contents
	      .Add_Part(NAME_PART, Am_Text.Create().Set(Am_TEXT, "message")
			.Add_Part(TEXT_INTER_PART, Am_Text_Edit_Interactor.Create()
				  .Set(Am_PRIORITY, 5)
				  .Set(Am_START_WHEN, "DOUBLE_LEFT_DOWN")))
	      .Add_Part(VALUE_PART, structure_slots))
    ;
}

Am_Slot_Key BL_SRC = Am_Register_Slot_Name("BL_SRC");
Am_Slot_Key BL_DEST = Am_Register_Slot_Name("BL_DEST");

/* ---------------- KL_Widgets Initialize routine ---------------- */

void Initialize_KL_Widgets(void)
{
  Initialize_Module();
  Initialize_Process();
  Initialize_Port(); 
  Initialize_Atom();
  Initialize_Structure();
}

void change_process_proto(void)
{
  Process_Proto
    .Get_Part(CONTENTS_PART)
    .Get_Part(PORTS_PART)
    .Set(Am_LAYOUT, packing_layout)
    ;
}

// eof
