// Copyright (C) 1997  Toyoda Masashi (toyoda@is.titech.ac.jp)
#include <amulet.h>

#include "ToyWidgets.h"

Am_Object PopUpMenu = 0;
Am_Object PopUpMenuInteractor = 0;
Am_Object MenuCommand = 0;

DEFINE_SLOT(MenuWindow);
DEFINE_SLOT(MenuBody);
DEFINE_SLOT(TargetObj);
DEFINE_SLOT(XinTarget);
DEFINE_SLOT(YinTarget);
DEFINE_SLOT(ReturnValue);


Am_Define_Method(Am_Object_Method, void, Pop_Up_Menu_Do, (Am_Object command_obj)) {
  Am_Object inter = command_obj.Get_Owner();
  Am_Object target = inter.Get(Am_START_OBJECT);
  Am_Object window = inter.Get(Am_WINDOW);
  int x = (int)inter.Get(Am_FIRST_X);
  int y = (int)inter.Get(Am_FIRST_Y);
  int xt, yt, xs, ys;
  Am_Translate_Coordinates(window, x, y, target, xt, yt);
  Am_Translate_Coordinates(window, x, y, Am_Screen, xs, ys);

  Am_Object menu = inter.Get_Object(MenuWindow)
    .Set(Am_LEFT, xs - 10)
    .Set(Am_TOP, ys - 10)
    .Get_Part(MenuBody)
      .Set(TargetObj, target)
      .Set(XinTarget, xt)
      .Set(YinTarget, yt)
    .Get_Owner()
    ;
  Am_To_Top(menu);

  Am_Value return_value;
  Am_Start_Widget(menu.Get_Part(MenuBody), Am_No_Value);
  Am_Pop_Up_Window_And_Wait(menu, return_value, true);
  command_obj.Set(ReturnValue, return_value);
}

Am_Define_Method(Am_Object_Method, void, Finish_Pop_Up_Do, (Am_Object command_obj)) {
  Am_Object window = command_obj.Get_Owner().Get(Am_WINDOW);
  //  cout << "finishing.." << endl;
  Am_Finish_Pop_Up_Waiting(window, Am_No_Value);
}

Am_Define_Method(Am_Object_Method, void, Pop_Up_Menu_Abort_Do, (Am_Object command_obj)) {
  Am_Object window = command_obj.Get_Owner().Get(Am_WINDOW);
  //  cout << "aborting..." << endl;
  Am_Finish_Pop_Up_Waiting(window, Am_No_Value);
}  

Am_Define_Object_Formula(ParentCommandForm)
{
  Am_Object menu_item = self.GV_Owner();
  if (!menu_item.Valid()) return 0;
  
  Am_Object menu = menu_item.GV_Owner();
  if (!menu.Valid()) return 0;

  return menu.GV_Object(Am_COMMAND);
}

void Initialize_Pop_Up_Menu (void)
{
  Am_Object menu = Am_Menu.Create("PopUpInsideMenu")
    .Set(TargetObj, Am_No_Object)
    .Set(Am_X_OFFSET, 0)
    .Set(Am_Y_OFFSET, 0)
    .Get_Part(Am_COMMAND)
      .Set(Am_DO_METHOD, Finish_Pop_Up_Do)
    .Get_Owner()
    .Get_Part(Am_INTERACTOR)
     .Set(Am_START_WHEN, "right_down")
     .Get_Part(Am_COMMAND)
      .Set(Am_ABORT_DO_METHOD, Pop_Up_Menu_Abort_Do)
     .Get_Owner()
    .Get_Owner()
    ;

  PopUpMenu = Am_Window.Create("PopUpMenu")
    .Set(Am_WIDTH, Am_Width_Of_Parts)
    .Set(Am_HEIGHT, Am_Height_Of_Parts)
    .Set(Am_OMIT_TITLE_BAR, true)
    .Set(Am_VISIBLE, false)
    .Add_Part(MenuBody, menu)
    ;

  PopUpMenuInteractor = Am_One_Shot_Interactor.Create("PopUpMenuInteractor")
    .Set(Am_START_WHEN, "right_down")
    .Set(Am_RUN_ALSO, true)
    .Get_Part(Am_COMMAND)
    .Set(Am_DO_METHOD, Pop_Up_Menu_Do)
    .Get_Owner()
    ;

  MenuCommand = Am_Command.Create("MenuCommand")
    .Set(Am_IMPLEMENTATION_PARENT, ParentCommandForm)
    ;
}
