// -*- C++ -*-
// Copyright (C) 1996,1997 Buntarou Shizuki(shizuki@is.titech.ac.jp)

#ifndef _CZoom_h
#define _CZoom_h

#include <math.h>
#include <string.h>
#include <stdlib.h>
#include <minmax.h>
#include <DLList.h>

#include <amulet.h>
#include <amulet/debugger.h>

extern Am_Slot_Key CZNODE;
extern Am_Slot_Key CZSTATE;
extern Am_Object CZNODE_PROTO;

#define CZSTATE_LEAF		0
#define CZSTATE_MAGINIFIED	1
#define CZSTATE_CLUSTER		2

#define ELLIPSIS_HORIZONTAL	0
#define ELLIPSIS_VERTICAL	1

extern "C" void bzero(void *, int);

class DoublePointSize {
  double		left, top, width, height;
public:

  void			SetPoint(double L, double T) { left = L; top = T; }
  void			SetSize(double W, double H) { width = W; height = H; }

  void			SetLeft(double L) { left = L; }
  void			SetTop(double T) { top = T; }
  void			SetWidth(double W) { width = W; }
  void			SetHeight(double H) { height = H; }

  double		GetLeft() { return left; }
  double		GetTop() { return top; }
  double		GetWidth() { return width; }
  double		GetHeight() { return height; }

  double		GetRight() { return left+width; }
  double		GetBottom() { return top+height; }
};

enum CZNodeState {
  CZ_be_auto,
  CZ_be_opened,
  CZ_be_closed
};

enum CZNodeStatus {
  CZ_none,
  CZ_opened,
  CZ_closed
};

class CZNode;
class DisplayMethod {
protected:
  CZNode *		group;
  DLList<CZNode *> *	group_member;

public:
  DisplayMethod();
  ~DisplayMethod();

  virtual void		Focus(CZNode *node) = 0;
  virtual CZNode *	GetFirst() = 0;
  virtual CZNode *	GetNext() = 0;
  virtual bool		IsDone() = 0;
  virtual CZNode *	GetOtherFirst() = 0;
  virtual CZNode *	GetOtherNext() = 0;
  virtual bool		IsOtherDone() = 0;
  virtual int		GetLength() = 0;

  void			SetOld(CZNode *child);

  virtual void		update() = 0;
};

class DisplayNormally : public DisplayMethod {
  Pix			node_index;
public:
  DisplayNormally(CZNode *node);
  ~DisplayNormally();

  void			Focus(CZNode *node) {}
  CZNode *		GetFirst();
  CZNode *		GetNext();
  bool			IsDone();
  CZNode *		GetOtherFirst() { return NULL; }
  CZNode *		GetOtherNext() { return NULL; }
  bool			IsOtherDone() { return true; }
  int			GetLength();
  void			update() {}
};

#define CZ_ELLIPSIS_NODES 7

class Ellipsis;
class DisplayEllipsis : public DisplayMethod {
  Ellipsis *		ellipsis1;
  Ellipsis *		ellipsis2;
  CZNode *		nodes[CZ_ELLIPSIS_NODES];
  int			nodes_length;
  int			nodes_index;
  int			focus_index; // -1 points the last one
  Pix			other_index;
  int			other_index_ellipsis;
  int			ellipsis1_index;
  int			ellipsis2_index;
public:
  DisplayEllipsis(CZNode *node, int mode);
  ~DisplayEllipsis() {}

  Am_Object		Image();
  void			Focus(CZNode *node);
  CZNode *		GetFirst();
  CZNode *		GetNext();
  bool			IsDone();
  CZNode *		GetOtherFirst();
  CZNode *		GetOtherNext();
  bool			IsOtherDone();
  int			GetLength(); 
  void			update();
};

class CZNode : public DoublePointSize {
  struct section {
    CZNode *node;
    int orig;
    double tmp;			// temporal scale factor
    double scale;		// current scale factor
    double doi;			// DOI for this section
    double start;
    double width;
  };

protected:
  static Am_Object	CZwindow;

private:
  static CZNode	*	root;
  static CZNode *	nodes_opened;
  static CZNode *	nodes_others;

  double		CZdoi;
  CZNodeState		state;

  double		Xreq, Yreq, tmpXreq, tmpYreq;
  double		Xscale, Yscale, tmpXscale, tmpYscale;
  section *		x_sections;
  section *		y_sections;

  DLList<CZNode *>	CZmember;
  CZNode *		next_opened; // for linked list in calc_min
  CZNode *		next_others; // for linked list in calc_min

  bool			current_visible;

  CZNodeStatus		current_expansion;
  CZNodeStatus		future_expansion;
  CZNodeState		forced_expansion;
  
  DisplayMethod	*	display_method;

  void			AssignRemainder(double L, double T, double W, double H);

  int			CZid;

  Pix			all_index;
public:
  DoublePointSize	OldPoint; // XXX
  DoublePointSize	NewPoint; // XXX

  CZNode *		CZparent; // XXX

  static int		CZinterpolation_step;

  static int		CZnumber_created;
  static int		CZdebug_member;
  static int		CZdebug_resection;
  static int		CZdebug_list;
  static int		CZdebug_calcpoint;
  static int		CZdebug_scale;
  static int		CZdebug_calc;
  static int		CZdebug_focus;

public:
  CZNode();
  ~CZNode();

  static void		CZInitCZoom(Am_Object target_window);
  static Am_Object	CZGetWindow() { return CZwindow; }
  
  static void		CZSetRoot(CZNode *N) { root = N; }
  static CZNode *	CZGetRoot() { return root; }

  void			CZSetMethod(DisplayMethod *M);

  static void		CZShow();
  void			CZShowPrologue();
  void			CZOthersDelete();
  void			CZShowIter(int count, int limit);
  void			CZShowEpilogue();
  static void		CZRedraw();
  static void		CZSetInterpolation(int s) { CZinterpolation_step = s; }
  
  void			CZCalcInit(CZNode *creator);
  void			CZSetDOI(double D);
  double		CZGetDOI() { return CZdoi; }
  int			CZGetID() { return CZid; }
  static void		CZCalc();
  static void		CZSetPoint();
  void			CZCalcPoint(double L, double T, double W, double H);

  virtual double	XMin() = 0; // minimum requirement when closed
  virtual double	YMin() = 0; // minimum requirement when closed
  virtual Am_Object	Image() = 0;

  virtual int		do_grow() = 0;
  virtual int		do_shrink() = 0;
  virtual int		do_expand() = 0;
  virtual int		do_auto() = 0;
  
  CZNodeState		CZGetState() { return state; }
  void			CZSetState(CZNodeState s);
  void			CZSetParent(CZNode *n);
  void			CZDeleteMember();
  DLList<CZNode *> *	CZGetMember() { return &CZmember; }
  void			CZFocus();
  CZNode *		GetFirst() { return display_method->GetFirst(); }
  CZNode *		GetNext() { return display_method->GetNext(); }
  bool			IsDone() { return display_method->IsDone(); }
  int			GetLength() { return display_method->GetLength(); }
  CZNode *		GetOtherFirst() { return display_method->GetOtherFirst(); }
  CZNode *		GetOtherNext() { return display_method->GetOtherNext(); }
  bool			IsOtherDone() { return display_method->IsOtherDone(); }
  int			GetAllLength() { return CZmember.length(); }
  CZNode *		GetAllFirst();
  CZNode *		GetAllNext();
  bool			IsAllDone();

  bool			IsVisible() { return current_visible; }
  CZNodeStatus		CZGetStatus() { return current_expansion; }
  
  //
  // XXX: see also Amulet formula "cznode_border_style" in CZoom.cc
  //
  virtual void		SetTmpMin() = 0;
  virtual void		SetNormalMin() = 0;

  void			CZSetMin(double X, double Y);
  void			CZCalcScale();
  void			CZTmpScale();
  void			CZCommitScale();
  void			CZCalcMin(CZNode *updated);
  void			CZCalcMin();
  void			CZResection();
  void			CZMakeSection();
  void			CZInitSection();
  void			CZTmpSection();
  void			CZCommitExpand();
  static void		CZMakeList();
  CZNode *		CZMakeListOpened();
  CZNode *		CZMakeListOthers();
  void			CZOldPoint(CZNode *child);

  void			CZDumpMember(int level);
  void			CZDumpSection();
  
  static void		click_grow(Am_Object cmd_obj);
  static void		click_shrink(Am_Object cmd_obj);
  static void		enter_focus_mode(Am_Object cmd_obj);
  static void		leave_focus_mode(Am_Object cmd_obj);

  friend CZNode *	merge_list_opened(CZNode *list1, CZNode *list2);
  friend CZNode *	merge_list_others(CZNode *list1, CZNode *list2);
  friend void		print_list_others(CZNode *node);
  friend int		compare_section(section *s1, section *s2);
  friend void		dump_sections(section *sec, int n);

private:
  void			unvisible();
};

#endif _CZoom_h

class Ellipsis : public CZNode {
private:
  Am_Object		image;
  CZNode *		ref_node;
public:
  Ellipsis(int mode);
  ~Ellipsis();

  double		XMin() { return 10; }
  double		YMin() { return 10; }
  Am_Object 		Image() { return image; }
  void			SetRef(CZNode *node) { ref_node = node; }

  double		CZGetDOI() { return CZNode::CZGetDOI()/2; } // XXX

  int			do_grow() { return 1; }
  int			do_shrink() { return 1; }
  int			do_expand() { return 1; }
  int			do_auto() { return 1; }

  void			SetTmpMin() { }
  void			SetNormalMin() { }

  void			SetPoint();
};

// eof
