// Copyright (C) 1997  Toyoda Masashi (toyoda@is.titech.ac.jp)

// Initialize routine
void Initialize_Zooming_Widgets(void);

// Constants

enum SequenceDir { LeftRight = 0, TopBottom = 1, RightLeft = 2, BottomTop = 3 };

#define NofFontFamilies	3
#define FontFixed	0
#define FontSerif	1
#define FontSansSerif	2

#ifndef _INTERNAL_

// AlignZoomGroup

extern Am_Object AlignZoomGroup;
extern Am_Object SequenceAlignZoomGroup;

// public
EXPORT_SLOT(gridObject);
EXPORT_SLOT(alignThreshold);
EXPORT_SLOT(minimumSpace);
EXPORT_SLOT(minimumSize);
EXPORT_SLOT(maximumPercentage);
EXPORT_SLOT(allowGrowing);
EXPORT_SLOT(detailThreshold);
EXPORT_SLOT(propagateParent);
EXPORT_SLOT(isShurunken);
EXPORT_SLOT(partMoved);
EXPORT_SLOT(seqDir);
EXPORT_SLOT(numberThreshold);

// Selection Widget for AlignZoomGroup

extern Am_Object AlignZoomSelectionWidget;
extern Am_Object UndoZoomCmd;
extern Am_Object RedoZoomCmd;
extern Am_Object SelectiveUndoZoomCmd;
extern Am_Object ZoomUndoDialog;


// ZoomingText

extern Am_Object ZoomingText;
// public
EXPORT_SLOT(TextPart);
EXPORT_SLOT(FontFamily);
EXPORT_SLOT(FontIsBold);
EXPORT_SLOT(FontIsItalic);
EXPORT_SLOT(FontIsUnderline);

// Formulas
extern Am_Formula ResizeByZoomForm;

// Utilities

Am_Object Align_Zoom_Create_Part(Am_Object part);
Am_Object Align_Zoom_Copy_Part(Am_Object part);
int Get_Required_Width(Am_Object group);
int Get_Required_Height(Am_Object group);
int origX(Am_Object obj);
int origY(Am_Object obj);
int origW(Am_Object obj);
int origH(Am_Object obj);

#endif


