// Copyright (C) 1997  Toyoda Masashi (toyoda@is.titech.ac.jp)

#include <fstream.h>
#include <strstream.h>

#include <amulet.h>
#include FORMULA_ADVANCED__H
#include INTER_ADVANCED__H
#include WIDGETS_ADVANCED__H

#include "ToyWidgets.h"
#include "PovlWidgets.h"
#include "Resources.h"
#include "Module.h"
#include "Process.h"
#include "Rule.h"
#include "Pattern.h"
#include "Atom.h"
#include "Message.h"
#include "Guard.h"
#include "Port.h"
#include "Binder.h"

// ---- Tags ----
#define Beg_Module 'M'
#define End_Module 'm'

#define Beg_Procs  'P'
#define End_Procs  'p'
#define Beg_Proc   'C'
#define End_Proc   'c'

#define Beg_Rules  'R'
#define End_Rules  'r'
#define Beg_Rule   'L'
#define End_Rule   'l'
#define Beg_Patt   'E'
#define End_Patt   'e'
#define Beg_Goals  'O'
#define End_Goals  'o'
#define Beg_Goal   'N'
#define End_Goal   'n'
#define Beg_Holes  'H'
#define End_Holes  'h'
#define Beg_Hole   'I'
#define End_Hole   'i'
#define Beg_Gurds  'G'
#define End_Gurds  'g'
#define Beg_Gurd   'F'
#define End_Gurd   'f'
#define Beg_Bndrs  'B'
#define End_Bndrs  'b'
#define Beg_Bndr   'D'
#define End_Bndr   'd'


#define Beg_Ports  'Q'
#define End_Ports  'q'
#define Beg_Port   'T'
#define End_Port   't'
#define Beg_Vals   'V'
#define End_Vals   'v'
#define Beg_Stru   'S'
#define End_Stru   's'
#define Beg_Atom   'A'
#define End_Atom   'a'

#define KL_Free_Pattern 0
#define KL_Seq_Pattern  1

// ---- Global ----
Am_Object Process_Table[1024];
Am_Object Inner_Port_Table[1024];

/* $B%;!<%V;~$K;H$&$,!"(Btranslator$B$G$O$D$+$o$J$$!#(B
// Process ID formula
// ------------------
Am_Define_Formula(int, ProcIdForm) {
  Am_Object module = self.GV(Parent);
  if (module.Valid()) {
    if (module.Is_Instance_Of(ModuleProto)) {
      Am_Value_List proc_list = module.GV(ProcessList);
      return Object_List_Index(proc_list, self);
    }
    Am_Object proto = self.Get_Prototype();
    if (proto.Is_Instance_Of(ProcessProto))
      return proto.GV(Id);
  }
  return 0;
}
*/

// ---- Utility ----
Am_Object new_obj(Am_Object proto)
{
  Copy_Method new_method = proto.Get(NewMethod);
  if (new_method.Valid()) 
    return new_method.Call(proto);
  else
    return 0;
}

void add_obj(Am_Object dest, Am_Object src)
{
  Bin_Check_Method add_method = dest.Get(AddMethod);
  if (add_method.Valid())
    add_method.Call(dest, src);
}

int save_position(Am_Object obj, ofstream& ofile)
{
  ofile << " " << (int)obj.Get(Am_LEFT) << " " << (int)obj.Get(Am_TOP) << " ";
  return 1;
}

int load_position(Am_Object obj, ifstream& ifile)
{
  int left, top;
  ifile >> left >> top;
  obj.Get(Am_LEFT);
  obj.Set(Am_LEFT, left)
     .Set(Am_TOP, top);
  return 1;
}

int save_position_with_icon_info(Am_Object obj, ofstream& ofile)
{
  save_position(obj, ofile);
//   ofile << (bool)obj.Get(IS_ICON) << " "
// 	<< (int)obj.Get(ORIG_LEFT) << " " << (int)obj.Get(ORIG_TOP) << " "
// 	<< (int)obj.Get(ICON_LEFT) << " " << (int)obj.Get(ICON_TOP) << " ";
  return 1;
}

int load_position_with_icon_info(Am_Object obj, ifstream& ifile)
{
  load_position(obj, ifile);
  int is_icon, orig_left, orig_top, icon_left, icon_top;
  ifile >> is_icon >> orig_left >> orig_top >> icon_left >> icon_top;
  //  obj.Set(IS_ICON, is_icon)
  //    .Set(ORIG_LEFT, orig_left)
  //    .Set(ORIG_TOP, orig_top)
  //    .Set(ICON_LEFT, icon_left)
  //    .Set(ICON_TOP, icon_top);
  return 1;
}

// -----------------------------------
int save_module(Am_Object Window, ofstream& ofile);
int load_module(Am_Object window, ifstream& ifile);
int   save_proc_part(Am_Value_List procs, ofstream& ofile);
int   load_proc_part(Am_Object module, ifstream& ifile);
int     save_process(Am_Object process, ofstream& ofile);
int     load_process(Am_Object proc_agg, ifstream& ifile);
int   save_rules_part(Am_Value_List rules, ofstream& ofile);
int   load_rules_part(Am_Object module, ifstream& ifile);
int     save_rule(Am_Object rule, ofstream& ofile);
int     load_rule(Am_Object rules_agg, ifstream& ifile);
int     load_really_rule(Am_Object module, ifstream& ifile);
int       save_goals_part(Am_Object goals_agg, ofstream& ofile);
int       load_goals_part(Am_Object rule, ifstream& ifile);
int         save_goal(Am_Object goal, ofstream& ofile);
int         load_goal(Am_Object rule, ifstream& ifile);
int         load_really_goal(Am_Object rule, ifstream& ifile);
int         save_binder_part(Am_Object rule, ofstream& ofile);
int       load_binder_part(Am_Object rule, ifstream& ifile);
int       save_binder(Am_Object rule, Am_Object binder, ofstream& ofile);
int       load_binder(Am_Object rule, ifstream& ifile);
int       save_guard_part(Am_Object rule, ofstream& ofile);
int       load_guard_part(Am_Object rule, ifstream& ifile);
int       save_guard(Am_Object guard, ofstream& ofile);
int       load_guard(Am_Object rule, ifstream& ifile);
int     save_pattern(Am_Object pattern, ofstream& ofile);
int     load_pattern(Am_Object patt_agg, ifstream& ifile);
int       save_holes_part(Am_Object holes_agg, ofstream& ofile);
int       load_holes_part(Am_Object patt, ifstream& ifile);
int       save_hole(Am_Object hole, ofstream& ofile);
int       load_hole(Am_Object patt, ifstream& ifile);

int save_port_part(Am_Object port_agg, ofstream& ofile);
int load_port_part(Am_Object proc_agg, ifstream& ifile);
int load_exist_port_part(Am_Object process, ifstream& ifile);
int save_port(Am_Object port, ofstream& ofile);
int load_port(Am_Object port, ifstream& ifile);
int load_exist_port(Am_Object port, ifstream& ifile);

int save_value_part(Am_Object value_agg, ofstream& ofile);
int load_value_part(Am_Object port, ifstream& ifile);
int save_value(Am_Object value, ofstream& ofile);
int load_value(Am_Object port, ifstream& ifile);

int save_atom(Am_Object value, ofstream& ofile);
int load_atom(Am_Object port, ifstream& ifile);
int save_structure(Am_Object value, ofstream& ofile);
int load_structure(Am_Object port, ifstream& ifile);

// -------- Error --------
void Err(char *string)
{
  cerr << "Error: " << string << endl;
}

// -------- Module --------
// Beg_Module Name
// ... processes ...
// ... rules ...
// End_Module
/*
int save_module(Am_Object module, ofstream& ofile)
{
  ofile << Beg_Module << " " << (Am_String)module.Get_Object(Model).Get(Name) << endl;
  save_proc_part ((Am_Value_List)module.Get(ProcessList), ofile); 
  save_rules_part((Am_Value_List)module.Get(RuleList),    ofile); 
  ofile << End_Module << endl;
  return 1;
}
*/

int load_module(Am_Object module, ifstream& ifile)
{
  char tag;
  ifile >> tag; if (tag != Beg_Module) {Err("Beg_Module"); return 0;}
  char name[1000];
  ifile >> name;
  if (!((Naming_Method)module.Get(NamingMethod)).Call(module, name)) {
    // $B$[$s$H$O>e=q$-$7$F$$$$$+%@%$%"%m%0$r$@$9$s$@$m$&$J!#(B
    // $B$G$b%3%T!<$H$+$5$l$F$k$HBgJQ$J$s$@$h$J!#$I$&$7$h$&(B???
    Err("Module name");
    return 0;
  }
  module.Get_Part(ContentsPart).Set(Am_ACTIVE, false);
  load_proc_part (module, ifile);
  load_rules_part(module, ifile);
  module.Get_Part(ContentsPart).Set(Am_ACTIVE, true);
  ifile >> tag; if (tag != End_Module) {Err("End_Module"); return 0;}
}

// -------- Processes --------
// Beg_Procs
// ... process ...
// End_Procs
/*
int save_proc_part(Am_Value_List procs, ofstream& ofile)
{
  ofile << Beg_Procs << endl;
  for (procs.Start(); !procs.Last(); procs.Next()) {
    Am_Object proc = procs.Get();
    save_process(proc, ofile);
  }
  ofile << End_Procs << endl;
}
*/

int load_proc_part(Am_Object module, ifstream& ifile)
{
  char tag;
  ifile >> tag; if (tag != Beg_Procs) {Err("Beg_Procs"); return 0;}
  while (load_process(module, ifile));
  ifile >> tag; if (tag != End_Procs) {Err("End_Procs"); return 0;}
}

// -------- Process --------
// Beg_Proc Id Name Type Left Top Icon OLeft OTop ILeft ITop
// ... ports ... 
// End_Proc
/*
int save_process(Am_Object process, ofstream& ofile)
{
  ofile << Beg_Proc << " ";
  int id         = process.Get(Id);
  Am_String name = (Am_String)process.Get_Object(Model).Get(Name);
  int type       = 0; //process.Get(PROC_TYPE);
  ofile << id << " " << name << " " << type;
  save_position_with_icon_info(process, ofile);
  ofile << endl;
  save_port_part(process.Get(PortList), ofile);
  ofile << End_Proc << endl;
}
*/

int load_process(Am_Object module, ifstream& ifile)
{
  char tag;
  ifile >> tag; if (tag != Beg_Proc) {ifile.putback(tag); return 0;}
  int id, type;
  char name[1000];
  ifile >> id >> name >> type;
  cout << "load process: " << name << " id: " << id << " type: " << type << endl;

  Am_Object new_proc = new_obj(ProcessProto);
  new_proc.Get_Object(Model)
    .Set(Name, name)
    ;
  load_position_with_icon_info(new_proc, ifile);
  load_port_part(new_proc, ifile);
  Process_Table[id] = new_proc; // global table $B$KEPO?!%(B
  if (strcmp(name, "main") != 0) {
    add_obj(module, new_proc);
  }
  ifile >> tag; if (tag != End_Proc) {Err("End_Proc"); return 0;}
  return 1;
}

// -------- Rules Part --------
// Beg_Rules
// ... rules ...
// End_Rules
/*
int save_rules_part(Am_Value_List rules, ofstream& ofile)
{
  ofile << Beg_Rules << endl;
  for (rules.Start(); !rules.Last(); rules.Next()) {
    Am_Object rule = (Am_Object)rules.Get();
    if (rule.Is_Instance_Of(RuleProto))    save_rule(rule, ofile);
    //    if (rule.Is_Instance_Of(PatternProto)) save_pattern(rule, ofile);
  }
  ofile << End_Rules << endl;
}
*/

int load_rules_part(Am_Object module, ifstream& ifile)
{
  char tag;
  ifile >> tag; if (tag != Beg_Rules) {Err("Beg_Rules"); return 0;}
  while (load_rule(module, ifile));
  ifile >> tag; if (tag != End_Rules) {Err("End_Rules"); return 0;}
}


// -------- Rule --------
// Beg_Rule Proc Type Left Top Icon OLeft OTop ILeft ITop
// ... ports ...
// ... goals ...
// ... binders...
// End_Rule
/*
int save_rule(Am_Object rule, ofstream& ofile)
{
  ofile << Beg_Rule << " ";
  int Proc = (int)((Am_Object)rule.Get(PARENT_PROC)).Get(PROC_ID);
  int type = rule.Get(RULE_TYPE);
  ofile << Proc << " " << type;
  save_position_with_icon_info(rule, ofile);
  ofile << endl;
  save_port_part(Rule_Ports_Part(rule), ofile);
  save_goals_part(Rule_Goals_Part(rule), ofile);
  save_binder_part(rule, ofile);
  save_guard_part(rule, ofile);
  ofile << End_Rule << endl;
}
*/

int load_rule(Am_Object module, ifstream& ifile)
{
  char tag;
  ifile >> tag;
  if (tag == Beg_Rule) return load_really_rule(module, ifile);
  if (tag == Beg_Patt) return load_pattern(module, ifile);
  ifile.putback(tag);
  return 0;
}

int load_really_rule(Am_Object module, ifstream& ifile)
{
  char tag;
//  ifile >> tag; if (tag != Beg_Rule) {ifile.putback(tag); return 0;}
  int Proc, type;
  ifile >> Proc >> type;
  cout << "load rule, Proc id: " << Proc << " type: " << type << endl;
  Am_Object rule;
  if   (type == TransitionRule) rule = TransitionRuleProto;
  else if (type == NetworkRule) rule = NetworkRuleProto;
  else return 0;
  Am_Object p = Process_Table[Proc];
  if (strcmp((Am_String)p.Get_Object(Model).Get(Name), "main") != 0) {
    rule = Rule_Create(p, rule);
  } else {
    rule = module.Get_Part(ContentsPart).Get_Part(MainRule);
  }

  load_position_with_icon_info(rule, ifile);
  rule.Get_Part(ContentsPart).Set(Am_ACTIVE, false);  
  load_exist_port_part(rule, ifile);
  load_goals_part(rule, ifile);
  load_binder_part(rule, ifile);
  load_guard_part(rule, ifile);
  rule.Get_Part(ContentsPart).Set(Am_ACTIVE, true);  
  if (strcmp((Am_String)p.Get_Object(Model).Get(Name), "main") != 0)
    add_obj(module, rule);
  ifile >> tag; if (tag != End_Rule) return 0;
  return 1;
}


// -------- Goals Part --------
// Beg_Goals
// ... goals ...
// End_Goals
/*
int save_goals_part(Am_Object goals_agg, ofstream& ofile)
{
  ofile << Beg_Goals << endl;
  Am_Value_List goals = (Am_Value_List)goals_agg.Get(Am_GRAPHICAL_PARTS);
  for (goals.Start(); !goals.Last(); goals.Next()) {
    Am_Object goal = (Am_Object)goals.Get();
    if (KL_Type(goal) == KL_Process)    save_goal(goal, ofile);
    if (KL_Type(goal) == KL_Pattern) save_pattern(goal, ofile);
  }
  ofile << End_Goals << endl;
}
*/

int load_goals_part(Am_Object rule, ifstream& ifile)
{
  char tag;
  ifile >> tag; if (tag != Beg_Goals) return 0;
  while (load_goal(rule, ifile));
  ifile >> tag; if (tag != End_Goals) return 0;
}

// -------- Goal --------
// Beg_Goal Id Parent Hole position_with_icon
// ... ports ...
// End_Goal
/*
int save_goal(Am_Object goal, ofstream& ofile)
{
  ofile << Beg_Goal << " ";
  int id = goal.Get(PROC_ID);
  int Parent = 0; // Pattern$B$N$H$-$NBP1~!%(B
  Am_Object parent = (Am_Object)goal.Get(PARENT_LINK);
  if (parent != goal) { // $B%3%T!<85$N$H$-$O(B,$B#0(B
    Parent = Group_Index(parent);
  }
  int Hole = 0; // Pattern$B$N$H$-$NBP1~!%(B
  Am_Object hole = (Am_Object)goal.Get(HOLE_LINK);
  if (hole.Valid()) {
    Hole = Group_Index(hole);
  }
  ofile << id << " " << Parent << " " << Hole;
  save_position_with_icon_info(goal, ofile); ofile << endl;
  save_port_part(Proc_Ports_Part(goal), ofile);
  ofile << End_Goal << endl;
}
*/

int load_goal(Am_Object rule, ifstream& ifile)
{
  char tag;
  ifile >> tag;
  if (tag == Beg_Goal) return load_really_goal(rule, ifile);
  if (tag == Beg_Patt) return load_pattern(rule, ifile);
  ifile.putback(tag);
  return 0;
}

int load_really_goal(Am_Object rule, ifstream& ifile)
{
  char tag;
  // tag check omitted by load_goal()
  int id, parent, hole;
  ifile >> id >> parent >> hole;

  Am_Object proc = Process_Table[id];
  Am_Object goal;
  if (parent == 0) {
    if (hole == 0 && !rule.Is_Instance_Of(MainRuleProto))
      goal = Process_Goal_Create(proc); // $B$$$$$N$+$J$3$l$G(B?
    else goal = Process_Inter_Module_Goal_Create(proc);
  } else {
    goal = Object_List_Get(rule.Get(ProcessList), hole);
  }
  load_position_with_icon_info(goal, ifile);

  if (parent == 0) {
    if (hole != 0) {
      Am_Object h = Object_List_Get(rule.Get(HoleList), hole);
      add_obj(h, goal);
    } else {
      add_obj(rule, goal);
    }
  }
  goal.Get_Part(ContentsPart).Set(Am_ACTIVE, false);    
  load_exist_port_part(goal, ifile);
  goal.Get_Part(ContentsPart).Set(Am_ACTIVE, true);    
  ifile >> tag; if (tag != End_Goal) return 0;
  return 1;
}


// -------- Binder Part --------
// Beg_Bndrs
// ... binders ...
// End_Bndrs
/*
int save_binder_part(Am_Object rule, ofstream& ofile)
{
  ofile << Beg_Bndrs << endl;
  Am_Value_List binders = Rule_Binder(rule);
  for (binders.Start(); !binders.Last(); binders.Next()) {
    Am_Object binder = (Am_Object)binders.Get();
    save_binder(rule, binder, ofile);
  }
  ofile << End_Bndrs << endl;
}
*/

int load_binder_part(Am_Object rule, ifstream& ifile)
{
  char tag;
  ifile >> tag; if (tag != Beg_Bndrs) return 0;
  while (load_binder(rule, ifile));
  ifile >> tag; if (tag != End_Bndrs) return 0;
}


// -------- Binder --------
// Beg_Bndr Visible
// Pos1.1 Pos1.2 ... -1
// Pos2.1 Pos2.2 ... -1
// End_Bndr
/*
int save_binder(Am_Object rule, Am_Object binder, ofstream& ofile)
{
  ofile << Beg_Bndr << (bool)binder.Get(Am_VISIBLE) << endl;
  Am_Object pair[2];
  pair[0] = binder.Get(BL_SRC);
  pair[1] = binder.Get(BL_DEST);
  int i;
  for (i = 0; i < 2; ++i) {
    Am_Value_List positions = Position_Get(pair[i], rule);
    for (positions.Start(); !positions.Last(); positions.Next()) {
      int pos = positions.Get();
      ofile << pos << " ";
    }
    ofile << -1 << endl;
  }
  ofile << End_Bndr << endl;
}
*/

int load_binder(Am_Object rule, ifstream& ifile)
{
  char tag;
  ifile >> tag; if (tag != Beg_Bndr) {ifile.putback(tag); return 0;}
  int visible;
  ifile >> visible;
  int pos;
  Am_Value_List positions[2] = {Am_Value_List(), Am_Value_List()};
  int i;
  for (i = 0; i < 2; ++i) {
    while (ifile >> pos, pos >= 0) {
      positions[i].Add(pos);
    }
  }
  Am_Object src_port = Position_To_Obj(rule, positions[0]);
  Am_Object des_port = Position_To_Obj(rule, positions[1]);
  Am_Object new_line = Single_Binding_Line_Create(src_port, des_port);
  //  cout << "create binder: " << src_port << des_port << new_line << endl;
  ifile >> tag; if (tag != End_Bndr) return 0;
}

  
// -------- Guard Part --------
// Beg_Gurds
// ... gurads ...
// End_Gurds
/*
int save_guard_part(Am_Object rule, ofstream& ofile)
{
  ofile << Beg_Gurds << endl;
  Am_Value_List guards = Rule_Guard(rule);
  for (guards.Start(); !guards.Last(); guards.Next()) {
    Am_Object guard = (Am_Object)guards.Get();
    save_guard(guard, ofile);
  }
  ofile << End_Gurds << endl;
}
*/

int load_guard_part(Am_Object rule, ifstream& ifile)
{
  char tag;
  ifile >> tag; if (tag != Beg_Gurds) return 0;
  while (load_guard(rule, ifile));
  ifile >> tag; if (tag != End_Gurds) return 0;
}

// -------- Guard --------
// Beg_Gurd position_with_icon_info Contents
// End_Gurd
/*
int save_guard(Am_Object guard, ofstream& ofile)
{
  ofile << Beg_Gurd << " ";
  save_position_with_icon_info(guard, ofile);
  ofile << (Am_String)guard.Get_Part(CONTENTS_PART).Get(Am_TEXT) << endl;
  ofile << End_Gurd << endl;
}
*/

int load_guard(Am_Object rule, ifstream& ifile)
{
  char tag;
  ifile >> tag; if (tag != Beg_Gurd) {ifile.putback(tag); return 0;}
  Am_Object new_guard = new_obj(GuardProto);
  load_position_with_icon_info(new_guard, ifile);
  char Contents[1000];
  ifile >> ws;
  ifile.getline(Contents, 1000);
  new_guard
    .Get_Object(Model)
    .Set(Name, Contents)
    ;
  add_obj(rule, new_guard);
  ifile >> tag; if (tag != End_Gurd) return 0;
  return 1;
}


// -------- Pattern --------
// Beg_Patt Type Name Dir Parent Hole position_with_icon_info
// ... ports ...
// ... holes ...
// ... goals ...
// ... binders ...
// End_Patt
/*
int save_pattern(Am_Object pattern, ofstream& ofile)
{
  ofile << Beg_Patt << " ";
  Am_String name = (Am_String)pattern.Get(PROC_NAME);
  int type = pattern.Get(PATTERN_TYPE);
  int dir  = pattern.Get(SEQ_DIR);
  int Parent = 0;
  Am_Object parent = (Am_Object)pattern.Get(PARENT_LINK);
  if (parent != pattern) { // $B%3%T!<85$N$H$-$O(B,$B#0(B
    Parent = Group_Index(parent);
  }
  int Hole = 0; // Pattern$B$N$H$-$NBP1~!%(B
  Am_Object hole = (Am_Object)pattern.Get(HOLE_LINK);
  if (hole.Valid()) {
    Hole = Group_Index(hole);
  }
  ofile << type << " " << name << " " << dir << " " << Parent << " " << Hole;
  save_position_with_icon_info(pattern, ofile); ofile << endl;
//  save_port_part(Rule_Ports_Part(pattern), ofile);
  if (Parent == 0) {
    save_port_part(Rule_Ports_Part(pattern), ofile);
    save_holes_part(Rule_Holes_Part(pattern), ofile);
    save_goals_part(Rule_Goals_Part(pattern), ofile);
    save_binder_part(pattern, ofile);
  }
  ofile << End_Patt << endl;
}
*/

int load_pattern(Am_Object rule, ifstream& ifile)
{
  char tag;
  //  ifile >> tag; $B%?%0%A%'%C%/$O$$$i$J$$!%(B
  int type, dir, parent, hole;
  char name[1000];
  ifile >> type >> name >> dir >> parent >> hole;
  cout << "load pattern: " << name << " type: " << type << " parent: " << parent << " hole: " << hole << endl;
  
  Am_Object new_patt;
  if (parent == 0) {
    if (type == KL_Free_Pattern) new_patt = new_obj(PatternProto);
    if (type == KL_Seq_Pattern)  new_patt = new_obj(ReplPatternProto).Set(Dir, dir);
    new_patt.Get_Object(Model).Set(Name, name);
  } else {
    new_patt = new_obj(PatternProto); // Dummy
  }
  load_position_with_icon_info(new_patt, ifile);
  
  if (parent == 0) {
    load_port_part(new_patt, ifile);
    load_holes_part(new_patt, ifile);
    load_goals_part(new_patt, ifile);
    load_binder_part(new_patt, ifile);

    Am_Object dest = rule; // $B8F$S=P$9(BAddMethod$B$ODI2C@h$K$h$C$FJQ$o$k!#(B
    if (hole != 0) dest = Object_List_Get(rule.Get(HoleList), hole);
    add_obj(dest, new_patt);
  } else {
    // $B%3%T!<$5$l$F$$$k$O$:$J$N$G2?$b$7$J$$!#(B
  }
  ifile >> tag; if (tag != End_Patt) return 0;
  cout << "end load pattern " << endl;
  return 1;
}

// -------- Hole Part --------
// Beg_Holes
// ... holes ...
// End_Holes
/*
int save_holes_part(Am_Object holes_agg, ofstream& ofile)
{
  ofile << Beg_Holes << endl;
  Am_Value_List holes = (Am_Value_List)holes_agg.Get(Am_GRAPHICAL_PARTS);
  for (holes.Start(); !holes.Last(); holes.Next()) {
    Am_Object hole = (Am_Object)holes.Get();
    save_hole(hole, ofile);
  }
  ofile << End_Holes << endl;
}
*/

int load_holes_part(Am_Object patt, ifstream& ifile)
{
  char tag;
  ifile >> tag; if (tag != Beg_Holes) return 0;
  while (load_hole(patt, ifile));
  ifile >> tag; if (tag != End_Holes) return 0;
}

// -------- Hole --------
// Beg_Hole Name Parent Visible position_with_icon_info
// ... ports ...
// End_Hole
// $B?F$OC/$+!)(B
/*
int save_hole(Am_Object hole, ofstream& ofile)
{
  ofile << Beg_Hole << " ";
  Am_String name = (Am_String)hole.Get(PROC_NAME);
  int Parent = 0;
  Am_Object parent = (Am_Object)hole.Get(PARENT_LINK);
  if (parent != hole) { // $B%3%T!<85$N$H$-$O(B,$B#0(B
    Parent = Group_Index(parent);
  }
  int Visible = (bool)hole.Get(Am_VISIBLE);
  ofile << name << " " << Parent << " " << Visible;
  save_position_with_icon_info(hole, ofile); ofile << endl;
  save_port_part(Proc_Ports_Part(hole), ofile);
  ofile << End_Hole << endl;
}
*/

int load_hole(Am_Object patt, ifstream& ifile)
{
  char tag;
  ifile >> tag; if (tag != Beg_Hole) {ifile.putback(tag); return 0;}
  char name[1000];
  int parent, Visible;
  ifile >> name >> parent >> Visible;
  Am_Object hole;
  if (patt.Is_Instance_Of(ReplPatternProto)) {
    Am_Value_List hole_list = patt.Get(HoleList);  hole_list.Start();
    hole = hole_list.Get();
  } else {
    if (parent == 0) hole = new_obj(HoleProto);
    else {Err ("invalid parent "); return 0;}
  } 
  hole.Get_Object(Model).Set(Name, name);
  load_position_with_icon_info(hole, ifile);
  if (!patt.Is_Instance_Of(ReplPatternProto)) add_obj(patt, hole);
  hole.Get_Part(ContentsPart).Set(Am_ACTIVE, false);    
  if (parent == 0) load_port_part(hole, ifile);
  else             load_exist_port_part(hole, ifile);
  hole.Get_Part(ContentsPart).Set(Am_ACTIVE, true);    
  ifile >> tag; if (tag != End_Hole) {Err("End_Hole");  cerr << name << endl; return 0;}
  return 1;
}


// -------- Port Part --------
// Beg_Ports
// ... ports ...
// End_Ports
/*
int save_port_part(Am_Object port_agg, ofstream& ofile)
{
  ofile << Beg_Ports << endl;
  Am_Value_List ports = (Am_Value_List)port_agg.Get(Am_GRAPHICAL_PARTS);
  for (ports.Start(); !ports.Last(); ports.Next()) {
    Am_Object port = (Am_Object)ports.Get();
    save_port(port, ofile);
  }
  ofile << End_Ports << endl;
}
*/

int load_port_part(Am_Object process, ifstream& ifile)
{
  char tag;
  ifile >> tag; if (tag != Beg_Ports) return 0;
  process.Get_Part(ContentsPart).Set(Am_ACTIVE, false);
  while (load_port(process, ifile));
  process.Get_Part(ContentsPart).Set(Am_ACTIVE, true);
  ifile >> tag; if (tag != End_Ports) return 0;
}

int load_exist_port_part(Am_Object process, ifstream& ifile)
{
  char tag;
  ifile >> tag; if (tag != Beg_Ports) return 0;
  Am_Value_List ports = process.Get(PortList);
  for (ports.Start(); !ports.Last(); ports.Next()) {
    Am_Object port = (Am_Object)ports.Get();
    if (!load_exist_port(port, ifile)) return 0;
  }
  ifile >> tag; if (tag != End_Ports) return 0;
}

// -------- Port --------
// Beg_Port Id Name Type Age Mode Open Dir Spec Left Top Icon OLeft OTop ILeft ITop
// ... Values ...
// End_Port
/*
int save_port(Am_Object port, ofstream& ofile)
{
  ofile << Beg_Port  << " ";
  int id   = port.Get(Id);
  Am_String name = (Am_String)port.Get(PORT_NAME);
  int type = port.Get(Type);
  int age  = port.Get(Age);
  int mode = port.Get(Mode);
  int state = port.Get(State);
  int dir  = port.Get(Dir);
  int Spec = port.Get(PORT_SPECIAL);
  ofile << id <<" "<< name <<" "<< type <<" "<< age <<" "<< mode <<" "<< state <<" "<< dir <<" "<< Spec;
  save_position_with_icon_info(port, ofile);
  ofile << endl;
  save_value_part(Port_Values_Part(port), ofile);
  ofile << End_Port << endl;
}
*/

int load_port(Am_Object process, ifstream& ifile)
{
  char tag;
  ifile >> tag; if (tag != Beg_Port) {ifile.putback(tag); return 0;}
  int id, type, age, mode, state, dir, Spec;
  char name[1000];
  ifile >> id >> name >> type >> age >> mode >> state >> dir >> Spec;
  Am_Object new_port;
  if (Spec == PortNormal) {
    if (mode == PortInput  && type == PortSingleton) new_port = new_obj(InSingletonProto);
    if (mode == PortOutput && type == PortSingleton) new_port = new_obj(OutSingletonProto);
    if (mode == PortInput  && type == PortStream) new_port = new_obj(InStreamProto);
    if (mode == PortOutput && type == PortStream) new_port = new_obj(OutStreamProto);
  } else {
    if (Spec == PortPatSingleton && mode == PortInput) new_port = new_obj(SpecialSingletonProto);
    if (Spec == PortPatSingleton && mode == PortOutput) new_port = new_obj(SpecialSingletonProto);
    if (Spec == PortPatStream && mode == PortInput) new_port = new_obj(SpecialStreamProto);
    if (Spec == PortPatStream && mode == PortOutput)new_port = new_obj(SpecialStreamProto);
    if (Spec == PortMap && mode == PortInput) new_port = new_obj(MapInProto);
    if (Spec == PortMap && mode == PortOutput) new_port = new_obj(MapOutProto);
    if (Spec == PortBroadcast && type == PortSingleton) new_port = new_obj(BroadSingletonProto);
    if (Spec == PortBroadcast && type == PortStream) new_port = new_obj(BroadStreamProto);
    if (Spec == PortMerge) new_port = new_obj(MergeProto);
  }
  new_port
    .Set(Dir,  dir)
    //    .Set(Age,  age)
    .Set(State, state)
    .Get_Object(Model)
      .Set(Name, name)
    ;
  if (process.Is_Instance_Of(RuleProto) && age == PortOld) new_port.Set(Mode, 1 - mode);
  load_position_with_icon_info(new_port, ifile);
  add_obj(process, new_port);
  load_value_part(new_port, ifile);
  ifile >> tag; if (tag != End_Port) return 0;
  return 1;
}

int load_exist_port(Am_Object port, ifstream& ifile)
{
  char tag;
  ifile >> tag; if (tag != Beg_Port) {ifile.putback(tag); return 0;}
  int id, type, age, mode, state, dir, Spec;
  char name[1000];
  ifile >> id >> name >> type >> age >> mode >> state >> dir >> Spec;
  port.Set(State, state)
      .Set(Dir,  dir)
    ;
  Am_Object owner = port.Get_Owner();
  port.Remove_From_Owner(); // $B1x$$!#(B
  load_position_with_icon_info(port, ifile);
  owner.Add_Part(port); // $B1x$$!#(B
  load_value_part(port, ifile);
  ifile >> tag; if (tag != End_Port) return 0;
  return 1;
}

int load_val_port(Am_Object port, ifstream& ifile)
{
  char tag;
//  ifile >> tag; if (tag != Beg_Port) {ifile.putback(tag); return 0;}
  int id, type, age, mode, state, dir, Spec;
  char name[1000];
  ifile >> id >> name >> type >> age >> mode >> state >> dir >> Spec;

  Am_Object rule = Parent_Rule(port);
  if (!rule.Valid()) return 0;
  Am_Object old_port = 0;
  Am_Value_List inner_ports = (Am_Value_List)rule.Get(InnerPortList);
  old_port = Object_List_Get_By_Model_Key(inner_ports, Name, name);

  Am_Object new_port;
  if (old_port.Valid()) {
    new_port = old_port.Create(); // ***
    load_position_with_icon_info(new_port, ifile);
    port.Get_Part(ContentsPart).Add_Part(new_port);
  } else if (Spec == PortNormal) {
    if (mode == PortInput  && type == PortSingleton) new_port = new_obj(InSingletonProto);
    if (mode == PortOutput && type == PortSingleton) new_port = new_obj(OutSingletonProto);
    if (mode == PortInput  && type == PortStream) new_port = new_obj(InStreamProto);
    if (mode == PortOutput && type == PortStream) new_port = new_obj(OutStreamProto);
    new_port
      .Set(Dir,  dir)
      .Set(Age,  age)
      .Set(State, state)
      .Get_Object(Model)
        .Set(Name, name)
        .Set(Type, type)
        .Set(Mode, mode)
      ;
    load_position_with_icon_info(new_port, ifile);
    add_obj(port, new_port);
  } else return 0;
  load_value_part(new_port, ifile);
  ifile >> tag; if (tag != End_Port) return 0;
  return 1;
}

// -------- Values Part --------
// Beg_Vals
// ... values ...
// End_Vals
/*
int save_value_part(Am_Object value_agg, ofstream& ofile)
{
  ofile << Beg_Vals << endl;
  Am_Value_List vals = (Am_Value_List)value_agg.Get(Am_GRAPHICAL_PARTS);
  for (vals.Start(); !vals.Last(); vals.Next()) {
    Am_Object val = (Am_Object)vals.Get();
    save_value(val, ofile);
  }
  ofile << End_Vals << endl;
}
*/

int load_value_part(Am_Object port, ifstream& ifile)
{
  char tag;
  ifile >> tag; if (tag != Beg_Vals) return 0;
  while (load_value(port, ifile));
  ifile >> tag; if (tag != End_Vals) return 0;
}

// -------- Value --------
/*
int save_value(Am_Object value, ofstream& ofile)
{
  int type = KL_Type(value);
  if (type == KL_Atom) return save_atom(value, ofile);
  if (type == KL_Structure) return save_structure(value, ofile);
  if (type == KL_Port) return save_port(value, ofile);
  return 0;
}
*/

int load_value(Am_Object port, ifstream& ifile)
{
  char tag;
  ifile >> tag;
  if (tag == Beg_Atom) return load_atom(port, ifile);
  if (tag == Beg_Stru) return load_structure(port, ifile);
  if (tag == Beg_Port) return load_val_port(port, ifile);
  ifile.putback(tag);
  return 0;
}

// -------- Atom --------
// Beg_Atom Contents
// End_Atom
int save_atom(Am_Object value, ofstream& ofile)
{
  ofile << Beg_Atom << " ";
  ofile << (Am_String)value.Get_Object(Model).Get(Name) << endl;
  ofile << End_Atom << endl;
}

int load_atom(Am_Object port, ifstream& ifile)
{
  char tag;
  char Contents[1000];
  ifile >> ws;
  ifile.getline(Contents, 1000);
  Am_Object new_atom = new_obj(AtomProto);
  new_atom.Get_Object(Model)
    .Set(Name, Contents);
  add_obj(port, new_atom);
  ifile >> tag; if (tag != End_Atom) return 0;
  return 1;
}

// -------- Structure --------
// Beg_Stru Name
// ... values ...
// End_Stru
/*
int save_structure(Am_Object value, ofstream& ofile)
{
  ofile << Beg_Stru << " ";
  ofile << (Am_String)value.Get_Object(Model).Get(Name) << endl;
  save_value_part(value.Get(ValueList), ofile);
  ofile << End_Stru << endl;
}
*/

int load_structure(Am_Object port, ifstream& ifile)
{
  char tag;
  char name[1000];
  ifile >> name;
  Am_Object new_str = new_obj(MessageProto);
  new_str.Get_Object(Model)
    .Set(Name, name);
  add_obj(port, new_str);
  load_value_part(new_str, ifile);
  ifile >> tag; if (tag != End_Stru) return 0;
  return 1;
}

