// Copyright (C) 1997  Toyoda Masashi (toyoda@is.titech.ac.jp)

#include <amulet.h>

#include "ToyWidgets.h"
#include "PovlWidgets.h"
#include "Resources.h"

#include "Message.h"
#include "Guard.h"
#include "Port.h"
#include "Process.h"
#include "Rule.h"

// ------------------------------------------------------------
// Process, Hole and Goal Menu and these popper
// ------------------------------------------------------------

// Global objects
// --------------
Am_Object GoalMenuPopper = 0;

// Formulas
// --------
Am_Define_Formula(int, EllispsisX1Form)
{
  Am_Object owner = self.GV_Owner(); if (!owner.Valid()) return 0;
  Am_Object replhole = owner.GV_Owner(); if (!replhole.Valid()) return 0;
  int dir = replhole.GV(seqDir);
  int x1 = 0;
  if (dir == LeftRight || dir == RightLeft) {
    x1 = 0;
    self.Set(Am_Y1, (int)owner.GV(Am_HEIGHT) / 2)
      .Set(Am_X2, (int)owner.GV(Am_WIDTH))
      .Set(Am_Y2, (int)owner.GV(Am_HEIGHT) / 2);
  } else {
    x1 = (int)owner.GV(Am_WIDTH) / 2;
    self.Set(Am_Y1, 0)
      .Set(Am_X2, (int)owner.GV(Am_WIDTH) / 2)
      .Set(Am_Y2, (int)owner.GV(Am_HEIGHT));
  }
  return x1;
}

Am_Define_Object_Formula(ReplHoleParentForm)
{
  Am_Object repl_holes = self.GV_Owner();
  if (repl_holes.Valid()) {
    return repl_holes.GV(Parent);
  }
  Am_Object process = self.GV(Process);
  if (process.Valid()) {
    Am_Object temp = process.GV_Owner();
    if (temp.Valid()) return temp.GV(Parent);
  }
  return 0;
}

// Methods
// -------
Am_Define_Method(Am_Object_Method, void, New_Rule_Do, (Am_Object command_obj))
{
  Am_Object menu = command_obj.Get_Owner().Get_Owner(); // $B%a%K%e!<(B

  Am_Object process = menu.Get_Object(TargetObj); // process
  Am_Object module = process.Get(Parent); // module
  Am_Object group = module.Get_Part(ContentsPart);
  int x = menu.Get(XinTarget);  // $B:BI8(B
  int y = menu.Get(YinTarget);
  Am_Translate_Coordinates(process, x, y, group, x, y);

  Am_Object rule_proto = command_obj.Get(Am_LABEL); // $BDI2C$9$k(Brule
  Am_Object new_rule = Rule_Create(process, rule_proto);
  new_rule
    .Set(Am_LEFT, CenterX(process) + 100) // $B%+!<%=%k$N0LCV$rCf?4$K(B
    .Set(Am_TOP, CenterY(process) - (int)new_rule.Get(Am_HEIGHT) / 2)
    ;
  ((Bin_Check_Method)module.Get(AddMethod)).Call(module, new_rule);
}

Am_Define_Method(Am_Object_Method, void, Copy_Proc_Do, (Am_Object command_obj))
{
  Am_Object menu = command_obj.Get_Owner().Get_Owner(); // $B%a%K%e!<(B

  Am_Object process = menu.Get_Object(TargetObj); // process
  Am_Object module = process.Get(Parent); // module

  Am_Object copy_p = CALL1(process, Copy_Method, CopyMethod);

  CALL2(module, Bin_Check_Method, AddMethod, copy_p);
}

Am_Define_Method(Am_Object_Method, void, Toggle_Rule_Visible_Do, (Am_Object command_obj))
{
  Am_Object menu = command_obj.Get_Owner().Get_Owner(); // $B%a%K%e!<(B

  Am_Object process = menu.Get_Object(TargetObj); // process
  Am_Object model = process.Get(Model); // model
  model.Set(RuleVisible, 1 - (int)model.Get(RuleVisible));
}

// ------------------------------------------------------------
// Initialize
// ------------------------------------------------------------

Am_Define_Object_Formula(ReplHoleModelForm)
{
  Am_Object repl_pattern = self.GV(Parent);
  if (!repl_pattern.Valid()) return 0;
  Am_Object repl_holes = repl_pattern.GV_Part(ContentsPart).GV_Part(ContentsPart);
  return repl_holes.GV_Object(Model);
}


void InitializeProcessMenu(void)
{
  // Process Menu
  // ------------
  Am_Object ProcessMenu = PopUpMenu.Create("ProcessMenu")
    .Get_Part(MenuBody)
    .Set(Am_ITEMS, Am_Value_List()
	 .Add(MenuCommand.Create().Set(Am_LABEL, TargetNameForm))
	 .Add(Am_Menu_Line_Command.Create())
	 .Add(UndoZoomCmd.Create())
	 .Add(RedoZoomCmd.Create())
	 .Add(SelectiveUndoZoomCmd.Create())
	 .Add(Am_Menu_Line_Command.Create())
	 .Add(NewObjectCmd.Create().Set(Am_LABEL, InSingletonProto))
	 .Add(NewObjectCmd.Create().Set(Am_LABEL, OutSingletonProto))
	 .Add(NewObjectCmd.Create().Set(Am_LABEL, InStreamProto))
	 .Add(NewObjectCmd.Create().Set(Am_LABEL, OutStreamProto))
	 //	 .Add(NewObjectCmd.Create().Set(Am_LABEL, NodePortProto))
	 .Add(Am_Menu_Line_Command.Create())
	 .Add(MenuCommand.Create().Set(Am_LABEL, NetworkRuleProto)
	      .Set(Am_DO_METHOD, New_Rule_Do))
	 .Add(MenuCommand.Create().Set(Am_LABEL, TransitionRuleProto)
	      .Set(Am_DO_METHOD, New_Rule_Do))
	 .Add(Am_Menu_Line_Command.Create())
	 .Add(MenuCommand.Create().Set(Am_LABEL, "Show/Hide Rules")
	      .Set(Am_DO_METHOD, Toggle_Rule_Visible_Do))
	 .Add(Am_Menu_Line_Command.Create())
	 .Add(MenuCommand.Create().Set(Am_LABEL, "Copy")
	      .Set(Am_DO_METHOD, Copy_Proc_Do))
	 .Add(RemoveObjectCmd.Create().Set(Am_LABEL, "Delete"))
	 )
    .Get_Owner();
  Am_Screen.Add_Part(ProcessMenu);

  Am_Object ProcessMenuPopper = PopUpMenuInteractor.Create("ProcessMenuPopper")
    .Set(MenuWindow, ProcessMenu);
  ProcessProto.Add_Part(MenuPopper, ProcessMenuPopper);

  // Hole Menu
  // ---------
  Am_Object HoleMenu = PopUpMenu.Create("HoleMenu")
    .Get_Part(MenuBody)
    .Set(Am_ITEMS, Am_Value_List()
	 .Add(MenuCommand.Create().Set(Am_LABEL, TargetNameForm))
	 .Add(Am_Menu_Line_Command.Create())
	 .Add(UndoZoomCmd.Create())
	 .Add(RedoZoomCmd.Create())
	 .Add(SelectiveUndoZoomCmd.Create())
	 .Add(Am_Menu_Line_Command.Create())
	 .Add(NewObjectCmd.Create().Set(Am_LABEL, InSingletonProto))
	 .Add(NewObjectCmd.Create().Set(Am_LABEL, OutSingletonProto))
	 .Add(NewObjectCmd.Create().Set(Am_LABEL, InStreamProto))
	 .Add(NewObjectCmd.Create().Set(Am_LABEL, OutStreamProto))
	 .Add(Am_Menu_Line_Command.Create())
	 .Add(MenuCommand.Create().Set(Am_LABEL, "Copy")
	      .Set(Am_DO_METHOD, Copy_Proc_Do))
	 .Add(RemoveObjectCmd.Create().Set(Am_LABEL, "Delete"))
	 )
    .Get_Owner();
  Am_Screen.Add_Part(HoleMenu);

  Am_Object HoleMenuPopper = PopUpMenuInteractor.Create("HoleMenuPopper")
    .Set(MenuWindow, HoleMenu);
  HoleProto.Add_Part(MenuPopper, HoleMenuPopper);

  // Goal Menu
  // ---------
  Am_Object GoalMenu = PopUpMenu.Create("GoalMenu")
    .Get_Part(MenuBody)
    .Set(Am_ITEMS, Am_Value_List()
	 .Add(MenuCommand.Create().Set(Am_LABEL, TargetNameForm))
	 .Add(Am_Menu_Line_Command.Create())
	 .Add(UndoZoomCmd.Create())
	 .Add(RedoZoomCmd.Create())
	 .Add(SelectiveUndoZoomCmd.Create())
	 .Add(Am_Menu_Line_Command.Create())
	 .Add(RemoveObjectCmd.Create().Set(Am_LABEL, "Delete"))
	 )
    .Get_Owner();
  Am_Screen.Add_Part(GoalMenu);

  GoalMenuPopper = PopUpMenuInteractor.Create("GoalMenuPopper") 
    .Set(MenuWindow, GoalMenu); // $B%W%m%;%9$N%a%K%e!<JQ99$N$?$a$3$l$@$1%0%m!<%P%k!#(B

  static char ellip_dash_list[2] = {1, 12};
  Am_Style ellip_line_dash ("black", 3, Am_CAP_ROUND, Am_JOIN_MITER,
			    Am_LINE_ON_OFF_DASH, ellip_dash_list);

  Am_Object ellipsis = PovlGroup.Create("Ellipsis")
    .Set(Am_WIDTH, 50)
    .Set(Am_HEIGHT, 50)
    .Add_Part(Am_Line.Create()
	      .Set(Am_X1, EllispsisX1Form)
	      .Set(Am_LINE_STYLE, ellip_line_dash)
	      )
    .Set(CheckDropMethod, 0)
    .Set(DropMethod, 0)
    .Set(DropPoints, 0)
    ;

  Am_Object repl_hole_proto = CALL1(HoleProto, Copy_Method, NewMethod)
    .Set(Parent, ReplHoleParentForm)
    .Set(Model, ReplHoleModelForm)
    .Set(ToCopyModel, false)
    //    .Set(Am_VISIBLE, true)
    ;
  
  ReplHolesProto
    .Add_Part(repl_hole_proto)
    .Add_Part(repl_hole_proto.Create())
    .Add_Part(ellipsis)
    .Add_Part(repl_hole_proto.Create())
    ;
}
