// Copyright (C) 1997  Toyoda Masashi (toyoda@is.titech.ac.jp)

#include <amulet.h>
#include OBJECT_ADVANCED__H

#include <strstream.h>

#include "ToyWidgets.h"
#include "PovlWidgets.h"
#include "Resources.h"
#include "Port.h"
#include "Pattern.h"
#include "Rule.h"
#include "ProcessMenu.h"
#include "Module.h"
#include "Binder.h"

#define _INTERNAL_
#include "Process.h"

// ------------------------------------------------------------
// Process Prototype
// ------------------------------------------------------------

// Global objects
// --------------
Am_Object ProcessModel = 0;
Am_Object ProcessProto = 0;

Am_Object HoleModel = 0;
Am_Object HoleProto = 0;
Am_Object ReplHolesProto = 0;

// Goal Creation Functions
// -----------------------
void disable_name_edit(Am_Object goal) {
  // $BL>A0$NJT=8$OIT2D(B
  Disable_Name_Edit(goal);
  // $B3F%]!<%H$NL>A0$NJT=8$bIT2D!"$*$h$S%a%K%e!<JQ99!#(B
  Am_Value_List ports = goal.Get(PortList);
  for (ports.Start(); !ports.Last(); ports.Next()) {
    Am_Object p = ports.Get();
    Disable_Name_Edit(p);
    Change_Menu(p, ProcessPortMenuPopper.Create());
  }
}

Am_Object Process_Goal_Create(Am_Object proc)
{
  Am_Object goal = Align_Zoom_Create_Part(proc);
  disable_name_edit(goal);
  // $B%k!<%k$N%"%$%3%s2=(B
  goal.Set(Am_VISIBLE, ContentsVisibleForm)
    .Set(Type, ProcessGoal)
    ;
  // Menu$B$NJQ99!#(B
  Change_Menu(goal, GoalMenuPopper.Create());
  return goal;
}

Am_Define_String_Formula(InterModuleGoalNameForm)
{
  char name[1000];
  ostrstream oname(name, 1000);

  Am_Object goal = self.GV_Owner().GV_Owner();
  Am_Object model = goal.GV_Object(Model);
  Am_String module_name = model.GV(Module);
  Am_String proc_name   = model.GV(Name);
  oname << module_name << ":" << proc_name << '\0';
  return (Am_String)name;
}

Am_String Inter_Module_Goal_Name(Am_Object self)
{
  char name[1000];
  ostrstream oname(name, 1000);

  Am_Object goal = self.Get_Owner().Get_Owner();
  Am_Object model = goal.Get_Object(Model);
  Am_String module_name = model.Get(Module);
  Am_String proc_name   = model.Get(Name);
  oname << module_name << ":" << proc_name << '\0';
  return (Am_String)name;
}

/*
Am_Define_Formula(bool, IsValidInterface)
{

}
*/

Am_Object Process_Inter_Module_Goal_Create(Am_Object proc)
{
  Am_Object goal = Align_Zoom_Copy_Part(proc);
  disable_name_edit(goal);
  // $B%k!<%k$N%"%$%3%s2=(B
  goal.Set(Am_VISIBLE, ContentsVisibleForm);
  // Menu$B$NJQ99!#(B
  Change_Menu(goal, GoalMenuPopper.Create());
  // RuleList$B$rL58z2=!"(BModule$B%9%m%C%H$K0MB8$7$F$$$k!#(B
  goal.Set(RuleList, Am_Value_List());
  // Model.Module$B$NCf?H$rL>A0$KJQ99!#(B
  Am_Object model = goal.Get_Object(Model);
  Am_Object module = model.Get_Object(Module);
  Am_String name = module.Get_Object(Model).Get(Name);
  model.Set(Module, name);
  goal.Set(Type, ProcessInterGoal);
  // $BI=<($9$kL>A0$r(Bmodule:proc$B$KJQ99!#(B
  Am_Object text = goal.Get_Part(NamePart).Get_Part(TextPart);
  text
    .Set_Single_Constraint_Mode(Am_TEXT, true) // formula$B$NJ#?t$r$5$1$k!#(B
    .Set(Am_TEXT, Inter_Module_Goal_Name(text));
  return goal;
}

Am_Object Process_Inter_Module_Goal_New(Am_String name, Am_String mname)
{
  Am_Object goal = CALL1(ProcessProto, Copy_Method, NewMethod);
  disable_name_edit(goal);
  // $B%k!<%k$N%"%$%3%s2=(B
  goal.Set(Am_VISIBLE, ContentsVisibleForm);
  // Menu$B$NJQ99!#(B
  Change_Menu(goal, GoalMenuPopper.Create());
  // RuleList$B$rL58z2=!"(BModule$B%9%m%C%H$K0MB8$7$F$$$k!#(B
  goal.Set(RuleList, Am_Value_List());
  // Model.Module$B$NCf?H$rL>A0$KJQ99!#(B
  Am_Object model = goal.Get_Object(Model);
  model.Set(Name, name)
    .Set(Module, mname);
  goal.Set(Type, ProcessInterGoal);
  // $BI=<($9$kL>A0$r(Bmodule:proc$B$KJQ99!#(B
  Am_Object text = goal.Get_Part(NamePart).Get_Part(TextPart);
  text
    .Set_Single_Constraint_Mode(Am_TEXT, true) // formula$B$NJ#?t$r$5$1$k!#(B
    .Set(Am_TEXT, Inter_Module_Goal_Name(text));
  return goal;
}

// Hole Replace Functions
// ----------------------
void bind_hole_port(Am_Object hport, Am_Object pport)
{
  Am_Value_List binders = hport.Get(HoleBinders);
  for (binders.Start(); !binders.Last(); binders.Next()) {
    Am_Object bl = binders.Get();
    Am_Object src = bl.Get(SrcPort);
    Am_Object dest = bl.Get(DestPort);
    if (src == hport) {
      Single_Binding_Line_Create(pport, dest);
    } else {
      Single_Binding_Line_Create(src, pport);
    }
  }
}

bool Single_Hole_Replace(Am_Object hole, Am_Object proc)
  // proc$B$O%3%T!<:Q$_$NJ*(B
{
  Am_Object hole_owner = hole.Get_Owner();
  hole_owner.Set(Am_ACTIVE, false);  // Zoom layout$B$r0l;~L58z2=(B
  int cx, cy, left, top;
  Center_Of_Object(hole, cx, cy);
  Left_Top_Of_Object_By_Center(proc, cx, cy, left, top);
  Am_Object pattern = hole.Get_Object(Parent);
  CALL2(pattern, Bin_Check_Method, AddMethod,
	proc.Set(Am_LEFT, left).Set(Am_TOP, top));
  Am_Move_Object(proc, hole);
  // port$B$N7k9g(B
  Am_Value_List hole_ports = hole.Get(PortList);
  Am_Value_List proc_ports = proc.Get(PortList);
  for (hole_ports.Start(); !hole_ports.Last(); hole_ports.Next()) {
    Am_Object hpt = (Am_Object)hole_ports.Get();
    int min_dist = 999999;
    Am_Object min_ppt = 0;
    for (proc_ports.Start(); !proc_ports.Last(); proc_ports.Next()) {
      Am_Object ppt = proc_ports.Get();
      int hpt_mode = hpt.Get(Mode);
      int ppt_mode = ppt.Get(Mode); if (proc.Is_Instance_Of(PatternProto)) ppt_mode = 1 - ppt_mode;
      if ((int)hpt.Get_Object(Model).Get(Type) == (int)ppt.Get_Object(Model).Get(Type) &&
	 hpt_mode == ppt_mode) {
	int d = Distance_Of_Objects(hpt, ppt);
	if (d < min_dist) {
	  min_dist = d;
	  min_ppt = ppt;
	}
      }
    }
    if (min_ppt.Valid()) {
      bind_hole_port(hpt, min_ppt);      // $B7k$V(B
      // $B$$$^7k$P$l$?%]!<%H$r:o=|(B
      proc_ports.Start();
      proc_ports.Member(min_ppt);
      proc_ports.Delete(); // $B$[$s$H$K>C$5$l$k$o$1$G$O$J$$(B
    } else {
      proc.Remove_From_Owner();
      return false;
    }
  }
  hole.Remove_From_Owner();
  //  CALL2(pattern, Bin_Check_Method, RemoveMethod, hole);
  hole_owner.Set(Am_ACTIVE, true);
  hole.Set(Process, proc);
  proc.Set(Hole, hole);
  return true;
}

// Rename, Add, Remove, Drop
// -------------------------
Am_Define_Method(Naming_Method, bool, Process_Rename, (Am_Object process, Am_String name))
{
  Am_Object module = process.Get(Parent);
  if (module.Valid())
    if (Member_Name(module, ProcPatternNameList, name)) return false;
  process.Get_Object(Model).Set(Name, name);
  return true;
}

Am_Define_Method(Naming_Method, bool, Hole_Rename, (Am_Object hole, Am_String name))
{
  Am_Object pattern = hole.Get(Parent);
  if (pattern.Valid())
    if (Member_Name(pattern, HoleNameList, name)) return false;
  hole.Get_Object(Model).Set(Name, name);
  return true;
}

Am_Define_Method(Bin_Check_Method, bool, Process_Add, (Am_Object process, Am_Object port))
{
  if (!port.Is_Instance_Of(PortProto)) {
    cerr << "Can't add " << port << " to " << process << endl;
    return false;
  }
  Am_String port_name = port.Get_Object(Model).Get(Name); // original name
  Am_String new_name = Next_Name(process, PortNameList, port_name); // change if the same name exists
  port.Get_Object(Model).Set(Name, new_name); // directly rename
  process.Get_Part(ContentsPart).Add_Part(port);

  Am_Instance_Iterator goals = process;
  for (goals.Start(); !goals.Last(); goals.Next()) {
    Am_Object g = goals.Get();
    Am_Object p = Align_Zoom_Create_Part(port);
    Disable_Name_Edit(p);
    Change_Menu(p, ProcessPortMenuPopper.Create());
    g.Get_Part(ContentsPart).Add_Part(p);
  }

  Am_Value_List rules = (Am_Value_List)process.Get(RuleList);
  for (rules.Start(); !rules.Last(); rules.Next()) {
     Am_Object rule = (Am_Object)rules.Get();
     CALL2(rule, Bin_Check_Method, AddMethod, port);
  }
  return true;
}

bool Hole_Add_Port(Am_Object hole, Am_Object port)
{
  Am_String port_name = port.Get_Object(Model).Get(Name); // original name
  Am_String new_name = Next_Name(hole, PortNameList, port_name); // change if the same name exists
  port.Get_Object(Model).Set(Name, new_name); // directoly rename
  
  Am_Value_List propagate_list = Change_Propagate_List(hole);
  Am_Object copy = port;
  //  cout << propagate_list << endl;
  for (propagate_list.Start(); !propagate_list.Last(); propagate_list.Next()) {
    Am_Object h = propagate_list.Get();
    h.Get_Part(ContentsPart).Add_Part(copy);
    if (!propagate_list.Last()) copy = port.Create();
  }
  return true;
}

bool Hole_Remove_Port(Am_Object hole, Am_Object port)
{
  Am_Value_List propagate_list = Change_Propagate_List(hole);
  for (propagate_list.Start(); !propagate_list.Last(); propagate_list.Next()) {
    Am_Object h = propagate_list.Get();
    Am_Value_List ports = h.Get(PortList);
    for (ports.Start(); !ports.Last(); ports.Next()) {
      Am_Object pt = ports.Get();
      if ((Am_String)pt.Get_Object(Model).Get(Name) == (Am_String)port.Get_Object(Model).Get(Name))
	pt.Remove_From_Owner();
    }
  }
  return true;
}

bool Hole_Add_Proc_Or_Pattern(Am_Object hole, Am_Object proc)
  // proc$B$O$^$@%3%T!<$:$_(B
{

  Am_Value_List propagate_list = Change_Propagate_List(hole);
  //  cout << propagate_list << endl;
  Am_Object copy = proc;
  for (propagate_list.Start(); !propagate_list.Last(); propagate_list.Next()) {
    Am_Object h = propagate_list.Get();
    if (!Single_Hole_Replace(h, copy)) {
      Am_Show_Alert_Dialog (Am_Value_List().Add("Can't Instantiate")
			    .Add(hole.Get_Name()).Add("with")
			    .Add(proc.Get_Name()));
      return false;
    }
    if (!propagate_list.Last()) copy = CALL1(proc, Copy_Method, CopyMethod);
  }
  return true;
}


Am_Define_Method(Bin_Check_Method, bool, Hole_Add, (Am_Object hole, Am_Object obj))
{
  if (obj.Is_Instance_Of(PortProto)) {
    return Hole_Add_Port(hole, obj);
  }
  else if (obj.Is_Instance_Of(ProcessProto) || obj.Is_Instance_Of(PatternProto)) {
    return Hole_Add_Proc_Or_Pattern(hole, obj);
  }
  Am_Show_Alert_Dialog (Am_Value_List().Add("Can't Add")
			.Add(obj.Get_Name()).Add("to")
			.Add(hole.Get_Name()));
  return false;
}

Am_Define_Method(Bin_Check_Method, bool, Process_Remove, (Am_Object process, Am_Object port))
{
  //  Remove_All_Binder(port);
  process.Get_Part(ContentsPart).Remove_Part(port);

  Am_Instance_Iterator goals = process;
  for (goals.Start(); !goals.Last(); goals.Next()) {
    Am_Object gl = goals.Get();
    Am_Object pt = Proc_Get_Port(gl, (Am_String)port.Get_Object(Model).Get(Name));
    if (pt.Valid())
      Process_Remove.Call(gl, pt);
  }

  Am_Value_List rules = process.Get(RuleList);
  for (rules.Start(); !rules.Last(); rules.Next()) {
    Am_Object rule = (Am_Object)rules.Get();
    Am_Value_List ports = rule.Get(PortList);
    for (ports.Start(); !ports.Last(); ports.Next()) {
      Am_Object pt = ports.Get();
      if ((Am_String)pt.Get_Object(Model).Get(Name) == (Am_String)port.Get_Object(Model).Get(Name))
	((Bin_Check_Method)rule.Get(RemoveMethod)).Call(rule, pt);
    }
  }
  return true;
}

Am_Define_Method(Bin_Check_Method, bool, Hole_Remove, (Am_Object process, Am_Object port))
{
  Hole_Remove_Port(process, port);
  return true;
}

Am_Define_Method(Bin_Check_Method, bool, Process_Check_Drop, (Am_Object source, Am_Object target))
{
  if ((int)source.Get(Type) != ProcessInterface) return false;
  Am_Object group = target.Get_Part(ContentsPart);
  if (source == target) return false; // $BF1$8%W%m%;%9$N>e$K$O%I%m%C%W$G$-$J$$!#(B
  if (source.Get_Owner() == group) return false;
  return true;
}

Am_Define_Method(Drop_Method, bool, Process_Drop, (Am_Object proc, Am_Object target, Am_Object cmd))
  // $B%k!<%k$K%I%m%C%W$7$?>l9g(B
  // $B0[$J$k%b%8%e!<%k$N%k!<%k$K%I%m%C%W$7$?>l9g(B
  // $B%Q%?!<%s$N%[!<%k$K%I%m%C%W$7$?>l9g(B
{
  Am_Object proc_model = proc.Get_Object(Model);
  Am_Object copy = 0;
  
  if (target.Is_Instance_Of(NetworkRuleProto)) {
    Am_Object rule_model = target.Get_Object(Model);
    if (proc_model.Get(Module) == rule_model.Get(Module)) {
      copy = Process_Goal_Create(proc);
    } else {
      copy = Process_Inter_Module_Goal_Create(proc);
    }
    Am_Object group = target.Get_Part(ContentsPart);
    cout << "Process_Drop: dropping " << proc << " in " << proc.Get_Owner() << " into " << group << endl;

    Am_Inter_Location new_loc = cmd.Get(Am_VALUE);
    bool as_line;
    Am_Object nref, oref;
    int nx, ny, w, h;
    new_loc.Get_Location(as_line, nref, nx, ny, w, h);
    Am_Translate_Coordinates(nref, nx, ny, group, nx, ny);

    copy.Set(Am_LEFT, nx).Set(Am_TOP, ny);
    group.Add_Part(copy);
    return true;
  } else if (target.Is_Instance_Of(HoleProto)) {
    // hole$B$NCV$-49$(!#(B
    copy = Process_Inter_Module_Goal_Create(proc);
    if (CALL2(target, Bin_Check_Method, AddMethod, copy)) return true;
    return false;
  }
}

// ------------------------------------------------------------
// Methods
// ------------------------------------------------------------
Am_Define_Method(Copy_Method, Am_Object, New_Process, (Am_Object /* proc */))
{
  Am_Object new_model = ProcessModel.Create();
  Am_Object new_proc  = ProcessProto.Create()
    .Set(Model, new_model)
    .Set(Am_WIDTH, 60)
    .Set(Am_HEIGHT, 60)
    ;
  return new_proc;
}

Am_Define_Method(Copy_Method, Am_Object, New_Hole, (Am_Object /* proc */ ))
{
  Am_Object new_model = HoleModel.Create();
  Am_Object new_proc  = HoleProto.Create()
    .Set(Model, new_model)
    .Set(Am_WIDTH, 60)
    .Set(Am_HEIGHT, 60)
    ;
  return new_proc;
}

Am_Define_Method(Copy_Method, Am_Object, Copy_Process, (Am_Object proc))
{
  //  Am_Object new_proc = Process_Inter_Module_Goal_Create(proc);
  Am_Object new_proc = Align_Zoom_Copy_Part(proc);
  return new_proc;
}

// Formulas
// --------

Am_Define_Object_Formula(SelfForm)
{
  return self;
}

Am_Define_Formula(int, CenterYOfOwnerForm)
{
  return (int)self.GV_Owner().GV(Am_HEIGHT) / 2;
}

Am_Define_Value_List_Formula(PortNameListForm) {
  Am_Value_List names = Am_Value_List();
  Am_Value_List ports = ContentsListForm(cc, self);
  for (ports.Start(); !ports.Last(); ports.Next()) {
    Am_Object p = ports.Get();
    names.Add((Am_String)p.GV_Object(Model).GV(Name));
  }
  return names;
}

Am_Define_Value_List_Formula(ProcRuleListForm) {
  Am_Object model = self.GV(Model);
  Am_String name = model.GV(Name);
  Am_Object module = model.GV(Module);
  if (!module.Valid()) return 0;
  if (!module.Get_Prototype().Valid()) return 0;

  Am_Value_List rules = Am_Value_List();
  Am_Value_List rule_list = module.GV(RuleList);
  for (rule_list.Start(); !rule_list.Last(); rule_list.Next()) {
    Am_Object r = rule_list.Get();
    if ((Am_String)r.GV_Object(Model).GV(Name) == name) {
      rules.Add(r);
    }
  }
  return rules;
}

Am_Define_Object_Formula(HoleParentForm)
{
  Am_Object parent = ParentForm(cc, self);
  if (parent.Valid()) return parent;

  Am_Object process = self.GV(Process);
  if (process.Valid()) return (Am_Object)process.GV(Parent);
  else return 0;
}

void initProcessProto(void) {
  ProcessModel = Am_Root_Object.Create("ProcessModel")
    .Set(Name,	"process")
    .Set(Module, 0)
    .Set(RuleVisible, true)
    ;

  Am_Object name = EditableZoomingText.Create("ProcessName")
    .Get_Part(TextPart).Set(Am_TEXT, ModelNameForm).Get_Owner()
    .Set(FontFamily, FontSansSerif)
    .Set(FontIsBold, true)
    .Set(NameHeightMax, 16)
    .Set(Am_WIDTH, Am_From_Owner(Am_WIDTH))
    .Set(Am_HEIGHT, NameHeightForm)
    ;

  Am_Object frame = Am_Border_Roundtangle.Create("ProcessFrame")
    .Set(Am_TOP, Bellow_Of_Sibling(NamePart))
    .Set(Am_WIDTH, Am_From_Owner(Am_WIDTH))     
    .Set(Am_HEIGHT, Am_Fill_To_Bottom)
    .Set(Am_RADIUS, 10)
    .Set(Am_THICKNESS, 2)
    .Set(Am_FILL_STYLE, Am_From_Object(PovlResources, ProcessFill))
    ;

  Am_Object contents = AlignZoomGroup.Create("ProcessContents")
    .Set(alignThreshold, 6)
    .Set(propagateParent, PropagateForm)
    .Set(numberThreshold, NumberThresholdForm)
    .Set(Am_TOP,    Bellow_Of_Sibling(NamePart))
    .Set(Am_WIDTH,  Am_From_Owner(Am_WIDTH))
    .Set(Am_HEIGHT, Am_Fill_To_Bottom)
    ;

  ProcessProto = PovlGroup.Create("ProcessProto")
    // Attributes
    .Set(Model, ProcessModel)
    .Set(Parent, ParentForm)
    .Set(Type,   ProcessInterface)
    // Lists
    .Set(PortList, ContentsListForm)
    .Set(PortNameList, PortNameListForm)
    .Set(RuleList, ProcRuleListForm)
    .Set(Hole, 0)
    // Methods
    .Set(NewMethod, New_Process)
    .Set(CopyMethod, Copy_Process)
    .Set(NamingMethod, Process_Rename)
    .Set(AddMethod, Process_Add)
    .Set(RemoveMethod, Process_Remove)
    .Set(CheckDropMethod, Process_Check_Drop)
    .Set(DropMethod, Process_Drop)
    // Graphics
    .Set(Am_WIDTH,  50)
    .Set(Am_HEIGHT, 40)
    .Add_Part(NamePart, name)
    .Add_Part(FramePart, frame)
    .Add_Part(ContentsPart, contents)
    ;

  HoleModel = Am_Root_Object.Create("HoleModel")
    .Set(Name, "hole")
    ;

  name = EditableZoomingText.Create("HoleName")
    .Get_Part(TextPart).Set(Am_TEXT, ModelNameForm).Get_Owner()
    .Set(FontFamily, FontSansSerif)
    .Set(FontIsBold, true)
    .Set(NameHeightMax, 16)
    .Set(Am_WIDTH, Am_From_Owner(Am_WIDTH))
    .Set(Am_HEIGHT, NameHeightForm)
    ;

  frame = Am_Border_Rectangle.Create("HoleFrame")
    .Set(Am_TOP, Bellow_Of_Sibling(NamePart))
    .Set(Am_WIDTH, Am_From_Owner(Am_WIDTH))     
    .Set(Am_HEIGHT, Am_Fill_To_Bottom)
    .Set(Am_RAISED, false)
    .Set(Am_THICKNESS, 2)
    .Set(Am_FILL_STYLE, Am_From_Object(PovlResources, ProcessFill))
    ;

  contents = AlignZoomGroup.Create("HoleContents")
    .Set(propagateParent, PropagateForm)
    .Set(numberThreshold, NumberThresholdForm)
    .Set(Am_TOP,    Bellow_Of_Sibling(NamePart))
    .Set(Am_WIDTH,  Am_From_Owner(Am_WIDTH))
    .Set(Am_HEIGHT, Am_Fill_To_Bottom)
    ;

  HoleProto = PovlGroup.Create("HoleProto")
    // Attributes
    .Set(Model, HoleModel)
    .Set(Parent, HoleParentForm)
    // Lists
    .Set(PortList, ContentsListForm)
    .Set(PortNameList, PortNameListForm)
    .Set(RuleList, Am_Value_List())
    .Set(Process, 0)
    .Set(ProcessList, Am_Value_List())
    // Methods
    .Set(NewMethod, New_Hole)
    .Set(NamingMethod, Hole_Rename)
    .Set(AddMethod, Hole_Add)
    .Set(RemoveMethod, Hole_Remove)
    .Set(CheckDropMethod, 0)
    .Set(DropMethod, 0)
    // Graphics
    .Set(Am_WIDTH, 50)
    .Set(Am_HEIGHT, 40)
    .Set(Am_VISIBLE, ContentsVisibleForm)
    .Add_Part(NamePart, name)
    .Add_Part(FramePart, frame)
    .Add_Part(ContentsPart, contents)
    ;

  ReplHolesProto = SequencePovlGroup.Create("ReplHolesProto")
    // Attributes
    .Set(Model, HoleModel.Create())
    .Set(Parent, ParentForm)
    .Set(Dir, LeftRight)
    .Set(seqDir, Am_Same_As(Dir))
    // Methods
    .Set(NewMethod, 0)
    .Set(NamingMethod, 0)
    .Set(AddMethod, 0)
    .Set(RemoveMethod, 0)
    .Set(CheckDropMethod, 0)
    .Set(DropMethod, 0)
    // Graphics
    .Set(Am_WIDTH, 220)
    .Set(Am_HEIGHT, 110)
    //    .Set(Am_VISIBLE, ContentsVisibleForm)
    .Set(ContentsPart, SelfForm)
    ;
}

// ------------------------------------------------------------
// Initialize
// ------------------------------------------------------------

void InitializeProcess(void)
{
  initProcessProto();
}
