// Copyright (C) 1997  Toyoda Masashi (toyoda@is.titech.ac.jp)

#include <amulet.h>
#include <fstream.h>

#include "ToyWidgets.h"
#include "PovlWidgets.h"
#include "Resources.h"
#include "Module.h"
#include "Process.h"
#include "Rule.h"
#include "ProcessMenu.h"
#include "Pattern.h"
#include "Atom.h"
#include "Message.h"
#include "Guard.h"
#include "Port.h"
#include "Binder.h"
#include "Translator.h"
#include "SaveLoad.h"

Am_Object TopWindow = 0;

Am_Define_Method(Am_Where_Method, Am_Object, Selection_Where_Test,
		 (Am_Object inter, Am_Object /* object */, Am_Object event_window,
		  Am_Input_Char /* ic */, int x, int y))
{
  Am_Object widget = inter.Get_Owner();
  Am_Value_List items = Am_Value_List()
    .Add(AtomProto)
    .Add(MessageProto)
    .Add(PortProto)
    .Add(GuardProto)
    .Add(ProcessProto)
    .Add(HoleProto)
    .Add(ReplHolesProto)
    .Add(RuleProto)
    .Add(PatternProto)
    .Add(ModuleProto)
    ;
  Am_Object below_root = widget.Get_Object(Am_OPERATES_ON);
  Am_Object obj = Content_Instance_Of(below_root, x, y, event_window, items);
  if (obj.Valid()) return obj;
  return widget; // click on background
}

Am_Define_Method(Am_Where_Method, Am_Object, Move_Where_Test,
		 (Am_Object inter, Am_Object /* object */, Am_Object event_window,
		  Am_Input_Char /* ic */, int x, int y))
{
  Am_Object widget = inter.Get_Owner();
  Am_Value_List items = Am_Value_List()
    .Add(AtomProto)
    .Add(MessageProto)
    .Add(PortProto)
    .Add(GuardProto)
    .Add(ProcessProto)
    .Add(HoleProto)
    .Add(RuleProto)
    .Add(PatternProto)
    .Add(ModuleProto)
    ;
  Am_Object below_root = widget.Get_Object(Am_OPERATES_ON);
  Am_Object obj = Content_Instance_Of(below_root, x, y, event_window, items);
  if (obj.Valid()) return obj;
  return Am_No_Object;
}

Am_Define_Method(Am_Object_Method, void, Load_Module_Do, (Am_Object command_obj))
{
  Am_Object menu = command_obj.Get_Owner().Get_Owner(); // $B%a%K%e!<(B
  Am_Object target = menu.Get(TargetObj); // $BDI2C@h(B
  Am_Object window = menu.Get_Owner();
  
  Am_Finish_Pop_Up_Waiting(window, Am_No_Value);

  Am_String file_name = Am_Get_Input_From_Dialog(Am_Value_List().Add("Load"), "",
						 100, 100, false);
  if (file_name.Valid()) {
    ifstream ifile;
    ifile.open(file_name, ios::in);
    if (!ifile) {
      cerr << "can't open " << file_name << endl;
    } else {
      Am_Object new_module = ((Copy_Method)ModuleProto.Get(NewMethod)).Call(ModuleProto);
      load_module(new_module, ifile);
      ((Bin_Check_Method)target.Get(AddMethod)).Call(target, new_module);
    }
  }
}

Am_Define_Method(Am_Object_Method, void, Load_New_Module_Do, (Am_Object command_obj))
{
  Am_Object menu = command_obj.Get_Owner().Get_Owner(); // $B%a%K%e!<(B
  Am_Object target = menu.Get(TargetObj); // $BDI2C@h(B
  Am_Object window = menu.Get_Owner();
  
  Am_Finish_Pop_Up_Waiting(window, Am_No_Value);

  Am_String file_name = Am_Get_Input_From_Dialog(Am_Value_List().Add("Load"), "",
						 100, 100, false);
  if (file_name.Valid()) {
    ifstream ifile;
    ifile.open(file_name, ios::in);
    if (!ifile) {
      cerr << "can't open " << file_name << endl;
    } else {
      Am_Object new_module = ((Copy_Method)ModuleProto.Get(NewMethod)).Call(ModuleProto);
      ((Bin_Check_Method)target.Get(AddMethod)).Call(target, new_module);
      Load_module(new_module, ifile);
    }
  }
}

Am_Define_Method(Am_Object_Method, void, Quit_Do, (Am_Object /* command_obj */))
{
  Am_Exit_Main_Event_Loop ();
}


void InitializePovlMainWindow(void)
{
  Am_Object root = PovlGroup.Create()
    .Set(Am_WIDTH, Am_From_Owner(Am_WIDTH))
    .Set(Am_HEIGHT, Am_From_Owner(Am_HEIGHT))
    .Add_Part(ContentsPart, TopModule
	      .Set(Am_LEFT, 0)
	      .Set(Am_TOP, 0)
	      .Set(Am_WIDTH, Am_From_Owner(Am_WIDTH))
	      .Set(Am_HEIGHT, Am_From_Owner(Am_HEIGHT))
	      )
    ;

  //  Am_Object undo_handler = Am_Multiple_Undo_Object.Create("undo"); 

  TopWindow = Am_Window.Create("TopWindow")
    .Set(Am_TITLE,	"D-Povl/KL1")
    .Set(Am_ICON_TITLE,	Am_Same_As(Am_TITLE))
    .Set(Am_WIDTH,	640)
    .Set(Am_HEIGHT,	468)
    .Set(Am_FILL_STYLE,	Am_Amulet_Purple)
    //    .Set(Am_UNDO_HANDLER, undo_handler)
    .Add_Part(ContentsPart, root)
    ;
  Am_Screen.Add_Part(TopWindow);

  Am_Object selection = PovlSelectionWidget
    .Set(Am_OPERATES_ON, root.Get_Part(ContentsPart))
    .Get_Part(Am_INTERACTOR)
      .Set(Am_START_WHERE_TEST, Selection_Where_Test)
    .Get_Owner()
    .Get_Part(Am_MOVE_INTERACTOR)
      .Set(Am_START_WHERE_TEST, Move_Where_Test)
    .Get_Owner()
    ;

  TopWindow.Add_Part(selection);

  /*
  UndoDialog = Am_Undo_Dialog_Box.Create("Undo_Dialog")
    .Set(Am_LEFT, 550)
    .Set(Am_TOP, 200)
    .Set(Am_UNDO_HANDLER_TO_DISPLAY, undo_handler)
    .Set(Am_SELECTION_WIDGET, selection)
    .Set(Am_SCROLLING_GROUP, Am_Scrolling_Group.Create("scroller"))
    .Set(Am_VISIBLE, false)
    ;

  Am_Screen.Add_Part(UndoDialog);
  */

  Am_Object TopModuleMenu = PopUpMenu.Create("TopModuleMenu")
    .Get_Part(MenuBody)
    .Set(Am_ITEMS, Am_Value_List()
	 .Add(MenuCommand.Create().Set(Am_LABEL, TargetNameForm))
	 .Add(Am_Menu_Line_Command.Create())
	 .Add(NewObjectCmd.Create().Set(Am_LABEL, ModuleProto))
	 .Add(MenuCommand.Create()
	      .Set(Am_LABEL, "Load Module").Set(Am_DO_METHOD, Load_New_Module_Do))
	 .Add(MenuCommand.Create()
	      .Set(Am_LABEL, "Load Old Module").Set(Am_DO_METHOD, Load_Module_Do))
	 // .Add(Am_Show_Undo_Dialog_Box_Command.Create()
	 // .Set(Am_UNDO_DIALOG_BOX, UndoDialog))
	 .Add(MenuCommand.Create()
	      .Set(Am_LABEL, "Quit").Set(Am_DO_METHOD, Quit_Do))
	 )
    .Get_Owner();
  Am_Screen.Add_Part(TopModuleMenu);

  Am_Object TopModuleMenuPopper = PopUpMenuInteractor.Create("TopModuleMenuPopper")
    .Set(MenuWindow, TopModuleMenu);
  TopModule.Add_Part(TopModuleMenuPopper);
}

void InitializeDragAndDrop(void)
{
  ModuleProto.Set(DropPoints,  Am_Value_List());
  RuleProto.Set(DropPoints,    Am_Value_List());
  PatternProto.Set(DropPoints, Am_Value_List().Add(PatternProto).Add(NetworkRuleProto).Add(HoleProto).Add(ModuleProto));
  ProcessProto.Set(DropPoints, Am_Value_List().Add(NetworkRuleProto).Add(HoleProto));
  HoleProto.Set(DropPoints,    Am_Value_List());
  ReplHolesProto.Set(DropPoints, Am_Value_List());
  MessageProto.Set(DropPoints, Am_Value_List().Add(PortProto));
  PortProto.Set(DropPoints,    Am_Value_List().Add(PortProto).Add(MessageProto));
  GuardProto.Set(DropPoints,   Am_Value_List());
  AtomProto.Set(DropPoints,    Am_Value_List().Add(PortProto));
}

			      
int main (void)
{
  cerr << "Initializing Amulet..." << endl;
  Am_Initialize();
  //  Am_Initialize_Undo_Dialog_Box();

  cerr << "Initializing ToyWidgets";
  Initialize_Rectangle_Widgets();  cerr << ".";
  Initialize_Pop_Up_Menu();        cerr << ".";
  Initialize_Zooming_Widgets();    cerr << ".";
  Initialize_Arrow();              cerr << "." << endl;

  cerr << "Initializing KLIEG widgets and resources";
  InitializeWidgets();		cerr << ".";
  InitializeResources();	cerr << ".";
  InitializeAtom();		cerr << ".";
  InitializeMessage();		cerr << ".";
  InitializeGuard();		cerr << ".";
  InitializePort();		cerr << ".";
  InitializeProcess();		cerr << ".";
  InitializePattern();		cerr << ".";
  InitializeRule();		cerr << ".";
  InitializeProcessMenu();	cerr << ".";
  InitializeModule();		cerr << ".";
  InitializeDragAndDrop();	cerr << ".";

  InitializePovlMainWindow();	cerr << ".";
  InitializeBinder();		cerr << ".";

  InitializeTranslator();	cerr << "." << endl;

  cerr << "Starting KLIEG editor" << endl;
  Am_Main_Event_Loop();
  Am_Cleanup();
}
