// Copyright (C) 1997  Toyoda Masashi (toyoda@is.titech.ac.jp)

// ToDo: $B%]!<%H$N(BOpen/Close$B$r%U%)!<%_%e%i$K$9$k$+!)(B

#include <amulet.h>
#include OBJECT_ADVANCED__H
#include FORMULA_ADVANCED__H

#include "ToyWidgets.h"

#include "Resources.h"
#include "PovlWidgets.h"

#include "Atom.h"
#include "Message.h"
#include "Process.h"
#include "Rule.h"
#include "Pattern.h"
#include "Binder.h"

#define _INTERNAL_
#include "Port.h"
// ------------------------------------------------------------
// Constants
// ------------------------------------------------------------

const char *BROADCAST_IMAGE_FILE = KLIEG_LIBDIR "/broadcast.bmp";
const char *MERGE_IMAGE_FILE     = KLIEG_LIBDIR "/merge.bmp";
const char *MAP_IN_IMAGE_FILE    = KLIEG_LIBDIR "/map-in.bmp";
const char *MAP_OUT_IMAGE_FILE   = KLIEG_LIBDIR "/map-out.bmp";

// #define NODE_IMAGE_FILE "/home/toyoda/work/src/amulet/klieg/V2.0/node.bmp"

// ------------------------------------------------------------
// Objects
// ------------------------------------------------------------

// Port Model

Am_Object PortModel = 0;

// Port View

Am_Object PortProto = 0;
Am_Object InSingletonProto = 0;
Am_Object OutSingletonProto = 0;
Am_Object InStreamProto = 0;
Am_Object OutStreamProto = 0;
Am_Object SpecialSingletonProto = 0;
Am_Object SpecialStreamProto = 0;
Am_Object BroadSingletonProto = 0;
Am_Object BroadStreamProto = 0;
Am_Object MergeProto = 0;
Am_Object MapInProto = 0;
Am_Object MapOutProto = 0;
Am_Object NodePortProto = 0;

// Menu popper

Am_Object ProcessPortMenuPopper = 0;

// ------------------------------------------------------------
// Utility Functions
// ------------------------------------------------------------

// $B%]!<%H$NAjBPE*$J0LCV$NH=Dj(B
// rule or pattern
// --------------------------------------------------------------------
//           pattern                   pattern
//           +------------------+      +------------------+
//  OutSide--+->InSide  GrSame--+------+->GrSame  InSide--+--->OutSide
//           |          GrSame<-+------+--GrSame          |
//           +------------------+      +------------------+
//            process
//            +-----------+
//  PaSame----+--PaSame   |
//            +-----------+
// --------------------------------------------------------------------
int Port_Side_Check(Am_Object obj_port, Am_Object sub_port)
{
  Am_Object obj_rule = Parent_Rule(obj_port);
  Am_Object sub_rule = Parent_Rule(sub_port);
  if (!obj_rule.Valid() || !sub_rule.Valid()) return PortFarAway;
  if (obj_rule == sub_rule) return PortParentSame;
  Am_Object obj_rule_parent = obj_rule.Get(Parent);
  Am_Object sub_rule_parent = sub_rule.Get(Parent);
  if (obj_rule_parent == sub_rule_parent && Is_Network(obj_rule_parent)) return PortGrandSame;
  if (obj_rule_parent == sub_rule) return PortInside;
  if (obj_rule == sub_rule_parent) return PortOutside;
  return PortFarAway;
}

// rule or pattern
// --------------------------------------------------------------------
//           pattern                   pattern
//           +------------------+      +------------------+
//  OutSide--+->InSide  InSide--+------+->InSide  InSide--+--->OutSide
//     |     |          InSide<-+------+--InSide          |
//     |     +------------------+      +------------------+
//     |    process
//     |   +-----------+
//     +---+--OutSide  |
//         +-----------+
int Port_Side(Am_Object obj_port, Am_Object sub_port)
{
  int check = Port_Side_Check(obj_port, sub_port);
  if (check == PortInside || check == PortGrandSame) return PortInside;
  if (check == PortOutside || check == PortParentSame) return PortOutside;
  return PortFarAway;
}

// $B%]!<%H$N>uBV$N%A%'%C%/(B
// ----------------------
bool Port_Has_Value(Am_Object port)
{
  Am_Value_List values = port.Get(ValueList);
  return !values.Empty();
}

bool Port_Has_Value2(Am_Object port, Am_Object src)
{
  int port_side = Port_Side(port, src);
  if (port_side == PortOutside) {
    return Port_Has_Value(port);
  }
  else return false;
}

bool Port_Is_Bound(Am_Object port, Am_Object src)
{
  if (((Am_Object)src.Get(Parent)).Is_Instance_Of(HoleProto) ||
      ((Am_Object)port.Get(Parent)).Is_Instance_Of(HoleProto)) {
    Am_Value_List binders = port.Get(HoleBinders);
    return !binders.Empty();
  } else {
    int port_mode, src_mode;
    Get_Correct_Modes(port, src, port_mode, src_mode);
    if (port_mode == PortInput)
      return !((Am_Value_List)port.Get(InputBinders)).Empty();
    else
      return !((Am_Value_List)port.Get(OutputBinders)).Empty();
  }
}

// $B?F$NC5:w(B
// --------
Am_Object Port_Top_Parent(Am_Object port) // $B%M%9%H$7$F$$$k%]!<%H$NCf$G0lHV>e$N%]!<%H$rJV$9!#(B
{
  Am_Object parent = port;
  Am_Object tmp;
  while((tmp = parent.Get(Parent)).Valid()) {
    if (!tmp.Is_Instance_Of(PortProto) && !tmp.Is_Instance_Of(MessageProto))
      return parent;
    parent = tmp;
  }
  return 0;
}

Am_Object Port_Parent_Proc(Am_Object port) // $B0lHV6a$$?F%W%m%;%9(B,$B%4!<%k(B,$B%k!<%k$rJV$9!%(B
{
  Am_Object parent = port;
  while((parent = parent.Get(Parent)).Valid()) {
    if (!parent.Is_Instance_Of(PortProto) && !parent.Is_Instance_Of(MessageProto))
      return parent;
  }
  return 0;
}

// $BDI2C!&0\F0$,2DG=$+$r%A%'%C%/(B
// ----------------------------
bool Port_Add_Allowed(Am_Object src_port, Am_Object des_port)
{
  // Valid $B%A%'%C%/(B
  if (!src_port.Valid() || !des_port.Valid()) return false;

  // atom $B$K$O(B add $B$G$-$J$$!%(Bport $B$+(B structure $B$G$"$k$3$H$rJ]>Z$9$k!%(B
  if (des_port.Is_Instance_Of(AtomProto)) return false;

  // Hole$B$N%]!<%H$K$O(Badd$B$G$-$J$$!#(B
  if (((Am_Object)des_port.Get(Parent)).Is_Instance_Of(HoleProto)) return false;

  int des_type = des_port.Get_Object(Model).Get(Type);
  int des_age  = des_port.Get(Age);
  int des_mode = des_port.Get(Mode);

  // single port $B$K$O0l$D$7$+F~$i$J$$!%(B
  if ((des_type == PortSingleton) && (Port_Has_Value(des_port) || Port_Is_Bound(des_port, src_port)))
    return false;

  // atom, structure $B$NDI2C!%(B
  if (src_port.Is_Instance_Of(AtomProto) || src_port.Is_Instance_Of(MessageProto)) {
    // goal$B$N=PNO(Bport$B$K$ODI2C$G$-$J$$!#(B
    if (des_mode == PortOutput && des_age == PortNew) return false;
    return true;
  } else if (src_port.Is_Instance_Of(PortProto)) {
    int src_type  =  src_port.Get_Object(Model).Get(Type);
    int src_age   =  src_port.Get(Age);
    int src_mode  =  src_port.Get(Mode);
    bool des_is_goal_port = ((Am_Object)des_port.Get(Parent)).Is_Instance_Of(ProcessProto);
    bool des_is_rule_port = Is_Network((Am_Object)des_port.Get(Parent));
    // single port $B$NDI2C!%(B
    if (src_type == PortSingleton) {
      if (des_type == PortStream) {
	// $B%4!<%k$N=PNO(B stream$B0J30$O(BOK.
	if (des_is_goal_port && des_mode == PortOutput) return false;
	else return true;
      }
      if (des_type == PortSingleton) {
	if (src_mode == PortOutput && des_is_goal_port)
	  return true;
	if (src_mode == PortOutput && des_is_rule_port && des_mode != PortInput)
	  return true;
	if (src_mode == PortInput && des_mode == PortInput) return true;
	return false;
      }
    }
    // stream port $B$NDI2C!%(B
    if (src_type == PortStream) {
      if (des_is_goal_port && des_mode == PortOutput) return false; // goal $B$O$@$a!%(B
      if (des_type != PortSingleton) return true; // structure $B$O(B Stream$B07$$$J$N$G(Bok.
    }
  }
  return false;
}

bool Port_Move_Allowed(Am_Object src_port, Am_Object des_port)
{
  // Valid $B%A%'%C%/(B
  if (!src_port.Valid() || !des_port.Valid()) return false;
  // $BF1$8%]!<%H$O$@$a!%(B
  if (src_port == des_port) return false;
  // $BF1$8%k!<%k$NCf$K$"$k$+$N%A%'%C%/!%(B
  if (Port_Side_Check(src_port, des_port) == PortFarAway) return false;
  // atom $B$K$O(B add $B$G$-$J$$!%(Bport $B$+(B structure $B$G$"$k$3$H$rJ]>Z$9$k!%(B
  if (des_port.Is_Instance_Of(AtomProto)) return false;

  int des_type = des_port.Get_Object(Model).Get(Type);
  int des_age  = des_port.Get(Age);
  int des_mode = des_port.Get(Mode);

  // single port $B$K$O0l$D$7$+F~$i$J$$!%(B
  if (des_type == PortSingleton && (Port_Has_Value(des_port) || Port_Is_Bound(des_port, src_port)))
    return false;

  // atom, structure $B$NDI2C!%(B
  if (src_port.Is_Instance_Of(AtomProto)||src_port.Is_Instance_Of(MessageProto)) {
    // goal$B$N=PNO(Bport$B$K$ODI2C$G$-$J$$!#(B
    if (des_mode == PortOutput && des_age == PortNew) return false;
    return true;
  } else if (src_port.Is_Instance_Of(PortProto)) {
    if (((Am_Object)src_port.Get(Parent)).Is_Instance_Of(ProcessProto)) return false;
    int src_type  =  src_port.Get_Object(Model).Get(Type);
    int src_age   =  src_port.Get(Age);
    int src_mode  =  src_port.Get(Mode);
    if (src_mode != PortOutput) return false;
    bool des_is_goal_port = ((Am_Object)des_port.Get(Parent)).Is_Instance_Of(ProcessProto);
    bool des_is_rule_port = Is_Network((Am_Object)des_port.Get(Parent));
    // single port $B$NDI2C!%(B
    if (src_type == PortSingleton) {
      if (des_type == PortStream) {
	// $B%4!<%k$N=PNO(B stream$B0J30$O(BOK.
        if (des_is_goal_port && des_mode == PortOutput) return false;
	else return true;
      }
      if (des_type == PortSingleton) {
	if (des_mode == PortInput && des_age == PortNew) return true;
	if (des_is_rule_port && des_mode == PortInput) return true;
 	if (des_is_rule_port && des_mode == PortOutput && des_age == PortOld) return true;
 	return false;
      }
    }
    // stream port $B$NDI2C!%(B
    if (src_type == PortStream) {
      if (des_is_goal_port && des_mode == PortOutput) return false; // goal $B$O$@$a!%(B
      if (des_type != PortSingleton) return true; // structure $B$O(B Stream$B07$$$J$N$G(Bok.
    }
  }
  return false;
}


// $B%]!<%H$N%Q%94XO"(B
// ----------------

// For upper compatibility
#define KL_None      0
#define KL_Module    1
#define KL_Pattern   2
#define KL_Process   3
#define KL_Hole      4
#define KL_Rule      5
#define KL_Port      6
#define KL_Atom      7
#define KL_Structure 8
#define KL_Guard     9
#define KL_Binder    10
#define KL_Data	     11

Am_Object Position_To_Obj(Am_Object root, Am_Value_List position)
{
  position.Start();
  if (position.Last()) return 0;
  Am_Value_List ports;
  int type = position.Get();  position.Next();
  if (type == KL_Port) {
    ports = root.Get(PortList);
  } else if (type == KL_Data) {
    //    ports = Rule_Data(root);
  } else {
    Am_Value_List goals;
    if (type == KL_Process) goals = root.Get(ProcessList);
    if (type == KL_Pattern) goals = root.Get(ProcessList);
    if (type == KL_Hole)    goals = root.Get(HoleList);
    if (type == KL_Binder)  goals = root.Get_Part(BindersPart).Get(Am_GRAPHICAL_PARTS);
    if (position.Last()) return 0;
    int idx = position.Get();  position.Next();
    Am_Object goal = Object_List_Get(goals, idx);
    if (position.Last()) return goal;
    ports = goal.Get(PortList);
  }
  if (position.Last()) return 0;
  int idx = position.Get(); position.Next();
  Am_Object port = Object_List_Get(ports, idx);
  for (; !position.Last(); position.Next()) {
    int idx = position.Get();
    port = Object_List_Get(port.Get(ValueList), idx);
  }
  return port;
}

// ------------------------------------------------------------
// Formulas
// ------------------------------------------------------------

// Binder Lists
// $BA4It$N%j%9%H(B Binders
// $BJRJ}$,%[!<%k%]!<%H$J$i(BHoleBinders$B$KEPO?(B
// $BF~$C$F$/$k%P%$%s%@$O(BInputBinders
// $B=P$F$$$/%P%$%s%@$O(BOutputBinders
// $B30B&$+$iMh$k%P%$%s%@$O(BBinders$B$KEPO?(B
// $BFbB&$X$N%P%$%s%@$O(BInnerBinders$B$KEPO?(B
// ----------------------------------------
void classify_binders(Am_Constraint_Context& cc, Am_Object& self, Am_Object network,
		      Am_Value_List& all_binders, Am_Value_List& in_binders,
		      Am_Value_List& out_binders, Am_Value_List& hole_binders)
{
  Am_Value_List binders = network.GV_Part(BindersPart).GV(Am_GRAPHICAL_PARTS);  
  for (binders.Start(); !binders.Last(); binders.Next()) {
    Am_Object b = binders.Get();
    Am_Object src = b.GV(SrcPort);
    Am_Object des = b.GV(DestPort);
    if (src == self || des == self) {
      all_binders.Add(b);
      if (src.GV_Object(Parent).Is_Instance_Of(HoleProto) ||
	  des.GV_Object(Parent).Is_Instance_Of(HoleProto)) hole_binders.Add(b);
      else if (self == src) out_binders.Add(b);
      else if (self == des) in_binders.Add(b);
    }
  }    
}

Am_Define_Value_List_Formula(AllBindersForm)
{
  Am_Value_List all_binders = Am_Value_List();
  Am_Value_List in_binders = Am_Value_List();
  Am_Value_List out_binders = Am_Value_List();
  Am_Value_List hole_binders = Am_Value_List();

  Am_Object paren_net = Parent_Rule_In_Form(cc, self);
  if (!paren_net.Valid()) return all_binders;
  classify_binders(cc, self, paren_net, all_binders, in_binders, out_binders, hole_binders);

  Am_Object grand_net = paren_net.GV(Parent);
  if (grand_net.Valid() && Is_Network(grand_net)) {
    classify_binders(cc, self, grand_net, all_binders, in_binders, out_binders, hole_binders);
  }
  self.Set(InputBinders, in_binders)
    .Set(OutputBinders, out_binders)
    .Set(HoleBinders, hole_binders);
  return all_binders;
}

// Mode of Special Ports
// ---------------------
Am_Define_Formula(int, SpecialModeForm)
{
  Am_Value_List binders = self.GV(Binders);  binders.Start();
  if (binders.Empty()) return PortUnknown;
  Am_Object b = binders.Get();  // $B$I$l$G$b$$$$!#(B
  Am_Object src = b.GV(SrcPort);
  Am_Object des = b.GV(DestPort);
  int src_side = Port_Side(src, des);
  int des_side = Port_Side(des, src);  
  if (self == src) {
    if (src_side == PortInside) return PortInput;
    if (src_side == PortOutside) return PortOutput;
  }
  if (self == des) {
    if (des_side == PortInside) return PortOutput;
    if (des_side == PortOutside) return PortInput;
  }
  return PortUnknown;
}

// Outlooks
// --------
Am_Define_Style_Formula(PortFillForm)
{
  int age = self.GV_Owner().GV(Age);
  if (age == PortNew)
    return PovlResources.GV(PortNewFill);
  else
    return PovlResources.GV(PortOldFill);
}

Am_Define_Formula(bool, PortFrameRaisedForm)
{
  Am_Object model = self.GV_Owner().GV(Model);
  if (!model.Valid()) return false;

  if (model.GV(Mode) == PortInput) return false;
  else return true;
}

Am_Define_Formula(bool, PortFrameRaisedFromSelfForm)
{
  Am_Object owner = self.GV_Owner();
  if (!owner.Valid) return false;

  if (owner.GV(Mode) == PortInput) return false;
  else return true;
}

Am_Define_Formula(int, PortRadiusForm) {
  Am_Object model = self.GV_Owner().GV(Model);
  int type = model.GV(Type);
  if (type == PortSingleton) 
    return (int)self.GV(Am_HEIGHT) / 2;
  else
    return 1;
}

// Layout of Ports

int Value_Length(Am_Constraint_Context& cc, Am_Object value, int self_count)
{
  int length = self_count;
  if (value.Get_Slot_Type(ValueList) == Am_NONE) return length;
  Am_Value_List values = value.GV(ValueList);
  for (values.Start(); !values.Last(); values.Next()) {
    Am_Object v = values.Get();
    length += Value_Length(cc, v, 1);
  }
  return length;
}  

Am_Define_Formula(int, PortLayoutForm) 
{
  int w = self.GV(Am_WIDTH);
  int h = self.GV(Am_HEIGHT);
  Am_Object port = self.GV_Owner();
  if (!port.Valid()) return 0;
  int dir = port.GV(Dir);
  Am_Value_List conts = self.GV(Am_GRAPHICAL_PARTS);
  int length = Value_Length(cc, self.GV_Owner(), 0);
  int left = 0;
  if (dir == PortLeft) {
    for (conts.Start(); !conts.Last(); conts.Next()) {
      Am_Object c = conts.Get();
      c.GV(Am_TOP); c.GV(Am_LEFT); c.GV(Am_WIDTH); c.GV(Am_HEIGHT);
      c.Set(Am_TOP, 1)
       .Set(Am_LEFT, left)
       .Set(Am_WIDTH, w * Value_Length(cc, c, 1) / length - 1)
       .Set(Am_HEIGHT, h - 2);
      left += w * Value_Length(cc, c, 1) / length;       
    }
  } else {
    for (conts.End(); !conts.First(); conts.Prev()) {
      Am_Object c = conts.Get();
      c.GV(Am_TOP); c.GV(Am_LEFT); c.GV(Am_WIDTH); c.GV(Am_HEIGHT);
      c.Set(Am_TOP, 1)
       .Set(Am_LEFT, left)
       .Set(Am_WIDTH, w * Value_Length(cc, c, 1) /length - 1)
       .Set(Am_HEIGHT, h - 2);
      left += w * Value_Length(cc, c, 1) / length;
    }
  }
  return 0;
}

Am_Define_Formula(int, PortContentsWidthForm)
{
  Am_Object name = self.GV_Sibling(NamePart);
  Am_Object mark = self.GV_Sibling(MarkerPart);

  if (!name.Valid() || !mark.Valid()) return 0;

  Am_Object port = self.GV_Owner();
  if (!port.Valid()) return 0;
  int type = port.GV_Object(Model).GV(Type);
  Am_Value_List values = self.GV(Am_GRAPHICAL_PARTS);
  //  if (!values.Valid()) return 0; 
  int length = Value_Length(cc, self.GV_Owner(), 0);
  int owner_width = port.GV(Am_WIDTH);
  int name_marker_width = owner_width / (length + 1);
  int contents_width = owner_width - name_marker_width;
  int marker_width = name_marker_width / 4;
  int name_width = name_marker_width - marker_width;
  if (type == PortSingleton) {
    marker_width = 0;
    name_width = name_marker_width;
  }
  mark.Set(Am_WIDTH, marker_width);
  name.Set(Am_WIDTH, name_width);
  return contents_width;
}

Am_Define_Formula(int, PortContentsLeftForm) 
{
  Am_Object port = self.GV_Owner();
  if (!port.Valid()) return 0;
  int dir = port.GV(Dir);
  Am_Object name = self.GV_Sibling(NamePart); if (!name.Valid()) return 0;
  Am_Object mark = self.GV_Sibling(MarkerPart); if (!mark.Valid()) return 0;

  if (dir == PortRight) {
    name.Set(Am_LEFT, 0);
    mark.Set(Am_LEFT, name.GV(Am_WIDTH));
    return (int)name.GV(Am_WIDTH) + (int)mark.GV(Am_WIDTH);
  } else {
    name.Set(Am_LEFT, (int)self.GV(Am_WIDTH) + (int)mark.GV(Am_WIDTH));
    mark.Set(Am_LEFT, self.GV(Am_WIDTH));
    return 0;
  }
  return 0;
}

Am_Define_Formula(int, PortWithIconContentsWidthForm)
{
  Am_Object name = self.GV_Sibling(NamePart);
  Am_Object icon = self.GV_Sibling(IconPart);
  Am_Object mark = self.GV_Sibling(MarkerPart);

  if (!name.Valid() || !mark.Valid() || !icon.Valid()) return 0;

  int type = self.GV_Owner().GV_Object(Model).GV(Type);
  Am_Value_List values = self.GV(Am_GRAPHICAL_PARTS);
  //  if (!values.Valid()) return 0;
  int length = Value_Length(cc, self.GV_Owner(), 0);
  int owner_width = self.GV_Owner().GV(Am_WIDTH);
  int name_marker_width = owner_width * 2 / (length + 2);
  int contents_width = owner_width - name_marker_width;
  int marker_width = name_marker_width / 5;
  int name_width = name_marker_width - marker_width - (int)icon.GV(Am_WIDTH);
  if (type == PortSingleton) {
    marker_width = 0;
    name_width = name_marker_width;
  }
  mark.Set(Am_WIDTH, marker_width);
  name.Set(Am_WIDTH, name_width);
  return contents_width;
}

Am_Define_Formula(int, PortWithIconContentsLeftForm) 
{
  int dir = self.GV_Owner().GV(Dir);
  Am_Object name = self.GV_Sibling(NamePart);
  Am_Object mark = self.GV_Sibling(MarkerPart);
  Am_Object icon = self.GV_Sibling(IconPart);

  if (!name.Valid() || !mark.Valid() || !icon.Valid()) return 0;

  if (dir == PortRight) {
    icon.Set(Am_LEFT, 0);
    name.Set(Am_LEFT, icon.GV(Am_WIDTH));
    mark.Set(Am_LEFT, (int)icon.GV(Am_WIDTH) + (int)name.GV(Am_WIDTH));
    return (int)icon.GV(Am_WIDTH) + (int)name.GV(Am_WIDTH) + (int)mark.GV(Am_WIDTH);
  } else {
    name.Set(Am_LEFT,(int)self.GV(Am_WIDTH)+(int)mark.GV(Am_WIDTH)+(int)icon.GV(Am_WIDTH));
    icon.Set(Am_LEFT,(int)self.GV(Am_WIDTH)+(int)mark.GV(Am_WIDTH)); 
    mark.Set(Am_LEFT,(int)self.GV(Am_WIDTH));
    return 0;
  }
  return 0;
}


Am_Define_Point_List_Formula(PortMarkerPointListForm) {
  Am_Point_List list;
  Am_Object owner = self.GV_Owner();
  if (!owner.Valid()) return list;
  Am_Object port = owner.GV_Owner();
  if (!port.Valid()) return list;
  
  int width  = owner.GV(Am_WIDTH);
  int height = owner.GV(Am_HEIGHT);
  int dir    = (int)port.GV(Dir);
  int state  = (int)port.GV(State);

  if (state == PortClose) {
    list.Add(0,		2);
    list.Add(width / 2,	2);
    list.Add(width / 2,	height - 2);
    list.Add(0,		height - 2);
    list.Add(0,		2);
    self.Set(Am_FILL_STYLE, Am_Red);
  } else if (dir == PortRight) {
    list.Add(0,		2);
    list.Add(0,		height - 2);
    list.Add(width - 2,	height / 2);
    list.Add(0,		2);
    self.Set(Am_FILL_STYLE, Am_Green);
  } else {
    list.Add(width - 2,	2);
    list.Add(width - 2,	height - 2);
    list.Add(0,		height / 2);
    list.Add(width - 2,	2);
    self.Set(Am_FILL_STYLE, Am_Green);
  }
  return list;
}

// ------------------------------------------------------------
// Methods
// ------------------------------------------------------------

Am_Define_Method(Copy_Method, Am_Object, New_Port, (Am_Object port))
{
  Am_Object model = port.Get(Model);
  Am_Object new_port = port.Create()
    .Set(Model, model.Create())
    ;
  return new_port;
}

Am_Define_Method(Naming_Method, bool, Port_Rename, (Am_Object port, Am_String name))
{
  Am_Object parent = port.Get(Parent);
  if (parent.Valid()) {
    if (parent.Is_Instance_Of(ProcessProto)||parent.Is_Instance_Of(HoleProto)||
	parent.Is_Instance_Of(PatternProto)) {
      if (Member_Name(parent, PortNameList, name)) return false;
      port.Get_Object(Model).Set(Name, name);
      return true;
    } else {
      Am_Object rule = Parent_Rule(port);
      if (rule.Valid())
	if (Member_Name(rule, InnerPortNameList, name)) return false;
      port.Get_Object(Model).Set(Name, name);
      return true;
    }
  }
  return false;
}

Am_Define_Method(Bin_Check_Method, bool, Port_Add, (Am_Object port, Am_Object value))
{
  if (!value.Is_Instance_Of(ValueProto) || !Port_Add_Allowed(value, port)) {
    Am_Show_Alert_Dialog (Am_Value_List().Add("Can't add")
			  .Add(value.Get_Name()).Add("to")
			  .Add(port.Get_Name()));
    return false;
  }
  if (value.Is_Instance_Of(PortProto)) {
    Am_String value_name = value.Get_Object(Model).Get(Name); // original name
    Am_Object rule = Parent_Rule(port);
    Am_String new_name = value_name;
    if (rule.Valid())
      if (Member_Name(rule, InnerPortNameList, value_name)) 
	new_name = Next_Name(rule, InnerPortNameList, value_name); // change
    value.Get_Object(Model).Set(Name, new_name); // directly rename
  }
  port.Get_Part(ContentsPart).Add_Part(value);
  return true;
}

Am_Define_Method(Bin_Check_Method, bool, Port_Remove, (Am_Object port, Am_Object value))
{
  //  Remove_All_Binder(port);
  port.Get_Part(ContentsPart).Remove_Part(value);
  return true;
}


Am_Define_Method(Bin_Check_Method, bool, Port_Check_Drop, (Am_Object source, Am_Object target))
{
  if (Port_Move_Allowed(source, target)) return true;
  else return false;
}

Am_Define_Method(Drop_Method, bool, Port_Drop, (Am_Object source, Am_Object target, Am_Object cmd))
{
  cout << "dropping " << source << " in " << source.Get_Owner() << " into " << target << endl;

  Am_Object copy = source.Create()
    //    .Set(Mode, 1 - (int)source.Get(Mode)) //$BF~=PNO5UE>(B***********
    ;
  target.Get_Part(ContentsPart).Add_Part(copy);
  return true;
}

void initPortProto(void)
{
  PortModel = Am_Root_Object.Create("PortModel")
    .Set(Name,	"Port")
    //    .Set(Mode,  PortInput)
    .Set(Type,  PortStream)
    .Set(Special, PortNormal)
    ;

  Am_Object singleton_frame = Am_Border_Roundtangle.Create("SingletonFrame")
    .Set(Am_WIDTH,      Am_From_Owner(Am_WIDTH))
    .Set(Am_HEIGHT,     Am_From_Owner(Am_HEIGHT))
    .Set(Am_FILL_STYLE, PortFillForm)
    .Set(Am_RADIUS,     PortRadiusForm)
    .Set(Am_THICKNESS,  1)
    .Set(Am_RAISED,     PortFrameRaisedFromSelfForm)
    ;

  Am_Object stream_frame = Am_Border_Rectangle.Create("StreamFrame")
    .Set(Am_WIDTH,      Am_From_Owner(Am_WIDTH))
    .Set(Am_HEIGHT,     Am_From_Owner(Am_HEIGHT))
    .Set(Am_FILL_STYLE, PortFillForm)
    .Set(Am_THICKNESS,  1)
    .Set(Am_RAISED,     PortFrameRaisedFromSelfForm)
    ;

  Am_Object name = EditableZoomingText.Create("PortName")
    .Set(Am_HEIGHT, Am_From_Owner(Am_HEIGHT))
    .Get_Part(TextPart).Set(Am_TEXT, ModelNameForm).Get_Owner()
    .Set(FontFamily, FontSansSerif)
    .Set(FontIsBold, false)
    ;

  Am_Object marker = PovlGroup.Create("PortMarker")
    .Set(Am_HEIGHT, Am_From_Owner(Am_HEIGHT))
    .Add_Part(MarkerPart, Am_Polygon.Create("PortMarker")
	      .Set(Am_POINT_LIST, PortMarkerPointListForm))
    ;

  //  Am_Object contents = AlignZoomGroup.Create("PortContents")
  Am_Object contents = PovlGroup.Create("PortContents")
    .Set(minimumSpace, 0)
    .Set(Am_LEFT,      PortContentsLeftForm)
    .Set(Am_WIDTH,     PortContentsWidthForm)
    .Set(Am_HEIGHT,    Am_From_Owner(Am_HEIGHT))
    .Set(Am_LAYOUT,    PortLayoutForm)
    ;

  PortProto = ValueProto.Create("Port_Proto")
    .Set(Parent, ParentForm)
    .Set(Model, PortModel)
    .Set(Mode, PortInput)
    .Set(Dir, PortRight)
    .Set(Age, PortNew)
    .Set(State, PortOpen)

    .Set(ValueList,  InstanceListForm(ValueProto))
    .Set(Binders, AllBindersForm)
    .Set(InputBinders, 0)
    .Set(OutputBinders, 0)
    .Set(HoleBinders, 0)

    .Set(Am_WIDTH, 40)
    .Set(Am_HEIGHT, 20)
    //    .Add_Part(FramePart, singleton_frame)
    //    .Add_Part(NamePart, name)
    //    .Add_Part(MarkerPart, marker)
    //    .Add_Part(ContentsPart, contents)

    .Set(NewMethod, New_Port)
    .Set(NamingMethod, Port_Rename)
    .Set(AddMethod, Port_Add)
    .Set(RemoveMethod, Port_Remove)
    .Set(CheckDropMethod, Port_Check_Drop)
    .Set(DropMethod, Port_Drop)
    ;

  InSingletonProto = PortProto.Create("InSingletonProto")
    .Set(Mode, PortInput)
    .Set(Model, PortModel.Create("InSingletonModel")
	 .Set(Name, "In")
	 .Set(Type, PortSingleton)
	 )
    .Add_Part(FramePart, singleton_frame)
    .Add_Part(NamePart, name)
    .Add_Part(MarkerPart, marker)
    .Add_Part(ContentsPart, contents)
    ;

  OutSingletonProto = PortProto.Create("OutSingletonProto")
    .Set(Mode, PortOutput)
    .Set(Model, PortModel.Create("OutSingletonModel")
	 .Set(Name, "Out")
	 .Set(Type, PortSingleton)
	 )
    .Add_Part(FramePart, singleton_frame.Copy())
    .Add_Part(NamePart, name.Copy())
    .Add_Part(MarkerPart, marker.Copy())
    .Add_Part(ContentsPart, contents.Copy())
    ;

  InStreamProto = PortProto.Create("InStreamProto")
    .Set(Mode, PortInput)
    .Set(Model, PortModel.Create("InStreamModel")
	 .Set(Name, "Ins")
	 .Set(Type, PortStream)
	 )
    .Add_Part(FramePart, stream_frame)
    .Add_Part(NamePart, name.Copy())
    .Add_Part(MarkerPart, marker.Copy())
    .Add_Part(ContentsPart, contents.Copy())

    ;

  OutStreamProto = PortProto.Create("OutStreamProto")
    .Set(Mode, PortOutput)
    .Set(Model, PortModel.Create("OutStreamModel")
	 .Set(Name, "Outs")
	 .Set(Type, PortStream)
	 )
    .Add_Part(FramePart, stream_frame.Copy())
    .Add_Part(NamePart, name.Copy())
    .Add_Part(MarkerPart, marker.Copy())
    .Add_Part(ContentsPart, contents.Copy())
    ;

  // special ports

  Am_Object special_singleton_frame = Am_Roundtangle.Create("SpecialSingleFrame")
    .Set(Am_WIDTH,      Am_From_Owner(Am_WIDTH))
    .Set(Am_HEIGHT,     Am_From_Owner(Am_HEIGHT))
    .Set(Am_FILL_STYLE, Am_White)
    .Set(Am_RADIUS,     PortRadiusForm)
    ;

  Am_Object special_stream_frame = Am_Rectangle.Create("SpecialStreamFrame")
    .Set(Am_WIDTH,      Am_From_Owner(Am_WIDTH))
    .Set(Am_HEIGHT,     Am_From_Owner(Am_HEIGHT))
    .Set(Am_FILL_STYLE, Am_White)
    ;

  Am_Object broadcast_image = PovlGroup.Create("broadcast_image")
    .Set(Am_WIDTH, 23)
    .Set(Am_HEIGHT, Am_From_Owner(Am_HEIGHT))
    .Add_Part(ContentsPart, Am_Bitmap.Create("broadcast_image")
	      .Set(Am_LEFT, Am_Center_X_Is_Center_Of_Owner)
	      .Set(Am_TOP, Am_Center_Y_Is_Center_Of_Owner)
	      .Set(Am_WIDTH, 23)
	      .Set(Am_HEIGHT, 19)
	      .Set(Am_LINE_STYLE, Am_Black)
	      .Set(Am_FILL_STYLE, Am_No_Style)
	      .Set(Am_IMAGE, Am_Image_Array(BROADCAST_IMAGE_FILE))
	      )
    ;

  Am_Object merge_image = broadcast_image.Create("merge_image")
    .Get_Part(ContentsPart)
    .Set(Am_IMAGE, Am_Image_Array(MERGE_IMAGE_FILE))
    .Get_Owner();

  Am_Object map_in_image = broadcast_image.Create("map_in_image")
    .Get_Part(ContentsPart)
    .Set(Am_IMAGE, Am_Image_Array(MAP_IN_IMAGE_FILE))
    .Get_Owner();

  Am_Object map_out_image = broadcast_image.Create("map_out_image")
    .Get_Part(ContentsPart)
    .Set(Am_IMAGE, Am_Image_Array(MAP_OUT_IMAGE_FILE))
    .Get_Owner();

  /*
  Am_Object node_image = broadcast_image.Create("node_image")
    .Get_Part(ContentsPart)
    .Set(Am_IMAGE, Am_Image_Array(NODE_IMAGE_FILE))
    .Get_Owner();
    */

  Am_Object icon_contents = PovlGroup.Create("PortWithIconContents")
    .Set(minimumSpace, 0)
    .Set(Am_LEFT,      PortWithIconContentsLeftForm)
    .Set(Am_WIDTH,     PortWithIconContentsWidthForm)
    .Set(Am_HEIGHT,    Am_From_Owner(Am_HEIGHT))
    .Set(Am_LAYOUT,    PortLayoutForm)
    ;

  SpecialSingletonProto = PortProto.Create("SpecialSingletonProto")
    .Set(Mode, SpecialModeForm)
    .Set(Age,  PortOld)
    .Set(Model, PortModel.Create("InSingletonModel")
	 .Set(Name, "X")
	 .Set(Type, PortSingleton)
	 .Set(Special, PortPatSingleton)
	 )
    .Add_Part(FramePart, special_singleton_frame.Copy())
    .Add_Part(NamePart, name.Copy())
    .Add_Part(MarkerPart, marker.Copy())
    .Add_Part(ContentsPart, contents.Copy())
    ;

  SpecialStreamProto = PortProto.Create("SpecialStreamProto")
    .Set(Mode, SpecialModeForm)
    .Set(Age,  PortOld)
    .Set(Model, PortModel.Create("InStreamModel")
	 .Set(Name, "Xs")
	 .Set(Type, PortStream)
	 .Set(Special, PortPatStream)
	 )
    .Add_Part(FramePart, special_stream_frame.Copy())
    .Add_Part(NamePart, name.Copy())
    .Add_Part(MarkerPart, marker.Copy())
    .Add_Part(ContentsPart, contents.Copy())
    ;

  BroadSingletonProto = PortProto.Create("BroadSingletonProto")
    .Set(Mode, PortOutput)
    .Set(Age,  PortOld)
    .Set(Model, PortModel.Create("BroadcastModel")
	 .Set(Name, "Bcast")
	 .Set(Type, PortSingleton)
	 .Set(Special, PortBroadcast)
	 )
    .Add_Part(FramePart, special_singleton_frame.Copy())
    .Add_Part(IconPart, broadcast_image)
    .Add_Part(NamePart, name.Copy())
    .Add_Part(MarkerPart, marker.Copy())
    .Add_Part(ContentsPart, icon_contents)
    ;

  BroadStreamProto = PortProto.Create("BroadcastProto")
    .Set(Mode, PortOutput)
    .Set(Age,  PortOld)
    .Set(Model, PortModel.Create("BroadcastModel")
	 .Set(Name, "Bcast")
	 .Set(Type, PortStream)
	 .Set(Special, PortBroadcast)
	 )
    .Add_Part(FramePart, special_stream_frame.Copy())
    .Add_Part(IconPart, broadcast_image.Copy())
    .Add_Part(NamePart, name.Copy())
    .Add_Part(MarkerPart, marker.Copy())
    .Add_Part(ContentsPart, icon_contents.Copy())
    ;

  MergeProto = PortProto.Create("MergeProto")
    .Set(Mode, PortInput)
    .Set(Age,  PortOld)
    .Set(Model, PortModel.Create("MergeModel")
	 .Set(Name, "Merge")
	 .Set(Type, PortStream)
	 .Set(Special, PortMerge)
	 )
    .Add_Part(FramePart, special_stream_frame.Copy())
    .Add_Part(IconPart, merge_image)
    .Add_Part(NamePart, name.Copy())
    .Add_Part(MarkerPart, marker.Copy())
    .Add_Part(ContentsPart, icon_contents.Copy())
    ;

  MapInProto = PortProto.Create("MapInProto")
    .Set(Mode, PortOutput)
    .Set(Age,  PortOld)
    .Set(Model, PortModel.Create("MapInModel")
	 .Set(Name, "MapIn")
	 .Set(Type, PortStream)
	 .Set(Special, PortMap)
	 )
    .Add_Part(FramePart, special_stream_frame.Copy())
    .Add_Part(IconPart, map_in_image)
    .Add_Part(NamePart, name.Copy())
    .Add_Part(MarkerPart, marker.Copy())
    .Add_Part(ContentsPart, icon_contents.Copy())
    ;

  MapOutProto = PortProto.Create("MapOutProto")
    .Set(Mode, PortInput)
    .Set(Age,  PortOld)
    .Set(Model, PortModel.Create("MapOutModel")
	 .Set(Name, "MapOut")
	 .Set(Type, PortStream)
	 .Set(Special, PortMap)
	 )
    .Add_Part(FramePart, special_stream_frame.Copy())
    .Add_Part(IconPart, map_out_image)
    .Add_Part(NamePart, name.Copy())
    .Add_Part(MarkerPart, marker.Copy())
    .Add_Part(ContentsPart, icon_contents.Copy())
    ;

  /*
  NodePortProto = PortProto.Create("NodePortProto")
    .Set(Mode, PortInput)
    .Set(Model, PortModel.Create("NodePortModel")
	 .Set(Name, "Node")
	 .Set(Type, PortSingleton)
	 .Set(Special, PortNode)
	 )
    .Add_Part(FramePart, special_singleton_frame.Copy())
    .Add_Part(NamePart, node_image)
    .Add_Part(MarkerPart, marker.Copy())
    .Add_Part(ContentsPart, contents.Copy())
    ;
    */
}

// ------------------------------------------------------------
// Port Menu
// ------------------------------------------------------------

Am_Define_Method(Am_Object_Method, void, Toggle_State_Do, (Am_Object command_obj))
{
  Am_Object menu = command_obj.Get_Owner().Get_Owner();
  Am_Object target = menu.Get(TargetObj);
  target.Set(State, 1 - (int)target.Get(State));
}

Am_Define_Method(Am_Object_Method, void, Toggle_Dir_Do, (Am_Object command_obj))
{
  Am_Object menu = command_obj.Get_Owner().Get_Owner();
  Am_Object port = menu.Get(TargetObj);
  port.Set(Dir, 1 - (int)port.Get(Dir));
}

Am_Define_Method(Am_Object_Method, void, Toggle_Age_Do, (Am_Object command_obj))
{
  Am_Object menu = command_obj.Get_Owner().Get_Owner();
  Am_Object port = menu.Get(TargetObj);
  port.Set(Age, 1 - (int)port.Get(Age));
}

void initPortMenu(void)
{
  Am_Object InterfacePortMenu = PopUpMenu.Create("InterfacePortMenu")
    .Get_Part(MenuBody)
    .Set(Am_ITEMS, Am_Value_List()
	 .Add(MenuCommand.Create().Set(Am_LABEL, TargetNameForm))
	 .Add(Am_Menu_Line_Command.Create())
	 .Add(UndoZoomCmd.Create())
	 .Add(RedoZoomCmd.Create())
	 .Add(SelectiveUndoZoomCmd.Create())
	 .Add(Am_Menu_Line_Command.Create())
	 .Add(MenuCommand.Create().Set(Am_LABEL, "Left/Right").Set(Am_DO_METHOD, Toggle_Dir_Do))
	 .Add(RemoveObjectCmd.Create().Set(Am_LABEL, "Delete"))
	 )
    .Get_Owner();
  Am_Screen.Add_Part(InterfacePortMenu);

  Am_Object InterfacePortMenuPopper = PopUpMenuInteractor.Create("InterfacePortMenuPopper")
    .Set(MenuWindow, InterfacePortMenu)
    ;

  Am_Object ProcessPortMenu = PopUpMenu.Create("ProcessPortMenu")
    .Get_Part(MenuBody)
    .Set(Am_ITEMS, Am_Value_List()
	 .Add(MenuCommand.Create().Set(Am_LABEL, TargetNameForm))
	 .Add(Am_Menu_Line_Command.Create())
	 .Add(UndoZoomCmd.Create())
	 .Add(RedoZoomCmd.Create())
	 .Add(SelectiveUndoZoomCmd.Create())
	 .Add(Am_Menu_Line_Command.Create())
	 .Add(NewObjectCmd.Create().Set(Am_LABEL, AtomProto))
	 .Add(NewObjectCmd.Create().Set(Am_LABEL, MessageProto))
	 .Add(NewObjectCmd.Create().Set(Am_LABEL, InSingletonProto))
	 .Add(NewObjectCmd.Create().Set(Am_LABEL, OutSingletonProto))
	 .Add(NewObjectCmd.Create().Set(Am_LABEL, InStreamProto))
	 .Add(NewObjectCmd.Create().Set(Am_LABEL, OutStreamProto))
	 .Add(Am_Menu_Line_Command.Create())
	 .Add(MenuCommand.Create().Set(Am_LABEL, "Left/Right").Set(Am_DO_METHOD, Toggle_Dir_Do))
	 .Add(MenuCommand.Create().Set(Am_LABEL, "Open/Close").Set(Am_DO_METHOD, Toggle_State_Do))
	 .Add(Am_Menu_Line_Command.Create())
	 .Add(RemoveObjectCmd.Create().Set(Am_LABEL, "Delete"))
	 )
    .Get_Owner();
  Am_Screen.Add_Part(ProcessPortMenu);

  ProcessPortMenuPopper = PopUpMenuInteractor.Create("ProcessPortMenuPopper")
    .Set(MenuWindow, ProcessPortMenu)
    ;

  InSingletonProto.Add_Part(MenuPopper, InterfacePortMenuPopper);
  OutSingletonProto.Add_Part(MenuPopper, InterfacePortMenuPopper.Create());
  InStreamProto.Add_Part(MenuPopper, InterfacePortMenuPopper.Create());
  OutStreamProto.Add_Part(MenuPopper, InterfacePortMenuPopper.Create());
  SpecialSingletonProto.Add_Part(MenuPopper, ProcessPortMenuPopper.Create());
  SpecialStreamProto.Add_Part(MenuPopper, ProcessPortMenuPopper.Create());
  BroadSingletonProto.Add_Part(MenuPopper, ProcessPortMenuPopper.Create());
  BroadStreamProto.Add_Part(MenuPopper, ProcessPortMenuPopper.Create());
  MergeProto.Add_Part(MenuPopper, ProcessPortMenuPopper.Create());
  MapInProto.Add_Part(MenuPopper, ProcessPortMenuPopper.Create());
  MapOutProto.Add_Part(MenuPopper, ProcessPortMenuPopper.Create());
  //  NodePortProto.Add_Part(MenuPopper, PortMenuPopper.Create());

  MessageProto.Add_Part(MenuPopper, ProcessPortMenuPopper.Create());
}

// ------------------------------------------------------------
// Initialize
// ------------------------------------------------------------

void InitializePort(void)
{
  initPortProto();
  initPortMenu();
}
