// Copyright (C) 1997  Toyoda Masashi (toyoda@is.titech.ac.jp)

#include <amulet.h>
#include OBJECT_ADVANCED__H

#include "ToyWidgets.h"
#include "PovlWidgets.h"
#include "Resources.h"
#include "Module.h"
#include "Process.h"
#include "Port.h"
#include "Rule.h"
#include "Binder.h"


// ------------------------------------------------------------
// Process Prototype
// ------------------------------------------------------------

// Global objects

Am_Object PatternModel = 0;
Am_Object PatternProto = 0;
Am_Object ReplPatternProto = 0;

// ------------------------------------------------------------
// Utility Functions
// ------------------------------------------------------------

// Binder$B$N%3%T!<(B
// --------------
void pattern_copy_binders(Am_Object pattern)
{
  Am_Value_List binders = pattern.Get_Part(BindersPart).Get(Am_GRAPHICAL_PARTS);
  Am_Object copySrc = pattern.Get(Am_SOURCE_OF_COPY);
  //  cout << pattern << copySrc << endl;
  for (binders.Start(); !binders.Last(); binders.Next()) {
    Am_Object b = binders.Get();
    Am_Object src = b.Get(SrcPort);
    Am_Object des = b.Get(DestPort);
    //    Am_Object copySrc = Binder_Which_Rule(src, des);
    //    cout << b << src << des << copySrc << endl;
    Am_Value_List src_path = Obj_To_Path(src, copySrc);
    Am_Value_List des_path = Obj_To_Path(des, copySrc);
    //    cout << src_path << endl;
    //    cout << des_path << endl;
    Am_Object my_src = Path_To_Obj(pattern, src_path);
    Am_Object my_des = Path_To_Obj(pattern, des_path);
    //    cout << my_src << my_des << endl;
    b.Set(SrcPort, my_src)
     .Set(DestPort, my_des);
  }
  Am_Value_List children = pattern.Get(ProcessList);
  for (children.Start(); !children.Last(); children.Next()) {
    Am_Object c = children.Get();
    if (c.Is_Instance_Of(PatternProto)) {
      pattern_copy_binders(c);
    }
  }
}

void pattern_copy_proc_hole_link(Am_Object pattern)
{
  Am_Value_List holes = pattern.Get(HoleList);
  for (holes.Start(); !holes.Last(); holes.Next()) {
    Am_Object h = holes.Get();
    Am_Object proc = h.Get(Process);
    if (proc.Valid()) {
      Am_Object new_hole = h.Copy();
      Am_Value_List path = Obj_To_Path(proc, Parent_Rule(proc));
      Am_Object my_proc = Path_To_Obj(pattern, path);
      new_hole.Set(Process, my_proc);
      my_proc.Set(Hole, new_hole);
      if (my_proc.Is_Instance_Of(PatternProto))
	pattern_copy_proc_hole_link(my_proc);
    }
  }
}

Am_Object Pattern_Copy(Am_Object pattern)
{
  pattern.Set(Am_ACTIVE, false); // $B0l;~E*$K(BBinder$B$N%l%$%"%&%H$r$d$a$F!">C$5$l$J$$$h$&$K$9$k!#1x$$(B
  Am_Object new_pattern = Align_Zoom_Copy_Part(pattern);
  pattern_copy_proc_hole_link(new_pattern);
  pattern_copy_binders(new_pattern);
  pattern.Set(Am_ACTIVE, true);
  new_pattern.Set(Am_ACTIVE, true);
  return new_pattern;
}

// $B0lIt$,JQ2=$7$?>l9g$=$l$,GH5Z$9$kHO0O$rD4$Y$k(B
// --------------------------------------------
Am_Value_List propagate_list_iter(Am_Object root, Am_Value_List path)
{
  path.Start();
  if (path.Empty()) return Am_Value_List().Add(root);
  int type = path.Get();  path.Delete();  path.Start();
  int idx = path.Get();   path.Delete();  path.Start();
  Am_Slot_Key list_slot = 0;
  if (type == PathProcess) list_slot = ProcessList;  else
  if (type == PathHole)    list_slot = HoleList;  else  
  if (type == PathPort)    list_slot = PortList;  else
  if (type == PathValue)   list_slot = ValueList;  else
  if (type == PathBinder)  list_slot = Binders;
  else return Am_Value_List();
  Am_Value_List obj_list = root.Get(list_slot);
  if (root.Is_Instance_Of(ReplPatternProto) && (type == PathProcess || type == PathHole)) {
    Am_Value_List list = Am_Value_List();
    for (obj_list.Start(); !obj_list.Last(); obj_list.Next()) {
      Am_Object obj = obj_list.Get();
      list.Append(propagate_list_iter(obj, path));
    }
    return list;
  } else {
    return propagate_list_iter(Object_List_Get(obj_list, idx), path);    
  }  
}

Am_Value_List Change_Propagate_List(Am_Object obj)
{
  Am_Object root = Top_Pattern(obj);
  if (!root.Valid()) return Am_Value_List().Add(obj);
  Am_Value_List path = Obj_To_Path(obj, root);
  Am_Value_List list = propagate_list_iter(root, path);
  return list;
}


// ------------------------------------------------------------
// Methods
// ------------------------------------------------------------


Am_Define_Method(Copy_Method, Am_Object, New_Pattern, (Am_Object net))
{
  Am_Object new_model = net.Get_Object(Model).Create();
  Am_Object new_net = net.Create()
    .Set(Model, new_model)
    .Set(Am_WIDTH, 150)
    .Set(Am_HEIGHT, 150)
    ;
  return new_net;
}

Am_Define_Method(Copy_Method, Am_Object, New_Repl_Pattern, (Am_Object net))
{
  Am_Object new_model = net.Get_Object(Model).Create();
  Am_Object new_net = net.Create()
    .Set(Model, new_model)
    .Set(Am_WIDTH, 150)
    .Set(Am_HEIGHT, 150)
    ;
  Am_Object repl_holes = new_net.Get_Part(ContentsPart).Get_Part(ContentsPart);
  Am_Object new_hole_model = repl_holes.Get_Object(Model).Create();
  repl_holes.Set(Model, new_hole_model);
  return new_net;
}

Am_Define_Method(Copy_Method, Am_Object, Copy_Pattern, (Am_Object patt))
{
  Am_Object new_patt = Pattern_Copy(patt);
  return new_patt;
}

Am_Define_Method(Naming_Method, bool, Pattern_Rename, (Am_Object pattern, Am_String name))
{
  Am_Object module = pattern.Get(Parent);
  //  if (module.Valid())
  //    if (Member_Name(module, ProcessNameList, name)) return false;
  pattern.Get_Object(Model).Set(Name, name);
  return true;
}

Am_Define_Method(Bin_Check_Method, bool, Pattern_Check_Drop, (Am_Object source, Am_Object target))
{
  if (target.Is_Instance_Of(PatternProto)) return false; // $B1x$$!#(Bmodule$B$,A*Br$5$l$F$7$^$&$N$G!#(B
  Am_Object group = target.Get_Part(ContentsPart);
  if (source == target) return false;
  if (source.Get_Owner() == group) return false;
  if (target.Is_Part_Of(source)) return false;
  return true;
}

Am_Define_Method(Drop_Method, bool, Pattern_Drop, (Am_Object source, Am_Object target, Am_Object cmd))
{
  if (target.Is_Instance_Of(ModuleProto) || target.Is_Instance_Of(NetworkRuleProto)) {
    Am_Object group = target.Get_Part(ContentsPart);
    //  cout << "dropping " << source << " in " << source.Get_Owner() << " into " << group << endl;
    Am_Inter_Location new_loc = cmd.Get(Am_VALUE);
    Am_Inter_Location old_loc = cmd.Get(Am_OLD_VALUE);

    bool as_line;
    Am_Object nref, oref;
    int nx, ny, ox, oy, w, h;
    new_loc.Get_Location(as_line, nref, nx, ny, w, h);
    old_loc.Get_Location(as_line, oref, ox, oy, w, h);
    Am_Translate_Coordinates(nref, nx, ny, group, nx, ny);

    Am_Object copy = Pattern_Copy(source)
      .Set(Am_LEFT, nx)
      .Set(Am_TOP, ny);
    if (CALL2(target, Bin_Check_Method, AddMethod, copy)) return true;
    return false;
  } else if (target.Is_Instance_Of(HoleProto)) {
    Am_Object copy = Pattern_Copy(source);
    if (CALL2(target, Bin_Check_Method, AddMethod, copy)) return true;
    return false;
  }
}

Am_Define_Object_Formula(ReplProcParentForm)
{
  Am_Object repl_holes = self.GV_Owner();
  if (repl_holes.Valid()) {
    return repl_holes.GV(Parent);
  }
  return 0;
}

Am_Define_Method(Bin_Check_Method, bool, Pattern_Add, (Am_Object rule, Am_Object obj))
{
  Am_Slot_Key list_key;
  Am_String base_name = (Am_String)obj.Get_Object(Model).Get(Name);

  // $B$3$l$i$O(BHole$B$,4hD%$C$F2?$H$+$7$F$/$l$k!#(B
  if (obj.Is_Instance_Of(ProcessProto)) {
    rule.Get_Part(ContentsPart).Add_Part(obj);
    return true;
  }
  else if (obj.Is_Instance_Of(PatternProto)) {
    rule.Get_Part(ContentsPart).Add_Part(obj);
    return true;
  }
  // $B$3$l$i$O(Bpropagate$B$7$J$/$F$O$J$i$J$$!#(B
  if (obj.Is_Instance_Of(PortProto)) {
    list_key = PortNameList;
  }
  else if (obj.Is_Instance_Of(HoleProto)) {
    list_key = HoleNameList;
  }
  else {
    cerr << "Can't add " << obj << " to " << rule << endl;
    return false;
  }

  Am_String new_name = Next_Name(rule, list_key, base_name);
  obj.Get_Object(Model).Set(Name, new_name);
  Am_Value_List propagate_list = Change_Propagate_List(rule);

  Am_Object copy = obj;
  //  cout << propagate_list << endl;
  for (propagate_list.Start(); !propagate_list.Last(); propagate_list.Next()) {
    Am_Object h = propagate_list.Get();
    h.Get_Part(ContentsPart).Add_Part(copy);
    if (!propagate_list.Last()) copy = obj.Create();
  }
  return true;
}

Am_Define_Method(Bin_Check_Method, bool, Repl_Pattern_Add, (Am_Object rule, Am_Object obj))
{
  Am_Slot_Key list_key;
  Am_String base_name = (Am_String)obj.Get_Object(Model).Get(Name);

  // $B$3$l$i$O(BHole$B$,4hD%$C$F2?$H$+$7$F$/$l$k!#(B
  if (obj.Is_Instance_Of(ProcessProto)) {
    rule.Get_Part(ContentsPart).Get_Part(ContentsPart).Add_Part(obj.Set(Parent, ReplProcParentForm));
    return true;
  }
  else if (obj.Is_Instance_Of(PatternProto)) {
    rule.Get_Part(ContentsPart).Get_Part(ContentsPart).Add_Part(obj.Set(Parent, ReplProcParentForm));
    return true;
  }
  
  // $B$3$l$i$O(Bpropagate$B$7$J$/$F$O$J$i$J$$!#(B
  if (obj.Is_Instance_Of(PortProto)) {
    list_key = PortNameList;
  }
  else {
    cerr << "Can't add " << obj << " to " << rule << endl;
    return false;
  }

  Am_String new_name = Next_Name(rule, list_key, base_name);
  obj.Get_Object(Model).Set(Name, new_name);
  Am_Value_List propagate_list = Change_Propagate_List(rule);
  Am_Object copy = obj;
  //  cout << propagate_list << endl;
  for (propagate_list.Start(); !propagate_list.Last(); propagate_list.Next()) {
    Am_Object h = propagate_list.Get();
    h.Get_Part(ContentsPart).Add_Part(copy);
    if (!propagate_list.Last()) copy = obj.Create();
  }
  return true;
}

bool single_hole_recover(Am_Object proc)
{
  Am_Object proc_owner = proc.Get_Owner();
  proc_owner.Set(Am_ACTIVE, false);
  Am_Object hole = proc.Get(Hole);
  int cx, cy, left, top;
  Center_Of_Object(proc, cx, cy);
  Left_Top_Of_Object_By_Center(hole, cx, cy, left, top);
  proc_owner.Add_Part(hole.Set(Am_LEFT, left).Set(Am_TOP, top));
  Am_Move_Object(hole, proc);
  proc.Remove_From_Owner();
  proc_owner.Set(Am_ACTIVE, true);
  hole.Set(Process, 0);
  proc.Set(Hole, 0);
  return true;
}

Am_Define_Method(Bin_Check_Method, bool, Pattern_Remove, (Am_Object rule, Am_Object obj))
{
  if (obj.Is_Instance_Of(ProcessProto) || obj.Is_Instance_Of(PatternProto)) {
    Am_Value_List propagate_list = Change_Propagate_List(obj);
    for (propagate_list.Start(); !propagate_list.Last(); propagate_list.Next()) {
      Am_Object p = propagate_list.Get();
      single_hole_recover(p);
    }
    return true;
  }
  Am_Slot_Key list_key;
  if (obj.Is_Instance_Of(PortProto)) list_key = PortList;
  else if (obj.Is_Instance_Of(HoleProto)) list_key = HoleList;
  else return false;
  Am_Value_List propagate_list = Change_Propagate_List(rule);
  for (propagate_list.Start(); !propagate_list.Last(); propagate_list.Next()) {
    Am_Object h = propagate_list.Get();
    Am_Value_List ports = h.Get(list_key);
    for (ports.Start(); !ports.Last(); ports.Next()) {
      Am_Object pt = ports.Get();
      if ((Am_String)pt.Get_Object(Model).Get(Name) == (Am_String)obj.Get_Object(Model).Get(Name))
	pt.Remove_From_Owner();
    }
  }
  return true;
}


// ------------------------------------------------------------
// Formulas
// ------------------------------------------------------------

Am_Define_Value_List_Formula(PatternHoleListForm)
{
  Am_Value_List list = Am_Value_List();

  Am_Value_List parts = ContentsListForm(cc, self);
  if (self.Is_Instance_Of(ReplPatternProto)) {
    Am_Object conts = self.GV_Part(ContentsPart);  if (!conts.Valid()) return 0;
    parts = ContentsListForm(cc, conts);
  }
  for (parts.Start(); !parts.Last(); parts.Next()) {
    Am_Object p = parts.Get();
    if (p.Is_Instance_Of(HoleProto)) list.Add(p);
    if (p.Is_Instance_Of(ProcessProto) || p.Is_Instance_Of(PatternProto)) {
      Am_Object hole = p.GV(Hole);
      if (hole.Valid()) list.Add(hole);
    }
  }
  return list;
}
			       
Am_Define_Value_List_Formula(PatternProcessListForm)
{
  Am_Value_List list = Am_Value_List();
  Am_Value_List parts = ContentsListForm(cc, self);
  if (self.Is_Instance_Of(ReplPatternProto)) {
    Am_Object conts = self.GV_Part(ContentsPart);
    parts = ContentsListForm(cc, conts);
  }
  for (parts.Start(); !parts.Last(); parts.Next()) {
    Am_Object p = parts.Get();
    if (p.Is_Instance_Of(ProcessProto) || p.Is_Instance_Of(PatternProto)) list.Add(p);
  }
  return list;
}

// ------------------------------------------------------------
// Initialize
// ------------------------------------------------------------

void initPatternProto(void) {
  Am_Object name = EditableZoomingText.Create("PatternName")
    .Get_Part(TextPart).Set(Am_TEXT, ModelNameForm).Get_Owner()
    .Set(FontFamily, FontSansSerif)
    .Set(FontIsBold, true)
    .Set(NameHeightMax, 16)
    .Set(Am_WIDTH, Am_From_Owner(Am_WIDTH))
    .Set(Am_HEIGHT, NameHeightForm)
    ;

  Am_Object frame = Am_Border_Rectangle.Create("PatternFrame")
    .Set(Am_TOP, Bellow_Of_Sibling(NamePart))
    .Set(Am_WIDTH, Am_From_Owner(Am_WIDTH))     
    .Set(Am_HEIGHT, Am_Fill_To_Bottom)
    .Set(Am_RADIUS, 10)
    .Set(Am_THICKNESS, 1)
    .Set(Am_FILL_STYLE, Am_From_Object(PovlResources, ProcessFill))
    ;

  Am_Object contents = AlignZoomGroup.Create("PatternContents")
    .Set(propagateParent, PropagateForm)
    .Set(numberThreshold, NumberThresholdForm)
    .Set(Am_TOP,    Bellow_Of_Sibling(NamePart))
    .Set(Am_WIDTH,  Am_From_Owner(Am_WIDTH))
    .Set(Am_HEIGHT, Am_Fill_To_Bottom)
    ;

  Am_Object binders_part = PovlGroup.Create("BindersPart")
    .Set(Am_VISIBLE, SelfVisibleForm)
    .Set(Am_TOP,    Bellow_Of_Sibling(NamePart))
    .Set(Am_WIDTH, Am_From_Owner(Am_WIDTH))
    .Set(Am_HEIGHT, Am_Fill_To_Bottom)
    ;

  PatternModel = Am_Root_Object.Create("PatternModel")
    .Set(Name,	"pattern")
    .Set(Module, 0)
    .Set(Type,  NormalPattern)
    ;

  PatternProto = PovlGroup.Create("PatternProto")
    .Set(Parent, ParentForm)
    .Set(Type, ProcessGoal)
    .Set(Dir, LeftRight)
    .Set(Model, PatternModel.Create())
    .Set(Am_VISIBLE, ContentsVisibleForm)
    .Set(Am_WIDTH,  50)
    .Set(Am_HEIGHT, 40)
    .Add_Part(NamePart, name)
    .Add_Part(FramePart, frame)
    .Add_Part(ContentsPart, contents)
    .Add_Part(BindersPart, binders_part)

    .Set(PortList, InstanceListForm(PortProto))
    .Set(PortNameList, NameListForm(PortList))
    .Set(ProcessList, PatternProcessListForm)
    .Set(ProcessNameList, Am_Value_List())
    .Set(Hole, 0)
    .Set(HoleList, PatternHoleListForm)
    .Set(HoleNameList, NameListForm(HoleList))
    .Set(InnerPortList, InnerPortListForm)
    .Set(InnerPortNameList, NameListForm(InnerPortList))
    .Set(GuardList, Am_Value_List())

    .Set(NewMethod, New_Pattern)
    .Set(CopyMethod, Copy_Pattern)
    .Set(NamingMethod, Pattern_Rename)
    .Set(AddMethod, Pattern_Add)
    .Set(RemoveMethod, Pattern_Remove)
    .Set(CheckDropMethod, Pattern_Check_Drop)
    .Set(DropMethod, Pattern_Drop)
    ;

  ReplPatternProto = PatternProto.Create("ReplPatternProto")
    .Set(Model, PatternModel.Create().Set(Name, "replication").Set(Type, ReplPattern))
    .Set(Dir, LeftRight)
    .Set(NewMethod, New_Repl_Pattern)
    .Get_Part(ContentsPart)
      .Set(Dir, Am_From_Owner(Dir))
      .Add_Part(ContentsPart, ReplHolesProto
		.Set(Dir, Am_From_Owner(Dir)))
    .Get_Owner()

    .Set(AddMethod, Repl_Pattern_Add)
    ;

}

// ------------------------------------------------------------
// Pattern Menu
// ------------------------------------------------------------

Am_Define_Method(Am_Object_Method, void, Pattern_Rotate_Do, (Am_Object command_obj))
{
  Am_Object menu = command_obj.Get_Owner().Get_Owner(); // $B%a%K%e!<(B
  Am_Object target = menu.Get(TargetObj); // $BDI2C@h(B

  Am_Object holes = target.Get_Part(ContentsPart).Get_Part(ContentsPart);
  int w = holes.Get(Am_WIDTH);
  int h = holes.Get(Am_HEIGHT);
  int dir = target.Get(Dir);
  target.Set(Dir, (dir + 1) % 4);
  holes
    .Set(Am_WIDTH, h)
    .Set(Am_HEIGHT, w)
    .Set(partMoved, true)
    ;
}

void initPatternMenu(void)
{
  Am_Object PatternMenu = PopUpMenu.Create("PatternMenu")
    .Get_Part(MenuBody)
    .Set(Am_ITEMS, Am_Value_List()
	 .Add(MenuCommand.Create().Set(Am_LABEL, TargetNameForm))
	 .Add(Am_Menu_Line_Command.Create())
	 .Add(UndoZoomCmd.Create())
	 .Add(RedoZoomCmd.Create())
	 .Add(SelectiveUndoZoomCmd.Create())
	 .Add(Am_Menu_Line_Command.Create())
	 .Add(NewObjectCmd.Create().Set(Am_LABEL, HoleProto))
	 .Add(NewObjectCmd.Create().Set(Am_LABEL, SpecialSingletonProto))
	 .Add(NewObjectCmd.Create().Set(Am_LABEL, SpecialStreamProto))
	 .Add(Am_Menu_Line_Command.Create())
	 .Add(RemoveObjectCmd.Create().Set(Am_LABEL, "Delete"))
	 )
    .Get_Owner();
  Am_Screen.Add_Part(PatternMenu);

  Am_Object PatternMenuPopper = PopUpMenuInteractor.Create("PatternMenuPopper")
    .Set(MenuWindow, PatternMenu)
    ;
  PatternProto.Add_Part(PatternMenuPopper);

  Am_Object ReplPatternMenu = PopUpMenu.Create("ReplPatternMenu")
    .Get_Part(MenuBody)
    .Set(Am_ITEMS, Am_Value_List()
	 .Add(MenuCommand.Create().Set(Am_LABEL, TargetNameForm))
	 .Add(Am_Menu_Line_Command.Create())
	 .Add(UndoZoomCmd.Create())
	 .Add(RedoZoomCmd.Create())
	 .Add(SelectiveUndoZoomCmd.Create())
	 .Add(Am_Menu_Line_Command.Create())
	 .Add(NewObjectCmd.Create().Set(Am_LABEL, SpecialSingletonProto))
	 .Add(NewObjectCmd.Create().Set(Am_LABEL, SpecialStreamProto))
	 .Add(NewObjectCmd.Create().Set(Am_LABEL, BroadSingletonProto))	 
	 .Add(NewObjectCmd.Create().Set(Am_LABEL, BroadStreamProto))	 
	 .Add(NewObjectCmd.Create().Set(Am_LABEL, MergeProto))
	 .Add(NewObjectCmd.Create().Set(Am_LABEL, MapInProto))
	 .Add(NewObjectCmd.Create().Set(Am_LABEL, MapOutProto))
	 .Add(Am_Menu_Line_Command.Create())
	 .Add(MenuCommand.Create().Set(Am_LABEL, "Rotate").Set(Am_DO_METHOD, Pattern_Rotate_Do))
	 .Add(Am_Menu_Line_Command.Create())
	 .Add(RemoveObjectCmd.Create().Set(Am_LABEL, "Delete"))
	 )
    .Get_Owner();
  Am_Screen.Add_Part(ReplPatternMenu);

  Am_Object ReplPatternMenuPopper = PopUpMenuInteractor.Create("PatternMenuPopper")
    .Set(MenuWindow, ReplPatternMenu)
    ;
  ReplPatternProto.Add_Part(ReplPatternMenuPopper);

}

// ------------------------------------------------------------
// Initialize
// ------------------------------------------------------------

void InitializePattern(void)
{
  initPatternProto();
  initPatternMenu();
}
