// Copyright (C) 1997  Toyoda Masashi (toyoda@is.titech.ac.jp)

#include <amulet.h>
#include UNDO_DIALOG__H
#include <strstream.h>
#include <fstream.h>

#include "ToyWidgets.h"
#include "PovlWidgets.h"
#include "Resources.h"
#include "Rule.h"
#include "Process.h"
#include "Pattern.h"
#include "SaveLoad.h"
#include "Translator.h"

extern Am_Object UndoDialog;

// ------------------------------------------------------------
// Module Prototype
// ------------------------------------------------------------

Am_Object ModuleModel = 0;

Am_Object TopModule = 0;
Am_Object ModuleProto = 0;
Am_Object MainRuleProto = 0;

DEFINE_SLOT(SplitBarPart);

Am_Define_Formula(int, ModuleFrameHeightForm)
{
  int name_h = self.GV_Sibling(NamePart).GV(Am_HEIGHT);
  int bar_h  = self.GV_Sibling(SplitBarPart).GV(Am_HEIGHT);
  int cont_h = self.GV_Sibling(ContentsPart).GV(Am_HEIGHT);
  return name_h + bar_h + cont_h;
}

// Methods

Am_Define_Method(Copy_Method, Am_Object, New_Module, (Am_Object /* module */))
{
  Am_Object new_model = ModuleModel.Create();
  Am_Object new_module = ModuleProto.Create()
    .Set(Model, new_model)
    .Set(Am_WIDTH, 400)
    .Set(Am_HEIGHT, 400)
    ;
  return new_module;
}

Am_Define_Method(Naming_Method, bool, Module_Rename, (Am_Object module, Am_String name))
{
  Am_Object root = module.Get(Parent);
  if (root.Valid()) 
    if (Member_Name(root, ModuleNameList, name)) return false;
  module.Get_Object(Model).Set(Name, name);
  return true;
}

Am_Define_Method(Bin_Check_Method, bool, Module_Add, (Am_Object module, Am_Object obj))
{
  Am_Slot_Key list_key;
  Am_String base_name;

  if (obj.Is_Instance_Of(RuleProto)) {
    module.Get_Part(ContentsPart).Add_Part(obj);
    return true;
  }

  if (obj.Is_Instance_Of(ModuleProto)) {
    base_name = (Am_String)obj.Get_Object(Model).Get(Name);
    list_key = ModuleNameList;
  }
  else if (obj.Is_Instance_Of(ProcessProto) || obj.Is_Instance_Of(PatternProto)) {
    base_name = (Am_String)obj.Get_Object(Model).Get(Name);
    list_key = ProcPatternNameList;
    obj.Get_Object(Model).Set(Module, module); // Module $B%9%m%C%H$N%;%C%H(B
  }
  else {
    cerr << "Can't add " << obj << " to " << module << endl;
    return false;
  }

  Am_String new_name = Next_Name(module, list_key, base_name);
  CALL2(obj, Naming_Method, NamingMethod, new_name);
  module.Get_Part(ContentsPart).Add_Part(obj);
  return true;
}

Am_Define_Method(Bin_Check_Method, bool, Module_Remove, (Am_Object module, Am_Object obj))
{
  module.Get_Part(ContentsPart).Remove_Part(obj);
  // $B%W%m%;%9$N$H$-$O%k!<%k$rA4It>C$5$J$$$H$M!#(B
  return true;
}

Am_Define_Method(Bin_Check_Method, bool, Module_Check_Drop, (Am_Object source, Am_Object target))
{
  if (source == target) return false;
  if (source.Get_Owner() == target.Get_Part(ContentsPart)) return false;
  if (target.Is_Part_Of(source)) return false;
  return true;
}

Am_Define_Method(Drop_Method, bool, Module_Drop,
		 (Am_Object source, Am_Object target, Am_Object /* cmd */))
{
  //  cout << "dropping " << source << " in " << source.Get_Owner() << " into " << target.Get_Part(ContentsPart) << endl;
  source.Get_Owner().Remove_Part(source);
  //  cout << "done remove" << endl;
  target.Get_Part(ContentsPart)
    .Add_Part(source);
  //  cout << "done add" << endl;
  return true;
}

// Formulas
// --------
Am_Define_Value_List_Formula(PatternListForm)
{
  // $B%Q%?!<%s$NL>A06u4V$O$I$&$7$h$&$+$J!)(B
  // $B3,AX$r(Bflatten$B$7$?L>A0%j%9%H$G%f%K!<%/$K$9$k!#(B
}

Am_Define_Value_List_Formula(ProcPatternListForm) {
  Am_Value_List list = Am_Value_List();
  Am_Value_List procs = self.GV(ProcessList);
  Am_Value_List patts = self.GV(PatternList);
  list.Append(procs).Append(patts);
  return list;
}

void initModuleProto(void) {
  ModuleModel = Am_Root_Object.Create("ModuleModel")
    .Set(Name,	"module")
    ;

  Am_Object name = EditableZoomingText.Create("ModuleName")
    .Get_Part(TextPart).Set(Am_TEXT, ModelNameForm).Get_Owner()
    .Set(FontFamily, FontSerif)
    .Set(FontIsBold, true)
    .Set(NameHeightMax, 16)
    .Set(Am_WIDTH, Am_From_Owner(Am_WIDTH))
    .Set(Am_HEIGHT, NameHeightForm)
    ;
  
  //  Am_Object frame = Am_Border_Rectangle.Create("ModuleFrame")
  Am_Object frame = Am_Rectangle.Create("ModuleFrame")
    .Set(Am_WIDTH, Am_From_Owner(Am_WIDTH))
    .Set(Am_HEIGHT, Am_From_Owner(Am_HEIGHT))
    .Set(Am_THICKNESS, 1)
    .Set(Am_FILL_STYLE, Am_From_Object(PovlResources, ModuleFill))
    ;

  Am_Object splitBar = Am_Border_Rectangle.Create("ModuleSplitBar")
    .Set(Am_LEFT, 1)
    .Set(Am_TOP, Bellow_Of_Sibling(NamePart))
    .Set(Am_WIDTH, Am_From_Owner_Plus(Am_WIDTH, -2))
    .Set(Am_HEIGHT, 2)
    .Set(Am_THICKNESS, 2)
    .Set(Am_RAISED, false)
    .Set(Am_FILL_STYLE, Am_From_Object(PovlResources, ModuleFill))
    ;

  Am_Object titleBar = Am_Border_Rectangle.Create("ModuleTitleBar")
    .Set(Am_LEFT, 1)
    .Set(Am_TOP, 1)
    .Set(Am_WIDTH, Am_From_Owner_Plus(Am_WIDTH, -2))
    .Set(Am_HEIGHT, Am_From_Sibling_Plus(NamePart, Am_HEIGHT, -1))
    .Set(Am_THICKNESS, 2)
    .Set(Am_RAISED, true)
    .Set(Am_FILL_STYLE, Am_From_Object(PovlResources, ModuleFill))
    ;

  Am_Object contents = AlignZoomGroup.Create("ModuleContents")
    .Set(propagateParent, PropagateForm)
    .Set(numberThreshold, NumberThresholdForm)
    .Set(Am_TOP, Bellow_Of_Sibling(SplitBarPart))
    .Set(Am_WIDTH, Am_From_Owner(Am_WIDTH))
    .Set(Am_HEIGHT, Am_Fill_To_Bottom)
    .Set(maximumPercentage, 95)
    ;

  ModuleProto = PovlGroup.Create("ModuleProto")
    .Set(Model, ModuleModel)
    .Set(Parent, ParentForm)
    .Set(ProcessList, InstanceListForm(ProcessProto))
    .Set(ProcessNameList, NameListForm(ProcessList))
    .Set(PatternList, InstanceListForm(PatternProto))
    .Set(PatternNameList, NameListForm(PatternList))
    .Set(ProcPatternList, ProcPatternListForm)
    .Set(ProcPatternNameList, NameListForm(ProcPatternList))
    .Set(RuleList, InstanceListForm(RuleProto))

    .Set(Am_WIDTH, 80)
    .Set(Am_HEIGHT, 35)

    .Add_Part(FramePart, frame)
    .Add_Part(SplitBarPart, titleBar)
    .Add_Part(NamePart, name)
    //    .Add_Part(SplitBarPart, splitBar)
    .Add_Part(ContentsPart, contents)

    .Set(NewMethod, New_Module)
    .Set(AddMethod, Module_Add)
    .Set(RemoveMethod, Module_Remove)
    .Set(CheckDropMethod, Module_Check_Drop)
    .Set(DropMethod, Module_Drop)
    .Set(NamingMethod, Module_Rename)
    ;

  TopModule = ModuleProto.Create("TopModuleProto")
    .Set(ModuleList, InstanceListForm(ModuleProto))
    .Set(ModuleNameList, NameListForm(ModuleList))
    .Get_Part(NamePart).Set(Am_VISIBLE, false).Get_Owner() // dirty!
    .Get_Part(SplitBarPart).Set(Am_VISIBLE, false).Get_Owner()
    .Get_Part(ContentsPart)
      .Set(propagateParent, 0)
      .Set(numberThreshold, 50)
      .Set(Am_TOP, 0)
      .Set(Am_HEIGHT, Am_From_Owner(Am_HEIGHT))
    .Get_Owner()
    ;

  MainRuleProto = CALL1(NetworkRuleProto, Copy_Method, NewMethod)
    .Set(Process, 0)
    .Set(Model, ProcessModel.Create()
	 .Set(Name, "main")
	 .Set(Module, ModuleProto))
    ;

  ModuleProto.Get_Part(ContentsPart)
    .Add_Part(MainRule, MainRuleProto)
    ;

}

// ------------------------------------------------------------
// Module Menu
// ------------------------------------------------------------

Am_Define_Method(Am_Object_Method, void, Execute_Do, (Am_Object command_obj))
{
  Am_Object menu = command_obj.Get_Owner().Get_Owner(); // $B%a%K%e!<(B
  Am_Object module = menu.Get(TargetObj); // $BDI2C@h(B
  Am_Object top_module = module.Get(Parent);

  Execute_Module(top_module, module);

}

Am_Define_Method(Am_Object_Method, void, Save_Do, (Am_Object command_obj))
{
  Am_Object menu = command_obj.Get_Owner().Get_Owner(); // $B%a%K%e!<(B
  Am_Object module = menu.Get(TargetObj); // $BDI2C@h(B

  Save_module(module);
}


void initModuleMenu(void)
{
  Am_Object ModuleMenu = PopUpMenu.Create("ModuleMenu")
    .Get_Part(MenuBody)
    .Set(Am_ITEMS, Am_Value_List()
	 .Add(MenuCommand.Create().Set(Am_LABEL, TargetNameForm))
	 .Add(Am_Menu_Line_Command.Create())
	 .Add(UndoZoomCmd.Create())
	 .Add(RedoZoomCmd.Create())
	 .Add(SelectiveUndoZoomCmd.Create())
	 .Add(Am_Menu_Line_Command.Create())
	 .Add(MenuCommand.Create().Set(Am_LABEL, "Execute")
	      .Set(Am_DO_METHOD, Execute_Do))
	 .Add(Am_Menu_Line_Command.Create())
	 .Add(NewObjectCmd.Create().Set(Am_LABEL, ProcessProto))
	 .Add(NewObjectCmd.Create().Set(Am_LABEL, PatternProto))	      
	 .Add(NewObjectCmd.Create().Set(Am_LABEL, ReplPatternProto))
	 .Add(MenuCommand.Create().Set(Am_LABEL, "Save Module")
	      .Set(Am_DO_METHOD, Save_Do))
	 .Add(RemoveObjectCmd.Create().Set(Am_LABEL, "Delete Module"))
	 )
    .Get_Owner();
  Am_Screen.Add_Part(ModuleMenu);

  Am_Object ModuleMenuPopper = PopUpMenuInteractor.Create("ModuleMenuPopper")
    .Set(MenuWindow, ModuleMenu);
  ModuleProto.Add_Part(ModuleMenuPopper);
}

// ------------------------------------------------------------
// Initialize
// ------------------------------------------------------------

void InitializeModule(void)
{
  initModuleProto();
  initModuleMenu();
}
