// Copyright (C) 1997  Toyoda Masashi (toyoda@is.titech.ac.jp)

#include <amulet.h>
#include OBJECT_ADVANCED__H
#include FORMULA_ADVANCED__H

#include "ToyWidgets.h"

#include "Resources.h"
#include "PovlWidgets.h"
#include "Atom.h"
#include "Port.h"

// ------------------------------------------------------------
// Message
// ------------------------------------------------------------

// Message Model

Am_Object MessageModel = 0;

// Port View

Am_Object MessageProto = 0;

// Methods

Am_Define_Method(Copy_Method, Am_Object, New_Message, (Am_Object mess))
{
  Am_Object model = mess.Get(Model);
  Am_Object new_mess = mess.Create()
    .Set(Model, model.Create())
    ;
  return new_mess;
}

Am_Define_Method(Naming_Method, bool, Message_Rename, (Am_Object mess, Am_String name))
{
  mess.Get_Object(Model).Set(Name, name);
  return true;
}

Am_Define_Method(Bin_Check_Method, bool, Message_Add, (Am_Object mess, Am_Object value))
{
  if (!value.Is_Instance_Of(ValueProto)) {
    cerr << "Can't add " << value << " to " << mess << endl;
    return false;
  }
  if (value.Is_Instance_Of(PortProto)) {
    Am_String value_name = value.Get_Object(Model).Get(Name); // original name
    Am_Object rule = Parent_Rule(mess);
    Am_String new_name = value_name;
    if (rule.Valid())
      if (Member_Name(rule, InnerPortNameList, value_name)) 
	new_name = Next_Name(rule, InnerPortNameList, value_name); // change
    value.Get_Object(Model).Set(Name, new_name); // directly rename
  }
  mess.Get_Part(ContentsPart).Add_Part(value);
  return true;
}

Am_Define_Method(Bin_Check_Method, bool, Message_Remove, (Am_Object mess, Am_Object value))
{
  //  Remove_All_Binder(port);
  mess.Get_Part(ContentsPart).Remove_Part(value);
  return true;
}

// Formulas

Am_Define_String_Formula(MessageNameForm)
{
  Am_Object model = self.GV_Owner().GV_Owner().GV(Model);
  if (model.Valid()) return model.GV(Name);
  else return (Am_String)"";
}

Am_Define_Formula(int, MessageRadiusForm) {
  Am_Object model = self.GV_Owner().GV(Model);
  return (int)self.GV(Am_HEIGHT) / 2;
}

Am_Define_Formula(int, MessageContentsWidthForm)
{
  Am_Value_List values = self.GV(Am_GRAPHICAL_PARTS);
  int length = Value_Length(cc, self.Get_Owner(), 0);
  int owner_width = self.GV_Owner().GV(Am_WIDTH);
  int name_width = owner_width / (length + 1);
  int contents_width = owner_width - name_width - name_width / 8;

  self.GV_Sibling(NamePart).Set(Am_WIDTH, name_width);
  return contents_width;
}

Am_Define_Formula(int, MessageContentsLeftForm) 
{
  Am_Object name = self.GV_Sibling(NamePart);

  name.Set(Am_LEFT, 0);
  return (int)name.GV(Am_WIDTH);
}

// ------------------------------------------------------------
// Initialize
// ------------------------------------------------------------

void InitializeMessage(void)
{
  MessageModel = Am_Root_Object.Create("MessageModel")
    .Set(Name,	"message")
    .Set(Type,    PortStream)  // Port_Add_Allowed$B$K0MB8(B
    .Set(Special, PortNormal)
    ;

  Am_Object frame = Am_Roundtangle.Create("MessageFrame")
    .Set(Am_WIDTH,      Am_From_Owner(Am_WIDTH))
    .Set(Am_HEIGHT,     Am_From_Owner(Am_HEIGHT))
    .Set(Am_FILL_STYLE, Am_Motif_Light_Orange)
    .Set(Am_RADIUS,     MessageRadiusForm)
    ;

  Am_Object name = EditableZoomingText.Create("MessageName")
    .Set(Am_HEIGHT, Am_From_Owner(Am_HEIGHT))
    .Get_Part(TextPart).Set(Am_TEXT, MessageNameForm).Get_Owner()
    ;

  //  Am_Object contents = AlignZoomGroup.Create()
  Am_Object contents = PovlGroup.Create("MessageContents")
    .Set(minimumSpace, 0)
    .Set(Am_LEFT,      MessageContentsLeftForm)
    .Set(Am_WIDTH,     MessageContentsWidthForm)
    .Set(Am_HEIGHT,    Am_From_Owner(Am_HEIGHT))
    .Set(Am_LAYOUT,    PortLayoutForm)
    ;

  MessageProto = ValueProto.Create("MessageProto")
    .Set(Parent, ParentForm)
    .Set(Model, MessageModel)
    .Set(Mode,    PortOutput)  // output $B$G$J$$$HF0$+$;$J$$!%(B
    .Set(Age,     PortOld) // $BDI2C$r5v$9$?$a(BPort_Add_Allowed$B$K0MB8(B
    .Set(ValueList,  InstanceListForm(ValueProto))
    .Set(Binders, Am_Value_List()) // $B$5$F$J$s$K$D$+$&$s$G$7$g$&(B?
    .Set(Am_WIDTH, 30)
    .Set(Am_HEIGHT, 14)
    .Add_Part(FramePart, frame)
    .Add_Part(NamePart, name)
    .Add_Part(ContentsPart, contents)

    .Set(NewMethod, New_Message)
    .Set(NamingMethod, Message_Rename)
    .Set(AddMethod, Message_Add)
    .Set(RemoveMethod, Message_Remove)
    .Set(CheckDropMethod, 0)
    .Set(DropMethod, 0)
    ;
}
