// Copyright (C) 1997  Toyoda Masashi (toyoda@is.titech.ac.jp)

#include <amulet.h>

#include "ToyWidgets.h"
#include "PovlWidgets.h"
#include "Resources.h"
#include "Process.h"
#include "Rule.h"
#include "Pattern.h"
#include "Port.h"
#include "Module.h"

extern Am_Object TopWindow;

// ------------------------------------------------------------
// Binder Prototype
// ------------------------------------------------------------

// Global objects

Am_Object BinderProto = 0;

// Constants

int bind_margin = 5;

// ------------------------------------------------------------
// Utility Functions
// ------------------------------------------------------------

void Get_Correct_Modes(Am_Object src_port, Am_Object des_port, int& src_mode, int& des_mode)
{
  src_mode = src_port.Get(Mode);
  des_mode = des_port.Get(Mode);
  int src_spec = src_port.Get_Object(Model).Get(Special);
  int des_spec = des_port.Get_Object(Model).Get(Special);
  int src_side = Port_Side(src_port, des_port);
  int des_side = Port_Side(des_port, src_port);
  if (src_spec != PortNormal && src_side == PortInside && src_mode != PortUnknown) src_mode = 1- src_mode;
  if (des_spec != PortNormal && des_side == PortInside && des_mode != PortUnknown) des_mode = 1- des_mode;
}

bool Port_Unify_Allowed(Am_Object src_port, Am_Object des_port)
{
  // Valid $B%A%'%C%/(B
  if (!src_port.Valid() || !des_port.Valid()) return false;
  // $BF1$8%]!<%H$O$@$a!%(B
  if (src_port == des_port) return false;
  // $BF1$8%k!<%k$NCf$K$"$k$+$N%A%'%C%/!%(B
  if (Port_Side_Check(src_port, des_port) == PortFarAway) return false;
  // $B$9$G$K7k9g$5$l$F$$$k$+$I$&$+!%(B
  Am_Value_List binders = src_port.Get(Binders);
  for (binders.Start(); !binders.Last(); binders.Next()) {
    Am_Object b = (Am_Object)binders.Get();
    if (b.Get_Object(DestPort) == des_port) return false;
  }
  // $BF1$8%?%$%W(B(stream, single)$B$+$I$&$+$N%A%'%C%/!%(B
  int src_type = (int)src_port.Get_Object(Model).Get(Type);
  int des_type = (int)des_port.Get_Object(Model).Get(Type);
  if (src_type != des_type) return false;
  // $B%b!<%I$,@5$7$$$+$I$&$+$N%A%'%C%/!%(B
  int src_mode, des_mode;
  Get_Correct_Modes(src_port, des_port, src_mode, des_mode);
  if (src_mode == PortInput || des_mode == PortOutput) return false;
  // $B%Q%?!<%sCf$N%H%C%W%]!<%HF1;N$O7k$Y$J$$!%!J0UL#$,$J$$$+$i!)!K(B
  Am_Object src_paren = src_port.Get(Parent);
  Am_Object des_paren = des_port.Get(Parent);
  if (src_paren == des_paren && src_paren.Is_Instance_Of(PatternProto)) return false;
  // Transition Rule $B$G$O(BUnify$B$OIT2D!%(B
  if (Parent_Rule(src_port).Is_Instance_Of(TransitionRuleProto)) return false;
  // $BC10lF~NO%]!<%H$O$R$H$D$7$+<u$1<h$l$J$$!%(B
  if (des_type == PortSingleton && (Port_Is_Bound(des_port, src_port) || Port_Has_Value2(des_port, src_port))) return false;
  // $B8E$$C10l%]!<%H$K(B,$B$9$G$KCM$,F~$C$F$$$k!%(B
  int src_age = src_port.Get(Age);
  if (src_age == PortOld && src_type == PortSingleton && Port_Has_Value(src_port)) return false;
  return true;
}

void check_direction(Am_Object &src_port, Am_Object &des_port)
{
  if (!src_port.Valid() || !des_port.Valid()) return;
  int src_mode, des_mode;
  Get_Correct_Modes(src_port, des_port, src_mode, des_mode);
  if (src_mode == PortInput || des_mode == PortOutput) {
      Am_Object tmp = src_port; src_port = des_port; des_port = tmp;      
  }
}

Am_Object Binder_Which_Rule(Am_Object src_port, Am_Object des_port)
{
  if (!src_port.Valid() || !des_port.Valid()) return Am_No_Object;
  // $B3F%]!<%H$N0lHV6a$$?F%k!<%k$^$?$O%Q%?!<%s(B
  Am_Object src_net = Parent_Rule(src_port);
  Am_Object des_net = Parent_Rule(des_port);
  if (!src_net.Valid() || !des_net.Valid()) return Am_No_Object;

  Am_Object network;
  // $BF1$8%k!<%k$J$i$=$3$K0z$/!%@u$$$[$&$N%k!<%k$K@~$r0z$/!%(B
  if (src_net == des_net) network = src_net;
  else if (src_net.Get(Parent) == des_net.Get(Parent) && Is_Network(src_net)) network = src_net.Get(Parent);
  else if (src_net.Get(Parent) == des_net) network = des_net;
  else if (des_net.Get(Parent) == src_net) network = src_net;
  else return Am_No_Object;

  return network;
}

Am_Object Single_Binding_Line_Create(Am_Object src_port, Am_Object des_port)
{
  check_direction(src_port, des_port);
  if (Port_Unify_Allowed(src_port, des_port)) {
    Am_Object rule = Binder_Which_Rule(src_port, des_port);
    //    Am_Object new_line = which_line(src_port, des_port, rule);
    Am_Object new_line = BinderProto.Create()
      .Set(SrcPort, src_port)
      .Set(DestPort, des_port)
      ;
    //    line_bind(new_line, src_port, des_port);
    rule.Get_Part(BindersPart).Add_Part(new_line);
    // new$B$7$?$H$-$@$1$J$<$+(BAm_LEFT$B$,@5$7$/7W;;$5$l$J$$!#(BWeb$B$N%P%0$i$7$$!#(B
    int x1 = new_line.Get(Am_X1);
    new_line.Set(Am_X1, 0);
    new_line.Set(Am_X1, x1);

    return new_line;
  }
  return 0;
}

// ------------------------------------------------------------
// Formulas
// ------------------------------------------------------------

#define BINDER_VISIBLE 0
#define BINDER_INVISIBLE 1
#define BINDER_REMOVE 2

int mark_and_check_visibility(Am_Constraint_Context& cc, Am_Object self, Am_Object owner)
  // self is a port
  // $B$H$A$e$&$N(Bobject$B$,$_$($F$$$F(B,owner$B$^$G$?$I$j$D$1$P(Bbinder$B$b$_$($k!#(B
  // $B$?$I$j$D$/$^$($K(BParent$B$,(Binvalid$B$J$i$5$/$8$g$9$k!#(B
  // $B$H$A$e$&$N$*$V$8$'$/$H$,$_$($J$$$H$-$O(Bbinder$B$r$+$/$9!#(B
{
  Am_Object pivot = self;
  Am_Object prev = self;
  int visible = BINDER_VISIBLE;
  // $B?F$^$?$O!"(BAm_Screen$B$K$?$I$jCe$$$?>l9g!"8+$($k!#(B
  while (pivot != owner) {
    // pivot$B$,(Binvalid, $B$^$?$O(BParent slot$B$,$J$$$H$-$O(BREMOVE
    if (!pivot.Valid()) {
      //      cerr << "REMOVE: pivot is invalid, self: " << self << " owner: " << owner << "prev: " << prev << endl;
      return BINDER_REMOVE;
    }
    if (pivot.Get_Slot_Type(Parent) == Am_NONE) return BINDER_REMOVE;
    // $B$5$$$1$$$5$s$,$*$3$k$h$&%^!<%/$9$k!#(B
    pivot.GV(Am_LEFT);   pivot.GV(Am_TOP);
    pivot.GV(Am_WIDTH);  pivot.GV(Am_HEIGHT);
    // pivot$B$,$_$($J$$$N$G$+$/$9(B
    if (pivot.GV(Am_VISIBLE) == false) visible = BINDER_INVISIBLE;
    // Hole$B$N>l9g$O%W%m%;%9$,BeF~$5$l$F$$$k$H$-$O>C$9!#(B
    if (pivot.Is_Instance_Of(HoleProto)) {
      if (pivot.GV(Process).Valid()) visible = BINDER_INVISIBLE;
    }
    prev = pivot;
    pivot = pivot.GV(Parent); // $B$J$<(BGet?
  }
  return visible;
}

Am_Define_Formula(bool, BinderLayout) {
  // src port $B$H(Bdestination port
  Am_Object src = self.GV(SrcPort);
  Am_Object des = self.GV(DestPort);

  // BindersPart$B$NI}!"9b$5$,JQ$o$C$?$i:F7W;;(B
  Am_Object binders_part = self.GV_Owner();
  if (!binders_part.Valid()) return false;
  binders_part.GV(Am_WIDTH);
  binders_part.GV(Am_HEIGHT); 

  Am_Object owner = binders_part.GV_Owner();
  if ((bool)owner.GV(Am_ACTIVE) == false) return false;

  int src_visible = mark_and_check_visibility(cc, src, owner);
  int des_visible = mark_and_check_visibility(cc, des, owner);
  if (src_visible == BINDER_INVISIBLE || des_visible == BINDER_INVISIBLE) return false;
  if (src_visible == BINDER_REMOVE || des_visible == BINDER_REMOVE) {
    cout << "----- Binder Removed -----" << self << "------------" << endl;
    self.Remove_From_Owner();
    return false;
  }
  // port$B$,8+$($J$$$H$-$O?F$N%U%l!<%`$K9g$o$;$k!#8+$($k$H$-$OL>A0$K9g$o$;$k!#(B
  Am_Object src_base = 0;
  Am_Object des_base = 0;
  if ((bool)src.GV_Owner().GV(Am_VISIBLE))
       src_base = src.GV_Part(NamePart);
  else src_base = src.GV_Object(Parent).GV_Part(FramePart);
  if ((bool)des.GV_Owner().GV(Am_VISIBLE))
       des_base = des.GV_Part(NamePart);
  else des_base = des.GV_Object(Parent).GV_Part(FramePart);

  //  src_base.GV(Am_LEFT); src_base.GV(Am_TOP);
  //  des_base.GV(Am_LEFT); des_base.GV(Am_TOP);

  int src_x, src_y, des_x, des_y;
  Am_Translate_Coordinates(src_base, 0, 0, binders_part, src_x, src_y);
  Am_Translate_Coordinates(des_base, 0, 0, binders_part, des_x, des_y);

  int src_w = src_base.GV(Am_WIDTH);
  int src_h = src_base.GV(Am_HEIGHT);
  int des_w = des_base.GV(Am_WIDTH);
  int des_h = des_base.GV(Am_HEIGHT);

  int x1 = src_x + (src_w / 2);
  int y1 = src_y + (src_h / 2);
  int r1 = imin(src_h, src_w);
  if (des_x + des_w < src_x) x1 = src_x + r1 / 6; 
  if (src_x + src_w < des_x) x1 = src_x + src_w - r1 / 6;
  if (des_y + des_h < src_y) y1 = src_y + r1 / 6;
  if (src_y + src_h < des_y) y1 = src_y + src_h - r1 / 6;

  int x2 = des_x + (des_w / 2);
  int y2 = des_y + (des_h / 2);
  int r2 = imin(des_h, des_w);
  if (src_x + src_w < des_x) x2 = des_x + r2 / 6;
  if (des_x + des_w < src_x) x2 = des_x + des_w - r2 / 6;
  if (src_y + src_h < des_y) y2 = des_y + r2 / 6;
  if (des_y + des_h < src_y) y2 = des_y + des_h - r2 / 6;

  self.Set(Am_X1, x1);
  self.Set(Am_X2, x2);
  self.Set(Am_Y1, y1);
  self.Set(Am_Y2, y2);
  return true;
}

// ------------------------------------------------------------
// Methods
// ------------------------------------------------------------


Am_Define_Method(Am_Where_Method, Am_Object, In_Port,
		 (Am_Object /* inter */, Am_Object /* object */, Am_Object event_window,
		  Am_Input_Char /* ic */, int x, int y))
{
  Am_Object port = Content_Instance_Of(event_window, x, y, event_window,
				       Am_Value_List().Add(PortProto));
  if (port.Valid()) return port;
  return Am_No_Object;
}

Am_Define_Method(Am_Create_New_Object_Method, Am_Object, New_Binder_Do,
		 (Am_Object inter, Am_Inter_Location location, Am_Object /* old_object */ ))
{
  Am_Object window = inter.Get(Am_WINDOW);
  bool as_line;
  Am_Object ref;
  int x1, y1, x2, y2;
  location.Get_Location(as_line, ref, x1, y1, x2, y2);
  Am_Object src = Content_Instance_Of(window, x1, y1, ref, Am_Value_List().Add(PortProto));
  Am_Object des = Content_Instance_Of(window, x2, y2, ref, Am_Value_List().Add(PortProto));
  //  cout << src << des << endl;
  if (!src.Valid() || !des.Valid()) return Am_No_Object;
  return Single_Binding_Line_Create(src, des);
}


void initBinderProto(void)
{
  BinderProto = Am_Arrow.Create("BinderProto")
    .Set(Am_ARROW_H_WIDTH, 10)
    .Set(Am_ARROW_H_HEIGHT, 15)
    .Set(Am_ARROW_WIDTH, 3)
    .Set(Am_LINE_STYLE, Am_Style(0, 0, 0, 3, Am_CAP_BUTT, Am_JOIN_MITER,
				 Am_LINE_SOLID, Am_DEFAULT_DASH_LIST,
				 Am_DEFAULT_DASH_LIST_LENGTH,
				 Am_FILL_STIPPLED, Am_FILL_POLY_EVEN_ODD,
				 Am_Image_Array(50)))
    .Set(Am_FILL_STYLE, Am_Gray_Stipple)
    .Set(Am_VISIBLE, BinderLayout)
    ;

  Am_Object BinderFeedback = Am_Line.Create("BinderFeedback")
    ;

  Am_Object PortBinder = Am_New_Points_Interactor.Create("PortBinder")
    .Set(Am_AS_LINE, true)
    .Set(Am_PRIORITY, 4)
    .Set(Am_START_WHERE_TEST, In_Port)
    .Set(Am_START_WHEN, "MIDDLE_DOWN")
    .Set(Am_FEEDBACK_OBJECT, BinderFeedback)
    .Set(Am_CREATE_NEW_OBJECT_METHOD, New_Binder_Do)
    ;

  TopWindow.Add_Part(PortBinder)
    .Add_Part(BinderFeedback)
    ;
}

// ------------------------------------------------------------
// Binder Menu
// ------------------------------------------------------------

Am_Define_Method(Am_Object_Method, void, Delete_Binder_Do, (Am_Object command_obj))
{
  Am_Object menu = command_obj.Get_Owner().Get_Owner();
  Am_Object target = menu.Get(TargetObj);
  target.Remove_From_Owner();
}

void initBinderMenu(void)
{
  Am_Object BinderMenu = PopUpMenu.Create("BinderMenu")
    .Get_Part(MenuBody)
    .Set(Am_ITEMS, Am_Value_List()
	 .Add(MenuCommand.Create().Set(Am_LABEL, "Binder"))
	 .Add(Am_Menu_Line_Command.Create())
	 .Add(MenuCommand.Create().Set(Am_LABEL, "Delete").Set(Am_DO_METHOD, Delete_Binder_Do))
	 )
    .Get_Owner();
  Am_Screen.Add_Part(BinderMenu);

  Am_Object BinderMenuPopper = PopUpMenuInteractor.Create("BinderMenuPopper")
    .Set(MenuWindow, BinderMenu)
    ;
  BinderProto.Add_Part(BinderMenuPopper);
}

// ------------------------------------------------------------
// Initialize
// ------------------------------------------------------------

void InitializeBinder(void)
{

  initBinderProto();
  initBinderMenu();
}
