// Copyright (C) 1997  Toyoda Masashi (toyoda@is.titech.ac.jp)

#include <amulet.h>
#include OBJECT_ADVANCED__H

#include "ToyWidgets.h"
#include "PovlWidgets.h"
#include "Resources.h"
#include "Port.h"
#include "Atom.h"

// ------------------------------------------------------------
// Process Prototype
// ------------------------------------------------------------

// Global objects

Am_Object AtomModel = 0;
Am_Object AtomProto = 0;

Am_Define_String_Formula(AtomNameForm)
{
  Am_Object model = self.GV_Owner().GV_Owner().GV(Model);
  if (model.Valid()) return model.GV(Name);
  else return (Am_String)"";
}

Am_Define_Method(Copy_Method, Am_Object, Copy_Atom, (Am_Object atom))
{
  Am_Object model = atom.Get(Model);
  Am_Object new_atom = atom.Create()
    .Set(Model, model.Create());
  return new_atom;
}

Am_Define_Method(Naming_Method, bool, Atom_Rename, (Am_Object atom, Am_String name))
{
  atom.Get_Object(Model).Set(Name, name);
  return true;
}

/*
Am_Define_Method(Bin_Check_Method, bool, Atom_Check_Drop, (Am_Object source, Am_Object target))
{
  if (Port_Move_Allowed(source, target)) return true;
  else return false;
}
*/

void initAtomProto(void)
{
  AtomModel = Am_Root_Object.Create("AtomModel")
    .Set(Name, "0")
    .Set(Type, PortSingleton)
    .Set(Special, PortNormal)
    ;

  Am_Object frame = Am_Rectangle.Create("AtomFrame")
    .Set(Am_WIDTH, Am_From_Owner(Am_WIDTH))
    .Set(Am_HEIGHT, Am_From_Owner(Am_HEIGHT))
    .Set(Am_FILL_STYLE, Am_White)
    ;

  Am_Object name = EditableZoomingText.Create("AtomContent")
    .Get_Part(TextPart).Set(Am_TEXT, AtomNameForm).Get_Owner()
    .Set(Am_WIDTH, Am_From_Owner(Am_WIDTH))
    .Set(Am_HEIGHT, Am_From_Owner(Am_HEIGHT))
    ;

  AtomProto = ValueProto.Create("AtomProto")
    .Set(Model, AtomModel)
    .Set(Parent, ParentForm)
    .Set(Mode, PortInput) // $B$J$<(BInput$B$K$7$F$"$k$N$@$m$&(B?
    .Set(Age,  PortNew)
    .Set(Am_WIDTH, 20)
    .Set(Am_HEIGHT, 20)
    .Add_Part(FramePart, frame)
    .Add_Part(NamePart, name)

    .Set(NewMethod, Copy_Atom)
    .Set(NamingMethod, Atom_Rename)
    .Set(CheckDropMethod, 0)
    .Set(DropMethod, 0)
    ;
}

// ------------------------------------------------------------
// Atom Menu
// ------------------------------------------------------------

void initAtomMenu(void)
{
  Am_Object AtomMenu = PopUpMenu.Create("AtomMenu")
    .Get_Part(MenuBody)
    .Set(Am_ITEMS, Am_Value_List()
	 .Add(MenuCommand.Create().Set(Am_LABEL, "Atom"))
	 .Add(Am_Menu_Line_Command.Create())
	 .Add(RemoveObjectCmd.Create().Set(Am_LABEL, "Delete"))
	 )
    .Get_Owner();
  Am_Screen.Add_Part(AtomMenu);

  Am_Object AtomMenuPopper = PopUpMenuInteractor.Create("AtomMenuPopper")
    .Set(MenuWindow, AtomMenu)
    ;
  AtomProto.Add_Part(AtomMenuPopper);
}

// ------------------------------------------------------------
// Initialize
// ------------------------------------------------------------

void InitializeAtom(void)
{
  initAtomProto();
  initAtomMenu();
}

