/*
 * Copyright (C) 1997 Hidemoto Nakada, Yoshiki Kinoshita, Koichi Takahashi
 */
import java.util.Vector;
import java.lang.Cloneable;

public class Set implements Cloneable{
  Vector v;
  public Set(){v = new Vector();}
  public Set(Vector v0){
    v = v0;
  }
  
  public synchronized Object clone() {
    return new Set((Vector) v.clone());
  }

  public void addElement(Object o){
    if (! v.contains(o))
      v.addElement(o);
  }

  public int indexOf(Object o){
    return v.indexOf(o);
  }

  public int size(){
    return v.size();
  }

  public Set addAll(Vector v2){
    int size = v2.size();
    for (int i = 0; i < size; i++)
      addElement(v2.elementAt(i));
    return this;
  }

  public Set addAll(Set s){
    int size = s.size();
    for (int i = 0; i < size; i++)
      addElement(s.elementAt(i));
    return this;
  }

  public boolean contains(Object o){
    return v.contains(o);
  }

  public Object elementAt(int i){
    return v.elementAt(i);
  }

  public void setElementAt(Object o, int i){
    v.setElementAt(o,i);
  }

  public void removeElementAt(int i){
    v.removeElementAt(i);
  }

  public boolean removeElement(Object o){
    return v.removeElement(o);
  }

  public int nextIndex(int i){
    i++;
    if (i >= v.size())
      i = 0;
    return i;
  }


  public int previousIndex(int i){
    i--;
    if (i < 0)
      i = v.size() - 1;
    return i;
  }
  public Object elementAt(int i, int diff){
    int index = (i + diff) % size();
    if (index < 0) index +=  size();
    return elementAt(index);
  }
  public Object elementNext(int i){
    return elementAt(nextIndex(i));
  }
  public Object elementPrevious(int i){
    return elementAt(previousIndex(i));
  }
  public Object elementLast(){
    if (size() == 0) return null;
    return elementAt(size() - 1);
  }
  
  public Set removeAll(Set s){
    int size = s.size();
    for (int i = 0; i < size; i++)
      removeElement(s.elementAt(i));
    return this;
  }

  public String toString(){
    String tmp = "Set [";
    for (int i = 0; i < v.size(); i++)
      tmp = tmp + " " + v.elementAt(i);
    tmp = tmp + " ]";
    return tmp;
  }

  public boolean replace(Object a, Object b){
    int i = indexOf(a);
    if (i < 0)
      return false;
    setElementAt(b, i);
    return true;
  }


  public boolean compareByName(Set other){
    if (this.size() != other.size())
      return false;
    for (int i = 0; i < this.size(); i++){
      Namable a = (Namable)this.elementAt(i);
      boolean flag = false;
      for (int j = 0; j < other.size(); j++){
	Namable b = (Namable)other.elementAt(j);
	if (a.compareByName(b)){
	  flag = true;
	  break;
	}
      }
      if (!flag)
	return false;
    }
    return true;
  }
  public boolean compareSerialByName(Set other){
    if (this.size() != other.size())
      return false;
    for (int i = 0; i < this.size(); i++){
      Namable a = (Namable)this.elementAt(i);
      Namable b = (Namable)other.elementAt(i);
      if (!a.compareByName(b))
	return false;
    }
    return true;
  }

  public boolean compare(Set other){
    if (this.size() != other.size())
      return false;
    for (int i = 0; i < this.size(); i++){
      Object a = (Object)this.elementAt(i);
      boolean flag = false;
      for (int j = 0; j < other.size(); j++){
	Object b = (Object)other.elementAt(j);
	if (a == b){
	  flag = true;
	  break;
	}
      }
      if (!flag)
	return false;
    }
    return true;
  }

  public Set removeAllByName(Set other){
    Set newone = (Set)this.clone();
    for (int i = 0; i < newone.size(); i++){
      Namable a = (Namable)newone.elementAt(i);
      for (int j = 0; j < other.size(); j++){
	Namable b = (Namable)other.elementAt(j);
	if (a.compareByName(b)){
	  this.removeElement(a);
	  break;
	}
      }
    }
    return this;
  }

  public Set andByName(Set other){
    Set newone = new Set();
    for (int i = 0; i < this.size(); i++){
      Namable a = (Namable)this.elementAt(i);
      for (int j = 0; j < other.size(); j++){
	Namable b = (Namable)other.elementAt(j);
	if (a.compareByName(b)){
	  newone.addElement(a);
	  break;
	}
      }
    }
    return newone;
  }

  public Set andByObj(Set other){
    Set newone = new Set();
    for (int i = 0; i < this.size(); i++){
      Object a = this.elementAt(i);
      for (int j = 0; j < other.size(); j++){
	Object b = other.elementAt(j);
	if (a == b){
	  newone.addElement(a);
	  break;
	}
      }
    }
    return newone;
  }

  public Namable getSameNameOne(Namable b){
    for (int i = 0; i < this.size(); i++){
      Namable a = (Namable)this.elementAt(i);
      if (a.compareByName(b))
	return a;
    }
    return null;
  }

  public Set getSameNameSet(Namable b){
    Set ans = new Set();
    for (int i = 0; i < this.size(); i++){
      Namable a = (Namable)this.elementAt(i);
      if (a.compareByName(b))
	ans.addElement(a);
    }
    return ans;
  }

  public boolean containsByName(Namable b){
    for (int i = 0; i < this.size(); i++){
      Namable a = (Namable)this.elementAt(i);
      if (a.compareByName(b))
	return true;
    }
    return false;
  }
}
