/*
 * Copyright (C) 1997 Hidemoto Nakada, Yoshiki Kinoshita, Koichi Takahashi
 */
import java.lang.*;



class Rewinder implements Runnable {
  int startx;
  int starty;
  int endx;
  int endy;
  int div;
  int mil;
  DrawPanel p;
  Thread current;

  public Rewinder(int startx, int starty, int endx, int endy, int div, int mil, DrawPanel p){
    this.startx = startx;
    this.starty = starty;
    this.endx = endx;
    this.endy = endy;
    this.div = div;
    this.mil = mil;
    this.p = p;
    current = new Thread(this);
    current.start();
  }

  public void run(){
    double divx = (endx - startx)/(double)div;
    double divy = (endy - starty)/(double)div;
    for (int i = 0; i < div; i++){
      p.rewindHypoSub(startx + (int)(divx * i), starty + (int)(divy * i));
      try{
	Thread.currentThread().sleep(mil);
      } catch(Exception e){}
    }
    p.currentHypo = null;
    p.repaint();
  }
}
