/*
 * Copyright (C) 1997 Hidemoto Nakada, Yoshiki Kinoshita, Koichi Takahashi
 */
import java.lang.*;

class RewindTick implements Tickable {
  int startx;
  int starty;
  int endx;
  int endy;
  int div;
  int mil;
  DrawPanel p;
  double divx, divy;
  LoopPutable lp;

  public RewindTick(int startx, int starty, int endx, int endy, int div, DrawPanel p, Loop l){
    this.startx = startx;
    this.starty = starty;
    this.endx = endx;
    this.endy = endy;
    this.div = div;
    this.p = p;
    divx = (endx - startx)/(double)(div);
    divy = (endy - starty)/(double)(div);
    lp =  new LoopPutable(l, 0, 0);
  }

  public void tick(int i){
//    p.rewindHypoSub(startx + (int)(divx * i), starty + (int)(divy * i));
    p.addVolatile(lp.setLocation(startx +(int)(divx * i) - endx, 
				 starty +(int)(divy * i) - endy));
    p.repaint();      
  }

  public void last(){
    p.removeVolatile(lp);
    p.repaint();
  }
}
