/*
 * Copyright (C) 1997 Hidemoto Nakada, Yoshiki Kinoshita, Koichi Takahashi
 */

public class Path{
  Set arcs;

  public Path(Set arcs){
    this.arcs = arcs;
  }

  public Path copy(Set nodes){
    Set narcs = new Set();

    for (int i = 0; i < arcs.size(); i++){
      Node start = (Node)nodes.elementAt(i);
      Node end   = (Node)nodes.elementAt(i+1);
      Arc narc = ((Arc)arcs.elementAt(i)).copy(start, end);
      narcs.addElement(narc);
    }
    return new Path(narcs);
  }
  public int size(){
    return arcs.size();
  }

  public Arc elementAt(int i){
    return (Arc)arcs.elementAt(i);
  }
  public Arc elementLast(){
    return (Arc)arcs.elementLast();
  }

  public boolean replace(Object a, Object b){
    return arcs.replace(a, b);
  }



  public boolean compareByName(Path p){
    if (p.arcs.size() != arcs.size())
      return false;
    for (int i = 0; i < p.arcs.size(); i++){
      try{
	Arc one = (Arc)arcs.elementAt(i);
	Arc pone = (Arc)p.arcs.elementAt(i);
	if (!one.compareByName(pone))
	  return false;
      } catch (Exception e){
	return false;
      }
    }
    return true;
  }

  Path tracePath(Arc a, Path p){
    Set tmp = new Set();
    int off = arcs.indexOf(a);
    for (int i = 0; i < p.arcs.size(); i++){
      try{
	Arc one = (Arc)arcs.elementAt(i+off);
	Arc pone = (Arc)p.arcs.elementAt(i);
	if (one.compareByName(pone))
	  tmp.addElement(one);
	else 
	  return null;
      } catch (Exception e){
	return null;
      }
    }
    return new Path(tmp);
  }

  public Set getMatches(Path p){
    Set answer = new Set();
    Set sarcs = p.arcs;
    Arc first = (Arc)sarcs.elementAt(0);
    Set matchFirst = arcs.getSameNameSet(first);
    for (int i = 0; i < matchFirst.size(); i++){
      Path tmp = tracePath((Arc)matchFirst.elementAt(i), p);
      if (tmp != null)
	answer.addElement(new Pair(tmp, p));
    }
    return answer;
  }

  public Node start() {
    return ((Arc)arcs.elementAt(0)).start;
  }
  public Node end() {
    return ((Arc)arcs.elementAt(arcs.size() - 1)).end;
  }
  public int len(){
    return arcs.size();
  }

  public Set getNodes() {
    Set tmp = new Set();
    for (int i = 0; i < arcs.size(); i++){
      Arc a = (Arc)arcs.elementAt(i);
      tmp.addElement(a.start);
      tmp.addElement(a.end);
    }    
    return tmp;
  }

  public Set getMidNodes() {
    Set tmp = new Set();
    if (arcs.size() <= 1)
      return new Set();
    for (int i = 0; i < arcs.size() - 1; i++){
      Arc a = (Arc)arcs.elementAt(i);
      tmp.addElement(a.end);
    }    
    return tmp;
  }

  public String toString(){
    String tmp = "path: [";
    for (int i = 0; i < arcs.size(); i++){
      tmp = tmp + ((Arc)arcs.elementAt(i)).toString() + " ";
    }
    return tmp + "]" ;
  }
}
