/*
 * Copyright (C) 1997 Hidemoto Nakada, Yoshiki Kinoshita, Koichi Takahashi
 */
import java.awt.*;
import java.lang.Math;
import java.util.Hashtable;

class Node implements Namable{
  public Set arcs = new Set();
  public int x, y;
  public String name;
  public static Font font = new Font("Helvetica", Font.PLAIN, 24);

  static int num = 0; 

  int width = 5;
  int height = 5;

  public Color col = Color.black;

  public Node(int x0, int y0){
    this(x0, y0, Color.black);
  }
  public Node(int x0, int y0, Color col0){
    this(x0, y0, col0, null);
  }
  public Node(int x0, int y0, Color col0, String name0){
    x = x0; y = y0; col = col0;
    if (name0 == null)
      autoName();
    else
      name = name0;
  }


  public Node copy(MyPoint mp){
    Node tmp = new Node(mp.x, mp.y, col, name);
    return tmp;
  }

  public Node copy(int x0, int y0){
    Node tmp = new Node(x0, y0, col, name);
    return tmp;
  }

  public Node movecopy(int x0, int y0, Hashtable ht){
    if (ht.containsKey(this))
      return (Node)ht.get(this);
    Node tmp = new Node(this.x + x0, this.y + y0, col, name);
    ht.put(this, tmp);
    for (int i = 0; i < arcs.size(); i++)
      tmp.arcs.addElement(((Arc)arcs.elementAt(i)).movecopy(x0, y0, ht));
    return tmp;
  }

  public static void initNum(){
    num = 0;
  }

  public void setColor(Color col0){
    col = col0;
  }

  public void autoName(){
//    name = "n"+(new Integer(num)).toString();
    name = "";
    num++;
  }
  
  public void replaceMe(Arc a, Arc b){
    arcs.removeElement(a);
    arcs.addElement(b);
  }

  public void replace(Node n){
    for (int i = 0; i < arcs.size(); i++){
      ((Arc)arcs.elementAt(i)).replace(this, n);
    }
  }

  public void name(String n){
    name = n;
  }
  public String getName(){
    return name;
  }

  public boolean compareByName(Namable n){
    if (name.compareTo(n.getName()) == 0)
      return true;
    return false;
  }

  public boolean isSource(Set loopArcs){
    int counter = 0;
    for (int i = 0; i < arcs.size(); i++){
      Arc a = (Arc)arcs.elementAt(i);
	if (loopArcs.contains(a))
	  if (a.amIstart(this))
	    counter++;
    }
    if (counter == 2){
      return true;
    }
    return false;
  }
  public boolean isSink(Set loopArcs){
    int counter = 0;
    for (int i = 0; i < arcs.size(); i++){
      Arc a = (Arc)arcs.elementAt(i);
	if (loopArcs.contains(a))
	  if (a.amIstart(this))
	    counter++;
    }
    if (counter == 0){
      return true;
    }
    return false;
  }

  public Arc getNearestArc(double min, int x, int y) {
    int np = arcs.size();
    Arc tmpArc = null;
    
    for (int i = 0; i < np; i++){
      Arc cArc = (Arc)arcs.elementAt(i);
      double dist = cArc.distance(x, y);
      if (dist < min){
	min = dist;
	tmpArc = cArc;
      }
    }
    return tmpArc;
  }

  public MyPoint point(){
    return new MyPoint(x, y);
  }

  public double distance(Node n){
    return distance(n.x, n.y);
  }

  public double distance(int x0, int y0){
    return Math.sqrt((x - x0) * (x - x0) + (y - y0) * (y - y0));
  }

  public String toString(){
    if (name != null)
      return name;

    return "Node:"+ x + ", " + y;
  }

  public void addArc(Arc a){
    arcs.addElement(a);
  }

  public Set trace(){
    Set tmp = new Set();
    this.trace(tmp);
    return tmp;
  }
  public void trace(Set s){
    if (s.contains(this))
      return;
    s.addElement(this);
    int np = arcs.size();
    for (int i = 0; i < np; i++)
      ((Arc)arcs.elementAt(i)).myBuddy(this).trace(s);
  }

  public void removeArc(Arc a){
    arcs.removeElement(a);
  }

  public void move(int x0, int y0){
    x += x0;
    y += y0;
    int np = arcs.size();
    for (int i = 0; i < np; i++){
      Arc tmpArc = ((Arc)arcs.elementAt(i));
      if (tmpArc.amIstart(this))
	tmpArc.move(x0, y0);
    }
  }

  public void reshape(int x0, int y0){
    x += x0;
    y += y0;
    int np = arcs.size();
    for (int i = 0; i < np; i++){
      Arc tmpArc = ((Arc)arcs.elementAt(i));
      tmpArc.reshape();
    }
  }

  public void paint(Graphics g){
    paintThis(g);
    int np = arcs.size();
    for (int i = 0; i < np; i++)
      ((Arc)arcs.elementAt(i)).paint(g, this);
  }

  public void paintThis(Graphics g){
    g.setFont(font);
    g.setColor(col);
    g.fillRect(x - width /2, y - height/2, width, height);
    if (name != null)
      g.drawString(name, x + 10, y + 10);
  }

}
