/*
 * Copyright (C) 1997 Hidemoto Nakada, Yoshiki Kinoshita, Koichi Takahashi
 */

class MyPoint {
  public int x, y;
  MyPoint(int x, int y){
    this.x = x;
    this.y = y;
  }

  public MyPoint getDivide(MyPoint n, double l){
    double dist = distance(n);
    double tx = (l/dist) * (n.x - x) + x;
    double ty = (l/dist) * (n.y - y) + y;
    return new MyPoint((int)tx,(int)ty);
  }

  public void move(int x0, int y0){
    x+=x0; y+=y0;
  }

  public double distance(MyPoint n){
    return distance(n.x, n.y);
  }

  public double distance(int x0, int y0){
    return Math.sqrt((x - x0) * (x - x0) + (y - y0) * (y - y0));
  }
}
