/*
 * Copyright (C) 1997 Hidemoto Nakada, Yoshiki Kinoshita, Koichi Takahashi
 */
import java.util.StringTokenizer;
import java.lang.Integer;

/* 
   target syntax: node(x, y), line(x, y, x, y); init(); cell(x,y); goal(x,y);
   prove(x, y, x, y, div); linen(x, y, x, y, div); remove(x,y);
*/
class MyParser{
  public DrawPanel dp;
  public MyParser(DrawPanel dp){
    this.dp = dp;
  }

  public Set parseString(String str){
    System.err.println("str");
    Set ans = new Set();
    StringTokenizer st = new StringTokenizer(str, " \n\t(),;");
    while (st.hasMoreTokens()){
      String command = st.nextToken();
      DummyEvent e;
      if (command.equalsIgnoreCase("node")){
	getNode(st, ans);
      } else if (command.equalsIgnoreCase("line")){
	getLine(st, ans);
      } else if (command.equalsIgnoreCase("remove")){
	getRemove(st, ans);
      } else if (command.equalsIgnoreCase("linen")){
	getLineN(st, ans);
      } else if (command.equalsIgnoreCase("cell")){
	getCell(st, ans);
      } else if (command.equalsIgnoreCase("goal")){
	getGoal(st, ans);
      } else if (command.equalsIgnoreCase("prove")){
	getProve(st, ans);
      } else if (command.equalsIgnoreCase("init")){
	getInit(st, ans);
      } else if (command.equalsIgnoreCase("wait")){
	getWait(st, ans);
      } else if (command.equalsIgnoreCase("reshape")){
	getReshape(st, ans);
      } else if (command.equalsIgnoreCase("clear")){
	getClear(st, ans);
      } else if (command.equalsIgnoreCase("move")){
	getMove(st, ans);
      } else {
	System.err.println("Syntax error in parseString, near " + command);
	break;
      }
    }
    return (ans);
  }
  void getInit(StringTokenizer st, Set s){
    s.addElement(new DummyEvent(DummyEvent.DOWN, DrawPanel.INIT, 0, 0, dp));
  }
  void getWait(StringTokenizer st, Set s){
    int c = Integer.parseInt(st.nextToken());
    for (int i = 0; i < c; i++){
      s.addElement(new DummyEvent(DummyEvent.DOWN, -1, 0, 0, dp));
    }
  }
  void getClear(StringTokenizer st, Set s){
    s.addElement(new DummyEvent(DummyEvent.DOWN, DrawPanel.CLEAR, 0, 0, dp));
  }
  void getNode(StringTokenizer st, Set s){
    int x = Integer.parseInt(st.nextToken());
    int y = Integer.parseInt(st.nextToken());
    s.addElement(new DummyEvent(DummyEvent.DOWN, DrawPanel.NODES, x, y, dp));
  }
  void getRemove(StringTokenizer st, Set s){
    int x = Integer.parseInt(st.nextToken());
    int y = Integer.parseInt(st.nextToken());
    s.addElement(new DummyEvent(DummyEvent.DOWN, DrawPanel.REMOVE, x, y, dp));
  }
  void getCell(StringTokenizer st, Set s){
    int x = Integer.parseInt(st.nextToken());
    int y = Integer.parseInt(st.nextToken());
    s.addElement(new DummyEvent(DummyEvent.DOWN, DrawPanel.MENSO, x, y, dp));
  }
  void getGoal(StringTokenizer st, Set s){
    int x = Integer.parseInt(st.nextToken());
    int y = Integer.parseInt(st.nextToken());
    s.addElement(new DummyEvent(DummyEvent.DOWN, DrawPanel.GOAL, x, y, dp));
  }
  void getLine(StringTokenizer st, Set s){
    int sx = Integer.parseInt(st.nextToken());
    int sy = Integer.parseInt(st.nextToken());
    int ex = Integer.parseInt(st.nextToken());
    int ey = Integer.parseInt(st.nextToken());
    s.addElement(new DummyEvent(DummyEvent.DOWN, DrawPanel.LINES, sx, sy, dp));
    s.addElement(new DummyEvent(DummyEvent.UP  , DrawPanel.LINES, ex, ey, dp));
  }

  void getLineN(StringTokenizer st, Set s){
    get5(st, s, DrawPanel.LINES);
  }
  void getProve(StringTokenizer st, Set s){
    get5(st, s, DrawPanel.PROVE);
  }
  void getReshape(StringTokenizer st, Set s){
    get5(st, s, DrawPanel.RESHAPE);
  }
  void getMove(StringTokenizer st, Set s){
    get5(st, s, DrawPanel.MOVE);
  }

  void get5(StringTokenizer st, Set s, int flag){
    int sx = Integer.parseInt(st.nextToken());
    int sy = Integer.parseInt(st.nextToken());
    int ex = Integer.parseInt(st.nextToken());
    int ey = Integer.parseInt(st.nextToken());
    int div = Integer.parseInt(st.nextToken());
    s.addElement(new DummyEvent(DummyEvent.DOWN, flag, sx, sy, dp));
    double divx = ((double)(ex - sx))/((double)(div + 1));
    double divy = ((double)(ey - sy))/((double)(div + 1));
    for (int i = 0; i < div; i++){
      int x = (int)(sx + divx * (i + 1));
      int y = (int)(sy + divy * (i + 1));
      s.addElement(new DummyEvent(DummyEvent.DRAG, flag, x, y, dp));
    }
    s.addElement(new DummyEvent(DummyEvent.UP  , flag, ex, ey, dp));
  }
}
