/*
 * Copyright (C) 1997 Hidemoto Nakada, Yoshiki Kinoshita, Koichi Takahashi
 */
import java.awt.Frame;
import java.awt.Panel;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Event;
import java.awt.Dimension;

//   abcdefghijklmnopqrstu
//  01234567890123456789
class MassagePanel extends Panel {
  int		maxchars = 50;
  String	sval;
  int		width;
  int		height;
  Font          font = new Font("Courier", Font.PLAIN, 16);
  FontMetrics   metrics;

  Color	bgColor;
  Color	fgColor;
  
  public MassagePanel(String initValue, int width, int height,
		    Color bgColor, Color fgColor) {
    this.width = width;
    this.height = height;
    resize(width, height);

    this.bgColor = bgColor;
    this.fgColor = fgColor;
    setText(initValue);

    metrics = getFontMetrics(font);
  }

  public void setText(String val) {
    sval = val;
  }
  
  public String getValue() {
    return sval;
  }
  public Dimension minimumSize(){
    return new Dimension(100, 20);
  }

  public Dimension preferredSize(){
    return new Dimension(width, height);
  }
  
  public void paint(Graphics g) {
    g.setFont(font);
    g.setColor(bgColor);
    g.fillRect(0, 0, size().width, size().height);

    if (sval != null) {
      int b_x = 0;
      int b_y = size().height/ 2;
      int cur_x = size().width - metrics.stringWidth(sval) - 2;
      int cur_y = b_y + 3;

      g.setColor(fgColor);
      g.drawString(sval, cur_x, cur_y);
    }
  }
  public void mouseUp(int x, int y) {
    // set the edit position
  }
}
