/*
 * Copyright (C) 1997 Hidemoto Nakada, Yoshiki Kinoshita, Koichi Takahashi
 */
import java.awt.Graphics;
import java.awt.Color;
import java.awt.Polygon;
import java.awt.Font;
import java.util.Hashtable;

class Loop extends Object implements Namable{

  public Set arcs;
  public Color col = Color.yellow;
  public Color stringCol = Color.black;
  public boolean isVisible = false;
  public boolean isGoal = false;
  public String name;
  static int num;
  public MyPoint center;
  public static Font font = new Font("Helvetica", Font.PLAIN, 24);
    
  public Node source;
  public Node sink;
  public Path onePath;
  public Path otherPath;

  static Color goalColor =  Color.gray;

  static Color colors[] = {
    Color.red, Color.green, Color.blue, Color.pink, Color.orange, Color.yellow
  };

  static Loop newLoop(Set arcs){
    Loop tmpLoop = new Loop(arcs);
    if (tmpLoop.source != null)
      return tmpLoop;
    else
      return null;
  }

  public Loop(){
    this(new Set());
  }
  public Loop(Set arcs){
    this.arcs = arcs;
    getSourceSink();
    getPathes();
  }

  public Path getOtherPath(Path a){
    if (onePath == a)
      return otherPath;
    if (otherPath == a)
      return onePath;
    return null;
  }

  public Set trace(Arc a, Node si){
    Set s = new Set();
    s.addElement(a);
    return traceSub(s, a, si);
  }
  public Set traceSub(Set s, Arc a, Node si){
    if (a.end == sink)
      return s;
    Arc next = next(a, a.end);
    s.addElement(next);
    return traceSub(s, next, si);
  }

  public boolean getPathes(){
    if (source == null)
      return false;
    Set firsts = arcs.andByObj(source.arcs);
    if (firsts.size() != 2)
      return false;
    onePath = new Path(trace((Arc)firsts.elementAt(0), sink));
    otherPath = new Path(trace((Arc)firsts.elementAt(1), sink));
    return true;
  }
  
  public boolean getSourceSink(){
    Set sources = new Set();
    Set sinks = new Set();
    Set nodes = getNodes();
    for (int i = 0; i < nodes.size(); i++){
      Node a = (Node)nodes.elementAt(i);
      if (a.isSink(arcs)) {
	sinks.addElement(a);
      } else if (a.isSource(arcs)){
	sources.addElement(a);
      }
    }
    if (sources.size() == 1 && sinks.size() == 1){
      source = (Node)sources.elementAt(0);
      sink   = (Node)sinks.elementAt(0);
      return true;
    }
    return false;
  }

  public Arc next(Arc a, Node n){
    int i = arcs.indexOf(a);
    Arc next = (Arc)arcs.elementNext(i);
    Arc prev = (Arc)arcs.elementPrevious(i);
    if (next.includes(n))
      return next;
    if (prev.includes(n))
      return prev;
    return null;
  }


  public Loop(Set arcs, boolean isVisible, Color col, String name, Node source, Node sink){
    this.arcs = arcs;
    this.isVisible = isVisible;
    this.col = col;
    this.name = name;
    this.source = source;
    this.sink = sink;
    getPathes();
  }

  public Loop movecopy(int x, int y, Hashtable ht){
    Set narcs = new Set();
    for (int i = 0; i < arcs.size(); i++)
      narcs.addElement(((Arc)arcs.elementAt(i)).movecopy(x, y, ht));
    Node nso = (Node)ht.get(source);
    Node nsi = (Node)ht.get(sink);
    return new Loop(narcs, isVisible, col, name, nso, nsi);
  }

  public void setVisible(boolean t){
    isVisible = t;
  }
  public void setGoal(){
    isGoal = true;
  }
  public void unsetGoal(){
    isGoal = false;
  }
  public void setColor(Color col){
    this.col = col;
  }
  public void visible(){
    isVisible = true;
  }

  public void autoColor(){
    int index = num % colors.length;
    setColor(colors[index]);
  }

  public void autoName(){
    name = "Loop :" + num;
    num++;
  }

  public void setMenso(){
    visible();
    autoColor();
    autoName();
  }

  public void name(String s){
    name = s;
  }
  public String getName(){
    return name;
  }


  public boolean compareByName(Namable l0){
    Loop l = (Loop)l0;
    if (!arcs.compareByName(l.arcs))
      return false;
    if (arcs.size() <= 0)
      return true;
    Arc key = (Arc)arcs.elementAt(0);
    Set normal = normalize(key);
    Set sameNamed = l.arcs.getSameNameSet(key);
    for (int i = 0; i < sameNamed.size(); i++){
      Arc lkey = (Arc)l.arcs.elementAt(i);
      Set lnormal = l.normalize(lkey);
      if (normal.compareSerialByName(lnormal))
	return true;
    }
    return false;
  }

  public int match(Loop l){
    int tmp = 0;
    for (int i = 0; i < arcs.size(); i++){
      Arc a = (Arc)arcs.elementAt(i);
      for (int j = 0; j < l.arcs.size(); j++){
	Arc b = (Arc)l.arcs.elementAt(i);
	if (a.compareByName(b)) {
	  tmp ++;
	  break;
	}
      }
    }
    return tmp;
  }

  public Set commonArcs(Loop l){
    return arcs.andByName(l.arcs);
  }

  public Set commonNodes(Loop l){
    return getNodes().andByName(l.getNodes());
  }

  
  public Set getNodes() {
    Set tmp = new Set();
    for (int i = 0; i < arcs.size(); i++){
      Arc a = (Arc)arcs.elementAt(i);
      tmp.addElement(a.start);
      tmp.addElement(a.end);
    }    
    return tmp;
  }

  public Set getNewNodes(Set nodes){
    Set answer = new Set();
    for (int i = 0; i < nodes.size(); i++){
      Node n = (Node)nodes.elementAt(i);
      answer.addElement(n.copy(center.x, center.y));
    }
    return answer;
  }

  public Set getNewArcs(Set larcs, Set lnodes, Set commonNodes){
    Set mnodes = ((Set)commonNodes.clone()).addAll(lnodes);
    Set newone = new Set();
    for (int i = 0; i < larcs.size(); i++){
      Arc arc = ((Arc)larcs.elementAt(i)).copy(mnodes);
      newone.addElement(arc);
    }
    return newone;
  }

  public boolean replace(Arc a, Arc b){
    for (int i = 0; i < arcs.size(); i++){
      if (a == ((Arc)arcs.elementAt(i))){
	arcs.setElementAt(b,i);
	return true;
      }
    }
    return false;
  }

  public boolean includes(Node node){
    for (int i = 0; i < arcs.size(); i++){
      Arc tmpArc = ((Arc)arcs.elementAt(i));
      if (tmpArc.includes(node))
	return true;
    }
    return false;
  }

  public boolean includes(Arc arc){
    return arcs.contains(arc);
  }
  public boolean included(Set nodes){
    for (int i = 0; i < arcs.size(); i++){
      Arc tmpArc = ((Arc)arcs.elementAt(i));      
      if (!(nodes.contains(tmpArc.start) && nodes.contains(tmpArc.end)))
	return false;
    }
    return true;
  }


  /** make list of arcs ordering by the specified arc */
  public Set normalize(Arc a){
    int index = arcs.indexOf(a);
    boolean fore = true;
    if (index < 0)
      return null;
    Set ans = new Set();
    if (((Arc)arcs.elementAt(arcs.nextIndex(index))).includes(a.end))
      fore = true;
    else if (((Arc)arcs.elementAt(arcs.previousIndex(index))).includes(a.end))
      fore = false;
    
    for (int i = 0; i < arcs.size(); i++){
      ans.addElement(arcs.elementAt(index));
      if (fore)
	index = arcs.nextIndex(index);
      else
	index = arcs.previousIndex(index);
    }
    return ans;
  }

  public double distance(int x0, int y0){
    if (center == null) center = getCenter();
    return Math.sqrt((center.x - x0) * (center.x - x0) + 
		     (center.y - y0) * (center.y - y0));
  }

  public MyPoint getCenter(){
    int tmpx = 0, tmpy = 0;
    for (int i = 0; i < arcs.size(); i++){
      Arc tmpArc = ((Arc)arcs.elementAt(i));      
      MyPoint tmpPoint = tmpArc.center();
      tmpx += tmpPoint.x;
      tmpy += tmpPoint.y;
    }
    return new MyPoint(tmpx/arcs.size(), tmpy/arcs.size());
  }

  Polygon getPolygon(){
    Polygon poly = new Polygon();
    if (arcs.size() <= 1)  return poly;
    Arc firstArc = ((Arc)arcs.elementAt(0));
    Arc secondArc = ((Arc)arcs.elementAt(1));
    Node tmpNode;
    if (secondArc.includes(firstArc.start))
      tmpNode = firstArc.end;
    else 
      tmpNode = firstArc.start;
    for (int i = 0; i < arcs.size(); i++){
      tmpNode = ((Arc)arcs.elementAt(i)).addNodeToPolygon(poly, tmpNode);
    }
   return poly;
  }

  void paint(Graphics g){
    paint(g, 0, 0);
  }

  void paint(Graphics g, int x0, int y0){
    center = getCenter();
    if (!isVisible && !isGoal) return;
    Polygon poly = getPolygon();
    g.translate(x0, y0);
    if (!isGoal)
      g.setColor(col);
    else
      g.setColor(goalColor);
    g.fillPolygon(poly);
    g.setFont(font);
    if (isGoal){
      g.setColor(stringCol);
      g.drawString("GOAL", center.x, center.y);
    } else  if (name != null){
      g.setColor(stringCol);
      g.drawString(name, center.x, center.y);
    }
    g.translate(-x0, -y0);
  }

  public String toString(){
    String tmp = "Loop";
    if (name != null)
      tmp = tmp + "(" + name +")";
    tmp = tmp + ":";
    tmp = tmp + "(source: " + source.toString() + ") ";
    tmp = tmp + "(sink: " + sink.toString() + " ):";
    tmp = tmp + "(onePath : " + onePath + ")";
    tmp = tmp + "(otherPath : " + otherPath + ")";
    return tmp;
  }

  public void fuse(Pair arcPair){
    if (arcs.contains((Arc)arcPair.car) &&
	arcs.contains((Arc)arcPair.cdr)){
      arcs.removeElement((Arc)arcPair.car);
      arcs.removeElement((Arc)arcPair.cdr);
      getSourceSink();
      getPathes();
      return;
    }
    if (arcs.contains((Arc)arcPair.car)){
      arcs.     replace((Arc)arcPair.car, (Arc)arcPair.cdr);
      onePath.  replace((Arc)arcPair.car, (Arc)arcPair.cdr);
      otherPath.replace((Arc)arcPair.car, (Arc)arcPair.cdr);
    }
  }

  public Pair getFuseArcs(Node n){
    Arc a, b;
    if (source == n){
      a = onePath.elementAt(0);
      b = otherPath.elementAt(0);
    } else if (sink == n){
      a = onePath.elementLast();
      b = otherPath.elementLast();
    } else {
      return null;
    }
    if (a.compareByName(b))
      return new Pair(a,b);
    return null;
  }
  public Pair getFuseNextArcs(Node n){
    if (onePath.size() < 2 || otherPath.size() < 2)
      return null;
    if (source == n)
      return new Pair(onePath.elementAt(1), otherPath.elementAt(1));
    if (sink == n)
      return new Pair(onePath.elementAt(onePath.size()-2), otherPath.elementAt(onePath.size()-2));
    return null;
  }



}
