/*
 * Copyright (C) 1997 Hidemoto Nakada, Yoshiki Kinoshita, Koichi Takahashi
 */
import java.awt.Frame;
import java.awt.Panel;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Event;
import java.awt.Dimension;

//   abcdefghijklmnopqrstu
//  01234567890123456789
class InputPanel extends Panel {
  int		maxchars = 50;
  int		cursorPos = 0;
  String	sval;
  char	        buffer[];
  char	        tmpbuffer[];
  int		nChars;
  int		width;
  int		height;
  Font          font = new Font("Courier", Font.PLAIN, 14);
  FontMetrics   metrics;
  String        cursorString = "_";
  int           cursorPosition = 0;

  static final int bs      = 8;
  static final int ret     = 10;  
  static final int back    = 2;  
  static final int forward = 6;  
  static final int top     = 1;  
  static final int tail    = 5;  
  static final int kill    = 11;  

  Color	bgColor;
  Color	fgColor;
  
  public InputPanel(String initValue, int width, int height,
		    Color bgColor, Color fgColor) {
    this.width = width;
    this.height = height;
    resize(width, height);

    this.bgColor = bgColor;
    this.fgColor = fgColor;
    buffer = new char[maxchars];
    tmpbuffer = new char[maxchars];
    nChars = 0;
    setText(initValue);

//    if (initValue != null) {
//      initValue.getChars(0, initValue.length(), this.buffer, 0);
//      nChars = initValue.length();
//      sval = initValue;
//    }
    metrics = getFontMetrics(font);
  }

  public void setText(String val) {
    int i;
    
    for (i=0; i < maxchars; i++) {
      buffer[i] = 0;
    }
    sval = new String(val);
    if (val == null) {
      sval = "";
      nChars = 0;
      buffer[0] = 0;
    } else {
      sval.getChars(0, sval.length(), buffer, 0);
      nChars = val.length();
      cursorPosition = val.length();
      sval = new String(buffer);
    }
  }
  
  public String getValue() {
    return sval;
  }
  public Dimension minimumSize(){
    return new Dimension(100, 20);
  }

  public Dimension preferredSize(){
    return new Dimension(width, height);
  }
  
  public void paint(Graphics g) {
    g.setFont(font);
    g.setColor(bgColor);
    g.fillRect(0, 0, size().width, size().height);

    if (sval != null) {
      int b_x = 0;
      int b_y = size().height/ 2;
      int cur_x = b_x + metrics.charsWidth(sval.toCharArray(), 0, cursorPosition);
      int cur_y = b_y + 3;

      g.setColor(fgColor);
      g.drawString(cursorString, cur_x, cur_y);
      g.drawString(sval, 0, b_y);
//      g.drawString(sval, 0, (height / 2) + 3);
    }
  }
  public void mouseUp(int x, int y) {
    // set the edit position
  }
  public boolean keyDown(Event e, int key) {
    int length = 0;
  
    if (nChars < maxchars) {
//System.out.println("char " + key);
      switch (key) {
      case bs: // delete
	if (cursorPosition == 0) {
	  break;
	}
	length = nChars - cursorPosition;
	System.arraycopy(buffer, cursorPosition, tmpbuffer, 0, length);
	System.arraycopy(tmpbuffer, 0, buffer, cursorPosition - 1, length);
	--cursorPosition;
	--nChars;
	buffer[nChars] = 0;
	sval = new String(new String(buffer, 0, nChars));
	break;
      case top: 
	cursorPosition = 0;
	break;
      case tail: 
	cursorPosition = nChars;
	break;
      case forward: 
	if (cursorPosition != nChars)
	  cursorPosition ++;
	break;
      case back: 
	if (cursorPosition != 0)
	  cursorPosition --;
	break;
      case kill: 
	for (int i = cursorPosition; i < nChars; i++)
	  buffer[i] = 0;
	nChars = cursorPosition;
	sval = new String(new String(buffer, 0, nChars));
	break;
      case ret: // return
	selected();
	break;
      default:
	if (key < 0x20) break;
	length = nChars - cursorPosition;
	System.arraycopy(buffer, cursorPosition, tmpbuffer, 0, length);
	System.arraycopy(tmpbuffer, 0, buffer, cursorPosition + 1, length);
	buffer[cursorPosition++] = (char)key;
	nChars++;
	sval = new String(new String(buffer, 0, nChars));

	break;
      }
    }
    repaint();
    return true;
  }
  public void selected() {
    getParent().action(new Event(this, 100, getValue()), getValue());
  }

  public static void main(String args[]) {
    Frame f = new Frame("InputPanel");
    InputPanel inputPanel = new InputPanel("test", 200, 18, Color.black, Color.white);
    
    f.add("Center", inputPanel);
    f.resize(300, 30);
    f.show();
  }
}
