/*
 * Copyright (C) 1997 Hidemoto Nakada, Yoshiki Kinoshita, Koichi Takahashi
 */
import java.awt.*;

class InputDialog  extends Panel {
  Frame frame;
  InputPanel panel;
  String name;
  Component target;
  int		width;
  int		height;


  public InputDialog(Component target){
    this("", 100, 30, Color.black, Color.white, target);
  }

  public InputDialog(Component target, String initValue){
    this(initValue, 100, 30, Color.black, Color.white, target);
  }

  public InputDialog(String initValue, int width, int height,
		    Color bgColor, Color fgColor, Component target){
    this.name = name;
    this.target = target;
    setLayout(new BorderLayout());
    frame = new Frame("InputPanel");
    panel = new InputPanel(initValue, width, height, bgColor, fgColor);
    this.add("Center", panel);
    Panel tmp = new Panel();
    tmp.add("East", new Button("Accept"));
    tmp.add("West", new Button("Cancel"));
    this.add("South", tmp);
    this.height = height;
    this.width = width;

    frame.add("Center", this);
    frame.resize(width + 100, height +100);
    frame.show();
  }

  public Dimension minimumSize(){
    return new Dimension(100, 30);
  }

  public Dimension preferredSize(){
    return new Dimension(width, height);
  }


  public boolean action(Event evt, Object arg){
    if (evt.target instanceof Button){
      if ((String)arg == "Accept"){
	target.action(new Event(this, 100, panel.getValue()), panel.getValue());
	frame.dispose();
      }else {
	frame.dispose();
      }
      return true;
    } if (evt.target instanceof InputPanel){
      target.action(new Event(this, 100, panel.getValue()), panel.getValue());
      frame.dispose();
      return true;
    }else {
      System.out.println(evt);
      return false;
    }
  }

}
