/*
 * Copyright (C) 1997 Hidemoto Nakada, Yoshiki Kinoshita, Koichi Takahashi
 */
import java.awt.Event;

class DummyPlug implements Tickable {
  DrawPanel dp;
  int firstMode = 0;
  int lastMode = -1;
  Set events;  

  public DummyPlug(DrawPanel dp, Set events) {
    this.dp = dp;
    this.events = events;
  }

  public void tick(int i){
    if (events.size() > i){
      DummyEvent de = (DummyEvent)events.elementAt(i);
      if (de.dpMode < 0)
	return;
      if (lastMode == -1)
	firstMode = dp.getDrawMode();
      if (de.dpMode != lastMode){
	lastMode = de.dpMode;
	dp.setDrawMode(de.dpMode);
      }
      dp.handleEvent(de.toEvent());
    }
  }

  public void last(){
    dp.setDrawMode(firstMode);
  }
}
