/*
 * Copyright (C) 1997 Hidemoto Nakada, Yoshiki Kinoshita, Koichi Takahashi
 */
/*
  Line connects two points.
  The relations must be maintained. 
*/

import java.awt.*;
import java.applet.*;

import java.util.Vector;
import java.util.Hashtable;

public class DrawTest2 extends Applet {
    public void init() {
	setLayout(new BorderLayout());
	MassagePanel mp = new MassagePanel("", 200, 20, Color.black, Color.white);
	DrawPanel dp = new DrawPanel(mp);
	add("Center", dp);
	add("North", mp);
	add("South",new DrawControls(dp));
    }

    public boolean handleEvent(Event e) {
	switch (e.id) {
	  case Event.WINDOW_DESTROY:
	    System.exit(0);
	    return true;
	  default:
	    return false;
	}
    }

    public static void main(String args[]) {
	Frame f = new Frame("DrawTest");
	DrawTest2 drawTest = new DrawTest2();
	drawTest.init();
	drawTest.start();

	f.add("Center", drawTest);
	f.resize(300, 300);
	f.show();
    }
}

class DrawPanel extends Panel {
  public static final int LINES  = 0;
  public static final int NODES = 1;
  public static final int MOVE   = 2;
  public static final int REMOVE = 3;
  public static final int RESHAPE = 4;
  public static final int NAME = 5;
  public static final int MENSO = 6;
  public static final int GOAL = 7;
  public static final int PROVE = 8;
  public static final int INIT = 9;
  public static final int DEMO = 10;

  public static final int CLEAR = 11;
  
  public static final int COPY = 12;

  public static final int PROVESELECT = 13;
  public static final int DUMP = 100;

  
  int	   mode = NODES;
  Set clusters = new Set();
  Node tmpStart = null;
  Node tmpEnd = null;
  int tmpx, tmpy;
  int currentx, currenty;
  Node moveNode = null;
  Arc reshapeArc = null;
  Cluster moveCluster = null;
  Hashtable namingDic = new Hashtable();
  Set currentLoops;
  Set blinkingArcs;
  Cluster currentGoalCluster;
  Loop currentGoal;
  Loop currentHypo;
  MyPoint donePoint = null;
  MassagePanel mp;
  Image sub_im;
  Graphics sub_g;
  Set volatiles;
  Set proveSelectSet;
  
  public DrawPanel(MassagePanel mp) {
    setBackground(Color.white);
    this.mp = mp;
    init();
  }

  public void init(){
    clusters = new Set();
    volatiles = new Set();
    currentLoops = null;
    currentGoalCluster = null;
    currentGoal = null;
    currentHypo = null;
  }

  public void resize(int x, int y){
    sub_im = this.createImage(x,y);
    sub_g = sub_im.getGraphics();
    super.resize(x,y);
  }
  public void resize(Dimension d){
    sub_im = this.createImage(d.width, d.height);
    sub_g = sub_im.getGraphics();
    super.resize(d);
  }
  
  public void setDrawMode(int mode) {
    switch (mode) {
    case LINES:
    case NODES:
    case MOVE:
    case REMOVE:
    case RESHAPE:
    case NAME:
    case MENSO:
    case GOAL:
    case PROVE:
    case COPY:
    case DUMP:
      this.mode = mode;
      mp.setText(null);
      mp.repaint();
      initBlinkingArcs();
      break;
    case PROVESELECT:
      this.mode = mode;
      mp.setText("Select Target");
      mp.repaint();
      break;
    default:
      throw new IllegalArgumentException();
    }
  }
  
  public boolean handleEvent(Event e) {
    switch (e.id) {
    case Event.WINDOW_DESTROY:
      System.exit(0);
      return true;
    default:
      return super.handleEvent(e);
    }
  }
  
  public boolean mouseDown(Event e, int x, int y){
    Arc tmpArc;
    mp.setText(null);
    switch (mode) {
    case NODES:
      addNode(x, y, getForeground());
      repaint();
      break;
    case LINES:
      tmpStart = getNearestNode(x, y);
      tmpx = x; tmpy = y;
      break;
    case REMOVE:
      Node tmpNode = getNearestNode(x, y);
      if (tmpNode != null){
	removeNode(tmpNode);
      } else {
	tmpArc = getNearestArc(x, y);
	if (tmpArc != null){
	  removeArc(tmpArc);
	}
      }
      break;
    case MENSO:
      tmpArc = getNearestArc(x, y);
      if (tmpArc != null){
	Loop tmpLoop = getMenso(tmpArc);
	if (tmpLoop != null){
	  tmpLoop.setMenso();
	  repaint();
	  setCurrentLoops();
	  initBlinkingArcs();
	}
      }
      break;
    case GOAL:
      tmpArc = getNearestArc(x, y);
      if (tmpArc != null){
	Loop tmpLoop = getMenso(tmpArc);
	if (tmpLoop != null){
	  if (currentGoal != null){
	    currentGoal.unsetGoal();
	  }
	  tmpLoop.setGoal();
	  currentGoal = tmpLoop;
	  currentGoalCluster = getCluster(tmpLoop);
	  repaint();
	  setCurrentLoops();
	  initBlinkingArcs();
	}
      }
      break;
    case RESHAPE:
      moveNode = getNearestNode(x, y);
      if (moveNode == null){
	tmpArc = getNearestArc(x, y);
	System.out.println(x + "," + y+ "," + tmpArc);
	if (tmpArc != null){
	  reshapeArc = tmpArc.reshape(x, y);
	}
      }
      tmpx = x; tmpy = y;
      break;
    case DUMP:
      dump();
      break;
    case PROVE:
      currentHypo = getNearestLoop(x, y);
      if (currentHypo == null)
	System.out.println("can't get loop");
      else
	System.out.println("get loop " + currentHypo);
      tmpx = x; tmpy = y;
      break;
    case PROVESELECT:
      proveSelectDown(x, y);
      break;
    case NAME:
      Namable namable = getNearestNode(x, y);
      if (namable == null)
	namable = getNearestArc(x, y);
      if (namable == null)
	namable = getNearestLoop(x, y);
      if (namable == null)
	break;
      getName(namable);
      break;
    case MOVE:
      moveNode = getNearestNode(x, y);
      if (moveNode == null){
	tmpArc = getNearestArc(x, y);
	if (tmpArc != null){
	  moveCluster = getCluster(tmpArc);
	}
      }
      tmpx = x; tmpy = y;
      break;
    case COPY:
      moveNode = getNearestNode(x, y);
      if (moveNode == null){
	tmpArc = getNearestArc(x, y);
	if (tmpArc != null){
	  moveCluster = getCluster(tmpArc);
	}
      } else {
	moveCluster = getCluster(moveNode);
	moveNode = null;
      }
      tmpx = x; tmpy = y;
      break;
    default:
      break;
    }
    return true;
  }
  public boolean mouseUp(Event e, int x, int y){
    switch (mode) {
    case LINES:
      tmpEnd = getNearestNode(x, y);
      if (tmpEnd != null && tmpStart != null && tmpStart != tmpEnd){
	Arc tmpArc = new ArcRect(tmpStart, tmpEnd, getForeground(), true);
	addArc(tmpArc);
      } 
      tmpStart = null;
      break;
    case NODES:
      break;
    case MOVE:
      moveNode = null;
      moveCluster = null;
      break;
    case COPY:
      if (moveCluster != null){
	copyCluster(moveCluster, x - tmpx, y - tmpy);
      }
      moveCluster = null;
      break;
    case PROVE:
      proveUp(x, y);
      break;
    case RESHAPE:
      moveNode = null;
      reshapeArc = null;
      break;
    default:
      break;
    }
    repaint();
    return true;
  }
  
  public boolean mouseDrag(Event e, int x, int y){
    switch (mode) {
    case LINES:
      tmpx = x;
      tmpy = y;
      break;
    case MOVE:
      if (moveNode != null)
	moveNode.reshape(x - tmpx, y- tmpy);
      if (moveCluster != null)
	moveCluster.move(x - tmpx, y- tmpy);
      tmpx = x; tmpy = y;
      break;
    case COPY:
      currentx = x; currenty = y;
      break;
    case PROVE:
      if (currentHypo != null)
	currentx = x; currenty = y;
      break;
    case RESHAPE:
      if (moveNode != null)
	moveNode.reshape(x - tmpx, y- tmpy);
      if (reshapeArc != null)
	reshapeArc = reshapeArc.reshape(x, y);
      tmpx = x; tmpy = y;
      break;
    case NODES:
    default:
      break;
    }
    repaint();
    return true;
  }

  public void getName(Namable namable){
    String def= namable.getName();
    if (def == null) def = "";
    InputDialog dialog = new InputDialog(this, def);
    namingDic.put(dialog, namable);
  }

  public void rewindHypo(int x, int y, Loop ch){
    new Interrupter(5, 40, new RewindTick(x, y, tmpx, tmpy, 5, this, ch));
    currentHypo = null;
  }

  public void proveOne(Cluster cGoalCluster, Loop cGoal, Loop cHypo, Set matchArcs){
    initBlinkingArcs();
    System.out.println(matchArcs);
    currentGoal = cGoalCluster.getNextGoal(cGoal, cHypo, matchArcs);;
    currentGoal.setGoal();
    currentHypo = null;
  }

  void proveSelectAgain(){
    message("No matching Arcs: Select Again");
    setDrawMode(PROVESELECT);
  }

  public void proveSelect(Set lset){
    setDrawMode(PROVESELECT);
    proveSelectSet = lset;
    initBlinkingArcs();
    for (int i = 0; i < lset.size(); i++){
      Interrupter tmp = new Interrupter(1000, 200, (new BlinkArcs(this, (Set)lset.elementAt(i))));
      blinkingArcs.addElement(tmp);
    }
  }

  public void proveSelectDown(int x, int y){
    Arc tmpArc = getNearestArc(x, y);
    if (tmpArc == null)
      return;
    Set proveSelectSetTmp = (Set)proveSelectSet.clone();
    for (int i = 0; i < proveSelectSetTmp.size(); i++){
      Set arcs = (Set)proveSelectSetTmp.elementAt(i);
      if (!arcs.contains(tmpArc))
	proveSelectSet.removeElement(arcs);
    }
    if (proveSelectSet.size() == 0){
      proveSelectAgain();
    } else if (proveSelectSet.size() == 1){
      proveOne(currentGoalCluster, currentGoal, currentHypo, 
	       ((Set)proveSelectSet.elementAt(0)));
      setDrawMode(PROVE);
    } else {
    }
  }

  public void proveUp(int x, int y){
    if (currentHypo != null && currentGoalCluster != null && currentGoal != null){
      if (!currentGoal.getPolygon().inside(x, y)){
	rewindHypo(x, y, currentHypo);
	return;
      }
      currentGoal.unsetGoal();
      Set lset = currentGoalCluster.getMatchPoints(currentGoal, currentHypo);
   System.out.println(lset);

      if (lset.size() == 0){    // no matching point;
	currentGoal.setGoal();
	rewindHypo(x, y, currentHypo);
	return;
      } else if (lset.size() == 1){
	proveOne(currentGoalCluster, currentGoal, currentHypo, (Set)lset.elementAt(0));
      } else {
	proveSelect(lset);
//	donePoint = currentGoal.getCenter();
//	currentGoal = null;
      }
    }
  }

  public void message(String str){
    mp.setText(str);
  }

  public void copyCluster(Cluster c, int x, int y){
    clusters.addElement(c.movecopy(x, y));
  }

  public Loop getMenso(Arc a){
    Set tmp = (Set)currentLoops.clone();
    for (int i = 0; i < currentLoops.size(); i++){
      Loop tmpLoop = (Loop)currentLoops.elementAt(i);
      if (!tmpLoop.includes(a))
	tmp.removeElement(tmpLoop);
    }
    currentLoops = tmp;
    if (currentLoops.size() == 0){
      setCurrentLoops();
      initBlinkingArcs();
      message("No such Cell, Select Again");
      repaint();
      return null;
    } else if (currentLoops.size() == 1){
      return (Loop)currentLoops.elementAt(0);
    } else {
      addBlinkingArcs(new Interrupter(1000, 200, new BlinkArc(this, a)));
      return null;
    }
  }


  public Cluster getCluster(Node s){
    int np = clusters.size();
    for (int i = 0; i < np; i++){
      Cluster cl = ((Cluster)clusters.elementAt(i));
      if (cl.nodes.contains(s))
	return cl;
    }
    return null;
  }

  public Cluster getCluster(Arc a){
    return getCluster(a.start);
  }

  public Cluster getCluster(Loop l){
    if (l.arcs.size() != 0)
      return getCluster((Arc)l.arcs.elementAt(0));
    return null;
  }

  public void mergeCluster(Node s, Node e, Arc tmpArc){
    Cluster sc = getCluster(s);
    Cluster ec = getCluster(e);
    if (sc != ec){
      sc.addCluster(ec);
      clusters.removeElement(ec);
    } else {
      sc.maintainLoop(tmpArc);
    }
  }


  public Node getNearestNode(int x, int y) {
    int np = clusters.size();
    double nearestMax = 10;

    Node currentNode = null;
    for (int i = 0; i < np; i++){
      Node tmp = ((Cluster)clusters.elementAt(i)).getNearestNode(nearestMax, x, y);
      if (tmp != null){
	if (currentNode == null){
	  currentNode = tmp;
	  nearestMax = tmp.distance(x, y);
	}
      }
    }
    return currentNode;
  }

  public Arc getNearestArc(int x, int y) {
    int np = clusters.size();
    double nearestMax = 10;

    Arc currentArc = null;
    for (int i = 0; i < np; i++){
      Arc tmp = ((Cluster)clusters.elementAt(i)).getNearestArc(nearestMax, x, y);
      if (tmp != null){
	if (currentArc == null){
	  currentArc = tmp;
	  nearestMax = tmp.distance(x, y);
	}
      }
    }
    return currentArc;
  }
  public Loop getNearestLoop(int x, int y) {
    double nearestMax = 10;
    setCurrentLoops();
    Loop currentLoop = null;

    for (int i = 0; i < currentLoops.size(); i++){
      Loop tmpLoop = (Loop)currentLoops.elementAt(i);
      int distance = (int)tmpLoop.distance(x, y);
  System.out.println(distance);      
      if (distance < nearestMax){
	nearestMax = distance;
	currentLoop = tmpLoop;
      }
    }
    return currentLoop;
  }
  public void removeArc(Arc a){
    int np = clusters.size();
    for (int i = 0; i < np; i++){
      Cluster c = ((Cluster)clusters.elementAt(i));
      if (c.containsArc(a)){
	Cluster tmp = c.removeArc(a);
	if (tmp != null)
	  clusters.addElement(tmp);
      }
    }
  }

  public void removeNode(Node a){
    int np = clusters.size();
    Set nclusters = new Set();
    for (int i = 0; i < np; i++){
      Cluster c = ((Cluster)clusters.elementAt(i));
      if (c.containsNode(a)){
	Set tmpClusters = c.removeNode(a);
	nclusters.addAll(tmpClusters);
      } else {
	nclusters.addElement(c);
      }
    }
    clusters = nclusters;
  }

  public boolean action(Event e, Object Arg){
    if (e.target instanceof InputDialog){
      ((Namable)namingDic.get(e.target)).name((String)Arg);
      namingDic.remove(e.target);
      repaint();
      return true;
    }
    return false;
  }

  public void repaint(){
    mp.repaint();
    super.repaint();
  }
  public void update(Graphics g) {
    if (sub_g == null){
      sub_im = this.createImage(size().width, size().height);
      sub_g = sub_im.getGraphics();
    }
    sub_g.setColor(getBackground());
    sub_g.fillRect(0, 0, size().width, size().height);
    sub_g.setColor(getForeground());
    paint(sub_g);
    //	System.out.println(sub_g);
    g.drawImage(sub_im, 0, 0, this);
  }
  
  public void addVolatile(Putable p){
    volatiles.addElement(p);
  }
  public void removeVolatile(Putable p){
    volatiles.removeElement(p);
  }

  public void paint(Graphics g) {
    int np = clusters.size();
    for (int i = 0; i < np; i++)
      ((Cluster)clusters.elementAt(i)).paint(g);
    if (tmpStart != null){
      g.setColor(getForeground());
      g.drawLine(tmpStart.x, tmpStart.y, tmpx, tmpy);
    }
//    System.out.println(currentHypo + ": "+(currentx - tmpx) + ", " +(currentx - tmpx));

    for (int i = 0; i < volatiles.size(); i++){
      ((Putable)volatiles.elementAt(i)).put(g);
    }
    volatiles = new Set();

    if (currentHypo != null)
      currentHypo.paint(g, currentx - tmpx, currenty - tmpy);
    if (mode == COPY && moveCluster != null)
      moveCluster.paint(g, currentx - tmpx, currenty - tmpy);
    if (donePoint != null){
      done(g, donePoint);
      donePoint = null;
    }
  }


  public void done(Graphics g, MyPoint p){
    String str = "D O N E";
    message(str);
    Font f = new Font("Helvetica", Font.BOLD, 34);
    FontMetrics fm = getFontMetrics(f);
    int len = fm.stringWidth(str);
    int height = fm.getHeight();
    g.setFont(f);
    g.drawString(str, p.x - (len/2), p.y + (height /2));
  }


  public void dump() {
    int np = clusters.size();
    for (int i = 0; i < np; i++)
      System.out.println(((Cluster)clusters.elementAt(i)).toString());
  }

  public void addBlinkingArcs(Interrupter i){
    blinkingArcs.addElement(i);
  }

  public void initBlinkingArcs(){
    if (blinkingArcs != null && blinkingArcs.size() != 0)
      for (int i = 0; i < blinkingArcs.size(); i++)
	((Interrupter)blinkingArcs.elementAt(i)).kill();
    blinkingArcs = new Set();
  }
  public void setCurrentLoops(){
    currentLoops = new Set();
    for (int i = 0; i < clusters.size(); i++){
      currentLoops.addAll(((Cluster)clusters.elementAt(i)).loops);
    }
  }

  public Node addNode(int x, int y, String n){
    return addNode(x, y, Color.black, n);
  }

  public Node addNode(int x, int y, Color c){
    return addNode(x, y, c, null);
  }
  public Node addNode(int x, int y, Color c, String n){
    Cluster nc = new Cluster(x, y, c, n);
    clusters.addElement(nc);
    return (Node)nc.nodes.elementAt(0);
  }

  public void addArc(Arc a){
    a.registerSelf();
    mergeCluster(a.start, a.end, a);    
  }

  public void demo(){
    Node.initNum();
    Arc.initNum();

    Node n0 = addNode(100, 100, "A");
    Node n1 = addNode(100, 200, "B");
    Node n2 = addNode(200, 200, "C");
    addArc(new ArcRect(n0, n1, Color.black, true, "f"));
    addArc(new ArcRect(n1, n2, Color.black, true, "g"));
    addArc(new ArcRect(n0, n2, Color.black, true, "h"));

    n0 = addNode(300, 100, "A");
    n1 = addNode(400, 200, "C");
    n2 = addNode(400, 100, "D");
    addArc(new ArcRect(n0, n1, Color.black, true, "h"));
    addArc(new ArcRect(n2, n1, Color.black, true, "i"));
    addArc(new ArcRect(n0, n2, Color.black, true, "j"));

    Node n3 = addNode(500, 100, "A");
    Node n4 = addNode(500, 200, "B");
    Node n5 = addNode(600, 300, "A");
    Node n6 = addNode(700, 300, "B");
    Node n7 = addNode(700, 200, "C");
    Node n8 = addNode(600, 100, "C");

    addArc(new ArcRect(n3, n4, Color.black, true, "f"));
    addArc(new ArcRect(n4, n5, Color.black, true, "k"));
    addArc(new ArcRect(n5, n6, Color.black, true, "f"));
    addArc(new ArcRect(n6, n7, Color.black, true, "g"));
    addArc(new ArcRect(n7, n8, Color.black, true, "i"));
    addArc(new ArcRect(n3, n8, Color.black, true, "h"));

    repaint();
  }

  
}

class DrawControls extends Panel {
    DrawPanel target;
    String currentSelected = "Nodes";

    public DrawControls(DrawPanel target) {
	this.target = target;
	setLayout(new FlowLayout());
	setBackground(Color.lightGray);
	target.setForeground(Color.red);
	CheckboxGroup group = new CheckboxGroup();
	Checkbox b;
	add(b = new Checkbox(null, group, false));
	b.setBackground(Color.red);
	add(b = new Checkbox(null, group, false));
	b.setBackground(Color.green);
	add(b = new Checkbox(null, group, false));
	b.setBackground(Color.blue);
	add(b = new Checkbox(null, group, false));
	b.setBackground(Color.pink);
	add(b = new Checkbox(null, group, false));
	b.setBackground(Color.orange);
	add(b = new Checkbox(null, group, true));
	b.setBackground(Color.black);
	target.setForeground(b.getForeground());
	Choice shapes = new Choice();
	shapes.addItem("Nodes");
	shapes.addItem("Lines");
	shapes.addItem("Copy");
	shapes.addItem("Move");
	shapes.addItem("Remove");
	shapes.addItem("Reshape");
	shapes.addItem("Name");
	shapes.addItem("-------");
	shapes.addItem("Cell");
	shapes.addItem("Goal");
	shapes.addItem("Prove");
	shapes.addItem("-------");
	shapes.addItem("Clear");
	shapes.addItem("Demo");
	shapes.addItem("Init");
	shapes.addItem("-------");
	shapes.addItem("Debug");
	shapes.setBackground(Color.lightGray);
	add(shapes);
    }

    public void paint(Graphics g) {
	Rectangle r = bounds();

	g.setColor(Color.lightGray);
	g.draw3DRect(0, 0, r.width, r.height, false);
    }

    public boolean action(Event e, Object arg) {
	if (e.target instanceof Checkbox) {
	    target.setForeground(((Component)e.target).getBackground());
	} else if (e.target instanceof Choice) {
	    String choice = (String)arg;
	    
	    if (choice.equals("Lines")) {
		target.setDrawMode(DrawPanel.LINES);
	    } else if (choice.equals("Nodes")) {
		target.setDrawMode(DrawPanel.NODES);
	    } else if (choice.equals("Move")) {
		target.setDrawMode(DrawPanel.MOVE);
	    } else if (choice.equals("Remove")) {
		target.setDrawMode(DrawPanel.REMOVE);
	    } else if (choice.equals("Reshape")) {
		target.setDrawMode(DrawPanel.RESHAPE);
	    } else if (choice.equals("Clear")) {
	        target.init();
		target.repaint();
	    } else if (choice.equals("Goal")) {
	        target.setCurrentLoops();
	        target.initBlinkingArcs();
		target.setDrawMode(DrawPanel.GOAL);
	    } else if (choice.equals("Cell")) {
	        target.setCurrentLoops();
	        target.initBlinkingArcs();
		target.setDrawMode(DrawPanel.MENSO);
	    } else if (choice.equals("Name")) {
		target.setDrawMode(DrawPanel.NAME);
	    } else if (choice.equals("Prove")) {
		target.setDrawMode(DrawPanel.PROVE);
	    } else if (choice.equals("Copy")) {
		target.setDrawMode(DrawPanel.COPY);
	    } else if (choice.equals("Dump")) {
	        target.dump();
	    } else if (choice.equals("Demo")) {
	        target.demo();
	    } else if (choice.equals("Init")) {
	      Node.initNum();
	      Arc.initNum();
	    } else {
	      ((Choice)e.target).select(currentSelected);
	    }
	    currentSelected = ((Choice)e.target).getSelectedItem();
	}
	return true;
    }
}
	
