/*
 * Copyright (C) 1997 Hidemoto Nakada, Yoshiki Kinoshita, Koichi Takahashi
 */
import java.awt.*;
import java.util.Hashtable;

public class DrawPanel extends Panel {
  public static final int LINES  = 0;
  public static final int NODES = 1;
  public static final int MOVE   = 2;
  public static final int REMOVE = 3;
  public static final int RESHAPE = 4;
  public static final int NAME = 5;
  public static final int MENSO = 6;
  public static final int GOAL = 7;
  public static final int PROVE = 8;
  public static final int INIT = 9;
  public static final int DEMO = 10;

  public static final int CLEAR = 11;
  
  public static final int COPY = 12;

  public static final int PROVESELECT = 13;
  public static final int FUSE = 14;

  public static final int DUMP = 100;

  
  int	   mode = NODES;
  Set clusters = new Set();
  Node tmpStart = null;
  Node tmpEnd = null;
  int tmpx, tmpy;
  int currentx, currenty;
  Node moveNode = null;
  Arc reshapeArc = null;
  Cluster moveCluster = null;
  Hashtable namingDic = new Hashtable();
  Set currentLoops;
  Set blinkingArcs;
  Cluster currentGoalCluster;
  Loop currentGoal;
  Loop currentHypo;
  MassagePanel mp;
  Image sub_im;
  Graphics sub_g;
  Set volatiles;
  Set proveSelectSet;
  Set autoDemoEvents = null;
  int autoDemoTick = 200;
  
  public DrawPanel(MassagePanel mp, String ad, String tick) {
    setBackground(Color.white);
    this.mp = mp;
    if (ad != null)
      autoDemoEvents = (new MyParser(this)).parseString(ad);
    if (tick != null)
      autoDemoTick = Integer.parseInt(tick);
    init();
  }

  public void init(){
    clusters = new Set();
    volatiles = new Set();
    currentLoops = null;
    currentGoalCluster = null;
    currentGoal = null;
    currentHypo = null;
  }

  public void resize(int x, int y){
    sub_im = this.createImage(x,y);
    sub_g = sub_im.getGraphics();
    super.resize(x,y);
  }
  public void resize(Dimension d){
    sub_im = this.createImage(d.width, d.height);
    sub_g = sub_im.getGraphics();
    super.resize(d);
  }
  
  public int getDrawMode() {
    return mode;
  }

  public void setDrawMode(int mode) {
    switch (mode) {
    case GOAL:
    case MENSO:
      setCurrentLoops();
      initBlinkingArcs(); /* intentional non break */
    case LINES:
    case NODES:
    case MOVE:
    case REMOVE:
    case RESHAPE:
    case NAME:
    case PROVE:
    case FUSE:
    case COPY:
    case INIT:
    case CLEAR:
    case DUMP:
      this.mode = mode;
      mp.setText(null);
      mp.repaint();
      initBlinkingArcs();
      break;
    case PROVESELECT:
      this.mode = mode;
      mp.setText("Select Target");
      mp.repaint();
      break;
    default:
      throw new IllegalArgumentException();
    }
  }
  
  public boolean handleEvent(Event e) {
    switch (e.id) {
    case Event.WINDOW_DESTROY:
      System.exit(0);
      return true;
    default:
      return super.handleEvent(e);
    }
  }
  
  public boolean mouseDown(Event e, int x, int y){
    Arc tmpArc;
    mp.setText(null);
    switch (mode) {
    case NODES:
      nodeDown(x, y);
      break;
    case LINES:
      tmpStart = getNearestNode(x, y);
      tmpx = x; tmpy = y;
      break;
    case REMOVE:
      remove(x, y);
      break;
    case MENSO:
      cellDown(x, y);
      break;
    case GOAL:
      goalDown(x, y);
      break;
    case RESHAPE:
      reshapeDown(x, y);
      break;
    case DUMP:
      dump();
      break;
    case FUSE:
      fuse(x, y);
      break;
    case PROVE:
      proveDown(x, y);
      break;
    case PROVESELECT:
      proveSelectDown(x, y);
      break;
    case NAME:
      name(x, y);
      break;
    case MOVE:
      moveDown(x, y);
      break;
    case COPY:
      copyDown(x, y);
      break;
    case INIT:
      Node.initNum();
      Arc.initNum();
      break;
    case CLEAR:
      init();
      repaint();
      break;
    default:
      break;
    }
    return true;
  }
  public boolean mouseUp(Event e, int x, int y){
    switch (mode) {
    case LINES:
      lineUp(x, y);
      break;
    case NODES:
      break;
    case MOVE:
      moveNode = null;
      moveCluster = null;
      break;
    case COPY:
      copyUp(x, y);
      break;
    case PROVE:
      proveUp(x, y);
      break;
    case RESHAPE:
      moveNode = null;
      reshapeArc = null;
      break;
    default:
      break;
    }
    repaint();
    return true;
  }
  
  public boolean mouseDrag(Event e, int x, int y){
    switch (mode) {
    case LINES:
      tmpx = x;
      tmpy = y;
      break;
    case MOVE:
      moveDrag(x, y);
      break;
    case COPY:
      currentx = x; currenty = y;
      break;
    case PROVE:
      if (currentHypo != null)
	currentx = x; currenty = y;
      break;
    case RESHAPE:
      reshapeDrag(x, y);
      break;
    case NODES:
    default:
      break;
    }
    repaint();
    return true;
  }

/***************  NODE METHODS   ************************/
  public void nodeDown(int x, int y){
    addNode(x, y, getForeground());
    repaint();
  }
/***************  LINE METHODS   ************************/
  public void lineUp(int x, int y){
    tmpEnd = getNearestNode(x, y);
    if (tmpEnd != null && tmpStart != null && tmpStart != tmpEnd){
      Arc tmpArc = new ArcRect(tmpStart, tmpEnd, getForeground(), true);
      addArc(tmpArc);
    } 
    tmpStart = null;
  }

/***************  MOVE METHODS   ************************/
  public void moveDown(int x, int y){
    moveNode = getNearestNode(x, y);
    if (moveNode == null){
      Arc tmpArc = getNearestArc(x, y);
      if (tmpArc != null){
	moveCluster = getCluster(tmpArc);
      }
    }
    tmpx = x; tmpy = y;
  }
  public void moveDrag(int x, int y){
    if (moveNode != null)
      moveNode.reshape(x - tmpx, y- tmpy);
    if (moveCluster != null)
      moveCluster.move(x - tmpx, y- tmpy);
    tmpx = x; tmpy = y;
  }

/***************  REMOVE METHODS   ************************/
  public void remove(int x, int y){
    Node tmpNode = getNearestNode(x, y);
    if (tmpNode != null){
      removeNode(tmpNode);
    } else {
      Arc tmpArc = getNearestArc(x, y);
      if (tmpArc != null){
	removeArc(tmpArc);
      }
    }
  }
/***************  NAME METHODS   ************************/
  public void getName(Namable namable){
    String def= namable.getName();
    if (def == null) def = "";
    InputDialog dialog = new InputDialog(this, def);
    namingDic.put(dialog, namable);
  }

  public void name(int x, int y){
      Namable namable = getNearestNode(x, y);
      if (namable == null)
	namable = getNearestArc(x, y);
      if (namable == null)
	namable = getNearestLoop(x, y);
      if (namable == null)
	return;
      getName(namable);
  }

/***************  RESHAPE METHODS   ************************/

  public void reshapeDrag(int x, int y){
    if (moveNode != null)
      moveNode.reshape(x - tmpx, y- tmpy);
    if (reshapeArc != null)
      reshapeArc = reshapeArc.reshape(x, y);
    tmpx = x; tmpy = y;
  }

  public void reshapeDown(int x, int y){
    moveNode = getNearestNode(x, y);
    if (moveNode == null){
      Arc tmpArc = getNearestArc(x, y);
      System.out.println(x + "," + y+ "," + tmpArc);
      if (tmpArc != null){
	reshapeArc = tmpArc.reshape(x, y);
      }
    }
    tmpx = x; tmpy = y;
  }

/***************  FUSE METHODS   ************************/
  public void fuse(int x, int y){
    if (currentGoal == null){
      message("Set Goal before fusing");
      return;
    }
    Node node = getNearestNode(x, y);
    if (node == null){
      message("Select Node, Again");
      return;
    }
    Cluster c = getCluster(node);
    Loop l = c.fuse(currentGoal, node);
    if (l == null){
      message("Can't Fuse. Select Node Again");
      return;
    }      
    currentGoal.unsetGoal();
    if (l.arcs.size() == 0){
      done(currentGoal.getCenter());
      currentGoal = null;
      return;
    }
    currentGoal = l;
    l.setGoal();
  }

/***************  PROVE SELECT METHODS   ************************/
  public void proveSelectDown(int x, int y){
    Arc tmpArc = getNearestArc(x, y);
    if (tmpArc == null)
      return;
    Set proveSelectSetTmp = (Set)proveSelectSet.clone();
    for (int i = 0; i < proveSelectSetTmp.size(); i++){
      Set arcs = (((Path)((Pair)proveSelectSetTmp.elementAt(i)).car).arcs);
      if (!arcs.contains(tmpArc))
	proveSelectSet.removeElement(proveSelectSetTmp.elementAt(i));
    }
    if (proveSelectSet.size() == 0){
      proveSelectAgain();
    } else if (proveSelectSet.size() == 1){
      proveOne(currentGoalCluster, currentGoal, currentHypo, 
	       ((Pair)proveSelectSet.elementAt(0)));
      setDrawMode(PROVE);
    } else {
    }
  }

  public void proveSelect(Set lset){
    setDrawMode(PROVESELECT);
    proveSelectSet = lset;
    initBlinkingArcs();
    for (int i = 0; i < lset.size(); i++){
      Set arcs = (((Path)((Pair)lset.elementAt(i)).car).arcs);
      Interrupter tmp = new Interrupter(1000, 200, (new BlinkArcs(this, arcs)));
      blinkingArcs.addElement(tmp);
    }
  }

/***************  PROVING METHODS   ************************/

  public void proveOne(Cluster cGoalCluster, Loop cGoal, Loop cHypo, Pair matchPathes){
    initBlinkingArcs();
    System.out.println(matchPathes);
    Loop tmpGoal = cGoalCluster.getNextGoal(cGoal, cHypo, matchPathes);;
    if (tmpGoal != null){
	currentGoal = tmpGoal;
	currentGoal.setGoal();
    } else {
    }
    currentHypo = null;
  }

  void proveSelectAgain(){
    message("No matching Arcs: Select Again");
    setDrawMode(PROVESELECT);
  }

  public void rewindHypo(int x, int y, Loop ch){
    new Interrupter(5, 40, new RewindTick(x, y, tmpx, tmpy, 5, this, ch));
    currentHypo = null;
  }


  public void proveDown(int x, int y){
      currentHypo = getNearestLoop(x, y);
      if (currentHypo == null)
	message("Can't get loop");
      tmpx = x; tmpy = y;
  }

  void proveDone(){
    done(currentGoal.getCenter());
    currentGoal.name(currentHypo.getName());
    currentGoal.setColor(currentHypo.col);
    currentGoal.visible();
    currentGoal = null;
    currentHypo = null;
  }

  public void proveUp(int x, int y){
    if (currentHypo != null && currentGoalCluster != null && currentGoal != null){
      if (!currentGoal.getPolygon().inside(x, y)){
	rewindHypo(x, y, currentHypo);
	return;
      }
      currentGoal.unsetGoal();
      
      if (currentGoalCluster.checkDone(currentGoal, currentHypo)){
	proveDone();
	return;
      }	

      Set lset = currentGoalCluster.getMatchPoints(currentGoal, currentHypo);
      System.out.println(lset);

      if (lset.size() == 0){    // no matching point;
	currentGoal.setGoal();
	rewindHypo(x, y, currentHypo);
	return;
      } else if (lset.size() == 1){
	proveOne(currentGoalCluster, currentGoal, currentHypo, (Pair)lset.elementAt(0));
      } else {
	proveSelect(lset);
      }
    } else if (currentHypo != null){
      rewindHypo(x, y, currentHypo);
    }
  }
/******************** GOAL OPERATIONS ***********************/
  public void goalDown(int x, int y){  
    Arc tmpArc = getNearestArc(x, y);
    if (tmpArc != null){
      Loop tmpLoop = getMenso(tmpArc);
      if (tmpLoop != null){
	if (currentGoal != null){
	  currentGoal.unsetGoal();
	}
	tmpLoop.setGoal();
	currentGoal = tmpLoop;
	currentGoalCluster = getCluster(tmpLoop);
	repaint();
	setCurrentLoops();
	initBlinkingArcs();
      }
    }
  }

/******************** CELL  OPERATIONS ***********************/
  public void cellDown(int x, int y){  
    Arc tmpArc = getNearestArc(x, y);
    if (tmpArc != null){
      Loop tmpLoop = getMenso(tmpArc);
      if (tmpLoop != null){
	tmpLoop.setMenso();
	repaint();
	setCurrentLoops();
	initBlinkingArcs();
      }
    }
  }

  public Loop getMenso(Arc a){
    Set tmp = (Set)currentLoops.clone();
    for (int i = 0; i < currentLoops.size(); i++){
      Loop tmpLoop = (Loop)currentLoops.elementAt(i);
      if (!tmpLoop.includes(a))
	tmp.removeElement(tmpLoop);
    }
    currentLoops = tmp;
    if (currentLoops.size() == 0){
      setCurrentLoops();
      initBlinkingArcs();
      message("No such Cell, Select Again");
      repaint();
      return null;
    } else if (currentLoops.size() == 1){
      return (Loop)currentLoops.elementAt(0);
    } else {
      addBlinkingArcs(new Interrupter(1000, 200, new BlinkArc(this, a)));
      return null;
    }
  }


/******************** COPY OPERATIONS ***********************/
  public void copyDown(int x, int y){  
    moveNode = getNearestNode(x, y);
    if (moveNode == null){
      Arc tmpArc = getNearestArc(x, y);
      if (tmpArc != null){
	moveCluster = getCluster(tmpArc);
      }
    } else {
      moveCluster = getCluster(moveNode);
      moveNode = null;
    }
    tmpx = x; tmpy = y;
  }
  public void copyUp(int x, int y){  
    if (moveCluster != null){
      copyCluster(moveCluster, x - tmpx, y - tmpy);
    }
    moveCluster = null;
  }
  public void copyCluster(Cluster c, int x, int y){
    clusters.addElement(c.movecopy(x, y));
  }


/******************** BASIC OPERATIONS ***********************/

  public void message(String str){
    mp.setText(str);
  }

  public Cluster getCluster(Node s){
    int np = clusters.size();
    for (int i = 0; i < np; i++){
      Cluster cl = ((Cluster)clusters.elementAt(i));
      if (cl.nodes.contains(s))
	return cl;
    }
    return null;
  }

  public Cluster getCluster(Arc a){
    return getCluster(a.start);
  }

  public Cluster getCluster(Loop l){
    if (l.arcs.size() != 0)
      return getCluster((Arc)l.arcs.elementAt(0));
    return null;
  }

  public void mergeCluster(Node s, Node e, Arc tmpArc){
    Cluster sc = getCluster(s);
    Cluster ec = getCluster(e);
    if (sc != ec){
      sc.addCluster(ec);
      clusters.removeElement(ec);
    } else {
      sc.maintainLoop(tmpArc);
    }
  }


  public Node getNearestNode(int x, int y) {
    int np = clusters.size();
    double nearestMax = 10;

    Node currentNode = null;
    for (int i = 0; i < np; i++){
      Node tmp = ((Cluster)clusters.elementAt(i)).getNearestNode(nearestMax, x, y);
      if (tmp != null){
	if (currentNode == null){
	  currentNode = tmp;
	  nearestMax = tmp.distance(x, y);
	}
      }
    }
    return currentNode;
  }

  public Arc getNearestArc(int x, int y) {
    int np = clusters.size();
    double nearestMax = 10;

    Arc currentArc = null;
    for (int i = 0; i < np; i++){
      Arc tmp = ((Cluster)clusters.elementAt(i)).getNearestArc(nearestMax, x, y);
      if (tmp != null){
	if (currentArc == null){
	  currentArc = tmp;
	  nearestMax = tmp.distance(x, y);
	}
      }
    }
    return currentArc;
  }
  public Loop getNearestLoop(int x, int y) {
    double nearestMax = 10;
    setCurrentLoops();
    Loop currentLoop = null;

    for (int i = 0; i < currentLoops.size(); i++){
      Loop tmpLoop = (Loop)currentLoops.elementAt(i);
      int distance = (int)tmpLoop.distance(x, y);
  System.out.println(distance);      
      if (distance < nearestMax){
	nearestMax = distance;
	currentLoop = tmpLoop;
      }
    }
    return currentLoop;
  }
  public void removeArc(Arc a){
    int np = clusters.size();
    for (int i = 0; i < np; i++){
      Cluster c = ((Cluster)clusters.elementAt(i));
      if (c.containsArc(a)){
	Cluster tmp = c.removeArc(a);
	if (tmp != null)
	  clusters.addElement(tmp);
      }
    }
  }

  public void removeNode(Node a){
    int np = clusters.size();
    Set nclusters = new Set();
    for (int i = 0; i < np; i++){
      Cluster c = ((Cluster)clusters.elementAt(i));
      if (c.containsNode(a)){
	Set tmpClusters = c.removeNode(a);
	nclusters.addAll(tmpClusters);
      } else {
	nclusters.addElement(c);
      }
    }
    clusters = nclusters;
  }

  public boolean action(Event e, Object Arg){
    if (e.target instanceof InputDialog){
      ((Namable)namingDic.get(e.target)).name((String)Arg);
      namingDic.remove(e.target);
      repaint();
      return true;
    }
    return false;
  }

  public void repaint(){
    mp.repaint();
    super.repaint();
  }
  public void update(Graphics g) {
    if (sub_g == null){
      sub_im = this.createImage(size().width, size().height);
      sub_g = sub_im.getGraphics();
    }
    sub_g.setColor(getBackground());
    sub_g.fillRect(0, 0, size().width, size().height);
    sub_g.setColor(getForeground());
    paint(sub_g);
    //	System.out.println(sub_g);
    g.drawImage(sub_im, 0, 0, this);
  }
  
  public void addVolatile(Putable p){
    volatiles.addElement(p);
  }
  public void removeVolatile(Putable p){
    volatiles.removeElement(p);
  }

  public void paint(Graphics g) {
    int np = clusters.size();
    for (int i = 0; i < np; i++)
      ((Cluster)clusters.elementAt(i)).paint(g);
    if (tmpStart != null){
      g.setColor(getForeground());
      g.drawLine(tmpStart.x, tmpStart.y, tmpx, tmpy);
    }
//    System.out.println(currentHypo + ": "+(currentx - tmpx) + ", " +(currentx - tmpx));

    for (int i = 0; i < volatiles.size(); i++){
      ((Putable)volatiles.elementAt(i)).put(g);
    }
    volatiles = new Set();

    if (currentHypo != null)
      currentHypo.paint(g, currentx - tmpx, currenty - tmpy);
    if (mode == COPY && moveCluster != null)
      moveCluster.paint(g, currentx - tmpx, currenty - tmpy);
  }


  public void done(MyPoint p){
    String str = "D O N E";
    message(str);
    addVolatile(new DonePutable(p, str, this));
  }


  public void dump() {
    int np = clusters.size();
    for (int i = 0; i < np; i++)
      System.out.println(((Cluster)clusters.elementAt(i)).toString());
  }

  public void addBlinkingArcs(Interrupter i){
    blinkingArcs.addElement(i);
  }

  public void initBlinkingArcs(){
    if (blinkingArcs != null && blinkingArcs.size() != 0)
      for (int i = 0; i < blinkingArcs.size(); i++)
	((Interrupter)blinkingArcs.elementAt(i)).kill();
    blinkingArcs = new Set();
  }
  public void setCurrentLoops(){
    currentLoops = new Set();
    for (int i = 0; i < clusters.size(); i++){
      currentLoops.addAll(((Cluster)clusters.elementAt(i)).loops);
    }
  }

  public Node addNode(int x, int y, String n){
    return addNode(x, y, Color.black, n);
  }

  public Node addNode(int x, int y, Color c){
    return addNode(x, y, c, null);
  }
  public Node addNode(int x, int y, Color c, String n){
    Cluster nc = new Cluster(x, y, c, n);
    clusters.addElement(nc);
    return (Node)nc.nodes.elementAt(0);
  }

  public void addArc(Arc a){
    a.registerSelf();
    mergeCluster(a.start, a.end, a);    
  }

  public void autoDemo(){
    if (autoDemoEvents == null){

      autoDemoEvents = new Set();
      autoDemoEvents.addElement(new DummyEvent(DummyEvent.DOWN, NODES, 100, 100, this));
      autoDemoEvents.addElement(new DummyEvent(DummyEvent.DOWN, NODES, 100, 200, this));
      autoDemoEvents.addElement(new DummyEvent(DummyEvent.DOWN, NODES, 200, 100, this));
      autoDemoEvents.addElement(new DummyEvent(DummyEvent.DOWN, NODES, 200, 200, this));
      
      autoDemoEvents.addElement(new DummyEvent(DummyEvent.DOWN, LINES, 100, 100, this));
      autoDemoEvents.addElement(new DummyEvent(DummyEvent.UP,   LINES, 100, 200, this));
    }
    new Interrupter(autoDemoEvents.size(), autoDemoTick, new DummyPlug(this, autoDemoEvents));
      
/*
    Node n0 = addNode(100, 100, "");
    Node n1 = addNode(100, 200, "");
    Node n2 = addNode(200, 200, "");
    addArc(new ArcRect(n0, n1, Color.black, true, "f"));
    addArc(new ArcRect(n1, n2, Color.black, true, "g"));
    addArc(new ArcRect(n0, n2, Color.black, true, "h"));

    n0 = addNode(300, 100, "");
    n1 = addNode(400, 200, "");
    n2 = addNode(400, 100, "");
    addArc(new ArcRect(n0, n1, Color.black, true, "h"));
    addArc(new ArcRect(n0, n2, Color.black, true, "i"));
    addArc(new ArcRect(n2, n1, Color.black, true, "j"));


    Node n3 = addNode(500, 100, "");
    Node n4 = addNode(500, 200, "");
    Node n5 = addNode(600, 200, "");
    Node n6 = addNode(600, 100, "");

    addArc(new ArcRect(n3, n4, Color.black, true, "f"));
    addArc(new ArcRect(n4, n5, Color.black, true, "g"));
    addArc(new ArcRect(n3, n6, Color.black, true, "i"));
    addArc(new ArcRect(n6, n5, Color.black, true, "j"));
*/

  }




  public void demo(){
    Node.initNum();
    Arc.initNum();

    Node n0 = addNode(50, 50, "");
    Node n1 = addNode(50, 150, "");
    Node n2 = addNode(120, 100, "");
    addArc(new ArcRect(n0, n1, Color.black, true, "f"));
    addArc(new ArcRect(n0, n2, Color.black, true, "id"));
    addArc(new ArcRect(n2, n1, Color.black, true, "f"));


    n0 = addNode(250, 50, "");
    n1 = addNode(250, 150, "");
    n2 = addNode(320, 100, "");
    addArc(new ArcRect(n0, n1, Color.black, true, "id"));
    addArc(new ArcRect(n0, n2, Color.black, true, "g"));
    addArc(new ArcRect(n2, n1, Color.black, true, "h"));


    n0 = addNode(50, 200, "");
    n1 = addNode(50, 300, "");
    n2 = addNode(120, 250, "");
    addArc(new ArcRect(n0, n1, Color.black, true, "id"));
    addArc(new ArcRect(n0, n2, Color.black, true, "h"));
    addArc(new ArcRect(n2, n1, Color.black, true, "f"));


    n0 = addNode(250, 200, "");
    n1 = addNode(250, 300, "");
    n2 = addNode(320, 250, "");
    addArc(new ArcRect(n0, n1, Color.black, true, "g"));
    addArc(new ArcRect(n0, n2, Color.black, true, "g"));
    addArc(new ArcRect(n2, n1, Color.black, true, "id"));



    Node n3 = addNode(500, 50, "");
    Node n4 = addNode(500, 300, "");

    addArc(new ArcRect(n3, n4, Color.black, true, "f"));
    addArc(new ArcRect(n3, n4, Color.black, true, "g"));
    repaint();
  }

  public void demo1(){
    Node.initNum();
    Arc.initNum();

    Node n0 = addNode(100, 100, "A");
    Node n1 = addNode(100, 200, "B");
    Node n2 = addNode(200, 200, "C");
    addArc(new ArcRect(n0, n1, Color.black, true, "f"));
    addArc(new ArcRect(n1, n2, Color.black, true, "g"));
    addArc(new ArcRect(n0, n2, Color.black, true, "h"));

    n0 = addNode(300, 100, "A");
    n1 = addNode(400, 200, "C");
    n2 = addNode(400, 100, "D");
    addArc(new ArcRect(n0, n1, Color.black, true, "h"));
    addArc(new ArcRect(n0, n2, Color.black, true, "i"));
    addArc(new ArcRect(n2, n1, Color.black, true, "j"));


    Node n3 = addNode(500, 100, "A");
    Node n4 = addNode(500, 200, "B");
    Node n5 = addNode(600, 200, "C");
    Node n6 = addNode(600, 100, "D");

    addArc(new ArcRect(n3, n4, Color.black, true, "f"));
    addArc(new ArcRect(n4, n5, Color.black, true, "g"));
    addArc(new ArcRect(n3, n6, Color.black, true, "i"));
    addArc(new ArcRect(n6, n5, Color.black, true, "j"));

/*
    Node n3 = addNode(500, 100, "A");
    Node n4 = addNode(500, 200, "B");
    Node n5 = addNode(600, 300, "A");
    Node n6 = addNode(700, 300, "B");
    Node n7 = addNode(700, 200, "C");
    Node n8 = addNode(600, 100, "C");

    addArc(new ArcRect(n3, n4, Color.black, true, "f"));
    addArc(new ArcRect(n4, n5, Color.black, true, "k"));
    addArc(new ArcRect(n5, n6, Color.black, true, "f"));
    addArc(new ArcRect(n6, n7, Color.black, true, "g"));
    addArc(new ArcRect(n7, n8, Color.black, true, "i"));
    addArc(new ArcRect(n3, n8, Color.black, true, "h"));
*/

    repaint();
  }
}
